import { ExpressionNode, NodeBase } from './shared/Node';
import ExportDefaultVariable from '../variables/ExportDefaultVariable';
import ClassDeclaration from './ClassDeclaration';
import FunctionDeclaration from './FunctionDeclaration';
import MagicString from 'magic-string';
import { NodeType } from './NodeType';
import { NodeRenderOptions, RenderOptions } from '../../utils/renderHelpers';
export default class ExportDefaultDeclaration extends NodeBase {
    type: NodeType.ExportDefaultDeclaration;
    declaration: FunctionDeclaration | ClassDeclaration | ExpressionNode;
    needsBoundaries: true;
    isExportDeclaration: true;
    variable: ExportDefaultVariable;
    private declarationName;
    bindNode(): void;
    initialiseNode(): void;
    render(code: MagicString, options: RenderOptions, {start, end}?: NodeRenderOptions): void;
    private renderNamedDeclaration(code, declarationStart, declarationKeyword, needsId, options);
    private renderVariableDeclaration(code, declarationStart, options);
}
