// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/devtools/resultstore/v2/action.proto

package resultstore

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Indicates how/where this Action was executed.
type ExecutionStrategy int32

const (
	// The action did not indicate how it was executed.
	ExecutionStrategy_EXECUTION_STRATEGY_UNSPECIFIED ExecutionStrategy = 0
	// The action was executed in some other form.
	ExecutionStrategy_OTHER_ENVIRONMENT ExecutionStrategy = 1
	// The action used a remote build service.
	ExecutionStrategy_REMOTE_SERVICE ExecutionStrategy = 2
	// The action was executed locally, in parallel with other actions.
	ExecutionStrategy_LOCAL_PARALLEL ExecutionStrategy = 3
	// The action was executed locally, without parallelism.
	ExecutionStrategy_LOCAL_SEQUENTIAL ExecutionStrategy = 4
)

// Enum value maps for ExecutionStrategy.
var (
	ExecutionStrategy_name = map[int32]string{
		0: "EXECUTION_STRATEGY_UNSPECIFIED",
		1: "OTHER_ENVIRONMENT",
		2: "REMOTE_SERVICE",
		3: "LOCAL_PARALLEL",
		4: "LOCAL_SEQUENTIAL",
	}
	ExecutionStrategy_value = map[string]int32{
		"EXECUTION_STRATEGY_UNSPECIFIED": 0,
		"OTHER_ENVIRONMENT":              1,
		"REMOTE_SERVICE":                 2,
		"LOCAL_PARALLEL":                 3,
		"LOCAL_SEQUENTIAL":               4,
	}
)

func (x ExecutionStrategy) Enum() *ExecutionStrategy {
	p := new(ExecutionStrategy)
	*p = x
	return p
}

func (x ExecutionStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_resultstore_v2_action_proto_enumTypes[0].Descriptor()
}

func (ExecutionStrategy) Type() protoreflect.EnumType {
	return &file_google_devtools_resultstore_v2_action_proto_enumTypes[0]
}

func (x ExecutionStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionStrategy.Descriptor instead.
func (ExecutionStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_action_proto_rawDescGZIP(), []int{0}
}

// Most build systems cache build results to speed up incremental builds.
// Some also cache test results too. This indicates whether the test results
// were found in a cache, and where that cache was located.
type TestCaching int32

const (
	// The implicit default enum value. Should never be set.
	TestCaching_TEST_CACHING_UNSPECIFIED TestCaching = 0
	// The test result was found in a local cache, so it wasn't run again.
	TestCaching_LOCAL_CACHE_HIT TestCaching = 1
	// The test result was found in a remote cache, so it wasn't run again.
	TestCaching_REMOTE_CACHE_HIT TestCaching = 2
	// The test result was not found in any cache, so it had to be run again.
	TestCaching_CACHE_MISS TestCaching = 3
)

// Enum value maps for TestCaching.
var (
	TestCaching_name = map[int32]string{
		0: "TEST_CACHING_UNSPECIFIED",
		1: "LOCAL_CACHE_HIT",
		2: "REMOTE_CACHE_HIT",
		3: "CACHE_MISS",
	}
	TestCaching_value = map[string]int32{
		"TEST_CACHING_UNSPECIFIED": 0,
		"LOCAL_CACHE_HIT":          1,
		"REMOTE_CACHE_HIT":         2,
		"CACHE_MISS":               3,
	}
)

func (x TestCaching) Enum() *TestCaching {
	p := new(TestCaching)
	*p = x
	return p
}

func (x TestCaching) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TestCaching) Descriptor() protoreflect.EnumDescriptor {
	return file_google_devtools_resultstore_v2_action_proto_enumTypes[1].Descriptor()
}

func (TestCaching) Type() protoreflect.EnumType {
	return &file_google_devtools_resultstore_v2_action_proto_enumTypes[1]
}

func (x TestCaching) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TestCaching.Descriptor instead.
func (TestCaching) EnumDescriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_action_proto_rawDescGZIP(), []int{1}
}

// An action that happened as part of a configured target. This action could be
// a build, a test, or another type of action, as specified in action_type
// oneof.
//
// Each parent ConfiguredTarget resource should have at least one Action as its
// child resource before the invocation is finalized. For a simple build, at
// least one build action should be created to represent the build result, and
// at at least one test action should be created to represent the test result,
// if any.
type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name.  Its format must be:
	// invocations/${INVOCATION_ID}/targets/${url_encode(TARGET_ID)}/configuredTargets/url_encode(${CONFIG_ID})/actions/${url_encode(ACTION_ID)}
	//
	// See CreateActionRequest proto for more information.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource ID components that identify the Action. They must match the
	// resource name after proper encoding.
	Id *Action_Id `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The status of the action.
	StatusAttributes *StatusAttributes `protobuf:"bytes,3,opt,name=status_attributes,json=statusAttributes,proto3" json:"status_attributes,omitempty"`
	// The timing of the whole action. For TestActions, the start time may be
	// before the test actually started, and the duration may last until after the
	// test actually finished.
	Timing *Timing `protobuf:"bytes,4,opt,name=timing,proto3" json:"timing,omitempty"`
	// The type of the action. The type of an action may not change over the
	// lifetime of the invocation. If one of these fields is to be set, it must be
	// set in the CreateAction method. It may be set to an empty message that is
	// populated in later methods or post-processing. A generic "untyped" action
	// can be created by not setting any of these fields. An untyped action will
	// be untyped for the lifetime of the invocation.
	//
	// Types that are assignable to ActionType:
	//	*Action_BuildAction
	//	*Action_TestAction
	ActionType isAction_ActionType `protobuf_oneof:"action_type"`
	// General attributes of the action.
	ActionAttributes *ActionAttributes `protobuf:"bytes,5,opt,name=action_attributes,json=actionAttributes,proto3" json:"action_attributes,omitempty"`
	// A list of resources that this action depended upon. May be used to provide
	// the cause of a build failure in the case of a failed build action.
	ActionDependencies []*Dependency `protobuf:"bytes,14,rep,name=action_dependencies,json=actionDependencies,proto3" json:"action_dependencies,omitempty"`
	// Arbitrary name-value pairs.
	// This is implemented as a multi-map. Multiple properties are allowed with
	// the same key. Properties will be returned in lexicographical order by key.
	Properties []*Property `protobuf:"bytes,7,rep,name=properties,proto3" json:"properties,omitempty"`
	// A list of file references for action level files.
	// The file IDs must be unique within this list. Duplicate file IDs will
	// result in an error. Files will be returned in lexicographical order by ID.
	//
	// Files with the following reserved file IDs cause specific post-processing
	// or have special handling. These files must be immediately available to
	// ResultStore for processing when the reference is uploaded.
	//
	// For build actions:
	// stdout: The stdout of the action
	// stderr: The stderr of the action
	// baseline.lcov: Baseline coverage file to be parsed by the server. This
	//     uses a stripped down implementation of the LCOV standard.
	//     http://ltp.sourceforge.net/coverage/lcov/geninfo.1.php
	//
	// For test actions:
	// test.xml: The test suite / test case data in XML format.
	// test.log: The combined stdout and stderr of the test process.
	// test.lcov: Coverage file to be parsed by the server. This uses a stripped
	//     down implementation of the LCOV standard.
	//     http://ltp.sourceforge.net/coverage/lcov/geninfo.1.php
	Files []*File `protobuf:"bytes,8,rep,name=files,proto3" json:"files,omitempty"`
	// List of names of file sets that are referenced from this Action.
	// Each name must point to a file set under the same Invocation. The name
	// format must be: invocations/${INVOCATION_ID}/fileSets/${FILE_SET_ID}
	FileSets []string `protobuf:"bytes,15,rep,name=file_sets,json=fileSets,proto3" json:"file_sets,omitempty"`
	// Coverage data was collected while running the build or test action. This
	// usually includes line coverage, and may also include branch coverage.
	// For test actions, this is usually only for the source files which were
	// actually executed by that particular action.
	// For build actions, this is the baseline coverage, which captures the
	// instrumented files and lines, without any lines being executed. This
	// ensures files that are never covered at all are included.
	Coverage *ActionCoverage `protobuf:"bytes,11,opt,name=coverage,proto3" json:"coverage,omitempty"`
	// ResultStore will read and parse Files with reserved IDs listed above. Read
	// and parse errors for all these Files are reported here.
	// This is implemented as a map, with one FileProcessingErrors for each file.
	// Typically produced when parsing Files, but may also be provided directly
	// by clients.
	FileProcessingErrors []*FileProcessingErrors `protobuf:"bytes,13,rep,name=file_processing_errors,json=fileProcessingErrors,proto3" json:"file_processing_errors,omitempty"`
}

func (x *Action) Reset() {
	*x = Action{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_action_proto_rawDescGZIP(), []int{0}
}

func (x *Action) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Action) GetId() *Action_Id {
	if x != nil {
		return x.Id
	}
	return nil
}

func (x *Action) GetStatusAttributes() *StatusAttributes {
	if x != nil {
		return x.StatusAttributes
	}
	return nil
}

func (x *Action) GetTiming() *Timing {
	if x != nil {
		return x.Timing
	}
	return nil
}

func (m *Action) GetActionType() isAction_ActionType {
	if m != nil {
		return m.ActionType
	}
	return nil
}

func (x *Action) GetBuildAction() *BuildAction {
	if x, ok := x.GetActionType().(*Action_BuildAction); ok {
		return x.BuildAction
	}
	return nil
}

func (x *Action) GetTestAction() *TestAction {
	if x, ok := x.GetActionType().(*Action_TestAction); ok {
		return x.TestAction
	}
	return nil
}

func (x *Action) GetActionAttributes() *ActionAttributes {
	if x != nil {
		return x.ActionAttributes
	}
	return nil
}

func (x *Action) GetActionDependencies() []*Dependency {
	if x != nil {
		return x.ActionDependencies
	}
	return nil
}

func (x *Action) GetProperties() []*Property {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *Action) GetFiles() []*File {
	if x != nil {
		return x.Files
	}
	return nil
}

func (x *Action) GetFileSets() []string {
	if x != nil {
		return x.FileSets
	}
	return nil
}

func (x *Action) GetCoverage() *ActionCoverage {
	if x != nil {
		return x.Coverage
	}
	return nil
}

func (x *Action) GetFileProcessingErrors() []*FileProcessingErrors {
	if x != nil {
		return x.FileProcessingErrors
	}
	return nil
}

type isAction_ActionType interface {
	isAction_ActionType()
}

type Action_BuildAction struct {
	// Used only when this action represents a build action.
	BuildAction *BuildAction `protobuf:"bytes,9,opt,name=build_action,json=buildAction,proto3,oneof"`
}

type Action_TestAction struct {
	// Only for test actions.
	TestAction *TestAction `protobuf:"bytes,10,opt,name=test_action,json=testAction,proto3,oneof"`
}

func (*Action_BuildAction) isAction_ActionType() {}

func (*Action_TestAction) isAction_ActionType() {}

// A build action, such as building a java library.
type BuildAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the action.  This is intended to be a clue as to how the output
	// of the action should be parsed. For example "javac" for a Java compile
	// action.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// The "primary" input artifact processed by this action.  E.g., the .cc file
	// of a C++ compile action.  Empty string ("") if the action has no input
	// artifacts or no "primary" input artifact.
	PrimaryInputPath string `protobuf:"bytes,2,opt,name=primary_input_path,json=primaryInputPath,proto3" json:"primary_input_path,omitempty"`
	// The "primary" output artifact processed by this action.  E.g., the .o file
	// of a C++ compile action.  Empty string ("") if the action has no output
	// artifacts or no "primary" output artifact.
	PrimaryOutputPath string `protobuf:"bytes,3,opt,name=primary_output_path,json=primaryOutputPath,proto3" json:"primary_output_path,omitempty"`
}

func (x *BuildAction) Reset() {
	*x = BuildAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BuildAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BuildAction) ProtoMessage() {}

func (x *BuildAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BuildAction.ProtoReflect.Descriptor instead.
func (*BuildAction) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_action_proto_rawDescGZIP(), []int{1}
}

func (x *BuildAction) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *BuildAction) GetPrimaryInputPath() string {
	if x != nil {
		return x.PrimaryInputPath
	}
	return ""
}

func (x *BuildAction) GetPrimaryOutputPath() string {
	if x != nil {
		return x.PrimaryOutputPath
	}
	return ""
}

// A test action, such as running a JUnit4 test binary.
type TestAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Timing data for execution of the test action.
	TestTiming *TestTiming `protobuf:"bytes,1,opt,name=test_timing,json=testTiming,proto3" json:"test_timing,omitempty"`
	// If the test is divided up into shards to improve performance, set this to
	// indicate which shard this test action is for. Value must be in interval
	// [0, total_shard_count). Defaults to 0, which is appropriate if all test
	// cases are run in the same process.
	ShardNumber int32 `protobuf:"varint,2,opt,name=shard_number,json=shardNumber,proto3" json:"shard_number,omitempty"`
	// If the user requested that every test be run multiple times, as is often
	// done to measure flakiness, set this to indicate which run this test action
	// is for. Value must be in interval [0, total_run_count). Defaults to 0,
	// which is appropriate if multiple runs were not requested.
	RunNumber int32 `protobuf:"varint,3,opt,name=run_number,json=runNumber,proto3" json:"run_number,omitempty"`
	// If flaky tests are automatically retried, set this to indicate which
	// attempt this test action is for. (e.g. 0 for the first attempt, 1 for
	// second, and so on). Defaults to 0, which is appropriate if this is only
	// attempt.
	AttemptNumber int32 `protobuf:"varint,4,opt,name=attempt_number,json=attemptNumber,proto3" json:"attempt_number,omitempty"`
	// A tree of test suites and test cases that were run by this test action.
	// Each test case has its own status information, including stack traces.
	// Typically produced by parsing an XML Log, but may also be provided directly
	// by clients.
	TestSuite *TestSuite `protobuf:"bytes,5,opt,name=test_suite,json=testSuite,proto3" json:"test_suite,omitempty"`
	// Warnings for this test action.
	Warnings []*TestWarning `protobuf:"bytes,8,rep,name=warnings,proto3" json:"warnings,omitempty"`
	// Estimated memory consumption of the test action, in bytes. A default value
	// of 0 means there is no memory consumption estimate specified.
	EstimatedMemoryBytes int64 `protobuf:"varint,10,opt,name=estimated_memory_bytes,json=estimatedMemoryBytes,proto3" json:"estimated_memory_bytes,omitempty"`
}

func (x *TestAction) Reset() {
	*x = TestAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAction) ProtoMessage() {}

func (x *TestAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAction.ProtoReflect.Descriptor instead.
func (*TestAction) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_action_proto_rawDescGZIP(), []int{2}
}

func (x *TestAction) GetTestTiming() *TestTiming {
	if x != nil {
		return x.TestTiming
	}
	return nil
}

func (x *TestAction) GetShardNumber() int32 {
	if x != nil {
		return x.ShardNumber
	}
	return 0
}

func (x *TestAction) GetRunNumber() int32 {
	if x != nil {
		return x.RunNumber
	}
	return 0
}

func (x *TestAction) GetAttemptNumber() int32 {
	if x != nil {
		return x.AttemptNumber
	}
	return 0
}

func (x *TestAction) GetTestSuite() *TestSuite {
	if x != nil {
		return x.TestSuite
	}
	return nil
}

func (x *TestAction) GetWarnings() []*TestWarning {
	if x != nil {
		return x.Warnings
	}
	return nil
}

func (x *TestAction) GetEstimatedMemoryBytes() int64 {
	if x != nil {
		return x.EstimatedMemoryBytes
	}
	return 0
}

// General attributes of an action
type ActionAttributes struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Strategy used for executing the action.
	ExecutionStrategy ExecutionStrategy `protobuf:"varint,1,opt,name=execution_strategy,json=executionStrategy,proto3,enum=google.devtools.resultstore.v2.ExecutionStrategy" json:"execution_strategy,omitempty"`
	// Exit code of the process that ran the action. A non-zero value means
	// failure.
	ExitCode int32 `protobuf:"varint,2,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
	// Where the action was run.
	Hostname string `protobuf:"bytes,3,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Information about the input files used in all actions under this configured
	// target.
	InputFileInfo *InputFileInfo `protobuf:"bytes,4,opt,name=input_file_info,json=inputFileInfo,proto3" json:"input_file_info,omitempty"`
}

func (x *ActionAttributes) Reset() {
	*x = ActionAttributes{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ActionAttributes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActionAttributes) ProtoMessage() {}

func (x *ActionAttributes) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActionAttributes.ProtoReflect.Descriptor instead.
func (*ActionAttributes) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_action_proto_rawDescGZIP(), []int{3}
}

func (x *ActionAttributes) GetExecutionStrategy() ExecutionStrategy {
	if x != nil {
		return x.ExecutionStrategy
	}
	return ExecutionStrategy_EXECUTION_STRATEGY_UNSPECIFIED
}

func (x *ActionAttributes) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

func (x *ActionAttributes) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *ActionAttributes) GetInputFileInfo() *InputFileInfo {
	if x != nil {
		return x.InputFileInfo
	}
	return nil
}

// File count and size information for the input files to a configured target.
type InputFileInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The number of input files (counting every file, even if a duplicate).
	Count int64 `protobuf:"varint,1,opt,name=count,proto3" json:"count,omitempty"`
	// The number of distinct input files.
	DistinctCount int64 `protobuf:"varint,2,opt,name=distinct_count,json=distinctCount,proto3" json:"distinct_count,omitempty"`
	// The max number of input files allowed by the build system (counting every
	// file, even if a duplicate).
	CountLimit int64 `protobuf:"varint,3,opt,name=count_limit,json=countLimit,proto3" json:"count_limit,omitempty"`
	// The total size of the distinct input files.
	DistinctBytes int64 `protobuf:"varint,4,opt,name=distinct_bytes,json=distinctBytes,proto3" json:"distinct_bytes,omitempty"`
	// The max allowed total size of the distinct input files.
	DistinctByteLimit int64 `protobuf:"varint,5,opt,name=distinct_byte_limit,json=distinctByteLimit,proto3" json:"distinct_byte_limit,omitempty"`
}

func (x *InputFileInfo) Reset() {
	*x = InputFileInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InputFileInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputFileInfo) ProtoMessage() {}

func (x *InputFileInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputFileInfo.ProtoReflect.Descriptor instead.
func (*InputFileInfo) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_action_proto_rawDescGZIP(), []int{4}
}

func (x *InputFileInfo) GetCount() int64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *InputFileInfo) GetDistinctCount() int64 {
	if x != nil {
		return x.DistinctCount
	}
	return 0
}

func (x *InputFileInfo) GetCountLimit() int64 {
	if x != nil {
		return x.CountLimit
	}
	return 0
}

func (x *InputFileInfo) GetDistinctBytes() int64 {
	if x != nil {
		return x.DistinctBytes
	}
	return 0
}

func (x *InputFileInfo) GetDistinctByteLimit() int64 {
	if x != nil {
		return x.DistinctByteLimit
	}
	return 0
}

// Timing data for tests executed locally on the machine running the build.
type LocalTestTiming struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time taken by the test process, typically surrounded by a small wrapper
	// script.
	TestProcessDuration *duration.Duration `protobuf:"bytes,1,opt,name=test_process_duration,json=testProcessDuration,proto3" json:"test_process_duration,omitempty"`
}

func (x *LocalTestTiming) Reset() {
	*x = LocalTestTiming{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocalTestTiming) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocalTestTiming) ProtoMessage() {}

func (x *LocalTestTiming) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocalTestTiming.ProtoReflect.Descriptor instead.
func (*LocalTestTiming) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_action_proto_rawDescGZIP(), []int{5}
}

func (x *LocalTestTiming) GetTestProcessDuration() *duration.Duration {
	if x != nil {
		return x.TestProcessDuration
	}
	return nil
}

// Timing data for one attempt to execute a test action remotely.
type RemoteTestAttemptTiming struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Idle period before the test process is invoked on the remote machine.
	QueueDuration *duration.Duration `protobuf:"bytes,1,opt,name=queue_duration,json=queueDuration,proto3" json:"queue_duration,omitempty"`
	// Time to upload data dependencies from the local machine to the remote
	// machine running the test, or to the distributed cache.
	UploadDuration *duration.Duration `protobuf:"bytes,2,opt,name=upload_duration,json=uploadDuration,proto3" json:"upload_duration,omitempty"`
	// Time to set up the remote machine.
	// Not to be confused with setup time in
	// xUnit test frameworks, which falls within the test_process_time.
	MachineSetupDuration *duration.Duration `protobuf:"bytes,3,opt,name=machine_setup_duration,json=machineSetupDuration,proto3" json:"machine_setup_duration,omitempty"`
	// Time taken by the test process, typically surrounded by a small wrapper
	// script.
	// For Java tests, this includes JVM setup, flag parsing, class path setup,
	// parsing files to setup the suite, and finally running your test methods.
	// In many cases, only a small fraction of the test process time is spent
	// running the test methods.
	TestProcessDuration *duration.Duration `protobuf:"bytes,4,opt,name=test_process_duration,json=testProcessDuration,proto3" json:"test_process_duration,omitempty"`
	// Time spent retrieving test logs and any other test outputs, back to the
	// local machine.
	DownloadDuration *duration.Duration `protobuf:"bytes,5,opt,name=download_duration,json=downloadDuration,proto3" json:"download_duration,omitempty"`
}

func (x *RemoteTestAttemptTiming) Reset() {
	*x = RemoteTestAttemptTiming{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteTestAttemptTiming) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteTestAttemptTiming) ProtoMessage() {}

func (x *RemoteTestAttemptTiming) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteTestAttemptTiming.ProtoReflect.Descriptor instead.
func (*RemoteTestAttemptTiming) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_action_proto_rawDescGZIP(), []int{6}
}

func (x *RemoteTestAttemptTiming) GetQueueDuration() *duration.Duration {
	if x != nil {
		return x.QueueDuration
	}
	return nil
}

func (x *RemoteTestAttemptTiming) GetUploadDuration() *duration.Duration {
	if x != nil {
		return x.UploadDuration
	}
	return nil
}

func (x *RemoteTestAttemptTiming) GetMachineSetupDuration() *duration.Duration {
	if x != nil {
		return x.MachineSetupDuration
	}
	return nil
}

func (x *RemoteTestAttemptTiming) GetTestProcessDuration() *duration.Duration {
	if x != nil {
		return x.TestProcessDuration
	}
	return nil
}

func (x *RemoteTestAttemptTiming) GetDownloadDuration() *duration.Duration {
	if x != nil {
		return x.DownloadDuration
	}
	return nil
}

// Timing data for the part of the test execution that is done remotely.
type RemoteTestTiming struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time taken locally to determine what to do.
	LocalAnalysisDuration *duration.Duration `protobuf:"bytes,1,opt,name=local_analysis_duration,json=localAnalysisDuration,proto3" json:"local_analysis_duration,omitempty"`
	// Normally there is only one attempt, but the system may retry on internal
	// errors, leading to multiple attempts.
	Attempts []*RemoteTestAttemptTiming `protobuf:"bytes,2,rep,name=attempts,proto3" json:"attempts,omitempty"`
}

func (x *RemoteTestTiming) Reset() {
	*x = RemoteTestTiming{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RemoteTestTiming) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteTestTiming) ProtoMessage() {}

func (x *RemoteTestTiming) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteTestTiming.ProtoReflect.Descriptor instead.
func (*RemoteTestTiming) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_action_proto_rawDescGZIP(), []int{7}
}

func (x *RemoteTestTiming) GetLocalAnalysisDuration() *duration.Duration {
	if x != nil {
		return x.LocalAnalysisDuration
	}
	return nil
}

func (x *RemoteTestTiming) GetAttempts() []*RemoteTestAttemptTiming {
	if x != nil {
		return x.Attempts
	}
	return nil
}

// Timing data for execution of a test action. The action may be performed
// locally, on the machine running the build, or remotely.
type TestTiming struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Test timing for either a local or remote execution.
	//
	// Types that are assignable to Location:
	//	*TestTiming_Local
	//	*TestTiming_Remote
	Location isTestTiming_Location `protobuf_oneof:"location"`
	// The amount of CPU time spent by the test process executing system calls
	// within the kernel, as opposed to library code. Time the test process spent
	// blocked does not count towards this figure.
	SystemTimeDuration *duration.Duration `protobuf:"bytes,3,opt,name=system_time_duration,json=systemTimeDuration,proto3" json:"system_time_duration,omitempty"`
	// The amount of CPU time spent by the test process executing user-mode code
	// outside the kernel, as opposed to library code. Time the test process
	// spent blocked does not count towards this figure. You can add user_time to
	// system_time to get total CPU time taken by the test process.
	UserTimeDuration *duration.Duration `protobuf:"bytes,4,opt,name=user_time_duration,json=userTimeDuration,proto3" json:"user_time_duration,omitempty"`
	// Most build systems cache build results to speed up incremental builds.
	// Some also cache test results too. This indicates whether the test results
	// were found in a cache, and where that cache was located.
	TestCaching TestCaching `protobuf:"varint,5,opt,name=test_caching,json=testCaching,proto3,enum=google.devtools.resultstore.v2.TestCaching" json:"test_caching,omitempty"`
}

func (x *TestTiming) Reset() {
	*x = TestTiming{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestTiming) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestTiming) ProtoMessage() {}

func (x *TestTiming) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestTiming.ProtoReflect.Descriptor instead.
func (*TestTiming) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_action_proto_rawDescGZIP(), []int{8}
}

func (m *TestTiming) GetLocation() isTestTiming_Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (x *TestTiming) GetLocal() *LocalTestTiming {
	if x, ok := x.GetLocation().(*TestTiming_Local); ok {
		return x.Local
	}
	return nil
}

func (x *TestTiming) GetRemote() *RemoteTestTiming {
	if x, ok := x.GetLocation().(*TestTiming_Remote); ok {
		return x.Remote
	}
	return nil
}

func (x *TestTiming) GetSystemTimeDuration() *duration.Duration {
	if x != nil {
		return x.SystemTimeDuration
	}
	return nil
}

func (x *TestTiming) GetUserTimeDuration() *duration.Duration {
	if x != nil {
		return x.UserTimeDuration
	}
	return nil
}

func (x *TestTiming) GetTestCaching() TestCaching {
	if x != nil {
		return x.TestCaching
	}
	return TestCaching_TEST_CACHING_UNSPECIFIED
}

type isTestTiming_Location interface {
	isTestTiming_Location()
}

type TestTiming_Local struct {
	// Used for local test actions.
	Local *LocalTestTiming `protobuf:"bytes,1,opt,name=local,proto3,oneof"`
}

type TestTiming_Remote struct {
	// Used for remote test actions.
	Remote *RemoteTestTiming `protobuf:"bytes,2,opt,name=remote,proto3,oneof"`
}

func (*TestTiming_Local) isTestTiming_Location() {}

func (*TestTiming_Remote) isTestTiming_Location() {}

// A warning from a test execution.
type TestWarning struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Contains the message detailing the warning.
	WarningMessage string `protobuf:"bytes,1,opt,name=warning_message,json=warningMessage,proto3" json:"warning_message,omitempty"`
}

func (x *TestWarning) Reset() {
	*x = TestWarning{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TestWarning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestWarning) ProtoMessage() {}

func (x *TestWarning) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestWarning.ProtoReflect.Descriptor instead.
func (*TestWarning) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_action_proto_rawDescGZIP(), []int{9}
}

func (x *TestWarning) GetWarningMessage() string {
	if x != nil {
		return x.WarningMessage
	}
	return ""
}

// The resource ID components that identify the Action.
type Action_Id struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Invocation ID.
	InvocationId string `protobuf:"bytes,1,opt,name=invocation_id,json=invocationId,proto3" json:"invocation_id,omitempty"`
	// The Target ID.
	TargetId string `protobuf:"bytes,2,opt,name=target_id,json=targetId,proto3" json:"target_id,omitempty"`
	// The Configuration ID.
	ConfigurationId string `protobuf:"bytes,3,opt,name=configuration_id,json=configurationId,proto3" json:"configuration_id,omitempty"`
	// The Action ID.
	ActionId string `protobuf:"bytes,4,opt,name=action_id,json=actionId,proto3" json:"action_id,omitempty"`
}

func (x *Action_Id) Reset() {
	*x = Action_Id{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Action_Id) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_Id) ProtoMessage() {}

func (x *Action_Id) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_resultstore_v2_action_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_Id.ProtoReflect.Descriptor instead.
func (*Action_Id) Descriptor() ([]byte, []int) {
	return file_google_devtools_resultstore_v2_action_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Action_Id) GetInvocationId() string {
	if x != nil {
		return x.InvocationId
	}
	return ""
}

func (x *Action_Id) GetTargetId() string {
	if x != nil {
		return x.TargetId
	}
	return ""
}

func (x *Action_Id) GetConfigurationId() string {
	if x != nil {
		return x.ConfigurationId
	}
	return ""
}

func (x *Action_Id) GetActionId() string {
	if x != nil {
		return x.ActionId
	}
	return ""
}

var File_google_devtools_resultstore_v2_action_proto protoreflect.FileDescriptor

var file_google_devtools_resultstore_v2_action_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32,
	0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x1a, 0x2b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x61, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2f, 0x76, 0x32, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x32,
	0x2f, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x75, 0x69, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xce, 0x08, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x39, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x64, 0x52, 0x02, 0x69, 0x64, 0x12, 0x5d, 0x0a, 0x11, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x10, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x3e, 0x0a, 0x06, 0x74, 0x69,
	0x6d, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x69, 0x6d, 0x69,
	0x6e, 0x67, 0x52, 0x06, 0x74, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x12, 0x50, 0x0a, 0x0c, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x0b, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x0b,
	0x74, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52,
	0x0a, 0x74, 0x65, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x11, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x52, 0x10, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x5b, 0x0a, 0x13, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65,
	0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x79, 0x52, 0x12, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x70, 0x65, 0x6e,
	0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x12, 0x48, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x79, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x3a, 0x0a, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52, 0x05, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x1b, 0x0a,
	0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x65, 0x74, 0x73, 0x12, 0x4a, 0x0a, 0x08, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x52, 0x08, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x12, 0x6a, 0x0a, 0x16, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x52, 0x14, 0x66, 0x69,
	0x6c, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x45, 0x72, 0x72, 0x6f,
	0x72, 0x73, 0x1a, 0x8e, 0x01, 0x0a, 0x02, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x76,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1b,
	0x0a, 0x09, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x49, 0x64, 0x12, 0x29, 0x0a, 0x10, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x42, 0x0d, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x22, 0x7f, 0x0a, 0x0b, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79,
	0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x10, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x50,
	0x61, 0x74, 0x68, 0x12, 0x2e, 0x0a, 0x13, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x11, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x50,
	0x61, 0x74, 0x68, 0x22, 0x8b, 0x03, 0x0a, 0x0a, 0x54, 0x65, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x0b, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x69, 0x6e,
	0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d,
	0x69, 0x6e, 0x67, 0x52, 0x0a, 0x74, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x12,
	0x21, 0x0a, 0x0c, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x73, 0x68, 0x61, 0x72, 0x64, 0x4e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x75, 0x6e, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x72, 0x75, 0x6e, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x5f, 0x6e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x61, 0x74, 0x74, 0x65, 0x6d,
	0x70, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x48, 0x0a, 0x0a, 0x74, 0x65, 0x73, 0x74,
	0x5f, 0x73, 0x75, 0x69, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x65,
	0x73, 0x74, 0x53, 0x75, 0x69, 0x74, 0x65, 0x52, 0x09, 0x74, 0x65, 0x73, 0x74, 0x53, 0x75, 0x69,
	0x74, 0x65, 0x12, 0x47, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65,
	0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e,
	0x67, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x65,
	0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x65, 0x73, 0x74,
	0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x22, 0x84, 0x02, 0x0a, 0x10, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x12, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72,
	0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x1b, 0x0a, 0x09, 0x65, 0x78, 0x69, 0x74,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x65, 0x78, 0x69,
	0x74, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x55, 0x0a, 0x0f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x22, 0xc4, 0x01, 0x0a, 0x0d, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x14, 0x0a, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x25, 0x0a, 0x0e, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e,
	0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x69, 0x73, 0x74,
	0x69, 0x6e, 0x63, 0x74, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x0d, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12,
	0x2e, 0x0a, 0x13, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x5f, 0x62, 0x79, 0x74, 0x65,
	0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x64, 0x69,
	0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x42, 0x79, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x22,
	0x60, 0x0a, 0x0f, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x54, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x69,
	0x6e, 0x67, 0x12, 0x4d, 0x0a, 0x15, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x74, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x87, 0x03, 0x0a, 0x17, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74,
	0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x12, 0x40, 0x0a,
	0x0e, 0x71, 0x75, 0x65, 0x75, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x0d, 0x71, 0x75, 0x65, 0x75, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x42, 0x0a, 0x0f, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x75, 0x70, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x16, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x73,
	0x65, 0x74, 0x75, 0x70, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x14,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x53, 0x65, 0x74, 0x75, 0x70, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4d, 0x0a, 0x15, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13,
	0x74, 0x65, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xba, 0x01, 0x0a, 0x10,
	0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67,
	0x12, 0x51, 0x0a, 0x17, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x15, 0x6c, 0x6f,
	0x63, 0x61, 0x6c, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x44, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x08, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64,
	0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x54, 0x65, 0x73,
	0x74, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x08,
	0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x22, 0x93, 0x03, 0x0a, 0x0a, 0x54, 0x65, 0x73,
	0x74, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x12, 0x47, 0x0a, 0x05, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x54, 0x65, 0x73,
	0x74, 0x54, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x48, 0x00, 0x52, 0x05, 0x6c, 0x6f, 0x63, 0x61, 0x6c,
	0x12, 0x4a, 0x0a, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x54, 0x65, 0x73, 0x74, 0x54, 0x69, 0x6d, 0x69,
	0x6e, 0x67, 0x48, 0x00, 0x52, 0x06, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x12, 0x4b, 0x0a, 0x14,
	0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x54, 0x69, 0x6d,
	0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x12, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x10, 0x75, 0x73, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x0c, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61,
	0x63, 0x68, 0x69, 0x6e, 0x67, 0x52, 0x0b, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x67, 0x42, 0x0a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x36,
	0x0a, 0x0b, 0x54, 0x65, 0x73, 0x74, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x27, 0x0a,
	0x0f, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2a, 0x8c, 0x01, 0x0a, 0x11, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x22, 0x0a, 0x1e,
	0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45,
	0x47, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x15, 0x0a, 0x11, 0x4f, 0x54, 0x48, 0x45, 0x52, 0x5f, 0x45, 0x4e, 0x56, 0x49, 0x52, 0x4f,
	0x4e, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x52, 0x45, 0x4d, 0x4f, 0x54,
	0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x4c,
	0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x50, 0x41, 0x52, 0x41, 0x4c, 0x4c, 0x45, 0x4c, 0x10, 0x03, 0x12,
	0x14, 0x0a, 0x10, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x53, 0x45, 0x51, 0x55, 0x45, 0x4e, 0x54,
	0x49, 0x41, 0x4c, 0x10, 0x04, 0x2a, 0x66, 0x0a, 0x0b, 0x54, 0x65, 0x73, 0x74, 0x43, 0x61, 0x63,
	0x68, 0x69, 0x6e, 0x67, 0x12, 0x1c, 0x0a, 0x18, 0x54, 0x45, 0x53, 0x54, 0x5f, 0x43, 0x41, 0x43,
	0x48, 0x49, 0x4e, 0x47, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4c, 0x4f, 0x43, 0x41, 0x4c, 0x5f, 0x43, 0x41, 0x43, 0x48,
	0x45, 0x5f, 0x48, 0x49, 0x54, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x45, 0x4d, 0x4f, 0x54,
	0x45, 0x5f, 0x43, 0x41, 0x43, 0x48, 0x45, 0x5f, 0x48, 0x49, 0x54, 0x10, 0x02, 0x12, 0x0e, 0x0a,
	0x0a, 0x43, 0x41, 0x43, 0x48, 0x45, 0x5f, 0x4d, 0x49, 0x53, 0x53, 0x10, 0x03, 0x42, 0x71, 0x0a,
	0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x32, 0x50, 0x01, 0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2f, 0x76, 0x32, 0x3b, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_resultstore_v2_action_proto_rawDescOnce sync.Once
	file_google_devtools_resultstore_v2_action_proto_rawDescData = file_google_devtools_resultstore_v2_action_proto_rawDesc
)

func file_google_devtools_resultstore_v2_action_proto_rawDescGZIP() []byte {
	file_google_devtools_resultstore_v2_action_proto_rawDescOnce.Do(func() {
		file_google_devtools_resultstore_v2_action_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_resultstore_v2_action_proto_rawDescData)
	})
	return file_google_devtools_resultstore_v2_action_proto_rawDescData
}

var file_google_devtools_resultstore_v2_action_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_devtools_resultstore_v2_action_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_devtools_resultstore_v2_action_proto_goTypes = []interface{}{
	(ExecutionStrategy)(0),          // 0: google.devtools.resultstore.v2.ExecutionStrategy
	(TestCaching)(0),                // 1: google.devtools.resultstore.v2.TestCaching
	(*Action)(nil),                  // 2: google.devtools.resultstore.v2.Action
	(*BuildAction)(nil),             // 3: google.devtools.resultstore.v2.BuildAction
	(*TestAction)(nil),              // 4: google.devtools.resultstore.v2.TestAction
	(*ActionAttributes)(nil),        // 5: google.devtools.resultstore.v2.ActionAttributes
	(*InputFileInfo)(nil),           // 6: google.devtools.resultstore.v2.InputFileInfo
	(*LocalTestTiming)(nil),         // 7: google.devtools.resultstore.v2.LocalTestTiming
	(*RemoteTestAttemptTiming)(nil), // 8: google.devtools.resultstore.v2.RemoteTestAttemptTiming
	(*RemoteTestTiming)(nil),        // 9: google.devtools.resultstore.v2.RemoteTestTiming
	(*TestTiming)(nil),              // 10: google.devtools.resultstore.v2.TestTiming
	(*TestWarning)(nil),             // 11: google.devtools.resultstore.v2.TestWarning
	(*Action_Id)(nil),               // 12: google.devtools.resultstore.v2.Action.Id
	(*StatusAttributes)(nil),        // 13: google.devtools.resultstore.v2.StatusAttributes
	(*Timing)(nil),                  // 14: google.devtools.resultstore.v2.Timing
	(*Dependency)(nil),              // 15: google.devtools.resultstore.v2.Dependency
	(*Property)(nil),                // 16: google.devtools.resultstore.v2.Property
	(*File)(nil),                    // 17: google.devtools.resultstore.v2.File
	(*ActionCoverage)(nil),          // 18: google.devtools.resultstore.v2.ActionCoverage
	(*FileProcessingErrors)(nil),    // 19: google.devtools.resultstore.v2.FileProcessingErrors
	(*TestSuite)(nil),               // 20: google.devtools.resultstore.v2.TestSuite
	(*duration.Duration)(nil),       // 21: google.protobuf.Duration
}
var file_google_devtools_resultstore_v2_action_proto_depIdxs = []int32{
	12, // 0: google.devtools.resultstore.v2.Action.id:type_name -> google.devtools.resultstore.v2.Action.Id
	13, // 1: google.devtools.resultstore.v2.Action.status_attributes:type_name -> google.devtools.resultstore.v2.StatusAttributes
	14, // 2: google.devtools.resultstore.v2.Action.timing:type_name -> google.devtools.resultstore.v2.Timing
	3,  // 3: google.devtools.resultstore.v2.Action.build_action:type_name -> google.devtools.resultstore.v2.BuildAction
	4,  // 4: google.devtools.resultstore.v2.Action.test_action:type_name -> google.devtools.resultstore.v2.TestAction
	5,  // 5: google.devtools.resultstore.v2.Action.action_attributes:type_name -> google.devtools.resultstore.v2.ActionAttributes
	15, // 6: google.devtools.resultstore.v2.Action.action_dependencies:type_name -> google.devtools.resultstore.v2.Dependency
	16, // 7: google.devtools.resultstore.v2.Action.properties:type_name -> google.devtools.resultstore.v2.Property
	17, // 8: google.devtools.resultstore.v2.Action.files:type_name -> google.devtools.resultstore.v2.File
	18, // 9: google.devtools.resultstore.v2.Action.coverage:type_name -> google.devtools.resultstore.v2.ActionCoverage
	19, // 10: google.devtools.resultstore.v2.Action.file_processing_errors:type_name -> google.devtools.resultstore.v2.FileProcessingErrors
	10, // 11: google.devtools.resultstore.v2.TestAction.test_timing:type_name -> google.devtools.resultstore.v2.TestTiming
	20, // 12: google.devtools.resultstore.v2.TestAction.test_suite:type_name -> google.devtools.resultstore.v2.TestSuite
	11, // 13: google.devtools.resultstore.v2.TestAction.warnings:type_name -> google.devtools.resultstore.v2.TestWarning
	0,  // 14: google.devtools.resultstore.v2.ActionAttributes.execution_strategy:type_name -> google.devtools.resultstore.v2.ExecutionStrategy
	6,  // 15: google.devtools.resultstore.v2.ActionAttributes.input_file_info:type_name -> google.devtools.resultstore.v2.InputFileInfo
	21, // 16: google.devtools.resultstore.v2.LocalTestTiming.test_process_duration:type_name -> google.protobuf.Duration
	21, // 17: google.devtools.resultstore.v2.RemoteTestAttemptTiming.queue_duration:type_name -> google.protobuf.Duration
	21, // 18: google.devtools.resultstore.v2.RemoteTestAttemptTiming.upload_duration:type_name -> google.protobuf.Duration
	21, // 19: google.devtools.resultstore.v2.RemoteTestAttemptTiming.machine_setup_duration:type_name -> google.protobuf.Duration
	21, // 20: google.devtools.resultstore.v2.RemoteTestAttemptTiming.test_process_duration:type_name -> google.protobuf.Duration
	21, // 21: google.devtools.resultstore.v2.RemoteTestAttemptTiming.download_duration:type_name -> google.protobuf.Duration
	21, // 22: google.devtools.resultstore.v2.RemoteTestTiming.local_analysis_duration:type_name -> google.protobuf.Duration
	8,  // 23: google.devtools.resultstore.v2.RemoteTestTiming.attempts:type_name -> google.devtools.resultstore.v2.RemoteTestAttemptTiming
	7,  // 24: google.devtools.resultstore.v2.TestTiming.local:type_name -> google.devtools.resultstore.v2.LocalTestTiming
	9,  // 25: google.devtools.resultstore.v2.TestTiming.remote:type_name -> google.devtools.resultstore.v2.RemoteTestTiming
	21, // 26: google.devtools.resultstore.v2.TestTiming.system_time_duration:type_name -> google.protobuf.Duration
	21, // 27: google.devtools.resultstore.v2.TestTiming.user_time_duration:type_name -> google.protobuf.Duration
	1,  // 28: google.devtools.resultstore.v2.TestTiming.test_caching:type_name -> google.devtools.resultstore.v2.TestCaching
	29, // [29:29] is the sub-list for method output_type
	29, // [29:29] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_google_devtools_resultstore_v2_action_proto_init() }
func file_google_devtools_resultstore_v2_action_proto_init() {
	if File_google_devtools_resultstore_v2_action_proto != nil {
		return
	}
	file_google_devtools_resultstore_v2_common_proto_init()
	file_google_devtools_resultstore_v2_coverage_proto_init()
	file_google_devtools_resultstore_v2_file_proto_init()
	file_google_devtools_resultstore_v2_file_processing_error_proto_init()
	file_google_devtools_resultstore_v2_test_suite_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_resultstore_v2_action_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_action_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BuildAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_action_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_action_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ActionAttributes); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_action_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InputFileInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_action_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocalTestTiming); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_action_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteTestAttemptTiming); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_action_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RemoteTestTiming); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_action_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestTiming); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_action_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TestWarning); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_resultstore_v2_action_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Action_Id); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_devtools_resultstore_v2_action_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Action_BuildAction)(nil),
		(*Action_TestAction)(nil),
	}
	file_google_devtools_resultstore_v2_action_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*TestTiming_Local)(nil),
		(*TestTiming_Remote)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_resultstore_v2_action_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_devtools_resultstore_v2_action_proto_goTypes,
		DependencyIndexes: file_google_devtools_resultstore_v2_action_proto_depIdxs,
		EnumInfos:         file_google_devtools_resultstore_v2_action_proto_enumTypes,
		MessageInfos:      file_google_devtools_resultstore_v2_action_proto_msgTypes,
	}.Build()
	File_google_devtools_resultstore_v2_action_proto = out.File
	file_google_devtools_resultstore_v2_action_proto_rawDesc = nil
	file_google_devtools_resultstore_v2_action_proto_goTypes = nil
	file_google_devtools_resultstore_v2_action_proto_depIdxs = nil
}
