package streamanalytics

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AuthenticationMode enumerates the values for authentication mode.
type AuthenticationMode string

const (
	// ConnectionString ...
	ConnectionString AuthenticationMode = "ConnectionString"
	// Msi ...
	Msi AuthenticationMode = "Msi"
	// UserToken ...
	UserToken AuthenticationMode = "UserToken"
)

// PossibleAuthenticationModeValues returns an array of possible values for the AuthenticationMode const type.
func PossibleAuthenticationModeValues() []AuthenticationMode {
	return []AuthenticationMode{ConnectionString, Msi, UserToken}
}

// BindingType enumerates the values for binding type.
type BindingType string

const (
	// BindingTypeFunctionRetrieveDefaultDefinitionParameters ...
	BindingTypeFunctionRetrieveDefaultDefinitionParameters BindingType = "FunctionRetrieveDefaultDefinitionParameters"
	// BindingTypeMicrosoftMachineLearningServices ...
	BindingTypeMicrosoftMachineLearningServices BindingType = "Microsoft.MachineLearningServices"
	// BindingTypeMicrosoftMachineLearningWebService ...
	BindingTypeMicrosoftMachineLearningWebService BindingType = "Microsoft.MachineLearning/WebService"
	// BindingTypeMicrosoftStreamAnalyticsCLRUdf ...
	BindingTypeMicrosoftStreamAnalyticsCLRUdf BindingType = "Microsoft.StreamAnalytics/CLRUdf"
	// BindingTypeMicrosoftStreamAnalyticsJavascriptUdf ...
	BindingTypeMicrosoftStreamAnalyticsJavascriptUdf BindingType = "Microsoft.StreamAnalytics/JavascriptUdf"
)

// PossibleBindingTypeValues returns an array of possible values for the BindingType const type.
func PossibleBindingTypeValues() []BindingType {
	return []BindingType{BindingTypeFunctionRetrieveDefaultDefinitionParameters, BindingTypeMicrosoftMachineLearningServices, BindingTypeMicrosoftMachineLearningWebService, BindingTypeMicrosoftStreamAnalyticsCLRUdf, BindingTypeMicrosoftStreamAnalyticsJavascriptUdf}
}

// ClusterProvisioningState enumerates the values for cluster provisioning state.
type ClusterProvisioningState string

const (
	// Canceled The cluster provisioning was canceled.
	Canceled ClusterProvisioningState = "Canceled"
	// Failed The cluster provisioning failed.
	Failed ClusterProvisioningState = "Failed"
	// InProgress The cluster provisioning was inprogress.
	InProgress ClusterProvisioningState = "InProgress"
	// Succeeded The cluster provisioning succeeded.
	Succeeded ClusterProvisioningState = "Succeeded"
)

// PossibleClusterProvisioningStateValues returns an array of possible values for the ClusterProvisioningState const type.
func PossibleClusterProvisioningStateValues() []ClusterProvisioningState {
	return []ClusterProvisioningState{Canceled, Failed, InProgress, Succeeded}
}

// ClusterSkuName enumerates the values for cluster sku name.
type ClusterSkuName string

const (
	// Default The default SKU.
	Default ClusterSkuName = "Default"
)

// PossibleClusterSkuNameValues returns an array of possible values for the ClusterSkuName const type.
func PossibleClusterSkuNameValues() []ClusterSkuName {
	return []ClusterSkuName{Default}
}

// CompatibilityLevel enumerates the values for compatibility level.
type CompatibilityLevel string

const (
	// OneFullStopZero ...
	OneFullStopZero CompatibilityLevel = "1.0"
)

// PossibleCompatibilityLevelValues returns an array of possible values for the CompatibilityLevel const type.
func PossibleCompatibilityLevelValues() []CompatibilityLevel {
	return []CompatibilityLevel{OneFullStopZero}
}

// ContentStoragePolicy enumerates the values for content storage policy.
type ContentStoragePolicy string

const (
	// ContentStoragePolicyJobStorageAccount ...
	ContentStoragePolicyJobStorageAccount ContentStoragePolicy = "JobStorageAccount"
	// ContentStoragePolicySystemAccount ...
	ContentStoragePolicySystemAccount ContentStoragePolicy = "SystemAccount"
)

// PossibleContentStoragePolicyValues returns an array of possible values for the ContentStoragePolicy const type.
func PossibleContentStoragePolicyValues() []ContentStoragePolicy {
	return []ContentStoragePolicy{ContentStoragePolicyJobStorageAccount, ContentStoragePolicySystemAccount}
}

// Encoding enumerates the values for encoding.
type Encoding string

const (
	// UTF8 ...
	UTF8 Encoding = "UTF8"
)

// PossibleEncodingValues returns an array of possible values for the Encoding const type.
func PossibleEncodingValues() []Encoding {
	return []Encoding{UTF8}
}

// EventSerializationType enumerates the values for event serialization type.
type EventSerializationType string

const (
	// Avro ...
	Avro EventSerializationType = "Avro"
	// Csv ...
	Csv EventSerializationType = "Csv"
	// CustomClr ...
	CustomClr EventSerializationType = "CustomClr"
	// JSON ...
	JSON EventSerializationType = "Json"
	// Parquet ...
	Parquet EventSerializationType = "Parquet"
)

// PossibleEventSerializationTypeValues returns an array of possible values for the EventSerializationType const type.
func PossibleEventSerializationTypeValues() []EventSerializationType {
	return []EventSerializationType{Avro, Csv, CustomClr, JSON, Parquet}
}

// EventsOutOfOrderPolicy enumerates the values for events out of order policy.
type EventsOutOfOrderPolicy string

const (
	// Adjust ...
	Adjust EventsOutOfOrderPolicy = "Adjust"
	// Drop ...
	Drop EventsOutOfOrderPolicy = "Drop"
)

// PossibleEventsOutOfOrderPolicyValues returns an array of possible values for the EventsOutOfOrderPolicy const type.
func PossibleEventsOutOfOrderPolicyValues() []EventsOutOfOrderPolicy {
	return []EventsOutOfOrderPolicy{Adjust, Drop}
}

// JobState enumerates the values for job state.
type JobState string

const (
	// JobStateCreated The job is currently in the Created state.
	JobStateCreated JobState = "Created"
	// JobStateDegraded The job is currently in the Degraded state.
	JobStateDegraded JobState = "Degraded"
	// JobStateDeleting The job is currently in the Deleting state.
	JobStateDeleting JobState = "Deleting"
	// JobStateFailed The job is currently in the Failed state.
	JobStateFailed JobState = "Failed"
	// JobStateRestarting The job is currently in the Restarting state.
	JobStateRestarting JobState = "Restarting"
	// JobStateRunning The job is currently in the Running state.
	JobStateRunning JobState = "Running"
	// JobStateScaling The job is currently in the Scaling state.
	JobStateScaling JobState = "Scaling"
	// JobStateStarting The job is currently in the Starting state.
	JobStateStarting JobState = "Starting"
	// JobStateStopped The job is currently in the Stopped state.
	JobStateStopped JobState = "Stopped"
	// JobStateStopping The job is currently in the Stopping state.
	JobStateStopping JobState = "Stopping"
)

// PossibleJobStateValues returns an array of possible values for the JobState const type.
func PossibleJobStateValues() []JobState {
	return []JobState{JobStateCreated, JobStateDegraded, JobStateDeleting, JobStateFailed, JobStateRestarting, JobStateRunning, JobStateScaling, JobStateStarting, JobStateStopped, JobStateStopping}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// Cloud ...
	Cloud JobType = "Cloud"
	// Edge ...
	Edge JobType = "Edge"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{Cloud, Edge}
}

// JSONOutputSerializationFormat enumerates the values for json output serialization format.
type JSONOutputSerializationFormat string

const (
	// Array ...
	Array JSONOutputSerializationFormat = "Array"
	// LineSeparated ...
	LineSeparated JSONOutputSerializationFormat = "LineSeparated"
)

// PossibleJSONOutputSerializationFormatValues returns an array of possible values for the JSONOutputSerializationFormat const type.
func PossibleJSONOutputSerializationFormatValues() []JSONOutputSerializationFormat {
	return []JSONOutputSerializationFormat{Array, LineSeparated}
}

// OutputErrorPolicy enumerates the values for output error policy.
type OutputErrorPolicy string

const (
	// OutputErrorPolicyDrop ...
	OutputErrorPolicyDrop OutputErrorPolicy = "Drop"
	// OutputErrorPolicyStop ...
	OutputErrorPolicyStop OutputErrorPolicy = "Stop"
)

// PossibleOutputErrorPolicyValues returns an array of possible values for the OutputErrorPolicy const type.
func PossibleOutputErrorPolicyValues() []OutputErrorPolicy {
	return []OutputErrorPolicy{OutputErrorPolicyDrop, OutputErrorPolicyStop}
}

// OutputStartMode enumerates the values for output start mode.
type OutputStartMode string

const (
	// CustomTime ...
	CustomTime OutputStartMode = "CustomTime"
	// JobStartTime ...
	JobStartTime OutputStartMode = "JobStartTime"
	// LastOutputEventTime ...
	LastOutputEventTime OutputStartMode = "LastOutputEventTime"
)

// PossibleOutputStartModeValues returns an array of possible values for the OutputStartMode const type.
func PossibleOutputStartModeValues() []OutputStartMode {
	return []OutputStartMode{CustomTime, JobStartTime, LastOutputEventTime}
}

// StreamingJobSkuName enumerates the values for streaming job sku name.
type StreamingJobSkuName string

const (
	// Standard ...
	Standard StreamingJobSkuName = "Standard"
)

// PossibleStreamingJobSkuNameValues returns an array of possible values for the StreamingJobSkuName const type.
func PossibleStreamingJobSkuNameValues() []StreamingJobSkuName {
	return []StreamingJobSkuName{Standard}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeFunctionBinding ...
	TypeFunctionBinding Type = "FunctionBinding"
	// TypeMicrosoftMachineLearningServices ...
	TypeMicrosoftMachineLearningServices Type = "Microsoft.MachineLearningServices"
	// TypeMicrosoftMachineLearningWebService ...
	TypeMicrosoftMachineLearningWebService Type = "Microsoft.MachineLearning/WebService"
	// TypeMicrosoftStreamAnalyticsCLRUdf ...
	TypeMicrosoftStreamAnalyticsCLRUdf Type = "Microsoft.StreamAnalytics/CLRUdf"
	// TypeMicrosoftStreamAnalyticsJavascriptUdf ...
	TypeMicrosoftStreamAnalyticsJavascriptUdf Type = "Microsoft.StreamAnalytics/JavascriptUdf"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeFunctionBinding, TypeMicrosoftMachineLearningServices, TypeMicrosoftMachineLearningWebService, TypeMicrosoftStreamAnalyticsCLRUdf, TypeMicrosoftStreamAnalyticsJavascriptUdf}
}

// TypeBasicFunctionProperties enumerates the values for type basic function properties.
type TypeBasicFunctionProperties string

const (
	// TypeAggregate ...
	TypeAggregate TypeBasicFunctionProperties = "Aggregate"
	// TypeFunctionProperties ...
	TypeFunctionProperties TypeBasicFunctionProperties = "FunctionProperties"
	// TypeScalar ...
	TypeScalar TypeBasicFunctionProperties = "Scalar"
)

// PossibleTypeBasicFunctionPropertiesValues returns an array of possible values for the TypeBasicFunctionProperties const type.
func PossibleTypeBasicFunctionPropertiesValues() []TypeBasicFunctionProperties {
	return []TypeBasicFunctionProperties{TypeAggregate, TypeFunctionProperties, TypeScalar}
}

// TypeBasicInputProperties enumerates the values for type basic input properties.
type TypeBasicInputProperties string

const (
	// TypeInputProperties ...
	TypeInputProperties TypeBasicInputProperties = "InputProperties"
	// TypeReference ...
	TypeReference TypeBasicInputProperties = "Reference"
	// TypeStream ...
	TypeStream TypeBasicInputProperties = "Stream"
)

// PossibleTypeBasicInputPropertiesValues returns an array of possible values for the TypeBasicInputProperties const type.
func PossibleTypeBasicInputPropertiesValues() []TypeBasicInputProperties {
	return []TypeBasicInputProperties{TypeInputProperties, TypeReference, TypeStream}
}

// TypeBasicOutputDataSource enumerates the values for type basic output data source.
type TypeBasicOutputDataSource string

const (
	// TypeMicrosoftAzureFunction ...
	TypeMicrosoftAzureFunction TypeBasicOutputDataSource = "Microsoft.AzureFunction"
	// TypeMicrosoftDataLakeAccounts ...
	TypeMicrosoftDataLakeAccounts TypeBasicOutputDataSource = "Microsoft.DataLake/Accounts"
	// TypeMicrosoftEventHubEventHub ...
	TypeMicrosoftEventHubEventHub TypeBasicOutputDataSource = "Microsoft.EventHub/EventHub"
	// TypeMicrosoftServiceBusEventHub ...
	TypeMicrosoftServiceBusEventHub TypeBasicOutputDataSource = "Microsoft.ServiceBus/EventHub"
	// TypeMicrosoftServiceBusQueue ...
	TypeMicrosoftServiceBusQueue TypeBasicOutputDataSource = "Microsoft.ServiceBus/Queue"
	// TypeMicrosoftServiceBusTopic ...
	TypeMicrosoftServiceBusTopic TypeBasicOutputDataSource = "Microsoft.ServiceBus/Topic"
	// TypeMicrosoftSQLServerDatabase ...
	TypeMicrosoftSQLServerDatabase TypeBasicOutputDataSource = "Microsoft.Sql/Server/Database"
	// TypeMicrosoftSQLServerDataWarehouse ...
	TypeMicrosoftSQLServerDataWarehouse TypeBasicOutputDataSource = "Microsoft.Sql/Server/DataWarehouse"
	// TypeMicrosoftStorageBlob ...
	TypeMicrosoftStorageBlob TypeBasicOutputDataSource = "Microsoft.Storage/Blob"
	// TypeMicrosoftStorageDocumentDB ...
	TypeMicrosoftStorageDocumentDB TypeBasicOutputDataSource = "Microsoft.Storage/DocumentDB"
	// TypeMicrosoftStorageTable ...
	TypeMicrosoftStorageTable TypeBasicOutputDataSource = "Microsoft.Storage/Table"
	// TypeOutputDataSource ...
	TypeOutputDataSource TypeBasicOutputDataSource = "OutputDataSource"
	// TypePowerBI ...
	TypePowerBI TypeBasicOutputDataSource = "PowerBI"
)

// PossibleTypeBasicOutputDataSourceValues returns an array of possible values for the TypeBasicOutputDataSource const type.
func PossibleTypeBasicOutputDataSourceValues() []TypeBasicOutputDataSource {
	return []TypeBasicOutputDataSource{TypeMicrosoftAzureFunction, TypeMicrosoftDataLakeAccounts, TypeMicrosoftEventHubEventHub, TypeMicrosoftServiceBusEventHub, TypeMicrosoftServiceBusQueue, TypeMicrosoftServiceBusTopic, TypeMicrosoftSQLServerDatabase, TypeMicrosoftSQLServerDataWarehouse, TypeMicrosoftStorageBlob, TypeMicrosoftStorageDocumentDB, TypeMicrosoftStorageTable, TypeOutputDataSource, TypePowerBI}
}

// TypeBasicReferenceInputDataSource enumerates the values for type basic reference input data source.
type TypeBasicReferenceInputDataSource string

const (
	// TypeBasicReferenceInputDataSourceTypeMicrosoftSQLServerDatabase ...
	TypeBasicReferenceInputDataSourceTypeMicrosoftSQLServerDatabase TypeBasicReferenceInputDataSource = "Microsoft.Sql/Server/Database"
	// TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob ...
	TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob TypeBasicReferenceInputDataSource = "Microsoft.Storage/Blob"
	// TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource ...
	TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource TypeBasicReferenceInputDataSource = "ReferenceInputDataSource"
)

// PossibleTypeBasicReferenceInputDataSourceValues returns an array of possible values for the TypeBasicReferenceInputDataSource const type.
func PossibleTypeBasicReferenceInputDataSourceValues() []TypeBasicReferenceInputDataSource {
	return []TypeBasicReferenceInputDataSource{TypeBasicReferenceInputDataSourceTypeMicrosoftSQLServerDatabase, TypeBasicReferenceInputDataSourceTypeMicrosoftStorageBlob, TypeBasicReferenceInputDataSourceTypeReferenceInputDataSource}
}

// TypeBasicSerialization enumerates the values for type basic serialization.
type TypeBasicSerialization string

const (
	// TypeAvro ...
	TypeAvro TypeBasicSerialization = "Avro"
	// TypeCsv ...
	TypeCsv TypeBasicSerialization = "Csv"
	// TypeCustomClr ...
	TypeCustomClr TypeBasicSerialization = "CustomClr"
	// TypeJSON ...
	TypeJSON TypeBasicSerialization = "Json"
	// TypeParquet ...
	TypeParquet TypeBasicSerialization = "Parquet"
	// TypeSerialization ...
	TypeSerialization TypeBasicSerialization = "Serialization"
)

// PossibleTypeBasicSerializationValues returns an array of possible values for the TypeBasicSerialization const type.
func PossibleTypeBasicSerializationValues() []TypeBasicSerialization {
	return []TypeBasicSerialization{TypeAvro, TypeCsv, TypeCustomClr, TypeJSON, TypeParquet, TypeSerialization}
}

// TypeBasicStreamInputDataSource enumerates the values for type basic stream input data source.
type TypeBasicStreamInputDataSource string

const (
	// TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs ...
	TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs TypeBasicStreamInputDataSource = "Microsoft.Devices/IotHubs"
	// TypeBasicStreamInputDataSourceTypeMicrosoftEventHubEventHub ...
	TypeBasicStreamInputDataSourceTypeMicrosoftEventHubEventHub TypeBasicStreamInputDataSource = "Microsoft.EventHub/EventHub"
	// TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub ...
	TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub TypeBasicStreamInputDataSource = "Microsoft.ServiceBus/EventHub"
	// TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob ...
	TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob TypeBasicStreamInputDataSource = "Microsoft.Storage/Blob"
	// TypeBasicStreamInputDataSourceTypeStreamInputDataSource ...
	TypeBasicStreamInputDataSourceTypeStreamInputDataSource TypeBasicStreamInputDataSource = "StreamInputDataSource"
)

// PossibleTypeBasicStreamInputDataSourceValues returns an array of possible values for the TypeBasicStreamInputDataSource const type.
func PossibleTypeBasicStreamInputDataSourceValues() []TypeBasicStreamInputDataSource {
	return []TypeBasicStreamInputDataSource{TypeBasicStreamInputDataSourceTypeMicrosoftDevicesIotHubs, TypeBasicStreamInputDataSourceTypeMicrosoftEventHubEventHub, TypeBasicStreamInputDataSourceTypeMicrosoftServiceBusEventHub, TypeBasicStreamInputDataSourceTypeMicrosoftStorageBlob, TypeBasicStreamInputDataSourceTypeStreamInputDataSource}
}

// UdfType enumerates the values for udf type.
type UdfType string

const (
	// Scalar ...
	Scalar UdfType = "Scalar"
)

// PossibleUdfTypeValues returns an array of possible values for the UdfType const type.
func PossibleUdfTypeValues() []UdfType {
	return []UdfType{Scalar}
}
