package hybridnetworkapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/management/2020-01-01-preview/hybridnetwork"
)

// VirtualNetworkFunctionsClientAPI contains the set of methods on the VirtualNetworkFunctionsClient type.
type VirtualNetworkFunctionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, virtualNetworkFunctionName string, parameters hybridnetwork.VirtualNetworkFunction) (result hybridnetwork.VirtualNetworkFunctionsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, virtualNetworkFunctionName string) (result hybridnetwork.VirtualNetworkFunctionsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, virtualNetworkFunctionName string) (result hybridnetwork.VirtualNetworkFunction, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result hybridnetwork.VirtualNetworkFunctionListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result hybridnetwork.VirtualNetworkFunctionListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result hybridnetwork.VirtualNetworkFunctionListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result hybridnetwork.VirtualNetworkFunctionListResultIterator, err error)
	UpdateTags(ctx context.Context, resourceGroupName string, virtualNetworkFunctionName string, parameters hybridnetwork.TagsObject) (result hybridnetwork.VirtualNetworkFunction, err error)
}

var _ VirtualNetworkFunctionsClientAPI = (*hybridnetwork.VirtualNetworkFunctionsClient)(nil)

// DevicesClientAPI contains the set of methods on the DevicesClient type.
type DevicesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, deviceName string, parameters hybridnetwork.Device) (result hybridnetwork.DevicesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, deviceName string) (result hybridnetwork.DevicesDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, deviceName string) (result hybridnetwork.Device, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result hybridnetwork.DeviceListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result hybridnetwork.DeviceListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result hybridnetwork.DeviceListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result hybridnetwork.DeviceListResultIterator, err error)
	ListRegistrationKey(ctx context.Context, resourceGroupName string, deviceName string) (result hybridnetwork.DeviceRegistrationKey, err error)
	UpdateTags(ctx context.Context, resourceGroupName string, deviceName string, parameters hybridnetwork.TagsObject) (result hybridnetwork.Device, err error)
}

var _ DevicesClientAPI = (*hybridnetwork.DevicesClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result hybridnetwork.OperationListPage, err error)
	ListComplete(ctx context.Context) (result hybridnetwork.OperationListIterator, err error)
}

var _ OperationsClientAPI = (*hybridnetwork.OperationsClient)(nil)

// VendorsClientAPI contains the set of methods on the VendorsClient type.
type VendorsClientAPI interface {
	CreateOrUpdate(ctx context.Context, vendorName string, parameters *hybridnetwork.Vendor) (result hybridnetwork.VendorsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, vendorName string) (result hybridnetwork.VendorsDeleteFuture, err error)
	Get(ctx context.Context, vendorName string) (result hybridnetwork.Vendor, err error)
	ListBySubscription(ctx context.Context) (result hybridnetwork.VendorListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result hybridnetwork.VendorListResultIterator, err error)
}

var _ VendorsClientAPI = (*hybridnetwork.VendorsClient)(nil)

// VendorSkusClientAPI contains the set of methods on the VendorSkusClient type.
type VendorSkusClientAPI interface {
	CreateOrUpdate(ctx context.Context, vendorName string, skuName string, parameters hybridnetwork.VendorSku) (result hybridnetwork.VendorSkusCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, vendorName string, skuName string) (result hybridnetwork.VendorSkusDeleteFuture, err error)
	Get(ctx context.Context, vendorName string, skuName string) (result hybridnetwork.VendorSku, err error)
	List(ctx context.Context, vendorName string) (result hybridnetwork.VendorSkuListResultPage, err error)
	ListComplete(ctx context.Context, vendorName string) (result hybridnetwork.VendorSkuListResultIterator, err error)
}

var _ VendorSkusClientAPI = (*hybridnetwork.VendorSkusClient)(nil)

// VendorVirtualNetworkFunctionsClientAPI contains the set of methods on the VendorVirtualNetworkFunctionsClient type.
type VendorVirtualNetworkFunctionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, locationName string, vendorName string, serviceKey string, parameters hybridnetwork.VendorVirtualNetworkFunction) (result hybridnetwork.VendorVirtualNetworkFunctionsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, locationName string, vendorName string, serviceKey string) (result hybridnetwork.VendorVirtualNetworkFunction, err error)
	List(ctx context.Context, locationName string, vendorName string, filter string) (result hybridnetwork.VendorVirtualNetworkFunctionListResultPage, err error)
	ListComplete(ctx context.Context, locationName string, vendorName string, filter string) (result hybridnetwork.VendorVirtualNetworkFunctionListResultIterator, err error)
}

var _ VendorVirtualNetworkFunctionsClientAPI = (*hybridnetwork.VendorVirtualNetworkFunctionsClient)(nil)

// VendorSkuPreviewClientAPI contains the set of methods on the VendorSkuPreviewClient type.
type VendorSkuPreviewClientAPI interface {
	CreateOrUpdate(ctx context.Context, vendorName string, skuName string, previewSubscription string, parameters hybridnetwork.PreviewSubscription) (result hybridnetwork.VendorSkuPreviewCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, vendorName string, skuName string, previewSubscription string) (result hybridnetwork.VendorSkuPreviewDeleteFuture, err error)
	Get(ctx context.Context, vendorName string, skuName string, previewSubscription string) (result hybridnetwork.PreviewSubscription, err error)
	List(ctx context.Context, vendorName string, skuName string) (result hybridnetwork.PreviewSubscriptionsListPage, err error)
	ListComplete(ctx context.Context, vendorName string, skuName string) (result hybridnetwork.PreviewSubscriptionsListIterator, err error)
}

var _ VendorSkuPreviewClientAPI = (*hybridnetwork.VendorSkuPreviewClient)(nil)

// VirtualNetworkFunctionVendorsClientAPI contains the set of methods on the VirtualNetworkFunctionVendorsClient type.
type VirtualNetworkFunctionVendorsClientAPI interface {
	List(ctx context.Context) (result hybridnetwork.VirtualNetworkFunctionVendorListResultPage, err error)
	ListComplete(ctx context.Context) (result hybridnetwork.VirtualNetworkFunctionVendorListResultIterator, err error)
}

var _ VirtualNetworkFunctionVendorsClientAPI = (*hybridnetwork.VirtualNetworkFunctionVendorsClient)(nil)

// VirtualNetworkFunctionVendorSkusClientAPI contains the set of methods on the VirtualNetworkFunctionVendorSkusClient type.
type VirtualNetworkFunctionVendorSkusClientAPI interface {
	List(ctx context.Context, vendorName string, vendorSkuName string) (result hybridnetwork.VirtualNetworkFunctionSkuDetailsPage, err error)
	ListComplete(ctx context.Context, vendorName string, vendorSkuName string) (result hybridnetwork.VirtualNetworkFunctionSkuDetailsIterator, err error)
	ListByVendor(ctx context.Context, vendorName string) (result hybridnetwork.VirtualNetworkFunctionSkuListResultPage, err error)
	ListByVendorComplete(ctx context.Context, vendorName string) (result hybridnetwork.VirtualNetworkFunctionSkuListResultIterator, err error)
}

var _ VirtualNetworkFunctionVendorSkusClientAPI = (*hybridnetwork.VirtualNetworkFunctionVendorSkusClient)(nil)
