package hdinsight

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"io"
	"net/http"
)

// JobClient is the the HDInsight Job Client.
type JobClient struct {
	BaseClient
}

// NewJobClient creates an instance of the JobClient client.
func NewJobClient(endpoint string, userName string) JobClient {
	return JobClient{New(endpoint, userName)}
}

// DeleteSparkBatch cancels a running spark batch job.
// Parameters:
// batchID - identifier for the batch job.
// requestedBy - add default value for X-Requested-By in header.
func (client JobClient) DeleteSparkBatch(ctx context.Context, batchID int32, requestedBy string) (result SparkJobDeletedResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.DeleteSparkBatch")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSparkBatchPreparer(ctx, batchID, requestedBy)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "DeleteSparkBatch", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSparkBatchSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "DeleteSparkBatch", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSparkBatchResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "DeleteSparkBatch", resp, "Failure responding to request")
	}

	return
}

// DeleteSparkBatchPreparer prepares the DeleteSparkBatch request.
func (client JobClient) DeleteSparkBatchPreparer(ctx context.Context, batchID int32, requestedBy string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"batchId": autorest.Encode("path", batchID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/livy/batches/{batchId}", pathParameters))
	if len(requestedBy) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Requested-By", autorest.String(requestedBy)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Requested-By", autorest.String("ambari")))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSparkBatchSender sends the DeleteSparkBatch request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) DeleteSparkBatchSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteSparkBatchResponder handles the response to the DeleteSparkBatch request. The method always
// closes the http.Response Body.
func (client JobClient) DeleteSparkBatchResponder(resp *http.Response) (result SparkJobDeletedResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSparkSessionJob cancels a running spark session.
// Parameters:
// sessionID - identifier for the session.
// requestedBy - add default value for X-Requested-By in header.
func (client JobClient) DeleteSparkSessionJob(ctx context.Context, sessionID int32, requestedBy string) (result SparkJobDeletedResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.DeleteSparkSessionJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSparkSessionJobPreparer(ctx, sessionID, requestedBy)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "DeleteSparkSessionJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSparkSessionJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "DeleteSparkSessionJob", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSparkSessionJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "DeleteSparkSessionJob", resp, "Failure responding to request")
	}

	return
}

// DeleteSparkSessionJobPreparer prepares the DeleteSparkSessionJob request.
func (client JobClient) DeleteSparkSessionJobPreparer(ctx context.Context, sessionID int32, requestedBy string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"sessionId": autorest.Encode("path", sessionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/livy/sessions/{sessionId}", pathParameters))
	if len(requestedBy) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Requested-By", autorest.String(requestedBy)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Requested-By", autorest.String("ambari")))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSparkSessionJobSender sends the DeleteSparkSessionJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) DeleteSparkSessionJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteSparkSessionJobResponder handles the response to the DeleteSparkSessionJob request. The method always
// closes the http.Response Body.
func (client JobClient) DeleteSparkSessionJobResponder(resp *http.Response) (result SparkJobDeletedResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteSparkStatementJob kill a statement within a session.
// Parameters:
// sessionID - identifier for the session.
// statementID - identifier for the statement.
// requestedBy - add default value for X-Requested-By in header.
func (client JobClient) DeleteSparkStatementJob(ctx context.Context, sessionID int32, statementID int32, requestedBy string) (result SparkStatementCancellationResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.DeleteSparkStatementJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteSparkStatementJobPreparer(ctx, sessionID, statementID, requestedBy)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "DeleteSparkStatementJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSparkStatementJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "DeleteSparkStatementJob", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteSparkStatementJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "DeleteSparkStatementJob", resp, "Failure responding to request")
	}

	return
}

// DeleteSparkStatementJobPreparer prepares the DeleteSparkStatementJob request.
func (client JobClient) DeleteSparkStatementJobPreparer(ctx context.Context, sessionID int32, statementID int32, requestedBy string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"sessionId":   autorest.Encode("path", sessionID),
		"statementId": autorest.Encode("path", statementID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/livy/sessions/{sessionId}/statements/{statementId}/cancel", pathParameters))
	if len(requestedBy) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Requested-By", autorest.String(requestedBy)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Requested-By", autorest.String("ambari")))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSparkStatementJobSender sends the DeleteSparkStatementJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) DeleteSparkStatementJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteSparkStatementJobResponder handles the response to the DeleteSparkStatementJob request. The method always
// closes the http.Response Body.
func (client JobClient) DeleteSparkStatementJobResponder(resp *http.Response) (result SparkStatementCancellationResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get gets job details from the specified HDInsight cluster.
// Parameters:
// jobID - the id of the job.
func (client JobClient) Get(ctx context.Context, jobID string) (result JobDetailRootJSONObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, jobID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client JobClient) GetPreparer(ctx context.Context, jobID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"jobId": autorest.Encode("path", jobID),
	}

	queryParameters := map[string]interface{}{
		"fields":    autorest.Encode("query", "*"),
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/templeton/v1/jobs/{jobId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client JobClient) GetResponder(resp *http.Response) (result JobDetailRootJSONObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAppState gets application state from the specified HDInsight cluster.
// Parameters:
// appID - the id of the job.
func (client JobClient) GetAppState(ctx context.Context, appID string) (result AppState, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.GetAppState")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAppStatePreparer(ctx, appID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetAppState", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAppStateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetAppState", resp, "Failure sending request")
		return
	}

	result, err = client.GetAppStateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetAppState", resp, "Failure responding to request")
	}

	return
}

// GetAppStatePreparer prepares the GetAppState request.
func (client JobClient) GetAppStatePreparer(ctx context.Context, appID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"appId": autorest.Encode("path", appID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/ws/v1/cluster/apps/{appId}/state", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAppStateSender sends the GetAppState request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) GetAppStateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAppStateResponder handles the response to the GetAppState request. The method always
// closes the http.Response Body.
func (client JobClient) GetAppStateResponder(resp *http.Response) (result AppState, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSparkBatchJob gets a single spark batch job.
// Parameters:
// batchID - identifier for the batch job.
func (client JobClient) GetSparkBatchJob(ctx context.Context, batchID int32) (result SparkBatchJob, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.GetSparkBatchJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSparkBatchJobPreparer(ctx, batchID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkBatchJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSparkBatchJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkBatchJob", resp, "Failure sending request")
		return
	}

	result, err = client.GetSparkBatchJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkBatchJob", resp, "Failure responding to request")
	}

	return
}

// GetSparkBatchJobPreparer prepares the GetSparkBatchJob request.
func (client JobClient) GetSparkBatchJobPreparer(ctx context.Context, batchID int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"batchId": autorest.Encode("path", batchID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/livy/batches/{batchId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSparkBatchJobSender sends the GetSparkBatchJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) GetSparkBatchJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSparkBatchJobResponder handles the response to the GetSparkBatchJob request. The method always
// closes the http.Response Body.
func (client JobClient) GetSparkBatchJobResponder(resp *http.Response) (result SparkBatchJob, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSparkBatchLog gets a single spark batch job logs.
// Parameters:
// batchID - identifier for the batch job.
// from - optional param specifying which index the list should begin from.
// size - optional param specifying the size of the returned list.
// By default it is 20 and that is the maximum.
func (client JobClient) GetSparkBatchLog(ctx context.Context, batchID int32, from *int32, size *int32) (result SparkJobLog, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.GetSparkBatchLog")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSparkBatchLogPreparer(ctx, batchID, from, size)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkBatchLog", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSparkBatchLogSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkBatchLog", resp, "Failure sending request")
		return
	}

	result, err = client.GetSparkBatchLogResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkBatchLog", resp, "Failure responding to request")
	}

	return
}

// GetSparkBatchLogPreparer prepares the GetSparkBatchLog request.
func (client JobClient) GetSparkBatchLogPreparer(ctx context.Context, batchID int32, from *int32, size *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"batchId": autorest.Encode("path", batchID),
	}

	queryParameters := map[string]interface{}{}
	if from != nil {
		queryParameters["from"] = autorest.Encode("query", *from)
	}
	if size != nil {
		queryParameters["size"] = autorest.Encode("query", *size)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/livy/batches/{batchId}/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSparkBatchLogSender sends the GetSparkBatchLog request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) GetSparkBatchLogSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSparkBatchLogResponder handles the response to the GetSparkBatchLog request. The method always
// closes the http.Response Body.
func (client JobClient) GetSparkBatchLogResponder(resp *http.Response) (result SparkJobLog, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSparkBatchState gets a single spark batch state.
// Parameters:
// batchID - identifier for the batch job.
func (client JobClient) GetSparkBatchState(ctx context.Context, batchID int32) (result SparkJobState, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.GetSparkBatchState")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSparkBatchStatePreparer(ctx, batchID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkBatchState", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSparkBatchStateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkBatchState", resp, "Failure sending request")
		return
	}

	result, err = client.GetSparkBatchStateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkBatchState", resp, "Failure responding to request")
	}

	return
}

// GetSparkBatchStatePreparer prepares the GetSparkBatchState request.
func (client JobClient) GetSparkBatchStatePreparer(ctx context.Context, batchID int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"batchId": autorest.Encode("path", batchID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/livy/batches/{batchId}/state", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSparkBatchStateSender sends the GetSparkBatchState request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) GetSparkBatchStateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSparkBatchStateResponder handles the response to the GetSparkBatchState request. The method always
// closes the http.Response Body.
func (client JobClient) GetSparkBatchStateResponder(resp *http.Response) (result SparkJobState, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSparkSessionJob gets a single spark session.
// Parameters:
// sessionID - identifier for the session.
func (client JobClient) GetSparkSessionJob(ctx context.Context, sessionID int32) (result SparkSessionJob, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.GetSparkSessionJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSparkSessionJobPreparer(ctx, sessionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkSessionJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSparkSessionJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkSessionJob", resp, "Failure sending request")
		return
	}

	result, err = client.GetSparkSessionJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkSessionJob", resp, "Failure responding to request")
	}

	return
}

// GetSparkSessionJobPreparer prepares the GetSparkSessionJob request.
func (client JobClient) GetSparkSessionJobPreparer(ctx context.Context, sessionID int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"sessionId": autorest.Encode("path", sessionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/livy/sessions/{sessionId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSparkSessionJobSender sends the GetSparkSessionJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) GetSparkSessionJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSparkSessionJobResponder handles the response to the GetSparkSessionJob request. The method always
// closes the http.Response Body.
func (client JobClient) GetSparkSessionJobResponder(resp *http.Response) (result SparkSessionJob, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSparkSessionLog gets a single spark session job logs.
// Parameters:
// sessionID - identifier for the session job.
// from - optional param specifying which index the list should begin from.
// size - optional param specifying the size of the returned list.
// By default it is 20 and that is the maximum.
func (client JobClient) GetSparkSessionLog(ctx context.Context, sessionID int32, from *int32, size *int32) (result SparkJobLog, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.GetSparkSessionLog")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSparkSessionLogPreparer(ctx, sessionID, from, size)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkSessionLog", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSparkSessionLogSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkSessionLog", resp, "Failure sending request")
		return
	}

	result, err = client.GetSparkSessionLogResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkSessionLog", resp, "Failure responding to request")
	}

	return
}

// GetSparkSessionLogPreparer prepares the GetSparkSessionLog request.
func (client JobClient) GetSparkSessionLogPreparer(ctx context.Context, sessionID int32, from *int32, size *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"sessionId": autorest.Encode("path", sessionID),
	}

	queryParameters := map[string]interface{}{}
	if from != nil {
		queryParameters["from"] = autorest.Encode("query", *from)
	}
	if size != nil {
		queryParameters["size"] = autorest.Encode("query", *size)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/livy/sessions/{sessionId}/log", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSparkSessionLogSender sends the GetSparkSessionLog request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) GetSparkSessionLogSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSparkSessionLogResponder handles the response to the GetSparkSessionLog request. The method always
// closes the http.Response Body.
func (client JobClient) GetSparkSessionLogResponder(resp *http.Response) (result SparkJobLog, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSparkSessionState gets a single spark session job state.
// Parameters:
// sessionID - identifier for the session job.
func (client JobClient) GetSparkSessionState(ctx context.Context, sessionID int32) (result SparkJobState, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.GetSparkSessionState")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSparkSessionStatePreparer(ctx, sessionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkSessionState", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSparkSessionStateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkSessionState", resp, "Failure sending request")
		return
	}

	result, err = client.GetSparkSessionStateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkSessionState", resp, "Failure responding to request")
	}

	return
}

// GetSparkSessionStatePreparer prepares the GetSparkSessionState request.
func (client JobClient) GetSparkSessionStatePreparer(ctx context.Context, sessionID int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"sessionId": autorest.Encode("path", sessionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/livy/sessions/{sessionId}/state", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSparkSessionStateSender sends the GetSparkSessionState request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) GetSparkSessionStateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSparkSessionStateResponder handles the response to the GetSparkSessionState request. The method always
// closes the http.Response Body.
func (client JobClient) GetSparkSessionStateResponder(resp *http.Response) (result SparkJobState, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetSparkStatementJob gets a single statement within a spark session.
// Parameters:
// sessionID - identifier for the session.
// statementID - identifier for the statement.
func (client JobClient) GetSparkStatementJob(ctx context.Context, sessionID int32, statementID int32) (result SparkStatement, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.GetSparkStatementJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetSparkStatementJobPreparer(ctx, sessionID, statementID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkStatementJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSparkStatementJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkStatementJob", resp, "Failure sending request")
		return
	}

	result, err = client.GetSparkStatementJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "GetSparkStatementJob", resp, "Failure responding to request")
	}

	return
}

// GetSparkStatementJobPreparer prepares the GetSparkStatementJob request.
func (client JobClient) GetSparkStatementJobPreparer(ctx context.Context, sessionID int32, statementID int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"sessionId":   autorest.Encode("path", sessionID),
		"statementId": autorest.Encode("path", statementID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/livy/sessions/{sessionId}/statements/{statementId}", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSparkStatementJobSender sends the GetSparkStatementJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) GetSparkStatementJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetSparkStatementJobResponder handles the response to the GetSparkStatementJob request. The method always
// closes the http.Response Body.
func (client JobClient) GetSparkStatementJobResponder(resp *http.Response) (result SparkStatement, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Kill initiates cancel on given running job in the specified HDInsight.
// Parameters:
// jobID - the id of the job.
func (client JobClient) Kill(ctx context.Context, jobID string) (result JobDetailRootJSONObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.Kill")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: jobID,
			Constraints: []validation.Constraint{{Target: "jobID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("hdinsight.JobClient", "Kill", err.Error())
	}

	req, err := client.KillPreparer(ctx, jobID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "Kill", nil, "Failure preparing request")
		return
	}

	resp, err := client.KillSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "Kill", resp, "Failure sending request")
		return
	}

	result, err = client.KillResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "Kill", resp, "Failure responding to request")
	}

	return
}

// KillPreparer prepares the Kill request.
func (client JobClient) KillPreparer(ctx context.Context, jobID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"jobId": autorest.Encode("path", jobID),
	}

	queryParameters := map[string]interface{}{
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/templeton/v1/jobs/{jobId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// KillSender sends the Kill request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) KillSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// KillResponder handles the response to the Kill request. The method always
// closes the http.Response Body.
func (client JobClient) KillResponder(resp *http.Response) (result JobDetailRootJSONObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List gets the list of jobs from the specified HDInsight cluster.
func (client JobClient) List(ctx context.Context) (result ListJobListJSONObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client JobClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{
		"fields":    autorest.Encode("query", "*"),
		"showall":   autorest.Encode("query", "true"),
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPath("/templeton/v1/jobs"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client JobClient) ListResponder(resp *http.Response) (result ListJobListJSONObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAfterJobID gets numrecords Of Jobs after jobid from the specified HDInsight cluster.
// Parameters:
// jobid - jobId from where to list jobs.
// numrecords - number of jobs to fetch.
func (client JobClient) ListAfterJobID(ctx context.Context, jobid string, numrecords *int32) (result ListJobListJSONObject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.ListAfterJobID")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: numrecords,
			Constraints: []validation.Constraint{{Target: "numrecords", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "numrecords", Name: validation.InclusiveMinimum, Rule: int64(1), Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("hdinsight.JobClient", "ListAfterJobID", err.Error())
	}

	req, err := client.ListAfterJobIDPreparer(ctx, jobid, numrecords)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListAfterJobID", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAfterJobIDSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListAfterJobID", resp, "Failure sending request")
		return
	}

	result, err = client.ListAfterJobIDResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListAfterJobID", resp, "Failure responding to request")
	}

	return
}

// ListAfterJobIDPreparer prepares the ListAfterJobID request.
func (client JobClient) ListAfterJobIDPreparer(ctx context.Context, jobid string, numrecords *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{
		"fields":    autorest.Encode("query", "*"),
		"showall":   autorest.Encode("query", "true"),
		"user.name": autorest.Encode("query", client.UserName),
	}
	if len(jobid) > 0 {
		queryParameters["jobid"] = autorest.Encode("query", jobid)
	}
	if numrecords != nil {
		queryParameters["numrecords"] = autorest.Encode("query", *numrecords)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPath("/templeton/v1/jobs"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAfterJobIDSender sends the ListAfterJobID request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) ListAfterJobIDSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListAfterJobIDResponder handles the response to the ListAfterJobID request. The method always
// closes the http.Response Body.
func (client JobClient) ListAfterJobIDResponder(resp *http.Response) (result ListJobListJSONObject, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSparkBatchJob list all spark batch jobs
// Parameters:
// from - optional param specifying which index the list should begin from.
// size - optional param specifying the size of the returned list.
// By default it is 20 and that is the maximum.
func (client JobClient) ListSparkBatchJob(ctx context.Context, from *int32, size *int32) (result SparkBatchJobCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.ListSparkBatchJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSparkBatchJobPreparer(ctx, from, size)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListSparkBatchJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSparkBatchJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListSparkBatchJob", resp, "Failure sending request")
		return
	}

	result, err = client.ListSparkBatchJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListSparkBatchJob", resp, "Failure responding to request")
	}

	return
}

// ListSparkBatchJobPreparer prepares the ListSparkBatchJob request.
func (client JobClient) ListSparkBatchJobPreparer(ctx context.Context, from *int32, size *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{}
	if from != nil {
		queryParameters["from"] = autorest.Encode("query", *from)
	}
	if size != nil {
		queryParameters["size"] = autorest.Encode("query", *size)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPath("/livy/batches"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSparkBatchJobSender sends the ListSparkBatchJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) ListSparkBatchJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListSparkBatchJobResponder handles the response to the ListSparkBatchJob request. The method always
// closes the http.Response Body.
func (client JobClient) ListSparkBatchJobResponder(resp *http.Response) (result SparkBatchJobCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSparkSessionJob list all spark sessions.
// Parameters:
// from - optional param specifying which index the list should begin from.
// size - optional param specifying the size of the returned list.
// By default it is 20 and that is the maximum.
func (client JobClient) ListSparkSessionJob(ctx context.Context, from *int32, size *int32) (result SparkSessionCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.ListSparkSessionJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSparkSessionJobPreparer(ctx, from, size)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListSparkSessionJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSparkSessionJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListSparkSessionJob", resp, "Failure sending request")
		return
	}

	result, err = client.ListSparkSessionJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListSparkSessionJob", resp, "Failure responding to request")
	}

	return
}

// ListSparkSessionJobPreparer prepares the ListSparkSessionJob request.
func (client JobClient) ListSparkSessionJobPreparer(ctx context.Context, from *int32, size *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{}
	if from != nil {
		queryParameters["from"] = autorest.Encode("query", *from)
	}
	if size != nil {
		queryParameters["size"] = autorest.Encode("query", *size)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPath("/livy/sessions"),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSparkSessionJobSender sends the ListSparkSessionJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) ListSparkSessionJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListSparkSessionJobResponder handles the response to the ListSparkSessionJob request. The method always
// closes the http.Response Body.
func (client JobClient) ListSparkSessionJobResponder(resp *http.Response) (result SparkSessionCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListSparkStatementJob gets a list of statements within a spark session.
// Parameters:
// sessionID - identifier for the session.
func (client JobClient) ListSparkStatementJob(ctx context.Context, sessionID int32) (result SparkStatementCollection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.ListSparkStatementJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListSparkStatementJobPreparer(ctx, sessionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListSparkStatementJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSparkStatementJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListSparkStatementJob", resp, "Failure sending request")
		return
	}

	result, err = client.ListSparkStatementJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "ListSparkStatementJob", resp, "Failure responding to request")
	}

	return
}

// ListSparkStatementJobPreparer prepares the ListSparkStatementJob request.
func (client JobClient) ListSparkStatementJobPreparer(ctx context.Context, sessionID int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"sessionId": autorest.Encode("path", sessionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/livy/sessions/{sessionId}/statements", pathParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSparkStatementJobSender sends the ListSparkStatementJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) ListSparkStatementJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListSparkStatementJobResponder handles the response to the ListSparkStatementJob request. The method always
// closes the http.Response Body.
func (client JobClient) ListSparkStatementJobResponder(resp *http.Response) (result SparkStatementCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SubmitHiveJob submits a Hive job to an HDInsight cluster.
// Parameters:
// content - the content of the Hive job request.
func (client JobClient) SubmitHiveJob(ctx context.Context, content io.ReadCloser) (result JobSubmissionJSONResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.SubmitHiveJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SubmitHiveJobPreparer(ctx, content)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitHiveJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.SubmitHiveJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitHiveJob", resp, "Failure sending request")
		return
	}

	result, err = client.SubmitHiveJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitHiveJob", resp, "Failure responding to request")
	}

	return
}

// SubmitHiveJobPreparer prepares the SubmitHiveJob request.
func (client JobClient) SubmitHiveJobPreparer(ctx context.Context, content io.ReadCloser) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/text"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPath("/templeton/v1/hive"),
		autorest.WithFile(content),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SubmitHiveJobSender sends the SubmitHiveJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) SubmitHiveJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SubmitHiveJobResponder handles the response to the SubmitHiveJob request. The method always
// closes the http.Response Body.
func (client JobClient) SubmitHiveJobResponder(resp *http.Response) (result JobSubmissionJSONResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SubmitMapReduceJob submits a MapReduce job to an HDInsight cluster.
// Parameters:
// content - the content of the MapReduce job request.
func (client JobClient) SubmitMapReduceJob(ctx context.Context, content io.ReadCloser) (result JobSubmissionJSONResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.SubmitMapReduceJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SubmitMapReduceJobPreparer(ctx, content)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitMapReduceJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.SubmitMapReduceJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitMapReduceJob", resp, "Failure sending request")
		return
	}

	result, err = client.SubmitMapReduceJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitMapReduceJob", resp, "Failure responding to request")
	}

	return
}

// SubmitMapReduceJobPreparer prepares the SubmitMapReduceJob request.
func (client JobClient) SubmitMapReduceJobPreparer(ctx context.Context, content io.ReadCloser) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("text/plain"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPath("/templeton/v1/mapreduce/jar"),
		autorest.WithFile(content),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SubmitMapReduceJobSender sends the SubmitMapReduceJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) SubmitMapReduceJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SubmitMapReduceJobResponder handles the response to the SubmitMapReduceJob request. The method always
// closes the http.Response Body.
func (client JobClient) SubmitMapReduceJobResponder(resp *http.Response) (result JobSubmissionJSONResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SubmitMapReduceStreamingJob submits a MapReduce streaming job to an HDInsight cluster.
// Parameters:
// content - the content of the MapReduce job request.
func (client JobClient) SubmitMapReduceStreamingJob(ctx context.Context, content io.ReadCloser) (result JobSubmissionJSONResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.SubmitMapReduceStreamingJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SubmitMapReduceStreamingJobPreparer(ctx, content)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitMapReduceStreamingJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.SubmitMapReduceStreamingJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitMapReduceStreamingJob", resp, "Failure sending request")
		return
	}

	result, err = client.SubmitMapReduceStreamingJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitMapReduceStreamingJob", resp, "Failure responding to request")
	}

	return
}

// SubmitMapReduceStreamingJobPreparer prepares the SubmitMapReduceStreamingJob request.
func (client JobClient) SubmitMapReduceStreamingJobPreparer(ctx context.Context, content io.ReadCloser) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("text/plain"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPath("/templeton/v1/mapreduce/streaming"),
		autorest.WithFile(content),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SubmitMapReduceStreamingJobSender sends the SubmitMapReduceStreamingJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) SubmitMapReduceStreamingJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SubmitMapReduceStreamingJobResponder handles the response to the SubmitMapReduceStreamingJob request. The method always
// closes the http.Response Body.
func (client JobClient) SubmitMapReduceStreamingJobResponder(resp *http.Response) (result JobSubmissionJSONResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SubmitPigJob submits a Pig job to an HDInsight cluster.
// Parameters:
// content - the content of the Pig job request.
func (client JobClient) SubmitPigJob(ctx context.Context, content io.ReadCloser) (result JobSubmissionJSONResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.SubmitPigJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SubmitPigJobPreparer(ctx, content)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitPigJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.SubmitPigJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitPigJob", resp, "Failure sending request")
		return
	}

	result, err = client.SubmitPigJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitPigJob", resp, "Failure responding to request")
	}

	return
}

// SubmitPigJobPreparer prepares the SubmitPigJob request.
func (client JobClient) SubmitPigJobPreparer(ctx context.Context, content io.ReadCloser) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("text/plain"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPath("/templeton/v1/pig"),
		autorest.WithFile(content),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SubmitPigJobSender sends the SubmitPigJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) SubmitPigJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SubmitPigJobResponder handles the response to the SubmitPigJob request. The method always
// closes the http.Response Body.
func (client JobClient) SubmitPigJobResponder(resp *http.Response) (result JobSubmissionJSONResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SubmitSparkBatchJob create a new spark batch job.
// Parameters:
// sparkBatchJobRequest - livy compatible batch job request payload.
// requestedBy - add default value for X-Requested-By in header.
func (client JobClient) SubmitSparkBatchJob(ctx context.Context, sparkBatchJobRequest SparkBatchJobRequest, requestedBy string) (result SparkBatchJob, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.SubmitSparkBatchJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SubmitSparkBatchJobPreparer(ctx, sparkBatchJobRequest, requestedBy)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSparkBatchJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.SubmitSparkBatchJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSparkBatchJob", resp, "Failure sending request")
		return
	}

	result, err = client.SubmitSparkBatchJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSparkBatchJob", resp, "Failure responding to request")
	}

	return
}

// SubmitSparkBatchJobPreparer prepares the SubmitSparkBatchJob request.
func (client JobClient) SubmitSparkBatchJobPreparer(ctx context.Context, sparkBatchJobRequest SparkBatchJobRequest, requestedBy string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPath("/livy/batches"),
		autorest.WithJSON(sparkBatchJobRequest))
	if len(requestedBy) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Requested-By", autorest.String(requestedBy)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Requested-By", autorest.String("ambari")))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SubmitSparkBatchJobSender sends the SubmitSparkBatchJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) SubmitSparkBatchJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SubmitSparkBatchJobResponder handles the response to the SubmitSparkBatchJob request. The method always
// closes the http.Response Body.
func (client JobClient) SubmitSparkBatchJobResponder(resp *http.Response) (result SparkBatchJob, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SubmitSparkSessionJob create a new spark session.
// Parameters:
// sparkSessionJobRequest - livy compatible session job request payload.
// requestedBy - add default value for X-Requested-By in header.
func (client JobClient) SubmitSparkSessionJob(ctx context.Context, sparkSessionJobRequest SparkSessionJobRequest, requestedBy string) (result SparkSessionJob, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.SubmitSparkSessionJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SubmitSparkSessionJobPreparer(ctx, sparkSessionJobRequest, requestedBy)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSparkSessionJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.SubmitSparkSessionJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSparkSessionJob", resp, "Failure sending request")
		return
	}

	result, err = client.SubmitSparkSessionJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSparkSessionJob", resp, "Failure responding to request")
	}

	return
}

// SubmitSparkSessionJobPreparer prepares the SubmitSparkSessionJob request.
func (client JobClient) SubmitSparkSessionJobPreparer(ctx context.Context, sparkSessionJobRequest SparkSessionJobRequest, requestedBy string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPath("/livy/sessions"),
		autorest.WithJSON(sparkSessionJobRequest))
	if len(requestedBy) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Requested-By", autorest.String(requestedBy)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Requested-By", autorest.String("ambari")))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SubmitSparkSessionJobSender sends the SubmitSparkSessionJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) SubmitSparkSessionJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SubmitSparkSessionJobResponder handles the response to the SubmitSparkSessionJob request. The method always
// closes the http.Response Body.
func (client JobClient) SubmitSparkSessionJobResponder(resp *http.Response) (result SparkSessionJob, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SubmitSparkStatementJob create a statement within a spark session.
// Parameters:
// sessionID - identifier for the session.
// sparkStatementRequest - livy compatible batch job request payload.
// requestedBy - add default value for X-Requested-By in header.
func (client JobClient) SubmitSparkStatementJob(ctx context.Context, sessionID int32, sparkStatementRequest SparkStatementRequest, requestedBy string) (result SparkStatement, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.SubmitSparkStatementJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SubmitSparkStatementJobPreparer(ctx, sessionID, sparkStatementRequest, requestedBy)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSparkStatementJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.SubmitSparkStatementJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSparkStatementJob", resp, "Failure sending request")
		return
	}

	result, err = client.SubmitSparkStatementJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSparkStatementJob", resp, "Failure responding to request")
	}

	return
}

// SubmitSparkStatementJobPreparer prepares the SubmitSparkStatementJob request.
func (client JobClient) SubmitSparkStatementJobPreparer(ctx context.Context, sessionID int32, sparkStatementRequest SparkStatementRequest, requestedBy string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"sessionId": autorest.Encode("path", sessionID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPathParameters("/livy/sessions/{sessionId}/statements", pathParameters),
		autorest.WithJSON(sparkStatementRequest))
	if len(requestedBy) > 0 {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Requested-By", autorest.String(requestedBy)))
	} else {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithHeader("X-Requested-By", autorest.String("ambari")))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SubmitSparkStatementJobSender sends the SubmitSparkStatementJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) SubmitSparkStatementJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SubmitSparkStatementJobResponder handles the response to the SubmitSparkStatementJob request. The method always
// closes the http.Response Body.
func (client JobClient) SubmitSparkStatementJobResponder(resp *http.Response) (result SparkStatement, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SubmitSqoopJob submits a Sqoop job to an HDInsight cluster.
// Parameters:
// content - the content of the Sqoop job request.
func (client JobClient) SubmitSqoopJob(ctx context.Context, content io.ReadCloser) (result JobSubmissionJSONResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobClient.SubmitSqoopJob")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.SubmitSqoopJobPreparer(ctx, content)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSqoopJob", nil, "Failure preparing request")
		return
	}

	resp, err := client.SubmitSqoopJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSqoopJob", resp, "Failure sending request")
		return
	}

	result, err = client.SubmitSqoopJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "hdinsight.JobClient", "SubmitSqoopJob", resp, "Failure responding to request")
	}

	return
}

// SubmitSqoopJobPreparer prepares the SubmitSqoopJob request.
func (client JobClient) SubmitSqoopJobPreparer(ctx context.Context, content io.ReadCloser) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{
		"user.name": autorest.Encode("query", client.UserName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("text/plain"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("https://{endpoint}", urlParameters),
		autorest.WithPath("/templeton/v1/sqoop"),
		autorest.WithFile(content),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SubmitSqoopJobSender sends the SubmitSqoopJob request. The method will close the
// http.Response Body if it receives an error.
func (client JobClient) SubmitSqoopJobSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// SubmitSqoopJobResponder handles the response to the SubmitSqoopJob request. The method always
// closes the http.Response Body.
func (client JobClient) SubmitSqoopJobResponder(resp *http.Response) (result JobSubmissionJSONResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
