package databricks

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// CustomParameterType enumerates the values for custom parameter type.
type CustomParameterType string

const (
	// Bool ...
	Bool CustomParameterType = "Bool"
	// Object ...
	Object CustomParameterType = "Object"
	// String ...
	String CustomParameterType = "String"
)

// PossibleCustomParameterTypeValues returns an array of possible values for the CustomParameterType const type.
func PossibleCustomParameterTypeValues() []CustomParameterType {
	return []CustomParameterType{Bool, Object, String}
}

// KeySource enumerates the values for key source.
type KeySource string

const (
	// Default ...
	Default KeySource = "Default"
	// MicrosoftKeyvault ...
	MicrosoftKeyvault KeySource = "Microsoft.Keyvault"
)

// PossibleKeySourceValues returns an array of possible values for the KeySource const type.
func PossibleKeySourceValues() []KeySource {
	return []KeySource{Default, MicrosoftKeyvault}
}

// PeeringProvisioningState enumerates the values for peering provisioning state.
type PeeringProvisioningState string

const (
	// Deleting ...
	Deleting PeeringProvisioningState = "Deleting"
	// Failed ...
	Failed PeeringProvisioningState = "Failed"
	// Succeeded ...
	Succeeded PeeringProvisioningState = "Succeeded"
	// Updating ...
	Updating PeeringProvisioningState = "Updating"
)

// PossiblePeeringProvisioningStateValues returns an array of possible values for the PeeringProvisioningState const type.
func PossiblePeeringProvisioningStateValues() []PeeringProvisioningState {
	return []PeeringProvisioningState{Deleting, Failed, Succeeded, Updating}
}

// PeeringState enumerates the values for peering state.
type PeeringState string

const (
	// Connected ...
	Connected PeeringState = "Connected"
	// Disconnected ...
	Disconnected PeeringState = "Disconnected"
	// Initiated ...
	Initiated PeeringState = "Initiated"
)

// PossiblePeeringStateValues returns an array of possible values for the PeeringState const type.
func PossiblePeeringStateValues() []PeeringState {
	return []PeeringState{Connected, Disconnected, Initiated}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateAccepted ...
	ProvisioningStateAccepted ProvisioningState = "Accepted"
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreated ...
	ProvisioningStateCreated ProvisioningState = "Created"
	// ProvisioningStateCreating ...
	ProvisioningStateCreating ProvisioningState = "Creating"
	// ProvisioningStateDeleted ...
	ProvisioningStateDeleted ProvisioningState = "Deleted"
	// ProvisioningStateDeleting ...
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateReady ...
	ProvisioningStateReady ProvisioningState = "Ready"
	// ProvisioningStateRunning ...
	ProvisioningStateRunning ProvisioningState = "Running"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating ...
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateAccepted, ProvisioningStateCanceled, ProvisioningStateCreated, ProvisioningStateCreating, ProvisioningStateDeleted, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateReady, ProvisioningStateRunning, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}
