// +build go1.9

// Copyright 2020 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package confluent

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/confluent/mgmt/2020-03-01-preview/confluent"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ProvisionState = original.ProvisionState

const (
	Accepted     ProvisionState = original.Accepted
	Canceled     ProvisionState = original.Canceled
	Creating     ProvisionState = original.Creating
	Deleted      ProvisionState = original.Deleted
	Deleting     ProvisionState = original.Deleting
	Failed       ProvisionState = original.Failed
	NotSpecified ProvisionState = original.NotSpecified
	Succeeded    ProvisionState = original.Succeeded
	Updating     ProvisionState = original.Updating
)

type SaaSOfferStatus = original.SaaSOfferStatus

const (
	SaaSOfferStatusFailed                  SaaSOfferStatus = original.SaaSOfferStatusFailed
	SaaSOfferStatusInProgress              SaaSOfferStatus = original.SaaSOfferStatusInProgress
	SaaSOfferStatusPendingFulfillmentStart SaaSOfferStatus = original.SaaSOfferStatusPendingFulfillmentStart
	SaaSOfferStatusReinstated              SaaSOfferStatus = original.SaaSOfferStatusReinstated
	SaaSOfferStatusStarted                 SaaSOfferStatus = original.SaaSOfferStatusStarted
	SaaSOfferStatusSubscribed              SaaSOfferStatus = original.SaaSOfferStatusSubscribed
	SaaSOfferStatusSucceeded               SaaSOfferStatus = original.SaaSOfferStatusSucceeded
	SaaSOfferStatusSuspended               SaaSOfferStatus = original.SaaSOfferStatusSuspended
	SaaSOfferStatusUnsubscribed            SaaSOfferStatus = original.SaaSOfferStatusUnsubscribed
	SaaSOfferStatusUpdating                SaaSOfferStatus = original.SaaSOfferStatusUpdating
)

type BaseClient = original.BaseClient
type ErrorResponseBody = original.ErrorResponseBody
type OfferDetail = original.OfferDetail
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationResult = original.OperationResult
type OrganizationClient = original.OrganizationClient
type OrganizationCreateFuture = original.OrganizationCreateFuture
type OrganizationDeleteFuture = original.OrganizationDeleteFuture
type OrganizationOperationsClient = original.OrganizationOperationsClient
type OrganizationResource = original.OrganizationResource
type OrganizationResourceListResult = original.OrganizationResourceListResult
type OrganizationResourceListResultIterator = original.OrganizationResourceListResultIterator
type OrganizationResourceListResultPage = original.OrganizationResourceListResultPage
type OrganizationResourceProperties = original.OrganizationResourceProperties
type OrganizationResourcePropertiesModel = original.OrganizationResourcePropertiesModel
type OrganizationResourcePropertiesOfferDetail = original.OrganizationResourcePropertiesOfferDetail
type OrganizationResourcePropertiesUserDetail = original.OrganizationResourcePropertiesUserDetail
type OrganizationResourceUpdate = original.OrganizationResourceUpdate
type ResourceProviderDefaultErrorResponse = original.ResourceProviderDefaultErrorResponse
type UserDetail = original.UserDetail

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(getNextPage)
}
func NewOrganizationClient(subscriptionID string) OrganizationClient {
	return original.NewOrganizationClient(subscriptionID)
}
func NewOrganizationClientWithBaseURI(baseURI string, subscriptionID string) OrganizationClient {
	return original.NewOrganizationClientWithBaseURI(baseURI, subscriptionID)
}
func NewOrganizationOperationsClient(subscriptionID string) OrganizationOperationsClient {
	return original.NewOrganizationOperationsClient(subscriptionID)
}
func NewOrganizationOperationsClientWithBaseURI(baseURI string, subscriptionID string) OrganizationOperationsClient {
	return original.NewOrganizationOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOrganizationResourceListResultIterator(page OrganizationResourceListResultPage) OrganizationResourceListResultIterator {
	return original.NewOrganizationResourceListResultIterator(page)
}
func NewOrganizationResourceListResultPage(getNextPage func(context.Context, OrganizationResourceListResult) (OrganizationResourceListResult, error)) OrganizationResourceListResultPage {
	return original.NewOrganizationResourceListResultPage(getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleProvisionStateValues() []ProvisionState {
	return original.PossibleProvisionStateValues()
}
func PossibleSaaSOfferStatusValues() []SaaSOfferStatus {
	return original.PossibleSaaSOfferStatusValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
