/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	"encoding/json"
)

// PrivateCrossConnectProperties struct for PrivateCrossConnectProperties
type PrivateCrossConnectProperties struct {
	// A name of that resource
	Name *string `json:"name,omitempty"`
	// Human readable description
	Description *string `json:"description,omitempty"`
	// Read-Only attribute. Lists LAN's joined to this private cross connect
	Peers *[]Peer `json:"peers,omitempty"`
	// Read-Only attribute. Lists datacenters that can be joined to this private cross connect
	ConnectableDatacenters *[]ConnectableDatacenter `json:"connectableDatacenters,omitempty"`
}



// GetName returns the Name field value
// If the value is explicit nil, the zero value for string will be returned
func (o *PrivateCrossConnectProperties) GetName() *string {
	if o == nil {
		return nil
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PrivateCrossConnectProperties) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Name, true
}

// SetName sets field value
func (o *PrivateCrossConnectProperties) SetName(v string) {
	o.Name = &v
}

// HasName returns a boolean if a field has been set.
func (o *PrivateCrossConnectProperties) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}



// GetDescription returns the Description field value
// If the value is explicit nil, the zero value for string will be returned
func (o *PrivateCrossConnectProperties) GetDescription() *string {
	if o == nil {
		return nil
	}

	return o.Description
}

// GetDescriptionOk returns a tuple with the Description field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PrivateCrossConnectProperties) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Description, true
}

// SetDescription sets field value
func (o *PrivateCrossConnectProperties) SetDescription(v string) {
	o.Description = &v
}

// HasDescription returns a boolean if a field has been set.
func (o *PrivateCrossConnectProperties) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}



// GetPeers returns the Peers field value
// If the value is explicit nil, the zero value for []Peer will be returned
func (o *PrivateCrossConnectProperties) GetPeers() *[]Peer {
	if o == nil {
		return nil
	}

	return o.Peers
}

// GetPeersOk returns a tuple with the Peers field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PrivateCrossConnectProperties) GetPeersOk() (*[]Peer, bool) {
	if o == nil {
		return nil, false
	}
	return o.Peers, true
}

// SetPeers sets field value
func (o *PrivateCrossConnectProperties) SetPeers(v []Peer) {
	o.Peers = &v
}

// HasPeers returns a boolean if a field has been set.
func (o *PrivateCrossConnectProperties) HasPeers() bool {
	if o != nil && o.Peers != nil {
		return true
	}

	return false
}



// GetConnectableDatacenters returns the ConnectableDatacenters field value
// If the value is explicit nil, the zero value for []ConnectableDatacenter will be returned
func (o *PrivateCrossConnectProperties) GetConnectableDatacenters() *[]ConnectableDatacenter {
	if o == nil {
		return nil
	}

	return o.ConnectableDatacenters
}

// GetConnectableDatacentersOk returns a tuple with the ConnectableDatacenters field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *PrivateCrossConnectProperties) GetConnectableDatacentersOk() (*[]ConnectableDatacenter, bool) {
	if o == nil {
		return nil, false
	}
	return o.ConnectableDatacenters, true
}

// SetConnectableDatacenters sets field value
func (o *PrivateCrossConnectProperties) SetConnectableDatacenters(v []ConnectableDatacenter) {
	o.ConnectableDatacenters = &v
}

// HasConnectableDatacenters returns a boolean if a field has been set.
func (o *PrivateCrossConnectProperties) HasConnectableDatacenters() bool {
	if o != nil && o.ConnectableDatacenters != nil {
		return true
	}

	return false
}


func (o PrivateCrossConnectProperties) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}

	if o.Name != nil {
		toSerialize["name"] = o.Name
	}
	

	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	

	if o.Peers != nil {
		toSerialize["peers"] = o.Peers
	}
	

	if o.ConnectableDatacenters != nil {
		toSerialize["connectableDatacenters"] = o.ConnectableDatacenters
	}
	
	return json.Marshal(toSerialize)
}

type NullablePrivateCrossConnectProperties struct {
	value *PrivateCrossConnectProperties
	isSet bool
}

func (v NullablePrivateCrossConnectProperties) Get() *PrivateCrossConnectProperties {
	return v.value
}

func (v *NullablePrivateCrossConnectProperties) Set(val *PrivateCrossConnectProperties) {
	v.value = val
	v.isSet = true
}

func (v NullablePrivateCrossConnectProperties) IsSet() bool {
	return v.isSet
}

func (v *NullablePrivateCrossConnectProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePrivateCrossConnectProperties(val *PrivateCrossConnectProperties) *NullablePrivateCrossConnectProperties {
	return &NullablePrivateCrossConnectProperties{value: val, isSet: true}
}

func (v NullablePrivateCrossConnectProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePrivateCrossConnectProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


