/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	_context "context"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

// VolumeApiService VolumeApi service
type VolumeApiService service

type ApiDatacentersVolumesCreateSnapshotPostRequest struct {
	ctx _context.Context
	ApiService *VolumeApiService
	datacenterId string
	volumeId string
	pretty *bool
	depth *int32
	xContractNumber *int32
	name *string
	description *string
	secAuthProtection *bool
	licenceType *string
}

func (r ApiDatacentersVolumesCreateSnapshotPostRequest) Pretty(pretty bool) ApiDatacentersVolumesCreateSnapshotPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersVolumesCreateSnapshotPostRequest) Depth(depth int32) ApiDatacentersVolumesCreateSnapshotPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersVolumesCreateSnapshotPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersVolumesCreateSnapshotPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}
func (r ApiDatacentersVolumesCreateSnapshotPostRequest) Name(name string) ApiDatacentersVolumesCreateSnapshotPostRequest {
	r.name = &name
	return r
}
func (r ApiDatacentersVolumesCreateSnapshotPostRequest) Description(description string) ApiDatacentersVolumesCreateSnapshotPostRequest {
	r.description = &description
	return r
}
func (r ApiDatacentersVolumesCreateSnapshotPostRequest) SecAuthProtection(secAuthProtection bool) ApiDatacentersVolumesCreateSnapshotPostRequest {
	r.secAuthProtection = &secAuthProtection
	return r
}
func (r ApiDatacentersVolumesCreateSnapshotPostRequest) LicenceType(licenceType string) ApiDatacentersVolumesCreateSnapshotPostRequest {
	r.licenceType = &licenceType
	return r
}

func (r ApiDatacentersVolumesCreateSnapshotPostRequest) Execute() (Snapshot, *APIResponse, error) {
	return r.ApiService.DatacentersVolumesCreateSnapshotPostExecute(r)
}

/*
 * DatacentersVolumesCreateSnapshotPost Create Volume Snapshot
 * Creates a snapshot of a volume within the datacenter. You can use a snapshot to create a new storage volume or to restore a storage volume.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param volumeId The unique ID of the Volume
 * @return ApiDatacentersVolumesCreateSnapshotPostRequest
 */
func (a *VolumeApiService) DatacentersVolumesCreateSnapshotPost(ctx _context.Context, datacenterId string, volumeId string) ApiDatacentersVolumesCreateSnapshotPostRequest {
	return ApiDatacentersVolumesCreateSnapshotPostRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		volumeId: volumeId,
	}
}

/*
 * Execute executes the request
 * @return Snapshot
 */
func (a *VolumeApiService) DatacentersVolumesCreateSnapshotPostExecute(r ApiDatacentersVolumesCreateSnapshotPostRequest) (Snapshot, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Snapshot
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "VolumeApiService.DatacentersVolumesCreateSnapshotPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/volumes/{volumeId}/create-snapshot"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"volumeId"+"}", _neturl.PathEscape(parameterToString(r.volumeId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.name != nil {
		localVarFormParams.Add("name", parameterToString(*r.name, ""))
	}
	if r.description != nil {
		localVarFormParams.Add("description", parameterToString(*r.description, ""))
	}
	if r.secAuthProtection != nil {
		localVarFormParams.Add("secAuthProtection", parameterToString(*r.secAuthProtection, ""))
	}
	if r.licenceType != nil {
		localVarFormParams.Add("licenceType", parameterToString(*r.licenceType, ""))
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersVolumesCreateSnapshotPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersVolumesDeleteRequest struct {
	ctx _context.Context
	ApiService *VolumeApiService
	datacenterId string
	volumeId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersVolumesDeleteRequest) Pretty(pretty bool) ApiDatacentersVolumesDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersVolumesDeleteRequest) Depth(depth int32) ApiDatacentersVolumesDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersVolumesDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersVolumesDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersVolumesDeleteRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.DatacentersVolumesDeleteExecute(r)
}

/*
 * DatacentersVolumesDelete Delete a Volume
 * Deletes the specified volume. This will result in the volume being removed from your datacenter. Use this with caution.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param volumeId The unique ID of the Volume
 * @return ApiDatacentersVolumesDeleteRequest
 */
func (a *VolumeApiService) DatacentersVolumesDelete(ctx _context.Context, datacenterId string, volumeId string) ApiDatacentersVolumesDeleteRequest {
	return ApiDatacentersVolumesDeleteRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		volumeId: volumeId,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *VolumeApiService) DatacentersVolumesDeleteExecute(r ApiDatacentersVolumesDeleteRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "VolumeApiService.DatacentersVolumesDelete")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/volumes/{volumeId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"volumeId"+"}", _neturl.PathEscape(parameterToString(r.volumeId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersVolumesDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersVolumesFindByIdRequest struct {
	ctx _context.Context
	ApiService *VolumeApiService
	datacenterId string
	volumeId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersVolumesFindByIdRequest) Pretty(pretty bool) ApiDatacentersVolumesFindByIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersVolumesFindByIdRequest) Depth(depth int32) ApiDatacentersVolumesFindByIdRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersVolumesFindByIdRequest) XContractNumber(xContractNumber int32) ApiDatacentersVolumesFindByIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersVolumesFindByIdRequest) Execute() (Volume, *APIResponse, error) {
	return r.ApiService.DatacentersVolumesFindByIdExecute(r)
}

/*
 * DatacentersVolumesFindById Retrieve a Volume
 * Retrieves the attributes of a given Volume
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param volumeId The unique ID of the Volume
 * @return ApiDatacentersVolumesFindByIdRequest
 */
func (a *VolumeApiService) DatacentersVolumesFindById(ctx _context.Context, datacenterId string, volumeId string) ApiDatacentersVolumesFindByIdRequest {
	return ApiDatacentersVolumesFindByIdRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		volumeId: volumeId,
	}
}

/*
 * Execute executes the request
 * @return Volume
 */
func (a *VolumeApiService) DatacentersVolumesFindByIdExecute(r ApiDatacentersVolumesFindByIdRequest) (Volume, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Volume
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "VolumeApiService.DatacentersVolumesFindById")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/volumes/{volumeId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"volumeId"+"}", _neturl.PathEscape(parameterToString(r.volumeId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersVolumesFindById",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersVolumesGetRequest struct {
	ctx _context.Context
	ApiService *VolumeApiService
	datacenterId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersVolumesGetRequest) Pretty(pretty bool) ApiDatacentersVolumesGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersVolumesGetRequest) Depth(depth int32) ApiDatacentersVolumesGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersVolumesGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersVolumesGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersVolumesGetRequest) Execute() (Volumes, *APIResponse, error) {
	return r.ApiService.DatacentersVolumesGetExecute(r)
}

/*
 * DatacentersVolumesGet List Volumes 
 * Retrieves a list of Volumes.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @return ApiDatacentersVolumesGetRequest
 */
func (a *VolumeApiService) DatacentersVolumesGet(ctx _context.Context, datacenterId string) ApiDatacentersVolumesGetRequest {
	return ApiDatacentersVolumesGetRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
	}
}

/*
 * Execute executes the request
 * @return Volumes
 */
func (a *VolumeApiService) DatacentersVolumesGetExecute(r ApiDatacentersVolumesGetRequest) (Volumes, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Volumes
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "VolumeApiService.DatacentersVolumesGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/volumes"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersVolumesGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersVolumesPatchRequest struct {
	ctx _context.Context
	ApiService *VolumeApiService
	datacenterId string
	volumeId string
	volume *VolumeProperties
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersVolumesPatchRequest) Volume(volume VolumeProperties) ApiDatacentersVolumesPatchRequest {
	r.volume = &volume
	return r
}
func (r ApiDatacentersVolumesPatchRequest) Pretty(pretty bool) ApiDatacentersVolumesPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersVolumesPatchRequest) Depth(depth int32) ApiDatacentersVolumesPatchRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersVolumesPatchRequest) XContractNumber(xContractNumber int32) ApiDatacentersVolumesPatchRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersVolumesPatchRequest) Execute() (Volume, *APIResponse, error) {
	return r.ApiService.DatacentersVolumesPatchExecute(r)
}

/*
 * DatacentersVolumesPatch Partially modify a Volume
 * You can use update attributes of a Volume
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param volumeId The unique ID of the Volume
 * @return ApiDatacentersVolumesPatchRequest
 */
func (a *VolumeApiService) DatacentersVolumesPatch(ctx _context.Context, datacenterId string, volumeId string) ApiDatacentersVolumesPatchRequest {
	return ApiDatacentersVolumesPatchRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		volumeId: volumeId,
	}
}

/*
 * Execute executes the request
 * @return Volume
 */
func (a *VolumeApiService) DatacentersVolumesPatchExecute(r ApiDatacentersVolumesPatchRequest) (Volume, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Volume
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "VolumeApiService.DatacentersVolumesPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/volumes/{volumeId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"volumeId"+"}", _neturl.PathEscape(parameterToString(r.volumeId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.volume == nil {
		return localVarReturnValue, nil, reportError("volume is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.volume
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersVolumesPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersVolumesPostRequest struct {
	ctx _context.Context
	ApiService *VolumeApiService
	datacenterId string
	volume *Volume
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersVolumesPostRequest) Volume(volume Volume) ApiDatacentersVolumesPostRequest {
	r.volume = &volume
	return r
}
func (r ApiDatacentersVolumesPostRequest) Pretty(pretty bool) ApiDatacentersVolumesPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersVolumesPostRequest) Depth(depth int32) ApiDatacentersVolumesPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersVolumesPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersVolumesPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersVolumesPostRequest) Execute() (Volume, *APIResponse, error) {
	return r.ApiService.DatacentersVolumesPostExecute(r)
}

/*
 * DatacentersVolumesPost Create a Volume
 * Creates a volume within the datacenter. This will not attach the volume to a server. Please see the Servers section for details on how to attach storage volumes
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @return ApiDatacentersVolumesPostRequest
 */
func (a *VolumeApiService) DatacentersVolumesPost(ctx _context.Context, datacenterId string) ApiDatacentersVolumesPostRequest {
	return ApiDatacentersVolumesPostRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
	}
}

/*
 * Execute executes the request
 * @return Volume
 */
func (a *VolumeApiService) DatacentersVolumesPostExecute(r ApiDatacentersVolumesPostRequest) (Volume, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Volume
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "VolumeApiService.DatacentersVolumesPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/volumes"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.volume == nil {
		return localVarReturnValue, nil, reportError("volume is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.volume
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersVolumesPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersVolumesPutRequest struct {
	ctx _context.Context
	ApiService *VolumeApiService
	datacenterId string
	volumeId string
	volume *Volume
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersVolumesPutRequest) Volume(volume Volume) ApiDatacentersVolumesPutRequest {
	r.volume = &volume
	return r
}
func (r ApiDatacentersVolumesPutRequest) Pretty(pretty bool) ApiDatacentersVolumesPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersVolumesPutRequest) Depth(depth int32) ApiDatacentersVolumesPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersVolumesPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersVolumesPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersVolumesPutRequest) Execute() (Volume, *APIResponse, error) {
	return r.ApiService.DatacentersVolumesPutExecute(r)
}

/*
 * DatacentersVolumesPut Modify a Volume
 * You can use update attributes of a Volume
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param volumeId The unique ID of the Volume
 * @return ApiDatacentersVolumesPutRequest
 */
func (a *VolumeApiService) DatacentersVolumesPut(ctx _context.Context, datacenterId string, volumeId string) ApiDatacentersVolumesPutRequest {
	return ApiDatacentersVolumesPutRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		volumeId: volumeId,
	}
}

/*
 * Execute executes the request
 * @return Volume
 */
func (a *VolumeApiService) DatacentersVolumesPutExecute(r ApiDatacentersVolumesPutRequest) (Volume, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Volume
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "VolumeApiService.DatacentersVolumesPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/volumes/{volumeId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"volumeId"+"}", _neturl.PathEscape(parameterToString(r.volumeId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.volume == nil {
		return localVarReturnValue, nil, reportError("volume is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.volume
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersVolumesPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersVolumesRestoreSnapshotPostRequest struct {
	ctx _context.Context
	ApiService *VolumeApiService
	datacenterId string
	volumeId string
	pretty *bool
	depth *int32
	xContractNumber *int32
	snapshotId *string
}

func (r ApiDatacentersVolumesRestoreSnapshotPostRequest) Pretty(pretty bool) ApiDatacentersVolumesRestoreSnapshotPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersVolumesRestoreSnapshotPostRequest) Depth(depth int32) ApiDatacentersVolumesRestoreSnapshotPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersVolumesRestoreSnapshotPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersVolumesRestoreSnapshotPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}
func (r ApiDatacentersVolumesRestoreSnapshotPostRequest) SnapshotId(snapshotId string) ApiDatacentersVolumesRestoreSnapshotPostRequest {
	r.snapshotId = &snapshotId
	return r
}

func (r ApiDatacentersVolumesRestoreSnapshotPostRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.DatacentersVolumesRestoreSnapshotPostExecute(r)
}

/*
 * DatacentersVolumesRestoreSnapshotPost Restore Volume Snapshot
 * This will restore a snapshot onto a volume. A snapshot is created as just another image that can be used to create subsequent volumes if you want or to restore an existing volume.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param volumeId The unique ID of the Volume
 * @return ApiDatacentersVolumesRestoreSnapshotPostRequest
 */
func (a *VolumeApiService) DatacentersVolumesRestoreSnapshotPost(ctx _context.Context, datacenterId string, volumeId string) ApiDatacentersVolumesRestoreSnapshotPostRequest {
	return ApiDatacentersVolumesRestoreSnapshotPostRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		volumeId: volumeId,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *VolumeApiService) DatacentersVolumesRestoreSnapshotPostExecute(r ApiDatacentersVolumesRestoreSnapshotPostRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "VolumeApiService.DatacentersVolumesRestoreSnapshotPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/volumes/{volumeId}/restore-snapshot"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"volumeId"+"}", _neturl.PathEscape(parameterToString(r.volumeId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/x-www-form-urlencoded"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.snapshotId != nil {
		localVarFormParams.Add("snapshotId", parameterToString(*r.snapshotId, ""))
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersVolumesRestoreSnapshotPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}
