/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery v2.3.0. DO NOT EDIT.

package ionoscloud

import (
	context "context"

	mock "github.com/stretchr/testify/mock"
	ionossdk "k8s.io/autoscaler/cluster-autoscaler/cloudprovider/ionoscloud/ionos-cloud-sdk-go"
)

// MockAPIClient is an autogenerated mock type for the APIClient type
type MockAPIClient struct {
	mock.Mock
}

// K8sNodepoolsFindById provides a mock function with given fields: ctx, k8sClusterId, nodepoolId
func (_m *MockAPIClient) K8sNodepoolsFindById(ctx context.Context, k8sClusterId string, nodepoolId string) ionossdk.ApiK8sNodepoolsFindByIdRequest {
	ret := _m.Called(ctx, k8sClusterId, nodepoolId)

	var r0 ionossdk.ApiK8sNodepoolsFindByIdRequest
	if rf, ok := ret.Get(0).(func(context.Context, string, string) ionossdk.ApiK8sNodepoolsFindByIdRequest); ok {
		r0 = rf(ctx, k8sClusterId, nodepoolId)
	} else {
		r0 = ret.Get(0).(ionossdk.ApiK8sNodepoolsFindByIdRequest)
	}

	return r0
}

// K8sNodepoolsFindByIdExecute provides a mock function with given fields: r
func (_m *MockAPIClient) K8sNodepoolsFindByIdExecute(r ionossdk.ApiK8sNodepoolsFindByIdRequest) (ionossdk.KubernetesNodePool, *ionossdk.APIResponse, error) {
	ret := _m.Called(r)

	var r0 ionossdk.KubernetesNodePool
	if rf, ok := ret.Get(0).(func(ionossdk.ApiK8sNodepoolsFindByIdRequest) ionossdk.KubernetesNodePool); ok {
		r0 = rf(r)
	} else {
		r0 = ret.Get(0).(ionossdk.KubernetesNodePool)
	}

	var r1 *ionossdk.APIResponse
	if rf, ok := ret.Get(1).(func(ionossdk.ApiK8sNodepoolsFindByIdRequest) *ionossdk.APIResponse); ok {
		r1 = rf(r)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*ionossdk.APIResponse)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(ionossdk.ApiK8sNodepoolsFindByIdRequest) error); ok {
		r2 = rf(r)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// K8sNodepoolsNodesDelete provides a mock function with given fields: ctx, k8sClusterId, nodepoolId, nodeId
func (_m *MockAPIClient) K8sNodepoolsNodesDelete(ctx context.Context, k8sClusterId string, nodepoolId string, nodeId string) ionossdk.ApiK8sNodepoolsNodesDeleteRequest {
	ret := _m.Called(ctx, k8sClusterId, nodepoolId, nodeId)

	var r0 ionossdk.ApiK8sNodepoolsNodesDeleteRequest
	if rf, ok := ret.Get(0).(func(context.Context, string, string, string) ionossdk.ApiK8sNodepoolsNodesDeleteRequest); ok {
		r0 = rf(ctx, k8sClusterId, nodepoolId, nodeId)
	} else {
		r0 = ret.Get(0).(ionossdk.ApiK8sNodepoolsNodesDeleteRequest)
	}

	return r0
}

// K8sNodepoolsNodesDeleteExecute provides a mock function with given fields: r
func (_m *MockAPIClient) K8sNodepoolsNodesDeleteExecute(r ionossdk.ApiK8sNodepoolsNodesDeleteRequest) (map[string]interface{}, *ionossdk.APIResponse, error) {
	ret := _m.Called(r)

	var r0 map[string]interface{}
	if rf, ok := ret.Get(0).(func(ionossdk.ApiK8sNodepoolsNodesDeleteRequest) map[string]interface{}); ok {
		r0 = rf(r)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[string]interface{})
		}
	}

	var r1 *ionossdk.APIResponse
	if rf, ok := ret.Get(1).(func(ionossdk.ApiK8sNodepoolsNodesDeleteRequest) *ionossdk.APIResponse); ok {
		r1 = rf(r)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*ionossdk.APIResponse)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(ionossdk.ApiK8sNodepoolsNodesDeleteRequest) error); ok {
		r2 = rf(r)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// K8sNodepoolsNodesGet provides a mock function with given fields: ctx, k8sClusterId, nodepoolId
func (_m *MockAPIClient) K8sNodepoolsNodesGet(ctx context.Context, k8sClusterId string, nodepoolId string) ionossdk.ApiK8sNodepoolsNodesGetRequest {
	ret := _m.Called(ctx, k8sClusterId, nodepoolId)

	var r0 ionossdk.ApiK8sNodepoolsNodesGetRequest
	if rf, ok := ret.Get(0).(func(context.Context, string, string) ionossdk.ApiK8sNodepoolsNodesGetRequest); ok {
		r0 = rf(ctx, k8sClusterId, nodepoolId)
	} else {
		r0 = ret.Get(0).(ionossdk.ApiK8sNodepoolsNodesGetRequest)
	}

	return r0
}

// K8sNodepoolsNodesGetExecute provides a mock function with given fields: r
func (_m *MockAPIClient) K8sNodepoolsNodesGetExecute(r ionossdk.ApiK8sNodepoolsNodesGetRequest) (ionossdk.KubernetesNodes, *ionossdk.APIResponse, error) {
	ret := _m.Called(r)

	var r0 ionossdk.KubernetesNodes
	if rf, ok := ret.Get(0).(func(ionossdk.ApiK8sNodepoolsNodesGetRequest) ionossdk.KubernetesNodes); ok {
		r0 = rf(r)
	} else {
		r0 = ret.Get(0).(ionossdk.KubernetesNodes)
	}

	var r1 *ionossdk.APIResponse
	if rf, ok := ret.Get(1).(func(ionossdk.ApiK8sNodepoolsNodesGetRequest) *ionossdk.APIResponse); ok {
		r1 = rf(r)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*ionossdk.APIResponse)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(ionossdk.ApiK8sNodepoolsNodesGetRequest) error); ok {
		r2 = rf(r)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// K8sNodepoolsPut provides a mock function with given fields: ctx, k8sClusterId, nodepoolId
func (_m *MockAPIClient) K8sNodepoolsPut(ctx context.Context, k8sClusterId string, nodepoolId string) ionossdk.ApiK8sNodepoolsPutRequest {
	ret := _m.Called(ctx, k8sClusterId, nodepoolId)

	var r0 ionossdk.ApiK8sNodepoolsPutRequest
	if rf, ok := ret.Get(0).(func(context.Context, string, string) ionossdk.ApiK8sNodepoolsPutRequest); ok {
		r0 = rf(ctx, k8sClusterId, nodepoolId)
	} else {
		r0 = ret.Get(0).(ionossdk.ApiK8sNodepoolsPutRequest)
	}

	return r0
}

// K8sNodepoolsPutExecute provides a mock function with given fields: r
func (_m *MockAPIClient) K8sNodepoolsPutExecute(r ionossdk.ApiK8sNodepoolsPutRequest) (ionossdk.KubernetesNodePoolForPut, *ionossdk.APIResponse, error) {
	ret := _m.Called(r)

	var r0 ionossdk.KubernetesNodePoolForPut
	if rf, ok := ret.Get(0).(func(ionossdk.ApiK8sNodepoolsPutRequest) ionossdk.KubernetesNodePoolForPut); ok {
		r0 = rf(r)
	} else {
		r0 = ret.Get(0).(ionossdk.KubernetesNodePoolForPut)
	}

	var r1 *ionossdk.APIResponse
	if rf, ok := ret.Get(1).(func(ionossdk.ApiK8sNodepoolsPutRequest) *ionossdk.APIResponse); ok {
		r1 = rf(r)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*ionossdk.APIResponse)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(ionossdk.ApiK8sNodepoolsPutRequest) error); ok {
		r2 = rf(r)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}
