/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	_context "context"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

// LabelApiService LabelApi service
type LabelApiService service

type ApiDatacentersLabelsDeleteRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	key string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLabelsDeleteRequest) Pretty(pretty bool) ApiDatacentersLabelsDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLabelsDeleteRequest) Depth(depth int32) ApiDatacentersLabelsDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLabelsDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersLabelsDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLabelsDeleteRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.DatacentersLabelsDeleteExecute(r)
}

/*
 * DatacentersLabelsDelete Delete a Label from Data Center
 * This will remove a label from the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Data Center
 * @param key The key of the Label
 * @return ApiDatacentersLabelsDeleteRequest
 */
func (a *LabelApiService) DatacentersLabelsDelete(ctx _context.Context, datacenterId string, key string) ApiDatacentersLabelsDeleteRequest {
	return ApiDatacentersLabelsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *LabelApiService) DatacentersLabelsDeleteExecute(r ApiDatacentersLabelsDeleteRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersLabelsDelete")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLabelsDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersLabelsFindByKeyRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	key string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLabelsFindByKeyRequest) Pretty(pretty bool) ApiDatacentersLabelsFindByKeyRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLabelsFindByKeyRequest) Depth(depth int32) ApiDatacentersLabelsFindByKeyRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLabelsFindByKeyRequest) XContractNumber(xContractNumber int32) ApiDatacentersLabelsFindByKeyRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLabelsFindByKeyRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.DatacentersLabelsFindByKeyExecute(r)
}

/*
 * DatacentersLabelsFindByKey Retrieve a Label of Data Center
 * This will retrieve the properties of a associated label to a data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Data Center
 * @param key The key of the Label
 * @return ApiDatacentersLabelsFindByKeyRequest
 */
func (a *LabelApiService) DatacentersLabelsFindByKey(ctx _context.Context, datacenterId string, key string) ApiDatacentersLabelsFindByKeyRequest {
	return ApiDatacentersLabelsFindByKeyRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) DatacentersLabelsFindByKeyExecute(r ApiDatacentersLabelsFindByKeyRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersLabelsFindByKey")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLabelsFindByKey",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersLabelsGetRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLabelsGetRequest) Pretty(pretty bool) ApiDatacentersLabelsGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLabelsGetRequest) Depth(depth int32) ApiDatacentersLabelsGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLabelsGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersLabelsGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLabelsGetRequest) Execute() (LabelResources, *APIResponse, error) {
	return r.ApiService.DatacentersLabelsGetExecute(r)
}

/*
 * DatacentersLabelsGet List all Data Center Labels
 * You can retrieve a list of all labels associated with a data center
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Data Center
 * @return ApiDatacentersLabelsGetRequest
 */
func (a *LabelApiService) DatacentersLabelsGet(ctx _context.Context, datacenterId string) ApiDatacentersLabelsGetRequest {
	return ApiDatacentersLabelsGetRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
	}
}

/*
 * Execute executes the request
 * @return LabelResources
 */
func (a *LabelApiService) DatacentersLabelsGetExecute(r ApiDatacentersLabelsGetRequest) (LabelResources, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResources
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersLabelsGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/labels"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLabelsGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersLabelsPostRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	label *LabelResource
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLabelsPostRequest) Label(label LabelResource) ApiDatacentersLabelsPostRequest {
	r.label = &label
	return r
}
func (r ApiDatacentersLabelsPostRequest) Pretty(pretty bool) ApiDatacentersLabelsPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLabelsPostRequest) Depth(depth int32) ApiDatacentersLabelsPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLabelsPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersLabelsPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLabelsPostRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.DatacentersLabelsPostExecute(r)
}

/*
 * DatacentersLabelsPost Add a Label to Data Center
 * This will add a label to the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Data Center
 * @return ApiDatacentersLabelsPostRequest
 */
func (a *LabelApiService) DatacentersLabelsPost(ctx _context.Context, datacenterId string) ApiDatacentersLabelsPostRequest {
	return ApiDatacentersLabelsPostRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) DatacentersLabelsPostExecute(r ApiDatacentersLabelsPostRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersLabelsPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/labels"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.label == nil {
		return localVarReturnValue, nil, reportError("label is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.label
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLabelsPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersLabelsPutRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	key string
	label *LabelResource
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersLabelsPutRequest) Label(label LabelResource) ApiDatacentersLabelsPutRequest {
	r.label = &label
	return r
}
func (r ApiDatacentersLabelsPutRequest) Pretty(pretty bool) ApiDatacentersLabelsPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersLabelsPutRequest) Depth(depth int32) ApiDatacentersLabelsPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersLabelsPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersLabelsPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersLabelsPutRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.DatacentersLabelsPutExecute(r)
}

/*
 * DatacentersLabelsPut Modify a Label of Data Center
 * This will modify the value of the label on a data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Data Center
 * @param key The key of the Label
 * @return ApiDatacentersLabelsPutRequest
 */
func (a *LabelApiService) DatacentersLabelsPut(ctx _context.Context, datacenterId string, key string) ApiDatacentersLabelsPutRequest {
	return ApiDatacentersLabelsPutRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) DatacentersLabelsPutExecute(r ApiDatacentersLabelsPutRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersLabelsPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.label == nil {
		return localVarReturnValue, nil, reportError("label is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.label
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersLabelsPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersLabelsDeleteRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	serverId string
	key string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersLabelsDeleteRequest) Pretty(pretty bool) ApiDatacentersServersLabelsDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersLabelsDeleteRequest) Depth(depth int32) ApiDatacentersServersLabelsDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersLabelsDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersLabelsDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersLabelsDeleteRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.DatacentersServersLabelsDeleteExecute(r)
}

/*
 * DatacentersServersLabelsDelete Delete a Label from Server
 * This will remove a label from the server.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Datacenter
 * @param serverId The unique ID of the Server
 * @param key The key of the Label
 * @return ApiDatacentersServersLabelsDeleteRequest
 */
func (a *LabelApiService) DatacentersServersLabelsDelete(ctx _context.Context, datacenterId string, serverId string, key string) ApiDatacentersServersLabelsDeleteRequest {
	return ApiDatacentersServersLabelsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *LabelApiService) DatacentersServersLabelsDeleteExecute(r ApiDatacentersServersLabelsDeleteRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersServersLabelsDelete")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersLabelsDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersLabelsFindByKeyRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	serverId string
	key string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersLabelsFindByKeyRequest) Pretty(pretty bool) ApiDatacentersServersLabelsFindByKeyRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersLabelsFindByKeyRequest) Depth(depth int32) ApiDatacentersServersLabelsFindByKeyRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersLabelsFindByKeyRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersLabelsFindByKeyRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersLabelsFindByKeyRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.DatacentersServersLabelsFindByKeyExecute(r)
}

/*
 * DatacentersServersLabelsFindByKey Retrieve a Label of Server
 * This will retrieve the properties of a associated label to a server.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Datacenter
 * @param serverId The unique ID of the Server
 * @param key The key of the Label
 * @return ApiDatacentersServersLabelsFindByKeyRequest
 */
func (a *LabelApiService) DatacentersServersLabelsFindByKey(ctx _context.Context, datacenterId string, serverId string, key string) ApiDatacentersServersLabelsFindByKeyRequest {
	return ApiDatacentersServersLabelsFindByKeyRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) DatacentersServersLabelsFindByKeyExecute(r ApiDatacentersServersLabelsFindByKeyRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersServersLabelsFindByKey")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersLabelsFindByKey",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersLabelsGetRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	serverId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersLabelsGetRequest) Pretty(pretty bool) ApiDatacentersServersLabelsGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersLabelsGetRequest) Depth(depth int32) ApiDatacentersServersLabelsGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersLabelsGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersLabelsGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersLabelsGetRequest) Execute() (LabelResources, *APIResponse, error) {
	return r.ApiService.DatacentersServersLabelsGetExecute(r)
}

/*
 * DatacentersServersLabelsGet List all Server Labels
 * You can retrieve a list of all labels associated with a server
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Datacenter
 * @param serverId The unique ID of the Server
 * @return ApiDatacentersServersLabelsGetRequest
 */
func (a *LabelApiService) DatacentersServersLabelsGet(ctx _context.Context, datacenterId string, serverId string) ApiDatacentersServersLabelsGetRequest {
	return ApiDatacentersServersLabelsGetRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
	}
}

/*
 * Execute executes the request
 * @return LabelResources
 */
func (a *LabelApiService) DatacentersServersLabelsGetExecute(r ApiDatacentersServersLabelsGetRequest) (LabelResources, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResources
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersServersLabelsGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/labels"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersLabelsGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersLabelsPostRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	serverId string
	label *LabelResource
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersLabelsPostRequest) Label(label LabelResource) ApiDatacentersServersLabelsPostRequest {
	r.label = &label
	return r
}
func (r ApiDatacentersServersLabelsPostRequest) Pretty(pretty bool) ApiDatacentersServersLabelsPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersLabelsPostRequest) Depth(depth int32) ApiDatacentersServersLabelsPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersLabelsPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersLabelsPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersLabelsPostRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.DatacentersServersLabelsPostExecute(r)
}

/*
 * DatacentersServersLabelsPost Add a Label to Server
 * This will add a label to the server.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Datacenter
 * @param serverId The unique ID of the Server
 * @return ApiDatacentersServersLabelsPostRequest
 */
func (a *LabelApiService) DatacentersServersLabelsPost(ctx _context.Context, datacenterId string, serverId string) ApiDatacentersServersLabelsPostRequest {
	return ApiDatacentersServersLabelsPostRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) DatacentersServersLabelsPostExecute(r ApiDatacentersServersLabelsPostRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersServersLabelsPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/labels"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.label == nil {
		return localVarReturnValue, nil, reportError("label is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.label
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersLabelsPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersLabelsPutRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	serverId string
	key string
	label *LabelResource
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersLabelsPutRequest) Label(label LabelResource) ApiDatacentersServersLabelsPutRequest {
	r.label = &label
	return r
}
func (r ApiDatacentersServersLabelsPutRequest) Pretty(pretty bool) ApiDatacentersServersLabelsPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersLabelsPutRequest) Depth(depth int32) ApiDatacentersServersLabelsPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersLabelsPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersLabelsPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersLabelsPutRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.DatacentersServersLabelsPutExecute(r)
}

/*
 * DatacentersServersLabelsPut Modify a Label of Server
 * This will modify the value of the label on a server.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Datacenter
 * @param serverId The unique ID of the Server
 * @param key The key of the Label
 * @return ApiDatacentersServersLabelsPutRequest
 */
func (a *LabelApiService) DatacentersServersLabelsPut(ctx _context.Context, datacenterId string, serverId string, key string) ApiDatacentersServersLabelsPutRequest {
	return ApiDatacentersServersLabelsPutRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) DatacentersServersLabelsPutExecute(r ApiDatacentersServersLabelsPutRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersServersLabelsPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.label == nil {
		return localVarReturnValue, nil, reportError("label is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.label
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersLabelsPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersVolumesLabelsDeleteRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	volumeId string
	key string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersVolumesLabelsDeleteRequest) Pretty(pretty bool) ApiDatacentersVolumesLabelsDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersVolumesLabelsDeleteRequest) Depth(depth int32) ApiDatacentersVolumesLabelsDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersVolumesLabelsDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersVolumesLabelsDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersVolumesLabelsDeleteRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.DatacentersVolumesLabelsDeleteExecute(r)
}

/*
 * DatacentersVolumesLabelsDelete Delete a Label from Volume
 * This will remove a label from the volume.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Datacenter
 * @param volumeId The unique ID of the Volume
 * @param key The key of the Label
 * @return ApiDatacentersVolumesLabelsDeleteRequest
 */
func (a *LabelApiService) DatacentersVolumesLabelsDelete(ctx _context.Context, datacenterId string, volumeId string, key string) ApiDatacentersVolumesLabelsDeleteRequest {
	return ApiDatacentersVolumesLabelsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		volumeId: volumeId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *LabelApiService) DatacentersVolumesLabelsDeleteExecute(r ApiDatacentersVolumesLabelsDeleteRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersVolumesLabelsDelete")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/volumes/{volumeId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"volumeId"+"}", _neturl.PathEscape(parameterToString(r.volumeId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersVolumesLabelsDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersVolumesLabelsFindByKeyRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	volumeId string
	key string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersVolumesLabelsFindByKeyRequest) Pretty(pretty bool) ApiDatacentersVolumesLabelsFindByKeyRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersVolumesLabelsFindByKeyRequest) Depth(depth int32) ApiDatacentersVolumesLabelsFindByKeyRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersVolumesLabelsFindByKeyRequest) XContractNumber(xContractNumber int32) ApiDatacentersVolumesLabelsFindByKeyRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersVolumesLabelsFindByKeyRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.DatacentersVolumesLabelsFindByKeyExecute(r)
}

/*
 * DatacentersVolumesLabelsFindByKey Retrieve a Label of Volume
 * This will retrieve the properties of a associated label to a volume.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Datacenter
 * @param volumeId The unique ID of the Volume
 * @param key The key of the Label
 * @return ApiDatacentersVolumesLabelsFindByKeyRequest
 */
func (a *LabelApiService) DatacentersVolumesLabelsFindByKey(ctx _context.Context, datacenterId string, volumeId string, key string) ApiDatacentersVolumesLabelsFindByKeyRequest {
	return ApiDatacentersVolumesLabelsFindByKeyRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		volumeId: volumeId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) DatacentersVolumesLabelsFindByKeyExecute(r ApiDatacentersVolumesLabelsFindByKeyRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersVolumesLabelsFindByKey")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/volumes/{volumeId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"volumeId"+"}", _neturl.PathEscape(parameterToString(r.volumeId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersVolumesLabelsFindByKey",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersVolumesLabelsGetRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	volumeId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersVolumesLabelsGetRequest) Pretty(pretty bool) ApiDatacentersVolumesLabelsGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersVolumesLabelsGetRequest) Depth(depth int32) ApiDatacentersVolumesLabelsGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersVolumesLabelsGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersVolumesLabelsGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersVolumesLabelsGetRequest) Execute() (LabelResources, *APIResponse, error) {
	return r.ApiService.DatacentersVolumesLabelsGetExecute(r)
}

/*
 * DatacentersVolumesLabelsGet List all Volume Labels
 * You can retrieve a list of all labels associated with a volume
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Datacenter
 * @param volumeId The unique ID of the Volume
 * @return ApiDatacentersVolumesLabelsGetRequest
 */
func (a *LabelApiService) DatacentersVolumesLabelsGet(ctx _context.Context, datacenterId string, volumeId string) ApiDatacentersVolumesLabelsGetRequest {
	return ApiDatacentersVolumesLabelsGetRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		volumeId: volumeId,
	}
}

/*
 * Execute executes the request
 * @return LabelResources
 */
func (a *LabelApiService) DatacentersVolumesLabelsGetExecute(r ApiDatacentersVolumesLabelsGetRequest) (LabelResources, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResources
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersVolumesLabelsGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/volumes/{volumeId}/labels"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"volumeId"+"}", _neturl.PathEscape(parameterToString(r.volumeId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersVolumesLabelsGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersVolumesLabelsPostRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	volumeId string
	label *LabelResource
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersVolumesLabelsPostRequest) Label(label LabelResource) ApiDatacentersVolumesLabelsPostRequest {
	r.label = &label
	return r
}
func (r ApiDatacentersVolumesLabelsPostRequest) Pretty(pretty bool) ApiDatacentersVolumesLabelsPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersVolumesLabelsPostRequest) Depth(depth int32) ApiDatacentersVolumesLabelsPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersVolumesLabelsPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersVolumesLabelsPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersVolumesLabelsPostRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.DatacentersVolumesLabelsPostExecute(r)
}

/*
 * DatacentersVolumesLabelsPost Add a Label to Volume
 * This will add a label to the volume.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Datacenter
 * @param volumeId The unique ID of the Volume
 * @return ApiDatacentersVolumesLabelsPostRequest
 */
func (a *LabelApiService) DatacentersVolumesLabelsPost(ctx _context.Context, datacenterId string, volumeId string) ApiDatacentersVolumesLabelsPostRequest {
	return ApiDatacentersVolumesLabelsPostRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		volumeId: volumeId,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) DatacentersVolumesLabelsPostExecute(r ApiDatacentersVolumesLabelsPostRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersVolumesLabelsPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/volumes/{volumeId}/labels"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"volumeId"+"}", _neturl.PathEscape(parameterToString(r.volumeId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.label == nil {
		return localVarReturnValue, nil, reportError("label is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.label
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersVolumesLabelsPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersVolumesLabelsPutRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	datacenterId string
	volumeId string
	key string
	label *LabelResource
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersVolumesLabelsPutRequest) Label(label LabelResource) ApiDatacentersVolumesLabelsPutRequest {
	r.label = &label
	return r
}
func (r ApiDatacentersVolumesLabelsPutRequest) Pretty(pretty bool) ApiDatacentersVolumesLabelsPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersVolumesLabelsPutRequest) Depth(depth int32) ApiDatacentersVolumesLabelsPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersVolumesLabelsPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersVolumesLabelsPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersVolumesLabelsPutRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.DatacentersVolumesLabelsPutExecute(r)
}

/*
 * DatacentersVolumesLabelsPut Modify a Label of Volume
 * This will modify the value of the label on a volume.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the Datacenter
 * @param volumeId The unique ID of the Volume
 * @param key The key of the Label
 * @return ApiDatacentersVolumesLabelsPutRequest
 */
func (a *LabelApiService) DatacentersVolumesLabelsPut(ctx _context.Context, datacenterId string, volumeId string, key string) ApiDatacentersVolumesLabelsPutRequest {
	return ApiDatacentersVolumesLabelsPutRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		volumeId: volumeId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) DatacentersVolumesLabelsPutExecute(r ApiDatacentersVolumesLabelsPutRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.DatacentersVolumesLabelsPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/volumes/{volumeId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"volumeId"+"}", _neturl.PathEscape(parameterToString(r.volumeId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.label == nil {
		return localVarReturnValue, nil, reportError("label is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.label
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersVolumesLabelsPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiIpblocksLabelsDeleteRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	ipblockId string
	key string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiIpblocksLabelsDeleteRequest) Pretty(pretty bool) ApiIpblocksLabelsDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiIpblocksLabelsDeleteRequest) Depth(depth int32) ApiIpblocksLabelsDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiIpblocksLabelsDeleteRequest) XContractNumber(xContractNumber int32) ApiIpblocksLabelsDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiIpblocksLabelsDeleteRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.IpblocksLabelsDeleteExecute(r)
}

/*
 * IpblocksLabelsDelete Delete a Label from IP Block
 * This will remove a label from the Ip Block.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param ipblockId The unique ID of the Ip Block
 * @param key The key of the Label
 * @return ApiIpblocksLabelsDeleteRequest
 */
func (a *LabelApiService) IpblocksLabelsDelete(ctx _context.Context, ipblockId string, key string) ApiIpblocksLabelsDeleteRequest {
	return ApiIpblocksLabelsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		ipblockId: ipblockId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *LabelApiService) IpblocksLabelsDeleteExecute(r ApiIpblocksLabelsDeleteRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.IpblocksLabelsDelete")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/ipblocks/{ipblockId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"ipblockId"+"}", _neturl.PathEscape(parameterToString(r.ipblockId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "IpblocksLabelsDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiIpblocksLabelsFindByKeyRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	ipblockId string
	key string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiIpblocksLabelsFindByKeyRequest) Pretty(pretty bool) ApiIpblocksLabelsFindByKeyRequest {
	r.pretty = &pretty
	return r
}
func (r ApiIpblocksLabelsFindByKeyRequest) Depth(depth int32) ApiIpblocksLabelsFindByKeyRequest {
	r.depth = &depth
	return r
}
func (r ApiIpblocksLabelsFindByKeyRequest) XContractNumber(xContractNumber int32) ApiIpblocksLabelsFindByKeyRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiIpblocksLabelsFindByKeyRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.IpblocksLabelsFindByKeyExecute(r)
}

/*
 * IpblocksLabelsFindByKey Retrieve a Label of IP Block
 * This will retrieve the properties of a associated label to a Ip Block.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param ipblockId The unique ID of the Ip Block
 * @param key The key of the Label
 * @return ApiIpblocksLabelsFindByKeyRequest
 */
func (a *LabelApiService) IpblocksLabelsFindByKey(ctx _context.Context, ipblockId string, key string) ApiIpblocksLabelsFindByKeyRequest {
	return ApiIpblocksLabelsFindByKeyRequest{
		ApiService: a,
		ctx: ctx,
		ipblockId: ipblockId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) IpblocksLabelsFindByKeyExecute(r ApiIpblocksLabelsFindByKeyRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.IpblocksLabelsFindByKey")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/ipblocks/{ipblockId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"ipblockId"+"}", _neturl.PathEscape(parameterToString(r.ipblockId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "IpblocksLabelsFindByKey",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiIpblocksLabelsGetRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	ipblockId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiIpblocksLabelsGetRequest) Pretty(pretty bool) ApiIpblocksLabelsGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiIpblocksLabelsGetRequest) Depth(depth int32) ApiIpblocksLabelsGetRequest {
	r.depth = &depth
	return r
}
func (r ApiIpblocksLabelsGetRequest) XContractNumber(xContractNumber int32) ApiIpblocksLabelsGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiIpblocksLabelsGetRequest) Execute() (LabelResources, *APIResponse, error) {
	return r.ApiService.IpblocksLabelsGetExecute(r)
}

/*
 * IpblocksLabelsGet List all Ip Block Labels
 * You can retrieve a list of all labels associated with a IP Block
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param ipblockId The unique ID of the Ip Block
 * @return ApiIpblocksLabelsGetRequest
 */
func (a *LabelApiService) IpblocksLabelsGet(ctx _context.Context, ipblockId string) ApiIpblocksLabelsGetRequest {
	return ApiIpblocksLabelsGetRequest{
		ApiService: a,
		ctx: ctx,
		ipblockId: ipblockId,
	}
}

/*
 * Execute executes the request
 * @return LabelResources
 */
func (a *LabelApiService) IpblocksLabelsGetExecute(r ApiIpblocksLabelsGetRequest) (LabelResources, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResources
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.IpblocksLabelsGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/ipblocks/{ipblockId}/labels"
	localVarPath = strings.Replace(localVarPath, "{"+"ipblockId"+"}", _neturl.PathEscape(parameterToString(r.ipblockId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "IpblocksLabelsGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiIpblocksLabelsPostRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	ipblockId string
	label *LabelResource
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiIpblocksLabelsPostRequest) Label(label LabelResource) ApiIpblocksLabelsPostRequest {
	r.label = &label
	return r
}
func (r ApiIpblocksLabelsPostRequest) Pretty(pretty bool) ApiIpblocksLabelsPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiIpblocksLabelsPostRequest) Depth(depth int32) ApiIpblocksLabelsPostRequest {
	r.depth = &depth
	return r
}
func (r ApiIpblocksLabelsPostRequest) XContractNumber(xContractNumber int32) ApiIpblocksLabelsPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiIpblocksLabelsPostRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.IpblocksLabelsPostExecute(r)
}

/*
 * IpblocksLabelsPost Add a Label to IP Block
 * This will add a label to the Ip Block.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param ipblockId The unique ID of the Ip Block
 * @return ApiIpblocksLabelsPostRequest
 */
func (a *LabelApiService) IpblocksLabelsPost(ctx _context.Context, ipblockId string) ApiIpblocksLabelsPostRequest {
	return ApiIpblocksLabelsPostRequest{
		ApiService: a,
		ctx: ctx,
		ipblockId: ipblockId,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) IpblocksLabelsPostExecute(r ApiIpblocksLabelsPostRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.IpblocksLabelsPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/ipblocks/{ipblockId}/labels"
	localVarPath = strings.Replace(localVarPath, "{"+"ipblockId"+"}", _neturl.PathEscape(parameterToString(r.ipblockId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.label == nil {
		return localVarReturnValue, nil, reportError("label is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.label
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "IpblocksLabelsPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiIpblocksLabelsPutRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	ipblockId string
	key string
	label *LabelResource
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiIpblocksLabelsPutRequest) Label(label LabelResource) ApiIpblocksLabelsPutRequest {
	r.label = &label
	return r
}
func (r ApiIpblocksLabelsPutRequest) Pretty(pretty bool) ApiIpblocksLabelsPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiIpblocksLabelsPutRequest) Depth(depth int32) ApiIpblocksLabelsPutRequest {
	r.depth = &depth
	return r
}
func (r ApiIpblocksLabelsPutRequest) XContractNumber(xContractNumber int32) ApiIpblocksLabelsPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiIpblocksLabelsPutRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.IpblocksLabelsPutExecute(r)
}

/*
 * IpblocksLabelsPut Modify a Label of IP Block
 * This will modify the value of the label on a Ip Block.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param ipblockId The unique ID of the Ip Block
 * @param key The key of the Label
 * @return ApiIpblocksLabelsPutRequest
 */
func (a *LabelApiService) IpblocksLabelsPut(ctx _context.Context, ipblockId string, key string) ApiIpblocksLabelsPutRequest {
	return ApiIpblocksLabelsPutRequest{
		ApiService: a,
		ctx: ctx,
		ipblockId: ipblockId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) IpblocksLabelsPutExecute(r ApiIpblocksLabelsPutRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.IpblocksLabelsPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/ipblocks/{ipblockId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"ipblockId"+"}", _neturl.PathEscape(parameterToString(r.ipblockId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.label == nil {
		return localVarReturnValue, nil, reportError("label is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.label
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "IpblocksLabelsPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiLabelsFindByLabelurnRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	labelurn string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiLabelsFindByLabelurnRequest) Pretty(pretty bool) ApiLabelsFindByLabelurnRequest {
	r.pretty = &pretty
	return r
}
func (r ApiLabelsFindByLabelurnRequest) Depth(depth int32) ApiLabelsFindByLabelurnRequest {
	r.depth = &depth
	return r
}
func (r ApiLabelsFindByLabelurnRequest) XContractNumber(xContractNumber int32) ApiLabelsFindByLabelurnRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiLabelsFindByLabelurnRequest) Execute() (Label, *APIResponse, error) {
	return r.ApiService.LabelsFindByLabelurnExecute(r)
}

/*
 * LabelsFindByLabelurn Returns the label by its URN.
 * You can retrieve the details of a specific label using its URN. A URN is for uniqueness of a Label and composed using urn:label:<resource_type>:<resource_uuid>:<key>
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param labelurn The URN representing the unique ID of the label. A URN is for uniqueness of a Label and composed using urn:label:<resource_type>:<resource_uuid>:<key>
 * @return ApiLabelsFindByLabelurnRequest
 */
func (a *LabelApiService) LabelsFindByLabelurn(ctx _context.Context, labelurn string) ApiLabelsFindByLabelurnRequest {
	return ApiLabelsFindByLabelurnRequest{
		ApiService: a,
		ctx: ctx,
		labelurn: labelurn,
	}
}

/*
 * Execute executes the request
 * @return Label
 */
func (a *LabelApiService) LabelsFindByLabelurnExecute(r ApiLabelsFindByLabelurnRequest) (Label, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Label
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.LabelsFindByLabelurn")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/labels/{labelurn}"
	localVarPath = strings.Replace(localVarPath, "{"+"labelurn"+"}", _neturl.PathEscape(parameterToString(r.labelurn, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "LabelsFindByLabelurn",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiLabelsGetRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiLabelsGetRequest) Pretty(pretty bool) ApiLabelsGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiLabelsGetRequest) Depth(depth int32) ApiLabelsGetRequest {
	r.depth = &depth
	return r
}
func (r ApiLabelsGetRequest) XContractNumber(xContractNumber int32) ApiLabelsGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiLabelsGetRequest) Execute() (Labels, *APIResponse, error) {
	return r.ApiService.LabelsGetExecute(r)
}

/*
 * LabelsGet List Labels 
 * You can retrieve a complete list of labels that you have access to.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @return ApiLabelsGetRequest
 */
func (a *LabelApiService) LabelsGet(ctx _context.Context) ApiLabelsGetRequest {
	return ApiLabelsGetRequest{
		ApiService: a,
		ctx: ctx,
	}
}

/*
 * Execute executes the request
 * @return Labels
 */
func (a *LabelApiService) LabelsGetExecute(r ApiLabelsGetRequest) (Labels, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Labels
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.LabelsGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/labels"

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "LabelsGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiSnapshotsLabelsDeleteRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	snapshotId string
	key string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiSnapshotsLabelsDeleteRequest) Pretty(pretty bool) ApiSnapshotsLabelsDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiSnapshotsLabelsDeleteRequest) Depth(depth int32) ApiSnapshotsLabelsDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiSnapshotsLabelsDeleteRequest) XContractNumber(xContractNumber int32) ApiSnapshotsLabelsDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiSnapshotsLabelsDeleteRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.SnapshotsLabelsDeleteExecute(r)
}

/*
 * SnapshotsLabelsDelete Delete a Label from Snapshot
 * This will remove a label from the snapshot.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param snapshotId The unique ID of the Snapshot
 * @param key The key of the Label
 * @return ApiSnapshotsLabelsDeleteRequest
 */
func (a *LabelApiService) SnapshotsLabelsDelete(ctx _context.Context, snapshotId string, key string) ApiSnapshotsLabelsDeleteRequest {
	return ApiSnapshotsLabelsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		snapshotId: snapshotId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *LabelApiService) SnapshotsLabelsDeleteExecute(r ApiSnapshotsLabelsDeleteRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.SnapshotsLabelsDelete")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/snapshots/{snapshotId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"snapshotId"+"}", _neturl.PathEscape(parameterToString(r.snapshotId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "SnapshotsLabelsDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiSnapshotsLabelsFindByKeyRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	snapshotId string
	key string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiSnapshotsLabelsFindByKeyRequest) Pretty(pretty bool) ApiSnapshotsLabelsFindByKeyRequest {
	r.pretty = &pretty
	return r
}
func (r ApiSnapshotsLabelsFindByKeyRequest) Depth(depth int32) ApiSnapshotsLabelsFindByKeyRequest {
	r.depth = &depth
	return r
}
func (r ApiSnapshotsLabelsFindByKeyRequest) XContractNumber(xContractNumber int32) ApiSnapshotsLabelsFindByKeyRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiSnapshotsLabelsFindByKeyRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.SnapshotsLabelsFindByKeyExecute(r)
}

/*
 * SnapshotsLabelsFindByKey Retrieve a Label of Snapshot
 * This will retrieve the properties of a associated label to a snapshot.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param snapshotId The unique ID of the Snapshot
 * @param key The key of the Label
 * @return ApiSnapshotsLabelsFindByKeyRequest
 */
func (a *LabelApiService) SnapshotsLabelsFindByKey(ctx _context.Context, snapshotId string, key string) ApiSnapshotsLabelsFindByKeyRequest {
	return ApiSnapshotsLabelsFindByKeyRequest{
		ApiService: a,
		ctx: ctx,
		snapshotId: snapshotId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) SnapshotsLabelsFindByKeyExecute(r ApiSnapshotsLabelsFindByKeyRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.SnapshotsLabelsFindByKey")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/snapshots/{snapshotId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"snapshotId"+"}", _neturl.PathEscape(parameterToString(r.snapshotId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "SnapshotsLabelsFindByKey",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiSnapshotsLabelsGetRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	snapshotId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiSnapshotsLabelsGetRequest) Pretty(pretty bool) ApiSnapshotsLabelsGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiSnapshotsLabelsGetRequest) Depth(depth int32) ApiSnapshotsLabelsGetRequest {
	r.depth = &depth
	return r
}
func (r ApiSnapshotsLabelsGetRequest) XContractNumber(xContractNumber int32) ApiSnapshotsLabelsGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiSnapshotsLabelsGetRequest) Execute() (LabelResources, *APIResponse, error) {
	return r.ApiService.SnapshotsLabelsGetExecute(r)
}

/*
 * SnapshotsLabelsGet List all Snapshot Labels
 * You can retrieve a list of all labels associated with a snapshot
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param snapshotId The unique ID of the Snapshot
 * @return ApiSnapshotsLabelsGetRequest
 */
func (a *LabelApiService) SnapshotsLabelsGet(ctx _context.Context, snapshotId string) ApiSnapshotsLabelsGetRequest {
	return ApiSnapshotsLabelsGetRequest{
		ApiService: a,
		ctx: ctx,
		snapshotId: snapshotId,
	}
}

/*
 * Execute executes the request
 * @return LabelResources
 */
func (a *LabelApiService) SnapshotsLabelsGetExecute(r ApiSnapshotsLabelsGetRequest) (LabelResources, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResources
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.SnapshotsLabelsGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/snapshots/{snapshotId}/labels"
	localVarPath = strings.Replace(localVarPath, "{"+"snapshotId"+"}", _neturl.PathEscape(parameterToString(r.snapshotId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "SnapshotsLabelsGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiSnapshotsLabelsPostRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	snapshotId string
	label *LabelResource
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiSnapshotsLabelsPostRequest) Label(label LabelResource) ApiSnapshotsLabelsPostRequest {
	r.label = &label
	return r
}
func (r ApiSnapshotsLabelsPostRequest) Pretty(pretty bool) ApiSnapshotsLabelsPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiSnapshotsLabelsPostRequest) Depth(depth int32) ApiSnapshotsLabelsPostRequest {
	r.depth = &depth
	return r
}
func (r ApiSnapshotsLabelsPostRequest) XContractNumber(xContractNumber int32) ApiSnapshotsLabelsPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiSnapshotsLabelsPostRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.SnapshotsLabelsPostExecute(r)
}

/*
 * SnapshotsLabelsPost Add a Label to Snapshot
 * This will add a label to the snapshot.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param snapshotId The unique ID of the Snapshot
 * @return ApiSnapshotsLabelsPostRequest
 */
func (a *LabelApiService) SnapshotsLabelsPost(ctx _context.Context, snapshotId string) ApiSnapshotsLabelsPostRequest {
	return ApiSnapshotsLabelsPostRequest{
		ApiService: a,
		ctx: ctx,
		snapshotId: snapshotId,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) SnapshotsLabelsPostExecute(r ApiSnapshotsLabelsPostRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.SnapshotsLabelsPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/snapshots/{snapshotId}/labels"
	localVarPath = strings.Replace(localVarPath, "{"+"snapshotId"+"}", _neturl.PathEscape(parameterToString(r.snapshotId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.label == nil {
		return localVarReturnValue, nil, reportError("label is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.label
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "SnapshotsLabelsPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiSnapshotsLabelsPutRequest struct {
	ctx _context.Context
	ApiService *LabelApiService
	snapshotId string
	key string
	label *LabelResource
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiSnapshotsLabelsPutRequest) Label(label LabelResource) ApiSnapshotsLabelsPutRequest {
	r.label = &label
	return r
}
func (r ApiSnapshotsLabelsPutRequest) Pretty(pretty bool) ApiSnapshotsLabelsPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiSnapshotsLabelsPutRequest) Depth(depth int32) ApiSnapshotsLabelsPutRequest {
	r.depth = &depth
	return r
}
func (r ApiSnapshotsLabelsPutRequest) XContractNumber(xContractNumber int32) ApiSnapshotsLabelsPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiSnapshotsLabelsPutRequest) Execute() (LabelResource, *APIResponse, error) {
	return r.ApiService.SnapshotsLabelsPutExecute(r)
}

/*
 * SnapshotsLabelsPut Modify a Label of Snapshot
 * This will modify the value of the label on a snapshot.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param snapshotId The unique ID of the Snapshot
 * @param key The key of the Label
 * @return ApiSnapshotsLabelsPutRequest
 */
func (a *LabelApiService) SnapshotsLabelsPut(ctx _context.Context, snapshotId string, key string) ApiSnapshotsLabelsPutRequest {
	return ApiSnapshotsLabelsPutRequest{
		ApiService: a,
		ctx: ctx,
		snapshotId: snapshotId,
		key: key,
	}
}

/*
 * Execute executes the request
 * @return LabelResource
 */
func (a *LabelApiService) SnapshotsLabelsPutExecute(r ApiSnapshotsLabelsPutRequest) (LabelResource, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  LabelResource
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "LabelApiService.SnapshotsLabelsPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/snapshots/{snapshotId}/labels/{key}"
	localVarPath = strings.Replace(localVarPath, "{"+"snapshotId"+"}", _neturl.PathEscape(parameterToString(r.snapshotId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"key"+"}", _neturl.PathEscape(parameterToString(r.key, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.label == nil {
		return localVarReturnValue, nil, reportError("label is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.label
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "SnapshotsLabelsPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}
