/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	"encoding/json"
)

// ResourceLimits struct for ResourceLimits
type ResourceLimits struct {
	// maximum number of cores per server
	CoresPerServer *int32 `json:"coresPerServer"`
	// maximum cores per contract
	CoresPerContract *int32 `json:"coresPerContract"`
	// number of cores provisioned
	CoresProvisioned *int32 `json:"coresProvisioned"`
	// maximum ram per server
	RamPerServer *int32 `json:"ramPerServer"`
	// maximum ram per contract
	RamPerContract *int32 `json:"ramPerContract"`
	// ram provisioned
	RamProvisioned *int32 `json:"ramProvisioned"`
	// hdd limit per volume
	HddLimitPerVolume *int64 `json:"hddLimitPerVolume"`
	// hdd limit per contract
	HddLimitPerContract *int64 `json:"hddLimitPerContract"`
	// hdd volume provisioned
	HddVolumeProvisioned *int64 `json:"hddVolumeProvisioned"`
	// ssd limit per volume
	SsdLimitPerVolume *int64 `json:"ssdLimitPerVolume"`
	// ssd limit per contract
	SsdLimitPerContract *int64 `json:"ssdLimitPerContract"`
	// ssd volume provisioned
	SsdVolumeProvisioned *int64 `json:"ssdVolumeProvisioned"`
	// total reservable ip limit of the customer
	ReservableIps *int32 `json:"reservableIps"`
	// reserved ips on a contract
	ReservedIpsOnContract *int32 `json:"reservedIpsOnContract"`
	// reserved ips in use
	ReservedIpsInUse *int32 `json:"reservedIpsInUse"`
	// k8s clusters total limit
	K8sClusterLimitTotal *int32 `json:"k8sClusterLimitTotal"`
	// k8s clusters provisioned
	K8sClustersProvisioned *int32 `json:"k8sClustersProvisioned"`
}



// GetCoresPerServer returns the CoresPerServer field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *ResourceLimits) GetCoresPerServer() *int32 {
	if o == nil {
		return nil
	}

	return o.CoresPerServer
}

// GetCoresPerServerOk returns a tuple with the CoresPerServer field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetCoresPerServerOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.CoresPerServer, true
}

// SetCoresPerServer sets field value
func (o *ResourceLimits) SetCoresPerServer(v int32) {
	o.CoresPerServer = &v
}

// HasCoresPerServer returns a boolean if a field has been set.
func (o *ResourceLimits) HasCoresPerServer() bool {
	if o != nil && o.CoresPerServer != nil {
		return true
	}

	return false
}



// GetCoresPerContract returns the CoresPerContract field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *ResourceLimits) GetCoresPerContract() *int32 {
	if o == nil {
		return nil
	}

	return o.CoresPerContract
}

// GetCoresPerContractOk returns a tuple with the CoresPerContract field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetCoresPerContractOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.CoresPerContract, true
}

// SetCoresPerContract sets field value
func (o *ResourceLimits) SetCoresPerContract(v int32) {
	o.CoresPerContract = &v
}

// HasCoresPerContract returns a boolean if a field has been set.
func (o *ResourceLimits) HasCoresPerContract() bool {
	if o != nil && o.CoresPerContract != nil {
		return true
	}

	return false
}



// GetCoresProvisioned returns the CoresProvisioned field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *ResourceLimits) GetCoresProvisioned() *int32 {
	if o == nil {
		return nil
	}

	return o.CoresProvisioned
}

// GetCoresProvisionedOk returns a tuple with the CoresProvisioned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetCoresProvisionedOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.CoresProvisioned, true
}

// SetCoresProvisioned sets field value
func (o *ResourceLimits) SetCoresProvisioned(v int32) {
	o.CoresProvisioned = &v
}

// HasCoresProvisioned returns a boolean if a field has been set.
func (o *ResourceLimits) HasCoresProvisioned() bool {
	if o != nil && o.CoresProvisioned != nil {
		return true
	}

	return false
}



// GetRamPerServer returns the RamPerServer field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *ResourceLimits) GetRamPerServer() *int32 {
	if o == nil {
		return nil
	}

	return o.RamPerServer
}

// GetRamPerServerOk returns a tuple with the RamPerServer field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetRamPerServerOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.RamPerServer, true
}

// SetRamPerServer sets field value
func (o *ResourceLimits) SetRamPerServer(v int32) {
	o.RamPerServer = &v
}

// HasRamPerServer returns a boolean if a field has been set.
func (o *ResourceLimits) HasRamPerServer() bool {
	if o != nil && o.RamPerServer != nil {
		return true
	}

	return false
}



// GetRamPerContract returns the RamPerContract field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *ResourceLimits) GetRamPerContract() *int32 {
	if o == nil {
		return nil
	}

	return o.RamPerContract
}

// GetRamPerContractOk returns a tuple with the RamPerContract field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetRamPerContractOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.RamPerContract, true
}

// SetRamPerContract sets field value
func (o *ResourceLimits) SetRamPerContract(v int32) {
	o.RamPerContract = &v
}

// HasRamPerContract returns a boolean if a field has been set.
func (o *ResourceLimits) HasRamPerContract() bool {
	if o != nil && o.RamPerContract != nil {
		return true
	}

	return false
}



// GetRamProvisioned returns the RamProvisioned field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *ResourceLimits) GetRamProvisioned() *int32 {
	if o == nil {
		return nil
	}

	return o.RamProvisioned
}

// GetRamProvisionedOk returns a tuple with the RamProvisioned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetRamProvisionedOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.RamProvisioned, true
}

// SetRamProvisioned sets field value
func (o *ResourceLimits) SetRamProvisioned(v int32) {
	o.RamProvisioned = &v
}

// HasRamProvisioned returns a boolean if a field has been set.
func (o *ResourceLimits) HasRamProvisioned() bool {
	if o != nil && o.RamProvisioned != nil {
		return true
	}

	return false
}



// GetHddLimitPerVolume returns the HddLimitPerVolume field value
// If the value is explicit nil, the zero value for int64 will be returned
func (o *ResourceLimits) GetHddLimitPerVolume() *int64 {
	if o == nil {
		return nil
	}

	return o.HddLimitPerVolume
}

// GetHddLimitPerVolumeOk returns a tuple with the HddLimitPerVolume field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetHddLimitPerVolumeOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.HddLimitPerVolume, true
}

// SetHddLimitPerVolume sets field value
func (o *ResourceLimits) SetHddLimitPerVolume(v int64) {
	o.HddLimitPerVolume = &v
}

// HasHddLimitPerVolume returns a boolean if a field has been set.
func (o *ResourceLimits) HasHddLimitPerVolume() bool {
	if o != nil && o.HddLimitPerVolume != nil {
		return true
	}

	return false
}



// GetHddLimitPerContract returns the HddLimitPerContract field value
// If the value is explicit nil, the zero value for int64 will be returned
func (o *ResourceLimits) GetHddLimitPerContract() *int64 {
	if o == nil {
		return nil
	}

	return o.HddLimitPerContract
}

// GetHddLimitPerContractOk returns a tuple with the HddLimitPerContract field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetHddLimitPerContractOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.HddLimitPerContract, true
}

// SetHddLimitPerContract sets field value
func (o *ResourceLimits) SetHddLimitPerContract(v int64) {
	o.HddLimitPerContract = &v
}

// HasHddLimitPerContract returns a boolean if a field has been set.
func (o *ResourceLimits) HasHddLimitPerContract() bool {
	if o != nil && o.HddLimitPerContract != nil {
		return true
	}

	return false
}



// GetHddVolumeProvisioned returns the HddVolumeProvisioned field value
// If the value is explicit nil, the zero value for int64 will be returned
func (o *ResourceLimits) GetHddVolumeProvisioned() *int64 {
	if o == nil {
		return nil
	}

	return o.HddVolumeProvisioned
}

// GetHddVolumeProvisionedOk returns a tuple with the HddVolumeProvisioned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetHddVolumeProvisionedOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.HddVolumeProvisioned, true
}

// SetHddVolumeProvisioned sets field value
func (o *ResourceLimits) SetHddVolumeProvisioned(v int64) {
	o.HddVolumeProvisioned = &v
}

// HasHddVolumeProvisioned returns a boolean if a field has been set.
func (o *ResourceLimits) HasHddVolumeProvisioned() bool {
	if o != nil && o.HddVolumeProvisioned != nil {
		return true
	}

	return false
}



// GetSsdLimitPerVolume returns the SsdLimitPerVolume field value
// If the value is explicit nil, the zero value for int64 will be returned
func (o *ResourceLimits) GetSsdLimitPerVolume() *int64 {
	if o == nil {
		return nil
	}

	return o.SsdLimitPerVolume
}

// GetSsdLimitPerVolumeOk returns a tuple with the SsdLimitPerVolume field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetSsdLimitPerVolumeOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.SsdLimitPerVolume, true
}

// SetSsdLimitPerVolume sets field value
func (o *ResourceLimits) SetSsdLimitPerVolume(v int64) {
	o.SsdLimitPerVolume = &v
}

// HasSsdLimitPerVolume returns a boolean if a field has been set.
func (o *ResourceLimits) HasSsdLimitPerVolume() bool {
	if o != nil && o.SsdLimitPerVolume != nil {
		return true
	}

	return false
}



// GetSsdLimitPerContract returns the SsdLimitPerContract field value
// If the value is explicit nil, the zero value for int64 will be returned
func (o *ResourceLimits) GetSsdLimitPerContract() *int64 {
	if o == nil {
		return nil
	}

	return o.SsdLimitPerContract
}

// GetSsdLimitPerContractOk returns a tuple with the SsdLimitPerContract field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetSsdLimitPerContractOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.SsdLimitPerContract, true
}

// SetSsdLimitPerContract sets field value
func (o *ResourceLimits) SetSsdLimitPerContract(v int64) {
	o.SsdLimitPerContract = &v
}

// HasSsdLimitPerContract returns a boolean if a field has been set.
func (o *ResourceLimits) HasSsdLimitPerContract() bool {
	if o != nil && o.SsdLimitPerContract != nil {
		return true
	}

	return false
}



// GetSsdVolumeProvisioned returns the SsdVolumeProvisioned field value
// If the value is explicit nil, the zero value for int64 will be returned
func (o *ResourceLimits) GetSsdVolumeProvisioned() *int64 {
	if o == nil {
		return nil
	}

	return o.SsdVolumeProvisioned
}

// GetSsdVolumeProvisionedOk returns a tuple with the SsdVolumeProvisioned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetSsdVolumeProvisionedOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return o.SsdVolumeProvisioned, true
}

// SetSsdVolumeProvisioned sets field value
func (o *ResourceLimits) SetSsdVolumeProvisioned(v int64) {
	o.SsdVolumeProvisioned = &v
}

// HasSsdVolumeProvisioned returns a boolean if a field has been set.
func (o *ResourceLimits) HasSsdVolumeProvisioned() bool {
	if o != nil && o.SsdVolumeProvisioned != nil {
		return true
	}

	return false
}



// GetReservableIps returns the ReservableIps field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *ResourceLimits) GetReservableIps() *int32 {
	if o == nil {
		return nil
	}

	return o.ReservableIps
}

// GetReservableIpsOk returns a tuple with the ReservableIps field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetReservableIpsOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.ReservableIps, true
}

// SetReservableIps sets field value
func (o *ResourceLimits) SetReservableIps(v int32) {
	o.ReservableIps = &v
}

// HasReservableIps returns a boolean if a field has been set.
func (o *ResourceLimits) HasReservableIps() bool {
	if o != nil && o.ReservableIps != nil {
		return true
	}

	return false
}



// GetReservedIpsOnContract returns the ReservedIpsOnContract field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *ResourceLimits) GetReservedIpsOnContract() *int32 {
	if o == nil {
		return nil
	}

	return o.ReservedIpsOnContract
}

// GetReservedIpsOnContractOk returns a tuple with the ReservedIpsOnContract field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetReservedIpsOnContractOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.ReservedIpsOnContract, true
}

// SetReservedIpsOnContract sets field value
func (o *ResourceLimits) SetReservedIpsOnContract(v int32) {
	o.ReservedIpsOnContract = &v
}

// HasReservedIpsOnContract returns a boolean if a field has been set.
func (o *ResourceLimits) HasReservedIpsOnContract() bool {
	if o != nil && o.ReservedIpsOnContract != nil {
		return true
	}

	return false
}



// GetReservedIpsInUse returns the ReservedIpsInUse field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *ResourceLimits) GetReservedIpsInUse() *int32 {
	if o == nil {
		return nil
	}

	return o.ReservedIpsInUse
}

// GetReservedIpsInUseOk returns a tuple with the ReservedIpsInUse field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetReservedIpsInUseOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.ReservedIpsInUse, true
}

// SetReservedIpsInUse sets field value
func (o *ResourceLimits) SetReservedIpsInUse(v int32) {
	o.ReservedIpsInUse = &v
}

// HasReservedIpsInUse returns a boolean if a field has been set.
func (o *ResourceLimits) HasReservedIpsInUse() bool {
	if o != nil && o.ReservedIpsInUse != nil {
		return true
	}

	return false
}



// GetK8sClusterLimitTotal returns the K8sClusterLimitTotal field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *ResourceLimits) GetK8sClusterLimitTotal() *int32 {
	if o == nil {
		return nil
	}

	return o.K8sClusterLimitTotal
}

// GetK8sClusterLimitTotalOk returns a tuple with the K8sClusterLimitTotal field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetK8sClusterLimitTotalOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.K8sClusterLimitTotal, true
}

// SetK8sClusterLimitTotal sets field value
func (o *ResourceLimits) SetK8sClusterLimitTotal(v int32) {
	o.K8sClusterLimitTotal = &v
}

// HasK8sClusterLimitTotal returns a boolean if a field has been set.
func (o *ResourceLimits) HasK8sClusterLimitTotal() bool {
	if o != nil && o.K8sClusterLimitTotal != nil {
		return true
	}

	return false
}



// GetK8sClustersProvisioned returns the K8sClustersProvisioned field value
// If the value is explicit nil, the zero value for int32 will be returned
func (o *ResourceLimits) GetK8sClustersProvisioned() *int32 {
	if o == nil {
		return nil
	}

	return o.K8sClustersProvisioned
}

// GetK8sClustersProvisionedOk returns a tuple with the K8sClustersProvisioned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetK8sClustersProvisionedOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return o.K8sClustersProvisioned, true
}

// SetK8sClustersProvisioned sets field value
func (o *ResourceLimits) SetK8sClustersProvisioned(v int32) {
	o.K8sClustersProvisioned = &v
}

// HasK8sClustersProvisioned returns a boolean if a field has been set.
func (o *ResourceLimits) HasK8sClustersProvisioned() bool {
	if o != nil && o.K8sClustersProvisioned != nil {
		return true
	}

	return false
}


func (o ResourceLimits) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}

	if o.CoresPerServer != nil {
		toSerialize["coresPerServer"] = o.CoresPerServer
	}
	

	if o.CoresPerContract != nil {
		toSerialize["coresPerContract"] = o.CoresPerContract
	}
	

	if o.CoresProvisioned != nil {
		toSerialize["coresProvisioned"] = o.CoresProvisioned
	}
	

	if o.RamPerServer != nil {
		toSerialize["ramPerServer"] = o.RamPerServer
	}
	

	if o.RamPerContract != nil {
		toSerialize["ramPerContract"] = o.RamPerContract
	}
	

	if o.RamProvisioned != nil {
		toSerialize["ramProvisioned"] = o.RamProvisioned
	}
	

	if o.HddLimitPerVolume != nil {
		toSerialize["hddLimitPerVolume"] = o.HddLimitPerVolume
	}
	

	if o.HddLimitPerContract != nil {
		toSerialize["hddLimitPerContract"] = o.HddLimitPerContract
	}
	

	if o.HddVolumeProvisioned != nil {
		toSerialize["hddVolumeProvisioned"] = o.HddVolumeProvisioned
	}
	

	if o.SsdLimitPerVolume != nil {
		toSerialize["ssdLimitPerVolume"] = o.SsdLimitPerVolume
	}
	

	if o.SsdLimitPerContract != nil {
		toSerialize["ssdLimitPerContract"] = o.SsdLimitPerContract
	}
	

	if o.SsdVolumeProvisioned != nil {
		toSerialize["ssdVolumeProvisioned"] = o.SsdVolumeProvisioned
	}
	

	if o.ReservableIps != nil {
		toSerialize["reservableIps"] = o.ReservableIps
	}
	

	if o.ReservedIpsOnContract != nil {
		toSerialize["reservedIpsOnContract"] = o.ReservedIpsOnContract
	}
	

	if o.ReservedIpsInUse != nil {
		toSerialize["reservedIpsInUse"] = o.ReservedIpsInUse
	}
	

	if o.K8sClusterLimitTotal != nil {
		toSerialize["k8sClusterLimitTotal"] = o.K8sClusterLimitTotal
	}
	

	if o.K8sClustersProvisioned != nil {
		toSerialize["k8sClustersProvisioned"] = o.K8sClustersProvisioned
	}
	
	return json.Marshal(toSerialize)
}

type NullableResourceLimits struct {
	value *ResourceLimits
	isSet bool
}

func (v NullableResourceLimits) Get() *ResourceLimits {
	return v.value
}

func (v *NullableResourceLimits) Set(val *ResourceLimits) {
	v.value = val
	v.isSet = true
}

func (v NullableResourceLimits) IsSet() bool {
	return v.isSet
}

func (v *NullableResourceLimits) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableResourceLimits(val *ResourceLimits) *NullableResourceLimits {
	return &NullableResourceLimits{value: val, isSet: true}
}

func (v NullableResourceLimits) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableResourceLimits) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


