/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was generated by go generate; DO NOT EDIT

package azure

// InstanceType is the sepc of Azure instance
type InstanceType struct {
	InstanceType string
	VCPU         int64
	MemoryMb     int64
	GPU          int64
}

// InstanceTypes is a map of azure resources
var InstanceTypes = map[string]*InstanceType{
	"Basic_A0": {
		InstanceType: "Basic_A0",
		VCPU:         1,
		MemoryMb:     0,
		GPU:          0,
	},
	"Basic_A1": {
		InstanceType: "Basic_A1",
		VCPU:         1,
		MemoryMb:     1024,
		GPU:          0,
	},
	"Basic_A2": {
		InstanceType: "Basic_A2",
		VCPU:         2,
		MemoryMb:     3072,
		GPU:          0,
	},
	"Basic_A3": {
		InstanceType: "Basic_A3",
		VCPU:         4,
		MemoryMb:     7168,
		GPU:          0,
	},
	"Basic_A4": {
		InstanceType: "Basic_A4",
		VCPU:         8,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_A0": {
		InstanceType: "Standard_A0",
		VCPU:         1,
		MemoryMb:     0,
		GPU:          0,
	},
	"Standard_A1": {
		InstanceType: "Standard_A1",
		VCPU:         1,
		MemoryMb:     1024,
		GPU:          0,
	},
	"Standard_A10": {
		InstanceType: "Standard_A10",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_A11": {
		InstanceType: "Standard_A11",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_A1_v2": {
		InstanceType: "Standard_A1_v2",
		VCPU:         1,
		MemoryMb:     2048,
		GPU:          0,
	},
	"Standard_A2": {
		InstanceType: "Standard_A2",
		VCPU:         2,
		MemoryMb:     3072,
		GPU:          0,
	},
	"Standard_A2_v2": {
		InstanceType: "Standard_A2_v2",
		VCPU:         2,
		MemoryMb:     4096,
		GPU:          0,
	},
	"Standard_A2m_v2": {
		InstanceType: "Standard_A2m_v2",
		VCPU:         2,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_A3": {
		InstanceType: "Standard_A3",
		VCPU:         4,
		MemoryMb:     7168,
		GPU:          0,
	},
	"Standard_A4": {
		InstanceType: "Standard_A4",
		VCPU:         8,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_A4_v2": {
		InstanceType: "Standard_A4_v2",
		VCPU:         4,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_A4m_v2": {
		InstanceType: "Standard_A4m_v2",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_A5": {
		InstanceType: "Standard_A5",
		VCPU:         2,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_A6": {
		InstanceType: "Standard_A6",
		VCPU:         4,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_A7": {
		InstanceType: "Standard_A7",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_A8": {
		InstanceType: "Standard_A8",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_A8_v2": {
		InstanceType: "Standard_A8_v2",
		VCPU:         8,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_A8m_v2": {
		InstanceType: "Standard_A8m_v2",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_A9": {
		InstanceType: "Standard_A9",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_B12ms": {
		InstanceType: "Standard_B12ms",
		VCPU:         12,
		MemoryMb:     49152,
		GPU:          0,
	},
	"Standard_B16ms": {
		InstanceType: "Standard_B16ms",
		VCPU:         16,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_B1ls": {
		InstanceType: "Standard_B1ls",
		VCPU:         1,
		MemoryMb:     0,
		GPU:          0,
	},
	"Standard_B1ms": {
		InstanceType: "Standard_B1ms",
		VCPU:         1,
		MemoryMb:     2048,
		GPU:          0,
	},
	"Standard_B1s": {
		InstanceType: "Standard_B1s",
		VCPU:         1,
		MemoryMb:     1024,
		GPU:          0,
	},
	"Standard_B20ms": {
		InstanceType: "Standard_B20ms",
		VCPU:         20,
		MemoryMb:     81920,
		GPU:          0,
	},
	"Standard_B2ms": {
		InstanceType: "Standard_B2ms",
		VCPU:         2,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_B2s": {
		InstanceType: "Standard_B2s",
		VCPU:         2,
		MemoryMb:     4096,
		GPU:          0,
	},
	"Standard_B4ms": {
		InstanceType: "Standard_B4ms",
		VCPU:         4,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_B8ms": {
		InstanceType: "Standard_B8ms",
		VCPU:         8,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_D1": {
		InstanceType: "Standard_D1",
		VCPU:         1,
		MemoryMb:     3072,
		GPU:          0,
	},
	"Standard_D11": {
		InstanceType: "Standard_D11",
		VCPU:         2,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_D11_v2": {
		InstanceType: "Standard_D11_v2",
		VCPU:         2,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_D11_v2_Promo": {
		InstanceType: "Standard_D11_v2_Promo",
		VCPU:         2,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_D12": {
		InstanceType: "Standard_D12",
		VCPU:         4,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_D12_v2": {
		InstanceType: "Standard_D12_v2",
		VCPU:         4,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_D12_v2_Promo": {
		InstanceType: "Standard_D12_v2_Promo",
		VCPU:         4,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_D13": {
		InstanceType: "Standard_D13",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_D13_v2": {
		InstanceType: "Standard_D13_v2",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_D13_v2_Promo": {
		InstanceType: "Standard_D13_v2_Promo",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_D14": {
		InstanceType: "Standard_D14",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_D14_v2": {
		InstanceType: "Standard_D14_v2",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_D14_v2_Promo": {
		InstanceType: "Standard_D14_v2_Promo",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_D15_v2": {
		InstanceType: "Standard_D15_v2",
		VCPU:         20,
		MemoryMb:     143360,
		GPU:          0,
	},
	"Standard_D16_v3": {
		InstanceType: "Standard_D16_v3",
		VCPU:         16,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_D16_v4": {
		InstanceType: "Standard_D16_v4",
		VCPU:         16,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_D16a_v3": {
		InstanceType: "Standard_D16a_v3",
		VCPU:         16,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_D16a_v4": {
		InstanceType: "Standard_D16a_v4",
		VCPU:         16,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_D16as_v3": {
		InstanceType: "Standard_D16as_v3",
		VCPU:         16,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_D16as_v4": {
		InstanceType: "Standard_D16as_v4",
		VCPU:         16,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_D16d_v4": {
		InstanceType: "Standard_D16d_v4",
		VCPU:         16,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_D16ds_v4": {
		InstanceType: "Standard_D16ds_v4",
		VCPU:         16,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_D16s_v3": {
		InstanceType: "Standard_D16s_v3",
		VCPU:         16,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_D16s_v4": {
		InstanceType: "Standard_D16s_v4",
		VCPU:         16,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_D1_v2": {
		InstanceType: "Standard_D1_v2",
		VCPU:         1,
		MemoryMb:     3072,
		GPU:          0,
	},
	"Standard_D2": {
		InstanceType: "Standard_D2",
		VCPU:         2,
		MemoryMb:     7168,
		GPU:          0,
	},
	"Standard_D2_v2": {
		InstanceType: "Standard_D2_v2",
		VCPU:         2,
		MemoryMb:     7168,
		GPU:          0,
	},
	"Standard_D2_v2_Promo": {
		InstanceType: "Standard_D2_v2_Promo",
		VCPU:         2,
		MemoryMb:     7168,
		GPU:          0,
	},
	"Standard_D2_v3": {
		InstanceType: "Standard_D2_v3",
		VCPU:         2,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_D2_v4": {
		InstanceType: "Standard_D2_v4",
		VCPU:         2,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_D2a_v3": {
		InstanceType: "Standard_D2a_v3",
		VCPU:         2,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_D2a_v4": {
		InstanceType: "Standard_D2a_v4",
		VCPU:         2,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_D2as_v3": {
		InstanceType: "Standard_D2as_v3",
		VCPU:         2,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_D2as_v4": {
		InstanceType: "Standard_D2as_v4",
		VCPU:         2,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_D2d_v4": {
		InstanceType: "Standard_D2d_v4",
		VCPU:         2,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_D2ds_v4": {
		InstanceType: "Standard_D2ds_v4",
		VCPU:         2,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_D2s_v3": {
		InstanceType: "Standard_D2s_v3",
		VCPU:         2,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_D2s_v4": {
		InstanceType: "Standard_D2s_v4",
		VCPU:         2,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_D3": {
		InstanceType: "Standard_D3",
		VCPU:         4,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_D32_v3": {
		InstanceType: "Standard_D32_v3",
		VCPU:         32,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_D32_v4": {
		InstanceType: "Standard_D32_v4",
		VCPU:         32,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_D32a_v3": {
		InstanceType: "Standard_D32a_v3",
		VCPU:         32,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_D32a_v4": {
		InstanceType: "Standard_D32a_v4",
		VCPU:         32,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_D32as_v3": {
		InstanceType: "Standard_D32as_v3",
		VCPU:         32,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_D32as_v4": {
		InstanceType: "Standard_D32as_v4",
		VCPU:         32,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_D32d_v4": {
		InstanceType: "Standard_D32d_v4",
		VCPU:         32,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_D32ds_v4": {
		InstanceType: "Standard_D32ds_v4",
		VCPU:         32,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_D32s_v3": {
		InstanceType: "Standard_D32s_v3",
		VCPU:         32,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_D32s_v4": {
		InstanceType: "Standard_D32s_v4",
		VCPU:         32,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_D3_v2": {
		InstanceType: "Standard_D3_v2",
		VCPU:         4,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_D3_v2_Promo": {
		InstanceType: "Standard_D3_v2_Promo",
		VCPU:         4,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_D4": {
		InstanceType: "Standard_D4",
		VCPU:         8,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_D48_v3": {
		InstanceType: "Standard_D48_v3",
		VCPU:         48,
		MemoryMb:     196608,
		GPU:          0,
	},
	"Standard_D48_v4": {
		InstanceType: "Standard_D48_v4",
		VCPU:         48,
		MemoryMb:     196608,
		GPU:          0,
	},
	"Standard_D48a_v3": {
		InstanceType: "Standard_D48a_v3",
		VCPU:         48,
		MemoryMb:     196608,
		GPU:          0,
	},
	"Standard_D48a_v4": {
		InstanceType: "Standard_D48a_v4",
		VCPU:         48,
		MemoryMb:     196608,
		GPU:          0,
	},
	"Standard_D48as_v3": {
		InstanceType: "Standard_D48as_v3",
		VCPU:         48,
		MemoryMb:     196608,
		GPU:          0,
	},
	"Standard_D48as_v4": {
		InstanceType: "Standard_D48as_v4",
		VCPU:         48,
		MemoryMb:     196608,
		GPU:          0,
	},
	"Standard_D48d_v4": {
		InstanceType: "Standard_D48d_v4",
		VCPU:         48,
		MemoryMb:     196608,
		GPU:          0,
	},
	"Standard_D48ds_v4": {
		InstanceType: "Standard_D48ds_v4",
		VCPU:         48,
		MemoryMb:     196608,
		GPU:          0,
	},
	"Standard_D48s_v3": {
		InstanceType: "Standard_D48s_v3",
		VCPU:         48,
		MemoryMb:     196608,
		GPU:          0,
	},
	"Standard_D48s_v4": {
		InstanceType: "Standard_D48s_v4",
		VCPU:         48,
		MemoryMb:     196608,
		GPU:          0,
	},
	"Standard_D4_v2": {
		InstanceType: "Standard_D4_v2",
		VCPU:         8,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_D4_v2_Promo": {
		InstanceType: "Standard_D4_v2_Promo",
		VCPU:         8,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_D4_v3": {
		InstanceType: "Standard_D4_v3",
		VCPU:         4,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_D4_v4": {
		InstanceType: "Standard_D4_v4",
		VCPU:         4,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_D4a_v3": {
		InstanceType: "Standard_D4a_v3",
		VCPU:         4,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_D4a_v4": {
		InstanceType: "Standard_D4a_v4",
		VCPU:         4,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_D4as_v3": {
		InstanceType: "Standard_D4as_v3",
		VCPU:         4,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_D4as_v4": {
		InstanceType: "Standard_D4as_v4",
		VCPU:         4,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_D4d_v4": {
		InstanceType: "Standard_D4d_v4",
		VCPU:         4,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_D4ds_v4": {
		InstanceType: "Standard_D4ds_v4",
		VCPU:         4,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_D4s_v3": {
		InstanceType: "Standard_D4s_v3",
		VCPU:         4,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_D4s_v4": {
		InstanceType: "Standard_D4s_v4",
		VCPU:         4,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_D5_v2": {
		InstanceType: "Standard_D5_v2",
		VCPU:         16,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_D5_v2_Promo": {
		InstanceType: "Standard_D5_v2_Promo",
		VCPU:         16,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_D64_v3": {
		InstanceType: "Standard_D64_v3",
		VCPU:         64,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_D64_v4": {
		InstanceType: "Standard_D64_v4",
		VCPU:         64,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_D64a_v3": {
		InstanceType: "Standard_D64a_v3",
		VCPU:         64,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_D64a_v4": {
		InstanceType: "Standard_D64a_v4",
		VCPU:         64,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_D64as_v3": {
		InstanceType: "Standard_D64as_v3",
		VCPU:         64,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_D64as_v4": {
		InstanceType: "Standard_D64as_v4",
		VCPU:         64,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_D64d_v4": {
		InstanceType: "Standard_D64d_v4",
		VCPU:         64,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_D64ds_v4": {
		InstanceType: "Standard_D64ds_v4",
		VCPU:         64,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_D64s_v3": {
		InstanceType: "Standard_D64s_v3",
		VCPU:         64,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_D64s_v4": {
		InstanceType: "Standard_D64s_v4",
		VCPU:         64,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_D8_v3": {
		InstanceType: "Standard_D8_v3",
		VCPU:         8,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_D8_v4": {
		InstanceType: "Standard_D8_v4",
		VCPU:         8,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_D8a_v3": {
		InstanceType: "Standard_D8a_v3",
		VCPU:         8,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_D8a_v4": {
		InstanceType: "Standard_D8a_v4",
		VCPU:         8,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_D8as_v3": {
		InstanceType: "Standard_D8as_v3",
		VCPU:         8,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_D8as_v4": {
		InstanceType: "Standard_D8as_v4",
		VCPU:         8,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_D8d_v4": {
		InstanceType: "Standard_D8d_v4",
		VCPU:         8,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_D8ds_v4": {
		InstanceType: "Standard_D8ds_v4",
		VCPU:         8,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_D8s_v3": {
		InstanceType: "Standard_D8s_v3",
		VCPU:         8,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_D8s_v4": {
		InstanceType: "Standard_D8s_v4",
		VCPU:         8,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_D96a_v4": {
		InstanceType: "Standard_D96a_v4",
		VCPU:         96,
		MemoryMb:     393216,
		GPU:          0,
	},
	"Standard_D96as_v4": {
		InstanceType: "Standard_D96as_v4",
		VCPU:         96,
		MemoryMb:     393216,
		GPU:          0,
	},
	"Standard_DC1s_v2": {
		InstanceType: "Standard_DC1s_v2",
		VCPU:         1,
		MemoryMb:     4096,
		GPU:          0,
	},
	"Standard_DC2s": {
		InstanceType: "Standard_DC2s",
		VCPU:         2,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_DC2s_v2": {
		InstanceType: "Standard_DC2s_v2",
		VCPU:         2,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_DC4s": {
		InstanceType: "Standard_DC4s",
		VCPU:         4,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_DC4s_v2": {
		InstanceType: "Standard_DC4s_v2",
		VCPU:         4,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_DC8_v2": {
		InstanceType: "Standard_DC8_v2",
		VCPU:         8,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_DS1": {
		InstanceType: "Standard_DS1",
		VCPU:         1,
		MemoryMb:     3072,
		GPU:          0,
	},
	"Standard_DS11": {
		InstanceType: "Standard_DS11",
		VCPU:         2,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_DS11-1_v2": {
		InstanceType: "Standard_DS11-1_v2",
		VCPU:         2,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_DS11_v2": {
		InstanceType: "Standard_DS11_v2",
		VCPU:         2,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_DS11_v2_Promo": {
		InstanceType: "Standard_DS11_v2_Promo",
		VCPU:         2,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_DS12": {
		InstanceType: "Standard_DS12",
		VCPU:         4,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_DS12-1_v2": {
		InstanceType: "Standard_DS12-1_v2",
		VCPU:         4,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_DS12-2_v2": {
		InstanceType: "Standard_DS12-2_v2",
		VCPU:         4,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_DS12_v2": {
		InstanceType: "Standard_DS12_v2",
		VCPU:         4,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_DS12_v2_Promo": {
		InstanceType: "Standard_DS12_v2_Promo",
		VCPU:         4,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_DS13": {
		InstanceType: "Standard_DS13",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_DS13-2_v2": {
		InstanceType: "Standard_DS13-2_v2",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_DS13-4_v2": {
		InstanceType: "Standard_DS13-4_v2",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_DS13_v2": {
		InstanceType: "Standard_DS13_v2",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_DS13_v2_Promo": {
		InstanceType: "Standard_DS13_v2_Promo",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_DS14": {
		InstanceType: "Standard_DS14",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_DS14-4_v2": {
		InstanceType: "Standard_DS14-4_v2",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_DS14-8_v2": {
		InstanceType: "Standard_DS14-8_v2",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_DS14_v2": {
		InstanceType: "Standard_DS14_v2",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_DS14_v2_Promo": {
		InstanceType: "Standard_DS14_v2_Promo",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_DS15_v2": {
		InstanceType: "Standard_DS15_v2",
		VCPU:         20,
		MemoryMb:     143360,
		GPU:          0,
	},
	"Standard_DS1_v2": {
		InstanceType: "Standard_DS1_v2",
		VCPU:         1,
		MemoryMb:     3072,
		GPU:          0,
	},
	"Standard_DS2": {
		InstanceType: "Standard_DS2",
		VCPU:         2,
		MemoryMb:     7168,
		GPU:          0,
	},
	"Standard_DS2_v2": {
		InstanceType: "Standard_DS2_v2",
		VCPU:         2,
		MemoryMb:     7168,
		GPU:          0,
	},
	"Standard_DS2_v2_Promo": {
		InstanceType: "Standard_DS2_v2_Promo",
		VCPU:         2,
		MemoryMb:     7168,
		GPU:          0,
	},
	"Standard_DS3": {
		InstanceType: "Standard_DS3",
		VCPU:         4,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_DS3_v2": {
		InstanceType: "Standard_DS3_v2",
		VCPU:         4,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_DS3_v2_Promo": {
		InstanceType: "Standard_DS3_v2_Promo",
		VCPU:         4,
		MemoryMb:     14336,
		GPU:          0,
	},
	"Standard_DS4": {
		InstanceType: "Standard_DS4",
		VCPU:         8,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_DS4_v2": {
		InstanceType: "Standard_DS4_v2",
		VCPU:         8,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_DS4_v2_Promo": {
		InstanceType: "Standard_DS4_v2_Promo",
		VCPU:         8,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_DS5_v2": {
		InstanceType: "Standard_DS5_v2",
		VCPU:         16,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_DS5_v2_Promo": {
		InstanceType: "Standard_DS5_v2_Promo",
		VCPU:         16,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_E16-4as_v4": {
		InstanceType: "Standard_E16-4as_v4",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16-4ds_v4": {
		InstanceType: "Standard_E16-4ds_v4",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16-4s_v3": {
		InstanceType: "Standard_E16-4s_v3",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16-4s_v4": {
		InstanceType: "Standard_E16-4s_v4",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16-8as_v4": {
		InstanceType: "Standard_E16-8as_v4",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16-8ds_v4": {
		InstanceType: "Standard_E16-8ds_v4",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16-8s_v3": {
		InstanceType: "Standard_E16-8s_v3",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16-8s_v4": {
		InstanceType: "Standard_E16-8s_v4",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16_v3": {
		InstanceType: "Standard_E16_v3",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16_v4": {
		InstanceType: "Standard_E16_v4",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16a_v4": {
		InstanceType: "Standard_E16a_v4",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16as_v4": {
		InstanceType: "Standard_E16as_v4",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16d_v4": {
		InstanceType: "Standard_E16d_v4",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16ds_v4": {
		InstanceType: "Standard_E16ds_v4",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16s_v3": {
		InstanceType: "Standard_E16s_v3",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E16s_v4": {
		InstanceType: "Standard_E16s_v4",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_E20_v3": {
		InstanceType: "Standard_E20_v3",
		VCPU:         20,
		MemoryMb:     163840,
		GPU:          0,
	},
	"Standard_E20_v4": {
		InstanceType: "Standard_E20_v4",
		VCPU:         20,
		MemoryMb:     163840,
		GPU:          0,
	},
	"Standard_E20a_v4": {
		InstanceType: "Standard_E20a_v4",
		VCPU:         20,
		MemoryMb:     163840,
		GPU:          0,
	},
	"Standard_E20as_v4": {
		InstanceType: "Standard_E20as_v4",
		VCPU:         20,
		MemoryMb:     163840,
		GPU:          0,
	},
	"Standard_E20d_v4": {
		InstanceType: "Standard_E20d_v4",
		VCPU:         20,
		MemoryMb:     163840,
		GPU:          0,
	},
	"Standard_E20ds_v4": {
		InstanceType: "Standard_E20ds_v4",
		VCPU:         20,
		MemoryMb:     163840,
		GPU:          0,
	},
	"Standard_E20s_v3": {
		InstanceType: "Standard_E20s_v3",
		VCPU:         20,
		MemoryMb:     163840,
		GPU:          0,
	},
	"Standard_E20s_v4": {
		InstanceType: "Standard_E20s_v4",
		VCPU:         20,
		MemoryMb:     163840,
		GPU:          0,
	},
	"Standard_E2_v3": {
		InstanceType: "Standard_E2_v3",
		VCPU:         2,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_E2_v4": {
		InstanceType: "Standard_E2_v4",
		VCPU:         2,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_E2a_v4": {
		InstanceType: "Standard_E2a_v4",
		VCPU:         2,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_E2as_v4": {
		InstanceType: "Standard_E2as_v4",
		VCPU:         2,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_E2d_v4": {
		InstanceType: "Standard_E2d_v4",
		VCPU:         2,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_E2ds_v4": {
		InstanceType: "Standard_E2ds_v4",
		VCPU:         2,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_E2s_v3": {
		InstanceType: "Standard_E2s_v3",
		VCPU:         2,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_E2s_v4": {
		InstanceType: "Standard_E2s_v4",
		VCPU:         2,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_E32-16as_v4": {
		InstanceType: "Standard_E32-16as_v4",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32-16ds_v4": {
		InstanceType: "Standard_E32-16ds_v4",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32-16s_v3": {
		InstanceType: "Standard_E32-16s_v3",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32-16s_v4": {
		InstanceType: "Standard_E32-16s_v4",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32-8as_v4": {
		InstanceType: "Standard_E32-8as_v4",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32-8ds_v4": {
		InstanceType: "Standard_E32-8ds_v4",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32-8s_v3": {
		InstanceType: "Standard_E32-8s_v3",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32-8s_v4": {
		InstanceType: "Standard_E32-8s_v4",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32_v3": {
		InstanceType: "Standard_E32_v3",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32_v4": {
		InstanceType: "Standard_E32_v4",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32a_v4": {
		InstanceType: "Standard_E32a_v4",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32as_v4": {
		InstanceType: "Standard_E32as_v4",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32d_v4": {
		InstanceType: "Standard_E32d_v4",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32ds_v4": {
		InstanceType: "Standard_E32ds_v4",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32s_v3": {
		InstanceType: "Standard_E32s_v3",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E32s_v4": {
		InstanceType: "Standard_E32s_v4",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_E4-2as_v4": {
		InstanceType: "Standard_E4-2as_v4",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_E4-2ds_v4": {
		InstanceType: "Standard_E4-2ds_v4",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_E4-2s_v3": {
		InstanceType: "Standard_E4-2s_v3",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_E4-2s_v4": {
		InstanceType: "Standard_E4-2s_v4",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_E48_v3": {
		InstanceType: "Standard_E48_v3",
		VCPU:         48,
		MemoryMb:     393216,
		GPU:          0,
	},
	"Standard_E48_v4": {
		InstanceType: "Standard_E48_v4",
		VCPU:         48,
		MemoryMb:     393216,
		GPU:          0,
	},
	"Standard_E48a_v4": {
		InstanceType: "Standard_E48a_v4",
		VCPU:         48,
		MemoryMb:     393216,
		GPU:          0,
	},
	"Standard_E48as_v4": {
		InstanceType: "Standard_E48as_v4",
		VCPU:         48,
		MemoryMb:     393216,
		GPU:          0,
	},
	"Standard_E48d_v4": {
		InstanceType: "Standard_E48d_v4",
		VCPU:         48,
		MemoryMb:     393216,
		GPU:          0,
	},
	"Standard_E48ds_v4": {
		InstanceType: "Standard_E48ds_v4",
		VCPU:         48,
		MemoryMb:     393216,
		GPU:          0,
	},
	"Standard_E48s_v3": {
		InstanceType: "Standard_E48s_v3",
		VCPU:         48,
		MemoryMb:     393216,
		GPU:          0,
	},
	"Standard_E48s_v4": {
		InstanceType: "Standard_E48s_v4",
		VCPU:         48,
		MemoryMb:     393216,
		GPU:          0,
	},
	"Standard_E4_v3": {
		InstanceType: "Standard_E4_v3",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_E4_v4": {
		InstanceType: "Standard_E4_v4",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_E4a_v4": {
		InstanceType: "Standard_E4a_v4",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_E4as_v4": {
		InstanceType: "Standard_E4as_v4",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_E4d_v4": {
		InstanceType: "Standard_E4d_v4",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_E4ds_v4": {
		InstanceType: "Standard_E4ds_v4",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_E4s_v3": {
		InstanceType: "Standard_E4s_v3",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_E4s_v4": {
		InstanceType: "Standard_E4s_v4",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_E64-16as_v4": {
		InstanceType: "Standard_E64-16as_v4",
		VCPU:         64,
		MemoryMb:     524288,
		GPU:          0,
	},
	"Standard_E64-16ds_v4": {
		InstanceType: "Standard_E64-16ds_v4",
		VCPU:         64,
		MemoryMb:     516096,
		GPU:          0,
	},
	"Standard_E64-16s_v3": {
		InstanceType: "Standard_E64-16s_v3",
		VCPU:         64,
		MemoryMb:     442368,
		GPU:          0,
	},
	"Standard_E64-16s_v4": {
		InstanceType: "Standard_E64-16s_v4",
		VCPU:         64,
		MemoryMb:     516096,
		GPU:          0,
	},
	"Standard_E64-32as_v4": {
		InstanceType: "Standard_E64-32as_v4",
		VCPU:         64,
		MemoryMb:     524288,
		GPU:          0,
	},
	"Standard_E64-32ds_v4": {
		InstanceType: "Standard_E64-32ds_v4",
		VCPU:         64,
		MemoryMb:     516096,
		GPU:          0,
	},
	"Standard_E64-32s_v3": {
		InstanceType: "Standard_E64-32s_v3",
		VCPU:         64,
		MemoryMb:     442368,
		GPU:          0,
	},
	"Standard_E64-32s_v4": {
		InstanceType: "Standard_E64-32s_v4",
		VCPU:         64,
		MemoryMb:     516096,
		GPU:          0,
	},
	"Standard_E64_v3": {
		InstanceType: "Standard_E64_v3",
		VCPU:         64,
		MemoryMb:     442368,
		GPU:          0,
	},
	"Standard_E64_v4": {
		InstanceType: "Standard_E64_v4",
		VCPU:         64,
		MemoryMb:     516096,
		GPU:          0,
	},
	"Standard_E64a_v4": {
		InstanceType: "Standard_E64a_v4",
		VCPU:         64,
		MemoryMb:     524288,
		GPU:          0,
	},
	"Standard_E64as_v4": {
		InstanceType: "Standard_E64as_v4",
		VCPU:         64,
		MemoryMb:     524288,
		GPU:          0,
	},
	"Standard_E64d_v4": {
		InstanceType: "Standard_E64d_v4",
		VCPU:         64,
		MemoryMb:     516096,
		GPU:          0,
	},
	"Standard_E64ds_v4": {
		InstanceType: "Standard_E64ds_v4",
		VCPU:         64,
		MemoryMb:     516096,
		GPU:          0,
	},
	"Standard_E64i_v3": {
		InstanceType: "Standard_E64i_v3",
		VCPU:         64,
		MemoryMb:     442368,
		GPU:          0,
	},
	"Standard_E64is_v3": {
		InstanceType: "Standard_E64is_v3",
		VCPU:         64,
		MemoryMb:     442368,
		GPU:          0,
	},
	"Standard_E64s_v3": {
		InstanceType: "Standard_E64s_v3",
		VCPU:         64,
		MemoryMb:     442368,
		GPU:          0,
	},
	"Standard_E64s_v4": {
		InstanceType: "Standard_E64s_v4",
		VCPU:         64,
		MemoryMb:     516096,
		GPU:          0,
	},
	"Standard_E8-2as_v4": {
		InstanceType: "Standard_E8-2as_v4",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8-2ds_v4": {
		InstanceType: "Standard_E8-2ds_v4",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8-2s_v3": {
		InstanceType: "Standard_E8-2s_v3",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8-2s_v4": {
		InstanceType: "Standard_E8-2s_v4",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8-4as_v4": {
		InstanceType: "Standard_E8-4as_v4",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8-4ds_v4": {
		InstanceType: "Standard_E8-4ds_v4",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8-4s_v3": {
		InstanceType: "Standard_E8-4s_v3",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8-4s_v4": {
		InstanceType: "Standard_E8-4s_v4",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E80ids_v4": {
		InstanceType: "Standard_E80ids_v4",
		VCPU:         80,
		MemoryMb:     516096,
		GPU:          0,
	},
	"Standard_E80is_v4": {
		InstanceType: "Standard_E80is_v4",
		VCPU:         80,
		MemoryMb:     516096,
		GPU:          0,
	},
	"Standard_E8_v3": {
		InstanceType: "Standard_E8_v3",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8_v4": {
		InstanceType: "Standard_E8_v4",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8a_v4": {
		InstanceType: "Standard_E8a_v4",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8as_v4": {
		InstanceType: "Standard_E8as_v4",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8d_v4": {
		InstanceType: "Standard_E8d_v4",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8ds_v4": {
		InstanceType: "Standard_E8ds_v4",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8s_v3": {
		InstanceType: "Standard_E8s_v3",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E8s_v4": {
		InstanceType: "Standard_E8s_v4",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_E96-24as_v4": {
		InstanceType: "Standard_E96-24as_v4",
		VCPU:         96,
		MemoryMb:     688128,
		GPU:          0,
	},
	"Standard_E96-48as_v4": {
		InstanceType: "Standard_E96-48as_v4",
		VCPU:         96,
		MemoryMb:     688128,
		GPU:          0,
	},
	"Standard_E96a_v4": {
		InstanceType: "Standard_E96a_v4",
		VCPU:         96,
		MemoryMb:     688128,
		GPU:          0,
	},
	"Standard_E96as_v4": {
		InstanceType: "Standard_E96as_v4",
		VCPU:         96,
		MemoryMb:     688128,
		GPU:          0,
	},
	"Standard_F1": {
		InstanceType: "Standard_F1",
		VCPU:         1,
		MemoryMb:     2048,
		GPU:          0,
	},
	"Standard_F16": {
		InstanceType: "Standard_F16",
		VCPU:         16,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_F16s": {
		InstanceType: "Standard_F16s",
		VCPU:         16,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_F16s_v2": {
		InstanceType: "Standard_F16s_v2",
		VCPU:         16,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_F1s": {
		InstanceType: "Standard_F1s",
		VCPU:         1,
		MemoryMb:     2048,
		GPU:          0,
	},
	"Standard_F2": {
		InstanceType: "Standard_F2",
		VCPU:         2,
		MemoryMb:     4096,
		GPU:          0,
	},
	"Standard_F2s": {
		InstanceType: "Standard_F2s",
		VCPU:         2,
		MemoryMb:     4096,
		GPU:          0,
	},
	"Standard_F2s_v2": {
		InstanceType: "Standard_F2s_v2",
		VCPU:         2,
		MemoryMb:     4096,
		GPU:          0,
	},
	"Standard_F32s_v2": {
		InstanceType: "Standard_F32s_v2",
		VCPU:         32,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_F4": {
		InstanceType: "Standard_F4",
		VCPU:         4,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_F48s_v2": {
		InstanceType: "Standard_F48s_v2",
		VCPU:         48,
		MemoryMb:     98304,
		GPU:          0,
	},
	"Standard_F4s": {
		InstanceType: "Standard_F4s",
		VCPU:         4,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_F4s_v2": {
		InstanceType: "Standard_F4s_v2",
		VCPU:         4,
		MemoryMb:     8192,
		GPU:          0,
	},
	"Standard_F64s_v2": {
		InstanceType: "Standard_F64s_v2",
		VCPU:         64,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_F72s_v2": {
		InstanceType: "Standard_F72s_v2",
		VCPU:         72,
		MemoryMb:     147456,
		GPU:          0,
	},
	"Standard_F8": {
		InstanceType: "Standard_F8",
		VCPU:         8,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_F8s": {
		InstanceType: "Standard_F8s",
		VCPU:         8,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_F8s_v2": {
		InstanceType: "Standard_F8s_v2",
		VCPU:         8,
		MemoryMb:     16384,
		GPU:          0,
	},
	"Standard_G1": {
		InstanceType: "Standard_G1",
		VCPU:         2,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_G2": {
		InstanceType: "Standard_G2",
		VCPU:         4,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_G3": {
		InstanceType: "Standard_G3",
		VCPU:         8,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_G4": {
		InstanceType: "Standard_G4",
		VCPU:         16,
		MemoryMb:     229376,
		GPU:          0,
	},
	"Standard_G5": {
		InstanceType: "Standard_G5",
		VCPU:         32,
		MemoryMb:     458752,
		GPU:          0,
	},
	"Standard_GS1": {
		InstanceType: "Standard_GS1",
		VCPU:         2,
		MemoryMb:     28672,
		GPU:          0,
	},
	"Standard_GS2": {
		InstanceType: "Standard_GS2",
		VCPU:         4,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_GS3": {
		InstanceType: "Standard_GS3",
		VCPU:         8,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_GS4": {
		InstanceType: "Standard_GS4",
		VCPU:         16,
		MemoryMb:     229376,
		GPU:          0,
	},
	"Standard_GS4-4": {
		InstanceType: "Standard_GS4-4",
		VCPU:         16,
		MemoryMb:     229376,
		GPU:          0,
	},
	"Standard_GS4-8": {
		InstanceType: "Standard_GS4-8",
		VCPU:         16,
		MemoryMb:     229376,
		GPU:          0,
	},
	"Standard_GS5": {
		InstanceType: "Standard_GS5",
		VCPU:         32,
		MemoryMb:     458752,
		GPU:          0,
	},
	"Standard_GS5-16": {
		InstanceType: "Standard_GS5-16",
		VCPU:         32,
		MemoryMb:     458752,
		GPU:          0,
	},
	"Standard_GS5-8": {
		InstanceType: "Standard_GS5-8",
		VCPU:         32,
		MemoryMb:     458752,
		GPU:          0,
	},
	"Standard_H16": {
		InstanceType: "Standard_H16",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_H16_Promo": {
		InstanceType: "Standard_H16_Promo",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_H16m": {
		InstanceType: "Standard_H16m",
		VCPU:         16,
		MemoryMb:     229376,
		GPU:          0,
	},
	"Standard_H16m_Promo": {
		InstanceType: "Standard_H16m_Promo",
		VCPU:         16,
		MemoryMb:     229376,
		GPU:          0,
	},
	"Standard_H16mr": {
		InstanceType: "Standard_H16mr",
		VCPU:         16,
		MemoryMb:     229376,
		GPU:          0,
	},
	"Standard_H16mr_Promo": {
		InstanceType: "Standard_H16mr_Promo",
		VCPU:         16,
		MemoryMb:     229376,
		GPU:          0,
	},
	"Standard_H16r": {
		InstanceType: "Standard_H16r",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_H16r_Promo": {
		InstanceType: "Standard_H16r_Promo",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_H8": {
		InstanceType: "Standard_H8",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_H8_Promo": {
		InstanceType: "Standard_H8_Promo",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          0,
	},
	"Standard_H8m": {
		InstanceType: "Standard_H8m",
		VCPU:         8,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_H8m_Promo": {
		InstanceType: "Standard_H8m_Promo",
		VCPU:         8,
		MemoryMb:     114688,
		GPU:          0,
	},
	"Standard_HB120rs_v2": {
		InstanceType: "Standard_HB120rs_v2",
		VCPU:         120,
		MemoryMb:     479232,
		GPU:          0,
	},
	"Standard_HB60rs": {
		InstanceType: "Standard_HB60rs",
		VCPU:         60,
		MemoryMb:     228352,
		GPU:          0,
	},
	"Standard_HC44rs": {
		InstanceType: "Standard_HC44rs",
		VCPU:         44,
		MemoryMb:     334848,
		GPU:          0,
	},
	"Standard_L16s": {
		InstanceType: "Standard_L16s",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_L16s_v2": {
		InstanceType: "Standard_L16s_v2",
		VCPU:         16,
		MemoryMb:     131072,
		GPU:          0,
	},
	"Standard_L32s": {
		InstanceType: "Standard_L32s",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_L32s_v2": {
		InstanceType: "Standard_L32s_v2",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_L48s_v2": {
		InstanceType: "Standard_L48s_v2",
		VCPU:         48,
		MemoryMb:     393216,
		GPU:          0,
	},
	"Standard_L4s": {
		InstanceType: "Standard_L4s",
		VCPU:         4,
		MemoryMb:     32768,
		GPU:          0,
	},
	"Standard_L64s_v2": {
		InstanceType: "Standard_L64s_v2",
		VCPU:         64,
		MemoryMb:     524288,
		GPU:          0,
	},
	"Standard_L80s_v2": {
		InstanceType: "Standard_L80s_v2",
		VCPU:         80,
		MemoryMb:     655360,
		GPU:          0,
	},
	"Standard_L8s": {
		InstanceType: "Standard_L8s",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_L8s_v2": {
		InstanceType: "Standard_L8s_v2",
		VCPU:         8,
		MemoryMb:     65536,
		GPU:          0,
	},
	"Standard_M128": {
		InstanceType: "Standard_M128",
		VCPU:         128,
		MemoryMb:     2048000,
		GPU:          0,
	},
	"Standard_M128-32ms": {
		InstanceType: "Standard_M128-32ms",
		VCPU:         128,
		MemoryMb:     3891200,
		GPU:          0,
	},
	"Standard_M128-64ms": {
		InstanceType: "Standard_M128-64ms",
		VCPU:         128,
		MemoryMb:     3891200,
		GPU:          0,
	},
	"Standard_M128m": {
		InstanceType: "Standard_M128m",
		VCPU:         128,
		MemoryMb:     3891200,
		GPU:          0,
	},
	"Standard_M128ms": {
		InstanceType: "Standard_M128ms",
		VCPU:         128,
		MemoryMb:     3891200,
		GPU:          0,
	},
	"Standard_M128s": {
		InstanceType: "Standard_M128s",
		VCPU:         128,
		MemoryMb:     2048000,
		GPU:          0,
	},
	"Standard_M16-4ms": {
		InstanceType: "Standard_M16-4ms",
		VCPU:         16,
		MemoryMb:     447488,
		GPU:          0,
	},
	"Standard_M16-8ms": {
		InstanceType: "Standard_M16-8ms",
		VCPU:         16,
		MemoryMb:     447488,
		GPU:          0,
	},
	"Standard_M16ms": {
		InstanceType: "Standard_M16ms",
		VCPU:         16,
		MemoryMb:     447488,
		GPU:          0,
	},
	"Standard_M208ms_v2": {
		InstanceType: "Standard_M208ms_v2",
		VCPU:         208,
		MemoryMb:     5836800,
		GPU:          0,
	},
	"Standard_M208s_v2": {
		InstanceType: "Standard_M208s_v2",
		VCPU:         208,
		MemoryMb:     2918400,
		GPU:          0,
	},
	"Standard_M32-16ms": {
		InstanceType: "Standard_M32-16ms",
		VCPU:         32,
		MemoryMb:     896000,
		GPU:          0,
	},
	"Standard_M32-8ms": {
		InstanceType: "Standard_M32-8ms",
		VCPU:         32,
		MemoryMb:     896000,
		GPU:          0,
	},
	"Standard_M32ls": {
		InstanceType: "Standard_M32ls",
		VCPU:         32,
		MemoryMb:     262144,
		GPU:          0,
	},
	"Standard_M32ms": {
		InstanceType: "Standard_M32ms",
		VCPU:         32,
		MemoryMb:     896000,
		GPU:          0,
	},
	"Standard_M32ts": {
		InstanceType: "Standard_M32ts",
		VCPU:         32,
		MemoryMb:     196608,
		GPU:          0,
	},
	"Standard_M416-208ms_v2": {
		InstanceType: "Standard_M416-208ms_v2",
		VCPU:         416,
		MemoryMb:     11673600,
		GPU:          0,
	},
	"Standard_M416-208s_v2": {
		InstanceType: "Standard_M416-208s_v2",
		VCPU:         416,
		MemoryMb:     5836800,
		GPU:          0,
	},
	"Standard_M416ms_v2": {
		InstanceType: "Standard_M416ms_v2",
		VCPU:         416,
		MemoryMb:     11673600,
		GPU:          0,
	},
	"Standard_M416s_v2": {
		InstanceType: "Standard_M416s_v2",
		VCPU:         416,
		MemoryMb:     5836800,
		GPU:          0,
	},
	"Standard_M64": {
		InstanceType: "Standard_M64",
		VCPU:         64,
		MemoryMb:     1024000,
		GPU:          0,
	},
	"Standard_M64-16ms": {
		InstanceType: "Standard_M64-16ms",
		VCPU:         64,
		MemoryMb:     1792000,
		GPU:          0,
	},
	"Standard_M64-32ms": {
		InstanceType: "Standard_M64-32ms",
		VCPU:         64,
		MemoryMb:     1792000,
		GPU:          0,
	},
	"Standard_M64ls": {
		InstanceType: "Standard_M64ls",
		VCPU:         64,
		MemoryMb:     524288,
		GPU:          0,
	},
	"Standard_M64m": {
		InstanceType: "Standard_M64m",
		VCPU:         64,
		MemoryMb:     1792000,
		GPU:          0,
	},
	"Standard_M64ms": {
		InstanceType: "Standard_M64ms",
		VCPU:         64,
		MemoryMb:     1792000,
		GPU:          0,
	},
	"Standard_M64s": {
		InstanceType: "Standard_M64s",
		VCPU:         64,
		MemoryMb:     1024000,
		GPU:          0,
	},
	"Standard_M8-2ms": {
		InstanceType: "Standard_M8-2ms",
		VCPU:         8,
		MemoryMb:     223232,
		GPU:          0,
	},
	"Standard_M8-4ms": {
		InstanceType: "Standard_M8-4ms",
		VCPU:         8,
		MemoryMb:     223232,
		GPU:          0,
	},
	"Standard_M8ms": {
		InstanceType: "Standard_M8ms",
		VCPU:         8,
		MemoryMb:     223232,
		GPU:          0,
	},
	"Standard_NC12": {
		InstanceType: "Standard_NC12",
		VCPU:         12,
		MemoryMb:     114688,
		GPU:          2,
	},
	"Standard_NC12_Promo": {
		InstanceType: "Standard_NC12_Promo",
		VCPU:         12,
		MemoryMb:     114688,
		GPU:          2,
	},
	"Standard_NC12s_v2": {
		InstanceType: "Standard_NC12s_v2",
		VCPU:         12,
		MemoryMb:     229376,
		GPU:          2,
	},
	"Standard_NC12s_v3": {
		InstanceType: "Standard_NC12s_v3",
		VCPU:         12,
		MemoryMb:     229376,
		GPU:          2,
	},
	"Standard_NC16as_T4_v3": {
		InstanceType: "Standard_NC16as_T4_v3",
		VCPU:         16,
		MemoryMb:     114688,
		GPU:          1,
	},
	"Standard_NC24": {
		InstanceType: "Standard_NC24",
		VCPU:         24,
		MemoryMb:     229376,
		GPU:          4,
	},
	"Standard_NC24_Promo": {
		InstanceType: "Standard_NC24_Promo",
		VCPU:         24,
		MemoryMb:     229376,
		GPU:          4,
	},
	"Standard_NC24r": {
		InstanceType: "Standard_NC24r",
		VCPU:         24,
		MemoryMb:     229376,
		GPU:          4,
	},
	"Standard_NC24r_Promo": {
		InstanceType: "Standard_NC24r_Promo",
		VCPU:         24,
		MemoryMb:     229376,
		GPU:          4,
	},
	"Standard_NC24rs_v2": {
		InstanceType: "Standard_NC24rs_v2",
		VCPU:         24,
		MemoryMb:     458752,
		GPU:          4,
	},
	"Standard_NC24rs_v3": {
		InstanceType: "Standard_NC24rs_v3",
		VCPU:         24,
		MemoryMb:     458752,
		GPU:          4,
	},
	"Standard_NC24s_v2": {
		InstanceType: "Standard_NC24s_v2",
		VCPU:         24,
		MemoryMb:     458752,
		GPU:          4,
	},
	"Standard_NC24s_v3": {
		InstanceType: "Standard_NC24s_v3",
		VCPU:         24,
		MemoryMb:     458752,
		GPU:          4,
	},
	"Standard_NC4as_T4_v3": {
		InstanceType: "Standard_NC4as_T4_v3",
		VCPU:         4,
		MemoryMb:     28672,
		GPU:          1,
	},
	"Standard_NC6": {
		InstanceType: "Standard_NC6",
		VCPU:         6,
		MemoryMb:     57344,
		GPU:          1,
	},
	"Standard_NC64as_T4_v3": {
		InstanceType: "Standard_NC64as_T4_v3",
		VCPU:         64,
		MemoryMb:     458752,
		GPU:          4,
	},
	"Standard_NC6_Promo": {
		InstanceType: "Standard_NC6_Promo",
		VCPU:         6,
		MemoryMb:     57344,
		GPU:          1,
	},
	"Standard_NC6s_v2": {
		InstanceType: "Standard_NC6s_v2",
		VCPU:         6,
		MemoryMb:     114688,
		GPU:          1,
	},
	"Standard_NC6s_v3": {
		InstanceType: "Standard_NC6s_v3",
		VCPU:         6,
		MemoryMb:     114688,
		GPU:          1,
	},
	"Standard_ND12s": {
		InstanceType: "Standard_ND12s",
		VCPU:         12,
		MemoryMb:     229376,
		GPU:          2,
	},
	"Standard_ND24rs": {
		InstanceType: "Standard_ND24rs",
		VCPU:         24,
		MemoryMb:     458752,
		GPU:          4,
	},
	"Standard_ND24s": {
		InstanceType: "Standard_ND24s",
		VCPU:         24,
		MemoryMb:     458752,
		GPU:          4,
	},
	"Standard_ND6s": {
		InstanceType: "Standard_ND6s",
		VCPU:         6,
		MemoryMb:     114688,
		GPU:          1,
	},
	"Standard_NC8as_T4_v3": {
		InstanceType: "Standard_NC8as_T4_v3",
		VCPU:         8,
		MemoryMb:     57344,
		GPU:          1,
	},
	"Standard_ND40rs_v2": {
		InstanceType: "Standard_ND40rs_v2",
		VCPU:         40,
		MemoryMb:     688128,
		GPU:          8,
	},
	"Standard_NV12": {
		InstanceType: "Standard_NV12",
		VCPU:         12,
		MemoryMb:     114688,
		GPU:          2,
	},
	"Standard_NV12_Promo": {
		InstanceType: "Standard_NV12_Promo",
		VCPU:         12,
		MemoryMb:     114688,
		GPU:          2,
	},
	"Standard_NV12s_v2": {
		InstanceType: "Standard_NV12s_v2",
		VCPU:         12,
		MemoryMb:     229376,
		GPU:          2,
	},
	"Standard_NV12s_v3": {
		InstanceType: "Standard_NV12s_v3",
		VCPU:         12,
		MemoryMb:     114688,
		GPU:          1,
	},
	"Standard_NV16as_v4": {
		InstanceType: "Standard_NV16as_v4",
		VCPU:         16,
		MemoryMb:     57344,
		GPU:          1,
	},
	"Standard_NV24": {
		InstanceType: "Standard_NV24",
		VCPU:         24,
		MemoryMb:     229376,
		GPU:          4,
	},
	"Standard_NV24_Promo": {
		InstanceType: "Standard_NV24_Promo",
		VCPU:         24,
		MemoryMb:     229376,
		GPU:          4,
	},
	"Standard_NV24s_v2": {
		InstanceType: "Standard_NV24s_v2",
		VCPU:         24,
		MemoryMb:     458752,
		GPU:          4,
	},
	"Standard_NV24s_v3": {
		InstanceType: "Standard_NV24s_v3",
		VCPU:         24,
		MemoryMb:     229376,
		GPU:          2,
	},
	"Standard_NV32as_v4": {
		InstanceType: "Standard_NV32as_v4",
		VCPU:         32,
		MemoryMb:     114688,
		GPU:          1,
	},
	"Standard_NV48s_v3": {
		InstanceType: "Standard_NV48s_v3",
		VCPU:         48,
		MemoryMb:     458752,
		GPU:          4,
	},
	"Standard_NV4as_v4": {
		InstanceType: "Standard_NV4as_v4",
		VCPU:         4,
		MemoryMb:     14336,
		GPU:          1,
	},
	"Standard_NV6": {
		InstanceType: "Standard_NV6",
		VCPU:         6,
		MemoryMb:     57344,
		GPU:          1,
	},
	"Standard_NV6_Promo": {
		InstanceType: "Standard_NV6_Promo",
		VCPU:         6,
		MemoryMb:     57344,
		GPU:          1,
	},
	"Standard_NV6s_v2": {
		InstanceType: "Standard_NV6s_v2",
		VCPU:         6,
		MemoryMb:     114688,
		GPU:          1,
	},
	"Standard_NV8as_v4": {
		InstanceType: "Standard_NV8as_v4",
		VCPU:         8,
		MemoryMb:     28672,
		GPU:          1,
	},
}
