/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	"encoding/json"
)

// ImageProperties struct for ImageProperties
type ImageProperties struct {
	// A name of that resource
	Name *string `json:"name,omitempty"`
	// Human readable description
	Description *string `json:"description,omitempty"`
	// Location of that image/snapshot. 
	Location *string `json:"location,omitempty"`
	// The size of the image in GB
	Size *float32 `json:"size,omitempty"`
	// Is capable of CPU hot plug (no reboot required)
	CpuHotPlug *bool `json:"cpuHotPlug,omitempty"`
	// Is capable of CPU hot unplug (no reboot required)
	CpuHotUnplug *bool `json:"cpuHotUnplug,omitempty"`
	// Is capable of memory hot plug (no reboot required)
	RamHotPlug *bool `json:"ramHotPlug,omitempty"`
	// Is capable of memory hot unplug (no reboot required)
	RamHotUnplug *bool `json:"ramHotUnplug,omitempty"`
	// Is capable of nic hot plug (no reboot required)
	NicHotPlug *bool `json:"nicHotPlug,omitempty"`
	// Is capable of nic hot unplug (no reboot required)
	NicHotUnplug *bool `json:"nicHotUnplug,omitempty"`
	// Is capable of Virt-IO drive hot plug (no reboot required)
	DiscVirtioHotPlug *bool `json:"discVirtioHotPlug,omitempty"`
	// Is capable of Virt-IO drive hot unplug (no reboot required). This works only for non-Windows virtual Machines.
	DiscVirtioHotUnplug *bool `json:"discVirtioHotUnplug,omitempty"`
	// Is capable of SCSI drive hot plug (no reboot required)
	DiscScsiHotPlug *bool `json:"discScsiHotPlug,omitempty"`
	// Is capable of SCSI drive hot unplug (no reboot required). This works only for non-Windows virtual Machines.
	DiscScsiHotUnplug *bool `json:"discScsiHotUnplug,omitempty"`
	// OS type of this Image
	LicenceType *string `json:"licenceType"`
	// This indicates the type of image
	ImageType *string `json:"imageType,omitempty"`
	// Indicates if the image is part of the public repository or not
	Public *bool `json:"public,omitempty"`
}



// GetName returns the Name field value
// If the value is explicit nil, the zero value for string will be returned
func (o *ImageProperties) GetName() *string {
	if o == nil {
		return nil
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Name, true
}

// SetName sets field value
func (o *ImageProperties) SetName(v string) {
	o.Name = &v
}

// HasName returns a boolean if a field has been set.
func (o *ImageProperties) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}



// GetDescription returns the Description field value
// If the value is explicit nil, the zero value for string will be returned
func (o *ImageProperties) GetDescription() *string {
	if o == nil {
		return nil
	}

	return o.Description
}

// GetDescriptionOk returns a tuple with the Description field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetDescriptionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Description, true
}

// SetDescription sets field value
func (o *ImageProperties) SetDescription(v string) {
	o.Description = &v
}

// HasDescription returns a boolean if a field has been set.
func (o *ImageProperties) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}



// GetLocation returns the Location field value
// If the value is explicit nil, the zero value for string will be returned
func (o *ImageProperties) GetLocation() *string {
	if o == nil {
		return nil
	}

	return o.Location
}

// GetLocationOk returns a tuple with the Location field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetLocationOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.Location, true
}

// SetLocation sets field value
func (o *ImageProperties) SetLocation(v string) {
	o.Location = &v
}

// HasLocation returns a boolean if a field has been set.
func (o *ImageProperties) HasLocation() bool {
	if o != nil && o.Location != nil {
		return true
	}

	return false
}



// GetSize returns the Size field value
// If the value is explicit nil, the zero value for float32 will be returned
func (o *ImageProperties) GetSize() *float32 {
	if o == nil {
		return nil
	}

	return o.Size
}

// GetSizeOk returns a tuple with the Size field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetSizeOk() (*float32, bool) {
	if o == nil {
		return nil, false
	}
	return o.Size, true
}

// SetSize sets field value
func (o *ImageProperties) SetSize(v float32) {
	o.Size = &v
}

// HasSize returns a boolean if a field has been set.
func (o *ImageProperties) HasSize() bool {
	if o != nil && o.Size != nil {
		return true
	}

	return false
}



// GetCpuHotPlug returns the CpuHotPlug field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *ImageProperties) GetCpuHotPlug() *bool {
	if o == nil {
		return nil
	}

	return o.CpuHotPlug
}

// GetCpuHotPlugOk returns a tuple with the CpuHotPlug field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetCpuHotPlugOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.CpuHotPlug, true
}

// SetCpuHotPlug sets field value
func (o *ImageProperties) SetCpuHotPlug(v bool) {
	o.CpuHotPlug = &v
}

// HasCpuHotPlug returns a boolean if a field has been set.
func (o *ImageProperties) HasCpuHotPlug() bool {
	if o != nil && o.CpuHotPlug != nil {
		return true
	}

	return false
}



// GetCpuHotUnplug returns the CpuHotUnplug field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *ImageProperties) GetCpuHotUnplug() *bool {
	if o == nil {
		return nil
	}

	return o.CpuHotUnplug
}

// GetCpuHotUnplugOk returns a tuple with the CpuHotUnplug field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetCpuHotUnplugOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.CpuHotUnplug, true
}

// SetCpuHotUnplug sets field value
func (o *ImageProperties) SetCpuHotUnplug(v bool) {
	o.CpuHotUnplug = &v
}

// HasCpuHotUnplug returns a boolean if a field has been set.
func (o *ImageProperties) HasCpuHotUnplug() bool {
	if o != nil && o.CpuHotUnplug != nil {
		return true
	}

	return false
}



// GetRamHotPlug returns the RamHotPlug field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *ImageProperties) GetRamHotPlug() *bool {
	if o == nil {
		return nil
	}

	return o.RamHotPlug
}

// GetRamHotPlugOk returns a tuple with the RamHotPlug field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetRamHotPlugOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.RamHotPlug, true
}

// SetRamHotPlug sets field value
func (o *ImageProperties) SetRamHotPlug(v bool) {
	o.RamHotPlug = &v
}

// HasRamHotPlug returns a boolean if a field has been set.
func (o *ImageProperties) HasRamHotPlug() bool {
	if o != nil && o.RamHotPlug != nil {
		return true
	}

	return false
}



// GetRamHotUnplug returns the RamHotUnplug field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *ImageProperties) GetRamHotUnplug() *bool {
	if o == nil {
		return nil
	}

	return o.RamHotUnplug
}

// GetRamHotUnplugOk returns a tuple with the RamHotUnplug field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetRamHotUnplugOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.RamHotUnplug, true
}

// SetRamHotUnplug sets field value
func (o *ImageProperties) SetRamHotUnplug(v bool) {
	o.RamHotUnplug = &v
}

// HasRamHotUnplug returns a boolean if a field has been set.
func (o *ImageProperties) HasRamHotUnplug() bool {
	if o != nil && o.RamHotUnplug != nil {
		return true
	}

	return false
}



// GetNicHotPlug returns the NicHotPlug field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *ImageProperties) GetNicHotPlug() *bool {
	if o == nil {
		return nil
	}

	return o.NicHotPlug
}

// GetNicHotPlugOk returns a tuple with the NicHotPlug field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetNicHotPlugOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.NicHotPlug, true
}

// SetNicHotPlug sets field value
func (o *ImageProperties) SetNicHotPlug(v bool) {
	o.NicHotPlug = &v
}

// HasNicHotPlug returns a boolean if a field has been set.
func (o *ImageProperties) HasNicHotPlug() bool {
	if o != nil && o.NicHotPlug != nil {
		return true
	}

	return false
}



// GetNicHotUnplug returns the NicHotUnplug field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *ImageProperties) GetNicHotUnplug() *bool {
	if o == nil {
		return nil
	}

	return o.NicHotUnplug
}

// GetNicHotUnplugOk returns a tuple with the NicHotUnplug field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetNicHotUnplugOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.NicHotUnplug, true
}

// SetNicHotUnplug sets field value
func (o *ImageProperties) SetNicHotUnplug(v bool) {
	o.NicHotUnplug = &v
}

// HasNicHotUnplug returns a boolean if a field has been set.
func (o *ImageProperties) HasNicHotUnplug() bool {
	if o != nil && o.NicHotUnplug != nil {
		return true
	}

	return false
}



// GetDiscVirtioHotPlug returns the DiscVirtioHotPlug field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *ImageProperties) GetDiscVirtioHotPlug() *bool {
	if o == nil {
		return nil
	}

	return o.DiscVirtioHotPlug
}

// GetDiscVirtioHotPlugOk returns a tuple with the DiscVirtioHotPlug field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetDiscVirtioHotPlugOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.DiscVirtioHotPlug, true
}

// SetDiscVirtioHotPlug sets field value
func (o *ImageProperties) SetDiscVirtioHotPlug(v bool) {
	o.DiscVirtioHotPlug = &v
}

// HasDiscVirtioHotPlug returns a boolean if a field has been set.
func (o *ImageProperties) HasDiscVirtioHotPlug() bool {
	if o != nil && o.DiscVirtioHotPlug != nil {
		return true
	}

	return false
}



// GetDiscVirtioHotUnplug returns the DiscVirtioHotUnplug field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *ImageProperties) GetDiscVirtioHotUnplug() *bool {
	if o == nil {
		return nil
	}

	return o.DiscVirtioHotUnplug
}

// GetDiscVirtioHotUnplugOk returns a tuple with the DiscVirtioHotUnplug field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetDiscVirtioHotUnplugOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.DiscVirtioHotUnplug, true
}

// SetDiscVirtioHotUnplug sets field value
func (o *ImageProperties) SetDiscVirtioHotUnplug(v bool) {
	o.DiscVirtioHotUnplug = &v
}

// HasDiscVirtioHotUnplug returns a boolean if a field has been set.
func (o *ImageProperties) HasDiscVirtioHotUnplug() bool {
	if o != nil && o.DiscVirtioHotUnplug != nil {
		return true
	}

	return false
}



// GetDiscScsiHotPlug returns the DiscScsiHotPlug field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *ImageProperties) GetDiscScsiHotPlug() *bool {
	if o == nil {
		return nil
	}

	return o.DiscScsiHotPlug
}

// GetDiscScsiHotPlugOk returns a tuple with the DiscScsiHotPlug field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetDiscScsiHotPlugOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.DiscScsiHotPlug, true
}

// SetDiscScsiHotPlug sets field value
func (o *ImageProperties) SetDiscScsiHotPlug(v bool) {
	o.DiscScsiHotPlug = &v
}

// HasDiscScsiHotPlug returns a boolean if a field has been set.
func (o *ImageProperties) HasDiscScsiHotPlug() bool {
	if o != nil && o.DiscScsiHotPlug != nil {
		return true
	}

	return false
}



// GetDiscScsiHotUnplug returns the DiscScsiHotUnplug field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *ImageProperties) GetDiscScsiHotUnplug() *bool {
	if o == nil {
		return nil
	}

	return o.DiscScsiHotUnplug
}

// GetDiscScsiHotUnplugOk returns a tuple with the DiscScsiHotUnplug field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetDiscScsiHotUnplugOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.DiscScsiHotUnplug, true
}

// SetDiscScsiHotUnplug sets field value
func (o *ImageProperties) SetDiscScsiHotUnplug(v bool) {
	o.DiscScsiHotUnplug = &v
}

// HasDiscScsiHotUnplug returns a boolean if a field has been set.
func (o *ImageProperties) HasDiscScsiHotUnplug() bool {
	if o != nil && o.DiscScsiHotUnplug != nil {
		return true
	}

	return false
}



// GetLicenceType returns the LicenceType field value
// If the value is explicit nil, the zero value for string will be returned
func (o *ImageProperties) GetLicenceType() *string {
	if o == nil {
		return nil
	}

	return o.LicenceType
}

// GetLicenceTypeOk returns a tuple with the LicenceType field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetLicenceTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.LicenceType, true
}

// SetLicenceType sets field value
func (o *ImageProperties) SetLicenceType(v string) {
	o.LicenceType = &v
}

// HasLicenceType returns a boolean if a field has been set.
func (o *ImageProperties) HasLicenceType() bool {
	if o != nil && o.LicenceType != nil {
		return true
	}

	return false
}



// GetImageType returns the ImageType field value
// If the value is explicit nil, the zero value for string will be returned
func (o *ImageProperties) GetImageType() *string {
	if o == nil {
		return nil
	}

	return o.ImageType
}

// GetImageTypeOk returns a tuple with the ImageType field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetImageTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.ImageType, true
}

// SetImageType sets field value
func (o *ImageProperties) SetImageType(v string) {
	o.ImageType = &v
}

// HasImageType returns a boolean if a field has been set.
func (o *ImageProperties) HasImageType() bool {
	if o != nil && o.ImageType != nil {
		return true
	}

	return false
}



// GetPublic returns the Public field value
// If the value is explicit nil, the zero value for bool will be returned
func (o *ImageProperties) GetPublic() *bool {
	if o == nil {
		return nil
	}

	return o.Public
}

// GetPublicOk returns a tuple with the Public field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ImageProperties) GetPublicOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.Public, true
}

// SetPublic sets field value
func (o *ImageProperties) SetPublic(v bool) {
	o.Public = &v
}

// HasPublic returns a boolean if a field has been set.
func (o *ImageProperties) HasPublic() bool {
	if o != nil && o.Public != nil {
		return true
	}

	return false
}


func (o ImageProperties) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}

	if o.Name != nil {
		toSerialize["name"] = o.Name
	}
	

	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	

	if o.Location != nil {
		toSerialize["location"] = o.Location
	}
	

	if o.Size != nil {
		toSerialize["size"] = o.Size
	}
	

	if o.CpuHotPlug != nil {
		toSerialize["cpuHotPlug"] = o.CpuHotPlug
	}
	

	if o.CpuHotUnplug != nil {
		toSerialize["cpuHotUnplug"] = o.CpuHotUnplug
	}
	

	if o.RamHotPlug != nil {
		toSerialize["ramHotPlug"] = o.RamHotPlug
	}
	

	if o.RamHotUnplug != nil {
		toSerialize["ramHotUnplug"] = o.RamHotUnplug
	}
	

	if o.NicHotPlug != nil {
		toSerialize["nicHotPlug"] = o.NicHotPlug
	}
	

	if o.NicHotUnplug != nil {
		toSerialize["nicHotUnplug"] = o.NicHotUnplug
	}
	

	if o.DiscVirtioHotPlug != nil {
		toSerialize["discVirtioHotPlug"] = o.DiscVirtioHotPlug
	}
	

	if o.DiscVirtioHotUnplug != nil {
		toSerialize["discVirtioHotUnplug"] = o.DiscVirtioHotUnplug
	}
	

	if o.DiscScsiHotPlug != nil {
		toSerialize["discScsiHotPlug"] = o.DiscScsiHotPlug
	}
	

	if o.DiscScsiHotUnplug != nil {
		toSerialize["discScsiHotUnplug"] = o.DiscScsiHotUnplug
	}
	

	if o.LicenceType != nil {
		toSerialize["licenceType"] = o.LicenceType
	}
	

	if o.ImageType != nil {
		toSerialize["imageType"] = o.ImageType
	}
	

	if o.Public != nil {
		toSerialize["public"] = o.Public
	}
	
	return json.Marshal(toSerialize)
}

type NullableImageProperties struct {
	value *ImageProperties
	isSet bool
}

func (v NullableImageProperties) Get() *ImageProperties {
	return v.value
}

func (v *NullableImageProperties) Set(val *ImageProperties) {
	v.value = val
	v.isSet = true
}

func (v NullableImageProperties) IsSet() bool {
	return v.isSet
}

func (v *NullableImageProperties) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableImageProperties(val *ImageProperties) *NullableImageProperties {
	return &NullableImageProperties{value: val, isSet: true}
}

func (v NullableImageProperties) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableImageProperties) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


