/*
 * CLOUD API
 *
 * An enterprise-grade Infrastructure is provided as a Service (IaaS) solution that can be managed through a browser-based \"Data Center Designer\" (DCD) tool or via an easy to use API.   The API allows you to perform a variety of management tasks such as spinning up additional servers, adding volumes, adjusting networking, and so forth. It is designed to allow users to leverage the same power and flexibility found within the DCD visual tool. Both tools are consistent with their concepts and lend well to making the experience smooth and intuitive.
 *
 * API version: 5.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionossdk

import (
	_context "context"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

// NicApiService NicApi service
type NicApiService service

type ApiDatacentersServersNicsDeleteRequest struct {
	ctx _context.Context
	ApiService *NicApiService
	datacenterId string
	serverId string
	nicId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsDeleteRequest) Pretty(pretty bool) ApiDatacentersServersNicsDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsDeleteRequest) Depth(depth int32) ApiDatacentersServersNicsDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsDeleteRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsDeleteExecute(r)
}

/*
 * DatacentersServersNicsDelete Delete a Nic
 * Deletes the specified NIC.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param serverId The unique ID of the Server
 * @param nicId The unique ID of the NIC
 * @return ApiDatacentersServersNicsDeleteRequest
 */
func (a *NicApiService) DatacentersServersNicsDelete(ctx _context.Context, datacenterId string, serverId string, nicId string) ApiDatacentersServersNicsDeleteRequest {
	return ApiDatacentersServersNicsDeleteRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
		nicId: nicId,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *NicApiService) DatacentersServersNicsDeleteExecute(r ApiDatacentersServersNicsDeleteRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NicApiService.DatacentersServersNicsDelete")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersNicsDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsFindByIdRequest struct {
	ctx _context.Context
	ApiService *NicApiService
	datacenterId string
	serverId string
	nicId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsFindByIdRequest) Pretty(pretty bool) ApiDatacentersServersNicsFindByIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsFindByIdRequest) Depth(depth int32) ApiDatacentersServersNicsFindByIdRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsFindByIdRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsFindByIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsFindByIdRequest) Execute() (Nic, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsFindByIdExecute(r)
}

/*
 * DatacentersServersNicsFindById Retrieve a Nic
 * Retrieves the attributes of a given NIC
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param serverId The unique ID of the Server
 * @param nicId The unique ID of the NIC
 * @return ApiDatacentersServersNicsFindByIdRequest
 */
func (a *NicApiService) DatacentersServersNicsFindById(ctx _context.Context, datacenterId string, serverId string, nicId string) ApiDatacentersServersNicsFindByIdRequest {
	return ApiDatacentersServersNicsFindByIdRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
		nicId: nicId,
	}
}

/*
 * Execute executes the request
 * @return Nic
 */
func (a *NicApiService) DatacentersServersNicsFindByIdExecute(r ApiDatacentersServersNicsFindByIdRequest) (Nic, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Nic
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NicApiService.DatacentersServersNicsFindById")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersNicsFindById",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsFirewallrulesDeleteRequest struct {
	ctx _context.Context
	ApiService *NicApiService
	datacenterId string
	serverId string
	nicId string
	firewallruleId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsFirewallrulesDeleteRequest) Pretty(pretty bool) ApiDatacentersServersNicsFirewallrulesDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesDeleteRequest) Depth(depth int32) ApiDatacentersServersNicsFirewallrulesDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsFirewallrulesDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsFirewallrulesDeleteRequest) Execute() (map[string]interface{}, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsFirewallrulesDeleteExecute(r)
}

/*
 * DatacentersServersNicsFirewallrulesDelete Delete a Firewall Rule
 * Removes the specific Firewall Rule
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param serverId The unique ID of the Server
 * @param nicId The unique ID of the NIC
 * @param firewallruleId The unique ID of the Firewall Rule
 * @return ApiDatacentersServersNicsFirewallrulesDeleteRequest
 */
func (a *NicApiService) DatacentersServersNicsFirewallrulesDelete(ctx _context.Context, datacenterId string, serverId string, nicId string, firewallruleId string) ApiDatacentersServersNicsFirewallrulesDeleteRequest {
	return ApiDatacentersServersNicsFirewallrulesDeleteRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
		nicId: nicId,
		firewallruleId: firewallruleId,
	}
}

/*
 * Execute executes the request
 * @return map[string]interface{}
 */
func (a *NicApiService) DatacentersServersNicsFirewallrulesDeleteExecute(r ApiDatacentersServersNicsFirewallrulesDeleteRequest) (map[string]interface{}, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  map[string]interface{}
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NicApiService.DatacentersServersNicsFirewallrulesDelete")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}/firewallrules/{firewallruleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"firewallruleId"+"}", _neturl.PathEscape(parameterToString(r.firewallruleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersNicsFirewallrulesDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsFirewallrulesFindByIdRequest struct {
	ctx _context.Context
	ApiService *NicApiService
	datacenterId string
	serverId string
	nicId string
	firewallruleId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsFirewallrulesFindByIdRequest) Pretty(pretty bool) ApiDatacentersServersNicsFirewallrulesFindByIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesFindByIdRequest) Depth(depth int32) ApiDatacentersServersNicsFirewallrulesFindByIdRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesFindByIdRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsFirewallrulesFindByIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsFirewallrulesFindByIdRequest) Execute() (FirewallRule, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsFirewallrulesFindByIdExecute(r)
}

/*
 * DatacentersServersNicsFirewallrulesFindById Retrieve a Firewall Rule
 * Retrieves the attributes of a given Firewall Rule.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param serverId The unique ID of the Server
 * @param nicId The unique ID of the NIC
 * @param firewallruleId The unique ID of the Firewall Rule
 * @return ApiDatacentersServersNicsFirewallrulesFindByIdRequest
 */
func (a *NicApiService) DatacentersServersNicsFirewallrulesFindById(ctx _context.Context, datacenterId string, serverId string, nicId string, firewallruleId string) ApiDatacentersServersNicsFirewallrulesFindByIdRequest {
	return ApiDatacentersServersNicsFirewallrulesFindByIdRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
		nicId: nicId,
		firewallruleId: firewallruleId,
	}
}

/*
 * Execute executes the request
 * @return FirewallRule
 */
func (a *NicApiService) DatacentersServersNicsFirewallrulesFindByIdExecute(r ApiDatacentersServersNicsFirewallrulesFindByIdRequest) (FirewallRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FirewallRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NicApiService.DatacentersServersNicsFirewallrulesFindById")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}/firewallrules/{firewallruleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"firewallruleId"+"}", _neturl.PathEscape(parameterToString(r.firewallruleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersNicsFirewallrulesFindById",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsFirewallrulesGetRequest struct {
	ctx _context.Context
	ApiService *NicApiService
	datacenterId string
	serverId string
	nicId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsFirewallrulesGetRequest) Pretty(pretty bool) ApiDatacentersServersNicsFirewallrulesGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesGetRequest) Depth(depth int32) ApiDatacentersServersNicsFirewallrulesGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsFirewallrulesGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsFirewallrulesGetRequest) Execute() (FirewallRules, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsFirewallrulesGetExecute(r)
}

/*
 * DatacentersServersNicsFirewallrulesGet List Firewall Rules 
 * Retrieves a list of firewall rules associated with a particular NIC
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param serverId The unique ID of the Server
 * @param nicId The unique ID of the NIC
 * @return ApiDatacentersServersNicsFirewallrulesGetRequest
 */
func (a *NicApiService) DatacentersServersNicsFirewallrulesGet(ctx _context.Context, datacenterId string, serverId string, nicId string) ApiDatacentersServersNicsFirewallrulesGetRequest {
	return ApiDatacentersServersNicsFirewallrulesGetRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
		nicId: nicId,
	}
}

/*
 * Execute executes the request
 * @return FirewallRules
 */
func (a *NicApiService) DatacentersServersNicsFirewallrulesGetExecute(r ApiDatacentersServersNicsFirewallrulesGetRequest) (FirewallRules, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FirewallRules
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NicApiService.DatacentersServersNicsFirewallrulesGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}/firewallrules"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersNicsFirewallrulesGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsFirewallrulesPatchRequest struct {
	ctx _context.Context
	ApiService *NicApiService
	datacenterId string
	serverId string
	nicId string
	firewallruleId string
	firewallrule *FirewallruleProperties
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsFirewallrulesPatchRequest) Firewallrule(firewallrule FirewallruleProperties) ApiDatacentersServersNicsFirewallrulesPatchRequest {
	r.firewallrule = &firewallrule
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPatchRequest) Pretty(pretty bool) ApiDatacentersServersNicsFirewallrulesPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPatchRequest) Depth(depth int32) ApiDatacentersServersNicsFirewallrulesPatchRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPatchRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsFirewallrulesPatchRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsFirewallrulesPatchRequest) Execute() (FirewallRule, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsFirewallrulesPatchExecute(r)
}

/*
 * DatacentersServersNicsFirewallrulesPatch Partially modify a Firewall Rule
 * You can use update attributes of a resource
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param serverId The unique ID of the Server
 * @param nicId The unique ID of the NIC
 * @param firewallruleId The unique ID of the Firewall Rule
 * @return ApiDatacentersServersNicsFirewallrulesPatchRequest
 */
func (a *NicApiService) DatacentersServersNicsFirewallrulesPatch(ctx _context.Context, datacenterId string, serverId string, nicId string, firewallruleId string) ApiDatacentersServersNicsFirewallrulesPatchRequest {
	return ApiDatacentersServersNicsFirewallrulesPatchRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
		nicId: nicId,
		firewallruleId: firewallruleId,
	}
}

/*
 * Execute executes the request
 * @return FirewallRule
 */
func (a *NicApiService) DatacentersServersNicsFirewallrulesPatchExecute(r ApiDatacentersServersNicsFirewallrulesPatchRequest) (FirewallRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FirewallRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NicApiService.DatacentersServersNicsFirewallrulesPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}/firewallrules/{firewallruleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"firewallruleId"+"}", _neturl.PathEscape(parameterToString(r.firewallruleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.firewallrule == nil {
		return localVarReturnValue, nil, reportError("firewallrule is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.firewallrule
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersNicsFirewallrulesPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsFirewallrulesPostRequest struct {
	ctx _context.Context
	ApiService *NicApiService
	datacenterId string
	serverId string
	nicId string
	firewallrule *FirewallRule
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsFirewallrulesPostRequest) Firewallrule(firewallrule FirewallRule) ApiDatacentersServersNicsFirewallrulesPostRequest {
	r.firewallrule = &firewallrule
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPostRequest) Pretty(pretty bool) ApiDatacentersServersNicsFirewallrulesPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPostRequest) Depth(depth int32) ApiDatacentersServersNicsFirewallrulesPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsFirewallrulesPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsFirewallrulesPostRequest) Execute() (FirewallRule, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsFirewallrulesPostExecute(r)
}

/*
 * DatacentersServersNicsFirewallrulesPost Create a Firewall Rule
 * This will add a Firewall Rule to the NIC
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param serverId The unique ID of the server
 * @param nicId The unique ID of the NIC
 * @return ApiDatacentersServersNicsFirewallrulesPostRequest
 */
func (a *NicApiService) DatacentersServersNicsFirewallrulesPost(ctx _context.Context, datacenterId string, serverId string, nicId string) ApiDatacentersServersNicsFirewallrulesPostRequest {
	return ApiDatacentersServersNicsFirewallrulesPostRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
		nicId: nicId,
	}
}

/*
 * Execute executes the request
 * @return FirewallRule
 */
func (a *NicApiService) DatacentersServersNicsFirewallrulesPostExecute(r ApiDatacentersServersNicsFirewallrulesPostRequest) (FirewallRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FirewallRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NicApiService.DatacentersServersNicsFirewallrulesPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}/firewallrules"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.firewallrule == nil {
		return localVarReturnValue, nil, reportError("firewallrule is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.firewallrule
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersNicsFirewallrulesPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsFirewallrulesPutRequest struct {
	ctx _context.Context
	ApiService *NicApiService
	datacenterId string
	serverId string
	nicId string
	firewallruleId string
	firewallrule *FirewallRule
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsFirewallrulesPutRequest) Firewallrule(firewallrule FirewallRule) ApiDatacentersServersNicsFirewallrulesPutRequest {
	r.firewallrule = &firewallrule
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPutRequest) Pretty(pretty bool) ApiDatacentersServersNicsFirewallrulesPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPutRequest) Depth(depth int32) ApiDatacentersServersNicsFirewallrulesPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsFirewallrulesPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsFirewallrulesPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsFirewallrulesPutRequest) Execute() (FirewallRule, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsFirewallrulesPutExecute(r)
}

/*
 * DatacentersServersNicsFirewallrulesPut Modify a Firewall Rule
 * You can use update attributes of a resource
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param serverId The unique ID of the Server
 * @param nicId The unique ID of the NIC
 * @param firewallruleId The unique ID of the Firewall Rule
 * @return ApiDatacentersServersNicsFirewallrulesPutRequest
 */
func (a *NicApiService) DatacentersServersNicsFirewallrulesPut(ctx _context.Context, datacenterId string, serverId string, nicId string, firewallruleId string) ApiDatacentersServersNicsFirewallrulesPutRequest {
	return ApiDatacentersServersNicsFirewallrulesPutRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
		nicId: nicId,
		firewallruleId: firewallruleId,
	}
}

/*
 * Execute executes the request
 * @return FirewallRule
 */
func (a *NicApiService) DatacentersServersNicsFirewallrulesPutExecute(r ApiDatacentersServersNicsFirewallrulesPutRequest) (FirewallRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FirewallRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NicApiService.DatacentersServersNicsFirewallrulesPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}/firewallrules/{firewallruleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"firewallruleId"+"}", _neturl.PathEscape(parameterToString(r.firewallruleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.firewallrule == nil {
		return localVarReturnValue, nil, reportError("firewallrule is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.firewallrule
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersNicsFirewallrulesPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsGetRequest struct {
	ctx _context.Context
	ApiService *NicApiService
	datacenterId string
	serverId string
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsGetRequest) Pretty(pretty bool) ApiDatacentersServersNicsGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsGetRequest) Depth(depth int32) ApiDatacentersServersNicsGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsGetRequest) Execute() (Nics, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsGetExecute(r)
}

/*
 * DatacentersServersNicsGet List Nics 
 * Retrieves a list of NICs.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param serverId The unique ID of the Server
 * @return ApiDatacentersServersNicsGetRequest
 */
func (a *NicApiService) DatacentersServersNicsGet(ctx _context.Context, datacenterId string, serverId string) ApiDatacentersServersNicsGetRequest {
	return ApiDatacentersServersNicsGetRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
	}
}

/*
 * Execute executes the request
 * @return Nics
 */
func (a *NicApiService) DatacentersServersNicsGetExecute(r ApiDatacentersServersNicsGetRequest) (Nics, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Nics
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NicApiService.DatacentersServersNicsGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersNicsGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsPatchRequest struct {
	ctx _context.Context
	ApiService *NicApiService
	datacenterId string
	serverId string
	nicId string
	nic *NicProperties
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsPatchRequest) Nic(nic NicProperties) ApiDatacentersServersNicsPatchRequest {
	r.nic = &nic
	return r
}
func (r ApiDatacentersServersNicsPatchRequest) Pretty(pretty bool) ApiDatacentersServersNicsPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsPatchRequest) Depth(depth int32) ApiDatacentersServersNicsPatchRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsPatchRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsPatchRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsPatchRequest) Execute() (Nic, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsPatchExecute(r)
}

/*
 * DatacentersServersNicsPatch Partially modify a Nic
 * You can use update attributes of a Nic
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param serverId The unique ID of the Server
 * @param nicId The unique ID of the NIC
 * @return ApiDatacentersServersNicsPatchRequest
 */
func (a *NicApiService) DatacentersServersNicsPatch(ctx _context.Context, datacenterId string, serverId string, nicId string) ApiDatacentersServersNicsPatchRequest {
	return ApiDatacentersServersNicsPatchRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
		nicId: nicId,
	}
}

/*
 * Execute executes the request
 * @return Nic
 */
func (a *NicApiService) DatacentersServersNicsPatchExecute(r ApiDatacentersServersNicsPatchRequest) (Nic, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Nic
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NicApiService.DatacentersServersNicsPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.nic == nil {
		return localVarReturnValue, nil, reportError("nic is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.nic
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersNicsPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsPostRequest struct {
	ctx _context.Context
	ApiService *NicApiService
	datacenterId string
	serverId string
	nic *Nic
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsPostRequest) Nic(nic Nic) ApiDatacentersServersNicsPostRequest {
	r.nic = &nic
	return r
}
func (r ApiDatacentersServersNicsPostRequest) Pretty(pretty bool) ApiDatacentersServersNicsPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsPostRequest) Depth(depth int32) ApiDatacentersServersNicsPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsPostRequest) Execute() (Nic, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsPostExecute(r)
}

/*
 * DatacentersServersNicsPost Create a Nic
 * Adds a NIC to the target server. Combine count of Nics and volumes attached to the server should not exceed size 24.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param serverId The unique ID of the Server
 * @return ApiDatacentersServersNicsPostRequest
 */
func (a *NicApiService) DatacentersServersNicsPost(ctx _context.Context, datacenterId string, serverId string) ApiDatacentersServersNicsPostRequest {
	return ApiDatacentersServersNicsPostRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
	}
}

/*
 * Execute executes the request
 * @return Nic
 */
func (a *NicApiService) DatacentersServersNicsPostExecute(r ApiDatacentersServersNicsPostRequest) (Nic, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Nic
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NicApiService.DatacentersServersNicsPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.nic == nil {
		return localVarReturnValue, nil, reportError("nic is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.nic
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersNicsPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersServersNicsPutRequest struct {
	ctx _context.Context
	ApiService *NicApiService
	datacenterId string
	serverId string
	nicId string
	nic *Nic
	pretty *bool
	depth *int32
	xContractNumber *int32
}

func (r ApiDatacentersServersNicsPutRequest) Nic(nic Nic) ApiDatacentersServersNicsPutRequest {
	r.nic = &nic
	return r
}
func (r ApiDatacentersServersNicsPutRequest) Pretty(pretty bool) ApiDatacentersServersNicsPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersServersNicsPutRequest) Depth(depth int32) ApiDatacentersServersNicsPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersServersNicsPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersServersNicsPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersServersNicsPutRequest) Execute() (Nic, *APIResponse, error) {
	return r.ApiService.DatacentersServersNicsPutExecute(r)
}

/*
 * DatacentersServersNicsPut Modify a Nic
 * You can use update attributes of a Nic
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the datacenter
 * @param serverId The unique ID of the Server
 * @param nicId The unique ID of the NIC
 * @return ApiDatacentersServersNicsPutRequest
 */
func (a *NicApiService) DatacentersServersNicsPut(ctx _context.Context, datacenterId string, serverId string, nicId string) ApiDatacentersServersNicsPutRequest {
	return ApiDatacentersServersNicsPutRequest{
		ApiService: a,
		ctx: ctx,
		datacenterId: datacenterId,
		serverId: serverId,
		nicId: nicId,
	}
}

/*
 * Execute executes the request
 * @return Nic
 */
func (a *NicApiService) DatacentersServersNicsPutExecute(r ApiDatacentersServersNicsPutRequest) (Nic, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  Nic
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NicApiService.DatacentersServersNicsPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/servers/{serverId}/nics/{nicId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"serverId"+"}", _neturl.PathEscape(parameterToString(r.serverId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"nicId"+"}", _neturl.PathEscape(parameterToString(r.nicId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.nic == nil {
		return localVarReturnValue, nil, reportError("nic is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	}
	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.nic
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse {
		Response: localVarHTTPResponse,
		Method: localVarHTTPMethod,
		RequestURL: localVarPath,
		Operation: "DatacentersServersNicsPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: localVarHTTPResponse.Status,
		}
			var v Error
			err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
			if err != nil {
				newErr.error = err.Error()
				return localVarReturnValue, localVarAPIResponse, newErr
			}
			newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			body:  localVarBody,
			error: err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}
