/*
Copyright 2019 Red Hat Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/kube-object-storage/lib-bucket-provisioner/pkg/apis/objectbucket.io/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ObjectBucketClaimLister helps list ObjectBucketClaims.
// All objects returned here must be treated as read-only.
type ObjectBucketClaimLister interface {
	// List lists all ObjectBucketClaims in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.ObjectBucketClaim, err error)
	// ObjectBucketClaims returns an object that can list and get ObjectBucketClaims.
	ObjectBucketClaims(namespace string) ObjectBucketClaimNamespaceLister
	ObjectBucketClaimListerExpansion
}

// objectBucketClaimLister implements the ObjectBucketClaimLister interface.
type objectBucketClaimLister struct {
	indexer cache.Indexer
}

// NewObjectBucketClaimLister returns a new ObjectBucketClaimLister.
func NewObjectBucketClaimLister(indexer cache.Indexer) ObjectBucketClaimLister {
	return &objectBucketClaimLister{indexer: indexer}
}

// List lists all ObjectBucketClaims in the indexer.
func (s *objectBucketClaimLister) List(selector labels.Selector) (ret []*v1alpha1.ObjectBucketClaim, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ObjectBucketClaim))
	})
	return ret, err
}

// ObjectBucketClaims returns an object that can list and get ObjectBucketClaims.
func (s *objectBucketClaimLister) ObjectBucketClaims(namespace string) ObjectBucketClaimNamespaceLister {
	return objectBucketClaimNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ObjectBucketClaimNamespaceLister helps list and get ObjectBucketClaims.
// All objects returned here must be treated as read-only.
type ObjectBucketClaimNamespaceLister interface {
	// List lists all ObjectBucketClaims in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.ObjectBucketClaim, err error)
	// Get retrieves the ObjectBucketClaim from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.ObjectBucketClaim, error)
	ObjectBucketClaimNamespaceListerExpansion
}

// objectBucketClaimNamespaceLister implements the ObjectBucketClaimNamespaceLister
// interface.
type objectBucketClaimNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ObjectBucketClaims in the indexer for a given namespace.
func (s objectBucketClaimNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.ObjectBucketClaim, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.ObjectBucketClaim))
	})
	return ret, err
}

// Get retrieves the ObjectBucketClaim from the indexer for a given namespace and name.
func (s objectBucketClaimNamespaceLister) Get(name string) (*v1alpha1.ObjectBucketClaim, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("objectbucketclaim"), name)
	}
	return obj.(*v1alpha1.ObjectBucketClaim), nil
}
