/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// CephObjectRealmLister helps list CephObjectRealms.
type CephObjectRealmLister interface {
	// List lists all CephObjectRealms in the indexer.
	List(selector labels.Selector) (ret []*v1.CephObjectRealm, err error)
	// CephObjectRealms returns an object that can list and get CephObjectRealms.
	CephObjectRealms(namespace string) CephObjectRealmNamespaceLister
	CephObjectRealmListerExpansion
}

// cephObjectRealmLister implements the CephObjectRealmLister interface.
type cephObjectRealmLister struct {
	indexer cache.Indexer
}

// NewCephObjectRealmLister returns a new CephObjectRealmLister.
func NewCephObjectRealmLister(indexer cache.Indexer) CephObjectRealmLister {
	return &cephObjectRealmLister{indexer: indexer}
}

// List lists all CephObjectRealms in the indexer.
func (s *cephObjectRealmLister) List(selector labels.Selector) (ret []*v1.CephObjectRealm, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephObjectRealm))
	})
	return ret, err
}

// CephObjectRealms returns an object that can list and get CephObjectRealms.
func (s *cephObjectRealmLister) CephObjectRealms(namespace string) CephObjectRealmNamespaceLister {
	return cephObjectRealmNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// CephObjectRealmNamespaceLister helps list and get CephObjectRealms.
type CephObjectRealmNamespaceLister interface {
	// List lists all CephObjectRealms in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.CephObjectRealm, err error)
	// Get retrieves the CephObjectRealm from the indexer for a given namespace and name.
	Get(name string) (*v1.CephObjectRealm, error)
	CephObjectRealmNamespaceListerExpansion
}

// cephObjectRealmNamespaceLister implements the CephObjectRealmNamespaceLister
// interface.
type cephObjectRealmNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all CephObjectRealms in the indexer for a given namespace.
func (s cephObjectRealmNamespaceLister) List(selector labels.Selector) (ret []*v1.CephObjectRealm, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.CephObjectRealm))
	})
	return ret, err
}

// Get retrieves the CephObjectRealm from the indexer for a given namespace and name.
func (s cephObjectRealmNamespaceLister) Get(name string) (*v1.CephObjectRealm, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("cephobjectrealm"), name)
	}
	return obj.(*v1.CephObjectRealm), nil
}
