/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	scheme "github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CephRBDMirrorsGetter has a method to return a CephRBDMirrorInterface.
// A group's client should implement this interface.
type CephRBDMirrorsGetter interface {
	CephRBDMirrors(namespace string) CephRBDMirrorInterface
}

// CephRBDMirrorInterface has methods to work with CephRBDMirror resources.
type CephRBDMirrorInterface interface {
	Create(*v1.CephRBDMirror) (*v1.CephRBDMirror, error)
	Update(*v1.CephRBDMirror) (*v1.CephRBDMirror, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.CephRBDMirror, error)
	List(opts metav1.ListOptions) (*v1.CephRBDMirrorList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.CephRBDMirror, err error)
	CephRBDMirrorExpansion
}

// cephRBDMirrors implements CephRBDMirrorInterface
type cephRBDMirrors struct {
	client rest.Interface
	ns     string
}

// newCephRBDMirrors returns a CephRBDMirrors
func newCephRBDMirrors(c *CephV1Client, namespace string) *cephRBDMirrors {
	return &cephRBDMirrors{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the cephRBDMirror, and returns the corresponding cephRBDMirror object, and an error if there is any.
func (c *cephRBDMirrors) Get(name string, options metav1.GetOptions) (result *v1.CephRBDMirror, err error) {
	result = &v1.CephRBDMirror{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cephrbdmirrors").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CephRBDMirrors that match those selectors.
func (c *cephRBDMirrors) List(opts metav1.ListOptions) (result *v1.CephRBDMirrorList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.CephRBDMirrorList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cephrbdmirrors").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested cephRBDMirrors.
func (c *cephRBDMirrors) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("cephrbdmirrors").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a cephRBDMirror and creates it.  Returns the server's representation of the cephRBDMirror, and an error, if there is any.
func (c *cephRBDMirrors) Create(cephRBDMirror *v1.CephRBDMirror) (result *v1.CephRBDMirror, err error) {
	result = &v1.CephRBDMirror{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("cephrbdmirrors").
		Body(cephRBDMirror).
		Do().
		Into(result)
	return
}

// Update takes the representation of a cephRBDMirror and updates it. Returns the server's representation of the cephRBDMirror, and an error, if there is any.
func (c *cephRBDMirrors) Update(cephRBDMirror *v1.CephRBDMirror) (result *v1.CephRBDMirror, err error) {
	result = &v1.CephRBDMirror{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("cephrbdmirrors").
		Name(cephRBDMirror.Name).
		Body(cephRBDMirror).
		Do().
		Into(result)
	return
}

// Delete takes name of the cephRBDMirror and deletes it. Returns an error if one occurs.
func (c *cephRBDMirrors) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cephrbdmirrors").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *cephRBDMirrors) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cephrbdmirrors").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched cephRBDMirror.
func (c *cephRBDMirrors) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.CephRBDMirror, err error) {
	result = &v1.CephRBDMirror{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("cephrbdmirrors").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
