/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	scheme "github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CephObjectZoneGroupsGetter has a method to return a CephObjectZoneGroupInterface.
// A group's client should implement this interface.
type CephObjectZoneGroupsGetter interface {
	CephObjectZoneGroups(namespace string) CephObjectZoneGroupInterface
}

// CephObjectZoneGroupInterface has methods to work with CephObjectZoneGroup resources.
type CephObjectZoneGroupInterface interface {
	Create(*v1.CephObjectZoneGroup) (*v1.CephObjectZoneGroup, error)
	Update(*v1.CephObjectZoneGroup) (*v1.CephObjectZoneGroup, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.CephObjectZoneGroup, error)
	List(opts metav1.ListOptions) (*v1.CephObjectZoneGroupList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.CephObjectZoneGroup, err error)
	CephObjectZoneGroupExpansion
}

// cephObjectZoneGroups implements CephObjectZoneGroupInterface
type cephObjectZoneGroups struct {
	client rest.Interface
	ns     string
}

// newCephObjectZoneGroups returns a CephObjectZoneGroups
func newCephObjectZoneGroups(c *CephV1Client, namespace string) *cephObjectZoneGroups {
	return &cephObjectZoneGroups{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the cephObjectZoneGroup, and returns the corresponding cephObjectZoneGroup object, and an error if there is any.
func (c *cephObjectZoneGroups) Get(name string, options metav1.GetOptions) (result *v1.CephObjectZoneGroup, err error) {
	result = &v1.CephObjectZoneGroup{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cephobjectzonegroups").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CephObjectZoneGroups that match those selectors.
func (c *cephObjectZoneGroups) List(opts metav1.ListOptions) (result *v1.CephObjectZoneGroupList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.CephObjectZoneGroupList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cephobjectzonegroups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested cephObjectZoneGroups.
func (c *cephObjectZoneGroups) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("cephobjectzonegroups").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a cephObjectZoneGroup and creates it.  Returns the server's representation of the cephObjectZoneGroup, and an error, if there is any.
func (c *cephObjectZoneGroups) Create(cephObjectZoneGroup *v1.CephObjectZoneGroup) (result *v1.CephObjectZoneGroup, err error) {
	result = &v1.CephObjectZoneGroup{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("cephobjectzonegroups").
		Body(cephObjectZoneGroup).
		Do().
		Into(result)
	return
}

// Update takes the representation of a cephObjectZoneGroup and updates it. Returns the server's representation of the cephObjectZoneGroup, and an error, if there is any.
func (c *cephObjectZoneGroups) Update(cephObjectZoneGroup *v1.CephObjectZoneGroup) (result *v1.CephObjectZoneGroup, err error) {
	result = &v1.CephObjectZoneGroup{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("cephobjectzonegroups").
		Name(cephObjectZoneGroup.Name).
		Body(cephObjectZoneGroup).
		Do().
		Into(result)
	return
}

// Delete takes name of the cephObjectZoneGroup and deletes it. Returns an error if one occurs.
func (c *cephObjectZoneGroups) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cephobjectzonegroups").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *cephObjectZoneGroups) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cephobjectzonegroups").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched cephObjectZoneGroup.
func (c *cephObjectZoneGroups) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.CephObjectZoneGroup, err error) {
	result = &v1.CephObjectZoneGroup{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("cephobjectzonegroups").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
