/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	scheme "github.com/rook/rook/pkg/client/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CephObjectZonesGetter has a method to return a CephObjectZoneInterface.
// A group's client should implement this interface.
type CephObjectZonesGetter interface {
	CephObjectZones(namespace string) CephObjectZoneInterface
}

// CephObjectZoneInterface has methods to work with CephObjectZone resources.
type CephObjectZoneInterface interface {
	Create(*v1.CephObjectZone) (*v1.CephObjectZone, error)
	Update(*v1.CephObjectZone) (*v1.CephObjectZone, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.CephObjectZone, error)
	List(opts metav1.ListOptions) (*v1.CephObjectZoneList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.CephObjectZone, err error)
	CephObjectZoneExpansion
}

// cephObjectZones implements CephObjectZoneInterface
type cephObjectZones struct {
	client rest.Interface
	ns     string
}

// newCephObjectZones returns a CephObjectZones
func newCephObjectZones(c *CephV1Client, namespace string) *cephObjectZones {
	return &cephObjectZones{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the cephObjectZone, and returns the corresponding cephObjectZone object, and an error if there is any.
func (c *cephObjectZones) Get(name string, options metav1.GetOptions) (result *v1.CephObjectZone, err error) {
	result = &v1.CephObjectZone{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cephobjectzones").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CephObjectZones that match those selectors.
func (c *cephObjectZones) List(opts metav1.ListOptions) (result *v1.CephObjectZoneList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.CephObjectZoneList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("cephobjectzones").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested cephObjectZones.
func (c *cephObjectZones) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("cephobjectzones").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a cephObjectZone and creates it.  Returns the server's representation of the cephObjectZone, and an error, if there is any.
func (c *cephObjectZones) Create(cephObjectZone *v1.CephObjectZone) (result *v1.CephObjectZone, err error) {
	result = &v1.CephObjectZone{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("cephobjectzones").
		Body(cephObjectZone).
		Do().
		Into(result)
	return
}

// Update takes the representation of a cephObjectZone and updates it. Returns the server's representation of the cephObjectZone, and an error, if there is any.
func (c *cephObjectZones) Update(cephObjectZone *v1.CephObjectZone) (result *v1.CephObjectZone, err error) {
	result = &v1.CephObjectZone{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("cephobjectzones").
		Name(cephObjectZone.Name).
		Body(cephObjectZone).
		Do().
		Into(result)
	return
}

// Delete takes name of the cephObjectZone and deletes it. Returns an error if one occurs.
func (c *cephObjectZones) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cephobjectzones").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *cephObjectZones) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("cephobjectzones").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched cephObjectZone.
func (c *cephObjectZones) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.CephObjectZone, err error) {
	result = &v1.CephObjectZone{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("cephobjectzones").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
