/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/edgefs.rook.io/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// SMBLister helps list SMBs.
type SMBLister interface {
	// List lists all SMBs in the indexer.
	List(selector labels.Selector) (ret []*v1.SMB, err error)
	// SMBs returns an object that can list and get SMBs.
	SMBs(namespace string) SMBNamespaceLister
	SMBListerExpansion
}

// sMBLister implements the SMBLister interface.
type sMBLister struct {
	indexer cache.Indexer
}

// NewSMBLister returns a new SMBLister.
func NewSMBLister(indexer cache.Indexer) SMBLister {
	return &sMBLister{indexer: indexer}
}

// List lists all SMBs in the indexer.
func (s *sMBLister) List(selector labels.Selector) (ret []*v1.SMB, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SMB))
	})
	return ret, err
}

// SMBs returns an object that can list and get SMBs.
func (s *sMBLister) SMBs(namespace string) SMBNamespaceLister {
	return sMBNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// SMBNamespaceLister helps list and get SMBs.
type SMBNamespaceLister interface {
	// List lists all SMBs in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.SMB, err error)
	// Get retrieves the SMB from the indexer for a given namespace and name.
	Get(name string) (*v1.SMB, error)
	SMBNamespaceListerExpansion
}

// sMBNamespaceLister implements the SMBNamespaceLister
// interface.
type sMBNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all SMBs in the indexer for a given namespace.
func (s sMBNamespaceLister) List(selector labels.Selector) (ret []*v1.SMB, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.SMB))
	})
	return ret, err
}

// Get retrieves the SMB from the indexer for a given namespace and name.
func (s sMBNamespaceLister) Get(name string) (*v1.SMB, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("smb"), name)
	}
	return obj.(*v1.SMB), nil
}
