#!/usr/bin/env node
"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));

var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));

var _log = require("./log.js");

var _minimist = _interopRequireDefault(require("minimist"));

var _index = require("./index.js");

function main() {
  return _main.apply(this, arguments);
}

function _main() {
  _main = (0, _asyncToGenerator2.default)( /*#__PURE__*/_regenerator.default.mark(function _callee() {
    var argv, nodeRange, platform, arch, forceFetch, forceBuild, local;
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            argv = (0, _minimist.default)(process.argv.slice(2), {
              boolean: ['f', 'b'],
              string: ['n', 'p', 'a']
            });
            nodeRange = argv.n || argv._.shift();
            platform = argv.p || argv._.shift();
            arch = argv.a || argv._.shift();
            forceFetch = argv.f;
            forceBuild = argv.b;
            _context.next = 8;
            return (0, _index.need)({
              nodeRange,
              platform,
              arch,
              forceFetch,
              forceBuild
            });

          case 8:
            local = _context.sent;

            _log.log.info(local);

          case 10:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _main.apply(this, arguments);
}

main().catch(function (error) {
  if (!error.wasReported) _log.log.error(error);
  process.exit(2);
});