"use strict";
/**
 * @license
 * Copyright 2019 Palantir Technologies, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.codeExamples = void 0;
var tslib_1 = require("tslib");
var Lint = require("../../index");
// tslint:disable: object-literal-sort-keys
exports.codeExamples = [
    {
        description: "Disallow object literals to appear in type assertion expressions (default). Casting to `any` and `unknown` is allowed.",
        config: Lint.Utils.dedent(templateObject_1 || (templateObject_1 = tslib_1.__makeTemplateObject(["\n            \"rules\": { \"no-object-literal-type-assertion\": true }\n        "], ["\n            \"rules\": { \"no-object-literal-type-assertion\": true }\n        "]))),
        pass: Lint.Utils.dedent(templateObject_2 || (templateObject_2 = tslib_1.__makeTemplateObject(["\n            let foo = {} as any;\n            let foo = {} as unknown;\n\n            let foo = {} as any as Foo;\n            let foo = {} as unknown as Foo;\n        "], ["\n            let foo = {} as any;\n            let foo = {} as unknown;\n\n            let foo = {} as any as Foo;\n            let foo = {} as unknown as Foo;\n        "]))),
        fail: Lint.Utils.dedent(templateObject_3 || (templateObject_3 = tslib_1.__makeTemplateObject(["\n            let foo = {} as Foo;\n            let foo = <Foo>{};\n        "], ["\n            let foo = {} as Foo;\n            let foo = <Foo>{};\n        "]))),
    },
    {
        description: "Allow using a type assertion when the object literal is used as an argument.",
        config: Lint.Utils.dedent(templateObject_4 || (templateObject_4 = tslib_1.__makeTemplateObject(["\n            \"rules\": { \"no-object-literal-type-assertion\": [true, { \"allow-arguments\": true }] }\n        "], ["\n            \"rules\": { \"no-object-literal-type-assertion\": [true, { \"allow-arguments\": true }] }\n        "]))),
        pass: Lint.Utils.dedent(templateObject_5 || (templateObject_5 = tslib_1.__makeTemplateObject(["\n            bar({} as Foo)\n        "], ["\n            bar({} as Foo)\n        "]))),
    },
];
var templateObject_1, templateObject_2, templateObject_3, templateObject_4, templateObject_5;
