import * as React from 'react';
import { ButtonProps } from '../Button';
export interface TouchspinProps extends React.HTMLProps<HTMLDivElement> {
    /** Value of the touchspin */
    value?: number;
    /** Additional classes added to the touchspin */
    className?: string;
    /** Sets the width of the touchspin to a number of characters */
    widthChars?: number;
    /** Indicates the whole touchspin should be disabled */
    isDisabled?: boolean;
    /** Callback for the minus button */
    onMinus?: (event: React.MouseEvent, name?: string) => void;
    /** Callback for the text input changing */
    onChange?: (event: React.FormEvent<HTMLInputElement>) => void;
    /** Callback for the plus button */
    onPlus?: (event: React.MouseEvent, name?: string) => void;
    /** Adds the given touchspin unit to the touchspin */
    unit?: React.ReactNode;
    /** Position of the touchspin unit in relation to the touchspin */
    unitPosition?: 'before' | 'after';
    /** Minimum value of the touchspin, disabling the minus button when reached */
    min?: number;
    /** Maximum value of the touchspin, disabling the plus button when reached */
    max?: number;
    /** Name of the input */
    inputName?: string;
    /** Aria label of the input */
    inputAriaLabel?: string;
    /** Aria label of the minus button */
    minusBtnAriaLabel?: string;
    /** Aria label of the plus button */
    plusBtnAriaLabel?: string;
    /** Additional properties added to the touchspin text input */
    inputProps?: any;
    /** Additional properties added to the minus button */
    minusBtnProps?: ButtonProps;
    /** Additional properties added to the plus button */
    plusBtnProps?: ButtonProps;
}
export declare const Touchspin: React.FunctionComponent<TouchspinProps>;
//# sourceMappingURL=Touchspin.d.ts.map