import * as React from 'react';
export interface JumpLinksProps extends Omit<React.HTMLProps<HTMLElement>, 'label'> {
    /** Whether to center children. */
    isCentered?: boolean;
    /** Whether the layout of children is vertical or horizontal. */
    isVertical?: boolean;
    /** Label to add to nav element. */
    label?: React.ReactNode;
    /** Aria-label to add to nav element. Defaults to label. */
    'aria-label'?: string;
    /** Selector for the scrollable element to spy on. Not passing a selector disables spying. */
    scrollableSelector?: string;
    /** The index of the child Jump link to make active. */
    activeIndex?: number;
    /** Children nodes */
    children?: React.ReactNode;
}
export declare const JumpLinks: React.FunctionComponent<JumpLinksProps>;
//# sourceMappingURL=JumpLinks.d.ts.map