"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DualListSelector = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const dual_list_selector_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/DualListSelector/dual-list-selector"));
const react_styles_1 = require("@patternfly/react-styles");
const Button_1 = require("../Button");
const angle_double_left_icon_1 = tslib_1.__importDefault(require("@patternfly/react-icons/dist/js/icons/angle-double-left-icon"));
const angle_left_icon_1 = tslib_1.__importDefault(require("@patternfly/react-icons/dist/js/icons/angle-left-icon"));
const angle_double_right_icon_1 = tslib_1.__importDefault(require("@patternfly/react-icons/dist/js/icons/angle-double-right-icon"));
const angle_right_icon_1 = tslib_1.__importDefault(require("@patternfly/react-icons/dist/js/icons/angle-right-icon"));
const DualListSelectorPane_1 = require("./DualListSelectorPane");
const helpers_1 = require("../../helpers");
class DualListSelector extends React.Component {
    constructor(props) {
        super(props);
        this.controlsEl = React.createRef();
        this.addAll = () => {
            this.setState(prevState => {
                const newChosen = [...prevState.chosenOptions, ...prevState.availableOptions];
                if (this.props.addAll) {
                    this.props.addAll([], newChosen);
                }
                if (this.props.onListChange) {
                    this.props.onListChange([], newChosen);
                }
                return {
                    availableOptions: [],
                    availableOptionsSelected: [],
                    chosenOptions: newChosen,
                    chosenOptionsSelected: []
                };
            });
        };
        this.removeAll = () => {
            this.setState(prevState => {
                const newAvailable = [...prevState.chosenOptions, ...prevState.availableOptions];
                if (this.props.removeAll) {
                    this.props.removeAll(newAvailable, []);
                }
                if (this.props.onListChange) {
                    this.props.onListChange(newAvailable, []);
                }
                return {
                    availableOptions: newAvailable,
                    availableOptionsSelected: [],
                    chosenOptions: [],
                    chosenOptionsSelected: []
                };
            });
        };
        this.addSelected = () => {
            this.setState(prevState => {
                const itemsToRemove = [];
                const newAvailable = [];
                prevState.availableOptions.forEach((value, index) => {
                    if (prevState.availableOptionsSelected.indexOf(index) !== -1) {
                        itemsToRemove.push(value);
                    }
                    else {
                        newAvailable.push(value);
                    }
                });
                const newChosen = [...prevState.chosenOptions, ...itemsToRemove];
                if (this.props.addSelected) {
                    this.props.addSelected(newAvailable, newChosen);
                }
                if (this.props.onListChange) {
                    this.props.onListChange(newAvailable, newChosen);
                }
                return {
                    chosenOptionsSelected: [],
                    availableOptionsSelected: [],
                    chosenOptions: newChosen,
                    availableOptions: newAvailable
                };
            });
        };
        this.removeSelected = () => {
            this.setState(prevState => {
                const itemsToRemove = [];
                const newChosen = [];
                prevState.chosenOptions.forEach((value, index) => {
                    if (prevState.chosenOptionsSelected.indexOf(index) !== -1) {
                        itemsToRemove.push(value);
                    }
                    else {
                        newChosen.push(value);
                    }
                });
                const newAvailable = [...prevState.availableOptions, ...itemsToRemove];
                if (this.props.removeSelected) {
                    this.props.removeSelected(newAvailable, newChosen);
                }
                if (this.props.onListChange) {
                    this.props.onListChange(newAvailable, newChosen);
                }
                return {
                    chosenOptionsSelected: [],
                    availableOptionsSelected: [],
                    chosenOptions: newChosen,
                    availableOptions: newAvailable
                };
            });
        };
        this.onOptionSelect = (e, index, isChosen) => {
            this.setState(prevState => {
                const originalArray = isChosen ? prevState.chosenOptionsSelected : prevState.availableOptionsSelected;
                let updatedArray = null;
                if (originalArray.indexOf(index) !== -1) {
                    updatedArray = originalArray.filter(value => value !== index);
                }
                else {
                    updatedArray = [...originalArray, index];
                }
                return {
                    chosenOptionsSelected: isChosen ? updatedArray : prevState.chosenOptionsSelected,
                    availableOptionsSelected: isChosen ? prevState.availableOptionsSelected : updatedArray
                };
            });
            const onOptionSelect = this.props.onOptionSelect;
            if (onOptionSelect) {
                onOptionSelect(e);
            }
        };
        this.handleKeys = (event) => {
            const key = event.key;
            let moveFocus = false;
            let currentIndex = -1;
            const controls = Array.from(this.controlsEl.current.getElementsByClassName('pf-c-button'));
            if (['ArrowUp', 'ArrowDown', 'ArrowLeft', 'ArrowRight'].includes(event.key)) {
                if (document.activeElement === this.controlsEl.current) {
                    currentIndex = 0;
                    while (currentIndex < controls.length &&
                        currentIndex >= 0 &&
                        controls[currentIndex].classList.contains('pf-m-disabled')) {
                        currentIndex = currentIndex + 1;
                    }
                    moveFocus = true;
                    event.preventDefault();
                }
                else {
                    controls.forEach((control, index) => {
                        if (document.activeElement === control) {
                            const increment = key === 'ArrowUp' || key === 'ArrowLeft' ? -1 : 1;
                            currentIndex = index + increment;
                            while (currentIndex < controls.length &&
                                currentIndex >= 0 &&
                                controls[currentIndex].classList.contains('pf-m-disabled')) {
                                currentIndex = currentIndex + increment;
                            }
                            moveFocus = true;
                            event.preventDefault();
                        }
                    });
                }
            }
            if (moveFocus && controls[currentIndex]) {
                controls[currentIndex].focus();
            }
        };
        this.state = {
            availableOptions: [...this.props.availableOptions],
            availableOptionsSelected: [],
            chosenOptions: [...this.props.chosenOptions],
            chosenOptionsSelected: []
        };
    }
    componentDidUpdate() {
        if (JSON.stringify(this.props.availableOptions) !== JSON.stringify(this.state.availableOptions) ||
            JSON.stringify(this.props.chosenOptions) !== JSON.stringify(this.state.chosenOptions)) {
            this.setState({
                availableOptions: [...this.props.availableOptions],
                chosenOptions: [...this.props.chosenOptions]
            });
        }
    }
    componentDidMount() {
        window.addEventListener('keydown', this.handleKeys);
    }
    componentWillUnmount() {
        window.removeEventListener('keydown', this.handleKeys);
    }
    render() {
        const _a = this.props, { availableOptionsTitle, availableOptionsActions, availableOptionsSearchAriaLabel, className, chosenOptionsTitle, chosenOptionsActions, chosenOptionsSearchAriaLabel, filterOption, isSearchable, chosenOptionsStatus, availableOptionsStatus, controlsAriaLabel, addAllAriaLabel, addSelectedAriaLabel, removeSelectedAriaLabel, removeAllAriaLabel, 
        /* eslint-disable @typescript-eslint/no-unused-vars */
        availableOptions: consumerPassedAvailableOptions, chosenOptions: consumerPassedChosenOptions, removeSelected, addAll, removeAll, addSelected, onListChange, id } = _a, props = tslib_1.__rest(_a, ["availableOptionsTitle", "availableOptionsActions", "availableOptionsSearchAriaLabel", "className", "chosenOptionsTitle", "chosenOptionsActions", "chosenOptionsSearchAriaLabel", "filterOption", "isSearchable", "chosenOptionsStatus", "availableOptionsStatus", "controlsAriaLabel", "addAllAriaLabel", "addSelectedAriaLabel", "removeSelectedAriaLabel", "removeAllAriaLabel", "availableOptions", "chosenOptions", "removeSelected", "addAll", "removeAll", "addSelected", "onListChange", "id"]);
        const { availableOptions, chosenOptions, chosenOptionsSelected, availableOptionsSelected } = this.state;
        const availableOptionsStatusToDisplay = availableOptionsStatus || `${availableOptionsSelected.length} of ${availableOptions.length} items selected`;
        const chosenOptionsStatusToDisplay = chosenOptionsStatus || `${chosenOptionsSelected.length} of ${chosenOptions.length} items selected`;
        return (React.createElement("div", Object.assign({ className: react_styles_1.css(dual_list_selector_1.default.dualListSelector, className), id: id }, props),
            React.createElement(DualListSelectorPane_1.DualListSelectorPane, { isSearchable: isSearchable, searchInputAriaLabel: availableOptionsSearchAriaLabel, filterOption: filterOption, status: availableOptionsStatusToDisplay, title: availableOptionsTitle, options: availableOptions, selectedOptions: availableOptionsSelected, onOptionSelect: this.onOptionSelect, actions: availableOptionsActions, id: `${id}-available-pane` }),
            React.createElement("div", { className: react_styles_1.css(dual_list_selector_1.default.dualListSelectorControls), tabIndex: 0, ref: this.controlsEl, "aria-label": controlsAriaLabel },
                React.createElement("div", { className: react_styles_1.css('pf-c-dual-list-selector__controls-item') },
                    React.createElement(Button_1.Button, { isDisabled: availableOptions.length === 0, "aria-disabled": availableOptions.length === 0, variant: Button_1.ButtonVariant.plain, onClick: this.addAll, "aria-label": addAllAriaLabel, tabIndex: -1 },
                        React.createElement(angle_double_right_icon_1.default, null))),
                React.createElement("div", { className: react_styles_1.css('pf-c-dual-list-selector__controls-item') },
                    React.createElement(Button_1.Button, { isDisabled: availableOptionsSelected.length === 0, "aria-disabled": availableOptionsSelected.length === 0, variant: Button_1.ButtonVariant.plain, onClick: this.addSelected, "aria-label": addSelectedAriaLabel, tabIndex: -1 },
                        React.createElement(angle_right_icon_1.default, null))),
                React.createElement("div", { className: react_styles_1.css('pf-c-dual-list-selector__controls-item') },
                    React.createElement(Button_1.Button, { variant: Button_1.ButtonVariant.plain, onClick: this.removeSelected, "aria-label": removeSelectedAriaLabel, tabIndex: -1, isDisabled: chosenOptionsSelected.length === 0, "aria-disabled": chosenOptionsSelected.length === 0 },
                        React.createElement(angle_left_icon_1.default, null))),
                React.createElement("div", { className: react_styles_1.css('pf-c-dual-list-selector__controls-item') },
                    React.createElement(Button_1.Button, { isDisabled: chosenOptions.length === 0, "aria-disabled": chosenOptions.length === 0, variant: Button_1.ButtonVariant.plain, onClick: this.removeAll, "aria-label": removeAllAriaLabel, tabIndex: -1 },
                        React.createElement(angle_double_left_icon_1.default, null)))),
            React.createElement(DualListSelectorPane_1.DualListSelectorPane, { isChosen: true, isSearchable: isSearchable, searchInputAriaLabel: chosenOptionsSearchAriaLabel, filterOption: filterOption, title: chosenOptionsTitle, status: chosenOptionsStatusToDisplay, options: chosenOptions, selectedOptions: chosenOptionsSelected, onOptionSelect: this.onOptionSelect, actions: chosenOptionsActions, id: `${id}-chosen-pane` })));
    }
}
exports.DualListSelector = DualListSelector;
DualListSelector.displayName = 'DualListSelector';
DualListSelector.defaultProps = {
    availableOptions: [],
    availableOptionsTitle: 'Available options',
    availableOptionsSearchAriaLabel: 'Available search input',
    chosenOptions: [],
    chosenOptionsTitle: 'Chosen options',
    chosenOptionsSearchAriaLabel: 'Chosen search input',
    id: helpers_1.getUniqueId('dual-list-selector'),
    controlsAriaLabel: 'Selector controls',
    addAllAriaLabel: 'Add all',
    addSelectedAriaLabel: 'Add selected',
    removeSelectedAriaLabel: 'Remove selected',
    removeAllAriaLabel: 'Remove all'
};
//# sourceMappingURL=DualListSelector.js.map