import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Touchspin/touchspin';
import { css } from '@patternfly/react-styles';
import MinusIcon from "@patternfly/react-icons/dist/esm/icons/minus-icon";
import PlusIcon from "@patternfly/react-icons/dist/esm/icons/plus-icon";
import { Button } from '../Button';
export const Touchspin = (_a) => {
    var { value = 0, className, widthChars, isDisabled = false, onMinus, onChange, onPlus, unit, unitPosition = 'after', min, max, inputName, inputAriaLabel = 'Input', minusBtnAriaLabel = 'Minus', plusBtnAriaLabel = 'Plus', inputProps, minusBtnProps, plusBtnProps } = _a, props = __rest(_a, ["value", "className", "widthChars", "isDisabled", "onMinus", "onChange", "onPlus", "unit", "unitPosition", "min", "max", "inputName", "inputAriaLabel", "minusBtnAriaLabel", "plusBtnAriaLabel", "inputProps", "minusBtnProps", "plusBtnProps"]);
    const touchspinUnit = React.createElement("div", { className: css(styles.touchspinUnit) }, unit);
    return (React.createElement("div", Object.assign({ className: css(styles.touchspin, className) }, (widthChars && {
        style: Object.assign({ '--pf-c-touchspin--c-form-control--width-chars': widthChars }, props.style)
    }), props),
        unit && unitPosition === 'before' && touchspinUnit,
        React.createElement("div", { className: css(styles.inputGroup) },
            React.createElement(Button, Object.assign({ variant: "control", "aria-label": minusBtnAriaLabel, isDisabled: isDisabled || value === min, onClick: evt => onMinus(evt, inputName) }, minusBtnProps),
                React.createElement("span", { className: css(styles.touchspinIcon) },
                    React.createElement(MinusIcon, { "aria-hidden": "true" }))),
            React.createElement("input", Object.assign({ className: css(styles.formControl), type: "text", value: value, name: inputName, "aria-label": inputAriaLabel }, (isDisabled && { disabled: isDisabled }), (onChange && { onChange }), (!onChange && { readOnly: true }), inputProps)),
            React.createElement(Button, Object.assign({ variant: "control", "aria-label": plusBtnAriaLabel, isDisabled: isDisabled || value === max, onClick: evt => onPlus(evt, inputName) }, plusBtnProps),
                React.createElement("span", { className: css(styles.touchspinIcon) },
                    React.createElement(PlusIcon, { "aria-hidden": "true" })))),
        unit && unitPosition === 'after' && touchspinUnit));
};
Touchspin.displayName = 'Touchspin';
//# sourceMappingURL=Touchspin.js.map