export declare type KubeResource = NamespacedResource | ClusterResource;
export interface IKubeResource {
    listPath(): string;
    namedPath(name: string): string;
}
export interface IDiscoveryResource {
    discoveryAggregator(): string;
    discoveryType(): string;
    path(): string;
    parametrized(params?: IDiscoveryParameters): {
        [param: string]: string;
    };
}
export interface INamedDiscoveryResource extends IDiscoveryResource {
    discoveryName(): string;
}
export interface IGroupVersionKindPlural {
    group: string;
    version: string;
    kindPlural: string;
}
export interface IDiscoveryParameters {
    offset?: number;
    limit?: number;
    [param: string]: string | number | undefined;
}
export declare type TokenExpiryHandler = (oldToken: object) => void;
export declare abstract class NamespacedResource implements IKubeResource {
    abstract gvk(): IGroupVersionKindPlural;
    namespace: string;
    constructor(namespace: string);
    listPath(): string;
    namedPath(name: string): string;
}
export declare abstract class ClusterResource implements IKubeResource {
    abstract gvk(): IGroupVersionKindPlural;
    listPath(): string;
    namedPath(name: string): string;
}
export declare abstract class DiscoveryResource implements IDiscoveryResource {
    private readonly _type;
    private readonly _aggregatorType;
    private readonly _aggregatorName;
    private _discoveryParameters;
    constructor(aggregatorName: string, type: string, discoveryParameters: IDiscoveryParameters, customAggregatorType?: string);
    discoveryType(): string;
    discoveryAggregator(): string;
    parametrized(params?: IDiscoveryParameters): {
        [param: string]: string;
    };
    path(): string;
}
export declare abstract class NamedDiscoveryResource extends DiscoveryResource implements INamedDiscoveryResource {
    private readonly _name;
    constructor(name: string, aggregator: string, type: string, discoveryParameters: IDiscoveryParameters, customAggregatorType?: string);
    discoveryName(): string;
    path(): string;
}
export declare abstract class OAuthClient {
    private _token;
    private _tokenExpiryTime;
    private _tokenExpiryHandler;
    constructor(token: string);
    getOAuthHeader(): {
        Authorization: string;
    };
    setTokenExpiryHandler(handler: TokenExpiryHandler, tokenExpiryTime: number): void;
    checkExpiry(err: {
        response?: {
            status: number;
        };
    }): void;
    private _oldToken;
}
