---
id: 'Date picker'
beta: true
section: components
cssPrefix: pf-c-date-picker
---import './DatePicker.css'

## Examples

### Basic

```html
<div class="pf-c-date-picker">
  <div class="pf-c-date-picker__input">
    <input class="pf-c-form-control pf-m-icon pf-m-calendar" type="text" value="03/05/2020" id="basic-input" name="basic-input" aria-label="Basic date picker example" />
  </div>
</div>
```

### Helper text

```html
<div class="pf-c-date-picker">
  <div class="pf-c-date-picker__input">
    <input class="pf-c-form-control pf-m-icon pf-m-calendar" type="text" value="03/05/2020" id="helper-text-input" name="helper-text-input" aria-label="Basic date picker example" />
  </div>
  <div class="pf-c-date-picker__helper-text">Select a date.</div>
</div>
```

### Invalid

```html
<div class="pf-c-date-picker">
  <div class="pf-c-date-picker__input">
    <input class="pf-c-form-control pf-m-icon pf-m-calendar" aria-invalid="true" type="text" value="03/05/2020" id="invalid-input" name="invalid-input" aria-label="Basic date picker example" />
  </div>
  <div class="pf-c-date-picker__helper-text pf-m-error">Invalid date selected.</div>
</div>
```

### Expanded

```html
<div class="pf-c-date-picker">
  <div class="pf-c-date-picker__input">
    <input class="pf-c-form-control pf-m-icon pf-m-calendar pf-m-expanded" type="text" value="03/05/2020" id="expanded-input" name="expanded-input" aria-label="Expanded date picker example" />
  </div>
  <div class="pf-c-date-picker__calendar">Calendar</div>
</div>
```

## Documentation

### Usage

| Class                            | Applied to                       | Outcome                                                                                                      |
| -------------------------------- | -------------------------------- | ------------------------------------------------------------------------------------------------------------ |
| `.pf-c-date-picker`              | `<div>`                          | Initiates the date picker component. **Required**                                                            |
| `.pf-c-date-picker__input`       | `<div>`                          | Initiates the date picker input container. **Required**                                                      |
| `.pf-c-date-picker__helper-text` | `<div>`                          | Initiates the date picker helper text.                                                                       |
| `.pf-c-date-picker__calendar`    | `<div>`                          | Initiates an optional date picker calendar container. **Note:** Required in the react date picker component. |
| `.pf-m-top`                      | `.pf-c-date-picker`              | Modifies to display the calendar above the date picker.                                                      |
| `.pf-m-error`                    | `.pf-c-date-picker__helper-text` | Modifies the helper text for the invalid/error state.                                                        |
| `.pf-m-align-right`              | `.pf-c-date-picker__calendar`    | Modifies the calendar to align the calendar to the right edge of the date picker.                            |
