---
id: Alert group
section: components
cssPrefix: pf-c-alert-group
---## Examples

### Static alert group

```html
<ul class="pf-c-alert-group">
  <li class="pf-c-alert-group__item">
    <div class="pf-c-alert pf-m-inline pf-m-success" aria-label="Success alert">
      <div class="pf-c-alert__icon">
        <i class="fas fa-fw fa-check-circle" aria-hidden="true"></i>
      </div>
      <p class="pf-c-alert__title">
        <strong>
          <span class="pf-screen-reader">Success alert:</span>Success alert title</strong>
      </p>
    </div>
  </li>
  <li class="pf-c-alert-group__item">
    <div class="pf-c-alert pf-m-inline pf-m-danger" aria-label="Danger alert">
      <div class="pf-c-alert__icon">
        <i class="fas fa-fw fa-exclamation-circle" aria-hidden="true"></i>
      </div>
      <p class="pf-c-alert__title">
        <strong>
          <span class="pf-screen-reader">Danger alert:</span>Danger alert title</strong>
      </p>
    </div>
  </li>
  <li class="pf-c-alert-group__item">
    <div class="pf-c-alert pf-m-inline pf-m-info" aria-label="Information alert">
      <div class="pf-c-alert__icon">
        <i class="fas fa-fw fa-info-circle" aria-hidden="true"></i>
      </div>
      <p class="pf-c-alert__title">
        <strong>
          <span class="pf-screen-reader">Info alert:</span>Info alert title</strong>
      </p>
      <div class="pf-c-alert__description">
        <p>Info alert description.
          <a href="#">This is a link.</a>
        </p>
      </div>
    </div>
  </li>
</ul>
```

### Overview

`.pf-c-alert-group` is optional when only one alert is needed. It becomes required when more than one alert is used in a list.

### Usage

| Attribute                 | Applied to | Outcome                                        |
| ------------------------- | ---------- | ---------------------------------------------- |
| `.pf-c-alert-group`       | `<ul>`     | Creates an alert group component. **Required** |
| `.pf-c-alert-group__item` | `<li>`     | Creates an alert group item. **Required**      |

### Toast alert group

```html isFullscreen
<ul class="pf-c-alert-group pf-m-toast">
  <li class="pf-c-alert-group__item">
    <div class="pf-c-alert pf-m-success" aria-label="Success toast alert">
      <div class="pf-c-alert__icon">
        <i class="fas fa-fw fa-check-circle" aria-hidden="true"></i>
      </div>
      <p class="pf-c-alert__title" id="alert_one_title">
        <strong>
          <span class="pf-screen-reader">Success alert:</span>Success toast alert title</strong>
      </p>
      <div class="pf-c-alert__action">
        <button class="pf-c-button pf-m-plain" type="button" aria-label="Close success alert: Success alert title">
          <i class="fas fa-times" aria-hidden="true"></i>
        </button>
      </div>
    </div>
  </li>
  <li class="pf-c-alert-group__item">
    <div class="pf-c-alert pf-m-danger" aria-label="Danger toast alert">
      <div class="pf-c-alert__icon">
        <i class="fas fa-fw fa-exclamation-circle" aria-hidden="true"></i>
      </div>
      <p class="pf-c-alert__title" id="alert_two_title">
        <strong>
          <span class="pf-screen-reader">Danger alert:</span>Danger toast alert title</strong>
      </p>
      <div class="pf-c-alert__action">
        <button class="pf-c-button pf-m-plain" type="button" aria-label="Close success alert: Success alert title">
          <i class="fas fa-times" aria-hidden="true"></i>
        </button>
      </div>
    </div>
  </li>
  <li class="pf-c-alert-group__item">
    <div class="pf-c-alert pf-m-info" aria-label="Information toast alert">
      <div class="pf-c-alert__icon">
        <i class="fas fa-fw fa-info-circle" aria-hidden="true"></i>
      </div>
      <p class="pf-c-alert__title" id="alert_three_title">
        <strong>
          <span class="pf-screen-reader">Info alert:</span>Info toast alert title</strong>
      </p>
      <div class="pf-c-alert__description">
        <p>Info toast alert description.
          <a href="#">This is a link.</a>
        </p>
      </div>
      <div class="pf-c-alert__action">
        <button class="pf-c-button pf-m-plain" type="button" aria-label="Close success alert: Success alert title">
          <i class="fas fa-times" aria-hidden="true"></i>
        </button>
      </div>
    </div>
  </li>
</ul>
```

### Overview

An alert group that includes the `.pf-m-toast` modifier becomes a toast alert group with unique positioning in the top-right corner of the window. `.pf-c-alert-group` is required to create a toast alert group.

Every toast alert must include a close button to dismiss the alert.

### Modifiers

| Class         | Applied to          | Outcome                                        |
| ------------- | ------------------- | ---------------------------------------------- |
| `.pf-m-toast` | `.pf-c-alert-group` | Applies toast alert styling to an alert group. |

## Documentation

### Overview

Alert groups are used to contain and align consecutive alerts. Groups can either be embedded alongside a page's content or in the top-right corner as a toast group using the `.pf-m-toast` modifier.
