import { Query, QueryCache, QueryKey } from 'react-query';
export interface DehydratedQueryConfig {
    cacheTime?: number;
}
export interface DehydratedQuery {
    queryKey: QueryKey;
    data?: unknown;
    updatedAt: number;
    config: DehydratedQueryConfig;
}
export interface DehydratedState {
    queries: Array<DehydratedQuery>;
}
export declare type ShouldDehydrateFunction = <TResult, TError = unknown>(query: Query<TResult, TError>) => boolean;
export interface DehydrateConfig {
    shouldDehydrate?: ShouldDehydrateFunction;
}
export declare function dehydrate(queryCache: QueryCache, dehydrateConfig?: DehydrateConfig): DehydratedState;
export declare function hydrate(queryCache: QueryCache, dehydratedState: unknown): void;
