import { QueryConfig, QueryStatus, QueryKey } from './types';
export declare type DataUpdateFunction<TInput, TOutput> = (input: TInput) => TOutput;
export declare type Updater<TInput, TOutput> = TOutput | DataUpdateFunction<TInput, TOutput>;
declare type ConsoleFunction = (...args: any[]) => void;
export interface ConsoleObject {
    log: ConsoleFunction;
    warn: ConsoleFunction;
    error: ConsoleFunction;
}
interface Cancelable {
    cancel(): void;
}
export declare class CancelledError {
    silent?: boolean;
    constructor(silent?: boolean);
}
export declare function uid(): number;
export declare const isServer: boolean;
export declare function noop(): undefined;
export declare let Console: ConsoleObject;
export declare function setConsole(c: ConsoleObject): void;
export declare function functionalUpdate<TInput, TOutput>(updater: Updater<TInput, TOutput>, input: TInput): TOutput;
export declare function stableStringify(value: any): string;
export declare function deepIncludes(a: any, b: any): boolean;
export declare function isValidTimeout(value: any): value is number;
export declare function isDocumentVisible(): boolean;
export declare function isOnline(): boolean;
export declare function getQueryArgs<TResult, TError, TOptions = undefined>(arg1: any, arg2?: any, arg3?: any, arg4?: any): [QueryKey, QueryConfig<TResult, TError>, TOptions];
/**
 * This function returns `a` if `b` is deeply equal.
 * If not, it will replace any deeply equal children of `b` with those of `a`.
 * This can be used for structural sharing between JSON values for example.
 */
export declare function replaceEqualDeep<T>(a: unknown, b: T): T;
export declare function isPlainObject(o: any): o is Object;
export declare function isCancelable(value: any): value is Cancelable;
export declare function isError(value: any): value is Error;
export declare function isCancelledError(value: any): value is CancelledError;
export declare function sleep(timeout: number): Promise<void>;
export declare function getStatusProps<T extends QueryStatus>(status: T): {
    status: T;
    isLoading: boolean;
    isSuccess: boolean;
    isError: boolean;
    isIdle: boolean;
};
export declare function createSetHandler(fn: () => void): (callback: (handler: () => void) => void) => void;
/**
 * Schedules a microtask.
 * This can be useful to schedule state updates after rendering.
 */
export declare function scheduleMicrotask(callback: () => void): void;
declare type BatchUpdateFunction = (callback: () => void) => void;
export declare function setBatchedUpdates(fn: BatchUpdateFunction): void;
export declare function getBatchedUpdates(): BatchUpdateFunction;
export {};
