// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/actions/type/datetime_range.proto

package date_time_range

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	datetime "google.golang.org/genproto/googleapis/type/datetime"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Represents a date and time range. This can represent:
//
// * A range between points in time with time zone or offset, e.g. the duration
//   of a flight which starts in the "America/New_York" time zone and ends in
//   the "Australia/Sydney" time zone
// * A range between points in time without time zone/offset info, e.g. an
//   appointment in local time
// * A range starting at a specific date and time, e.g. the range of time which
//   can be measured in milliseconds since the Unix epoch (period starting with
//   1970-01-01T00:00:00Z)
// * A range ending at a specific date and time, e.g. range of time before
//   a deadline
//
// When considering whether a DateTime falls within a DateTimeRange, the start
// of the range is inclusive and the end is exclusive.
//
// While [google.type.DateTime][google.type.DateTime] allows zero years, DateTimeRange does not.
// Year must always be non-zero.
//
// When both start and end are set, either both or neither must have a
// time_offset. When set, time_offset can be specified by either utc_offset or
// time_zone and must match for start and end, that is if start has utc_offset
// set then end must also have utc_offset set. The values of utc_offset or
// time_zone need not be the same for start and end.
//
// When both start and end are set, start must be chronologically less than or
// equal to end. When start and end are equal, the range is empty.
//
// The semantics of start and end are the same as those of
// [google.type.DateTime][google.type.DateTime].
type DateTimeRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// DateTime at which the date range begins. If unset, the range has no
	// beginning bound.
	Start *datetime.DateTime `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	// DateTime at which the date range ends. If unset, the range has no ending
	// bound.
	End *datetime.DateTime `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *DateTimeRange) Reset() {
	*x = DateTimeRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_type_datetime_range_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DateTimeRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DateTimeRange) ProtoMessage() {}

func (x *DateTimeRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_type_datetime_range_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DateTimeRange.ProtoReflect.Descriptor instead.
func (*DateTimeRange) Descriptor() ([]byte, []int) {
	return file_google_actions_type_datetime_range_proto_rawDescGZIP(), []int{0}
}

func (x *DateTimeRange) GetStart() *datetime.DateTime {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *DateTimeRange) GetEnd() *datetime.DateTime {
	if x != nil {
		return x.End
	}
	return nil
}

var File_google_actions_type_datetime_range_proto protoreflect.FileDescriptor

var file_google_actions_type_datetime_range_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72,
	0x61, 0x6e, 0x67, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x13, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x1a,
	0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74,
	0x65, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x65, 0x0a, 0x0d, 0x44,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x2b, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x27, 0x0a, 0x03, 0x65, 0x6e, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x03, 0x65,
	0x6e, 0x64, 0x42, 0x83, 0x01, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x42, 0x12,
	0x44, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x2f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0x3b, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65,
	0xa2, 0x02, 0x05, 0x41, 0x4f, 0x47, 0x54, 0x50, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_actions_type_datetime_range_proto_rawDescOnce sync.Once
	file_google_actions_type_datetime_range_proto_rawDescData = file_google_actions_type_datetime_range_proto_rawDesc
)

func file_google_actions_type_datetime_range_proto_rawDescGZIP() []byte {
	file_google_actions_type_datetime_range_proto_rawDescOnce.Do(func() {
		file_google_actions_type_datetime_range_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_type_datetime_range_proto_rawDescData)
	})
	return file_google_actions_type_datetime_range_proto_rawDescData
}

var file_google_actions_type_datetime_range_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_actions_type_datetime_range_proto_goTypes = []interface{}{
	(*DateTimeRange)(nil),     // 0: google.actions.type.DateTimeRange
	(*datetime.DateTime)(nil), // 1: google.type.DateTime
}
var file_google_actions_type_datetime_range_proto_depIdxs = []int32{
	1, // 0: google.actions.type.DateTimeRange.start:type_name -> google.type.DateTime
	1, // 1: google.actions.type.DateTimeRange.end:type_name -> google.type.DateTime
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_actions_type_datetime_range_proto_init() }
func file_google_actions_type_datetime_range_proto_init() {
	if File_google_actions_type_datetime_range_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_actions_type_datetime_range_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DateTimeRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_type_datetime_range_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_actions_type_datetime_range_proto_goTypes,
		DependencyIndexes: file_google_actions_type_datetime_range_proto_depIdxs,
		MessageInfos:      file_google_actions_type_datetime_range_proto_msgTypes,
	}.Build()
	File_google_actions_type_datetime_range_proto = out.File
	file_google_actions_type_datetime_range_proto_rawDesc = nil
	file_google_actions_type_datetime_range_proto_goTypes = nil
	file_google_actions_type_datetime_range_proto_depIdxs = nil
}
