---
title: Velero 1.2 Sets Sail by Shifting Plugins Out of Tree, Adding a Structural Schema, and Sharpening Usability
excerpt: With this release, we’ve focused on extracting in-tree cloud provider plugins into their own repositories, making further usability improvements to the restic integration, preparing for the general availability of Kubernetes custom resource definitions (CRDs) by adding a structural schema to our CRDs, and many other new features and usability improvements.
author_name: Steve Kriss
slug: Velero-1.2-Sets-Sail
categories: ['velero','release']
image: /img/posts/sailboat.jpg
# Tag should match author to drive author pages
tags: ['Velero Team', 'Steve Kriss']
---
Velero continues to evolve with the release of version 1.2. With this release, we’ve focused on extracting in-tree cloud provider plugins into their own repositories, making further usability improvements to the restic integration, preparing for the general availability of Kubernetes custom resource definitions (CRDs) by adding a structural schema to our CRDs, and many other new features and usability improvements.

Let’s take a look at the highlights for this release.

## Moving Cloud Provider Plugins Out of Tree

Velero has had built-in support for AWS, Microsoft Azure, and Google Cloud Platform (GCP)  since day 1. When Velero moved to a plugin architecture for object store providers and volume snapshotters in version 0.6, the code for these three providers was converted to use the plugin interface provided by this new architecture, but the cloud provider code still remained inside the Velero codebase. This put the AWS, Azure, and GCP plugins in a different position compared with other providers’ plugins, since they automatically shipped with the Velero binary and could include documentation in-tree.

With version 1.2, we’ve extracted the AWS, Azure, and GCP plugins into their own repositories, one per provider. We now also publish one plugin image per provider. This change brings these providers to parity with other providers’ plugin implementations, reduces the size of the core Velero binary by not requiring each provider’s SDK to be included, and opens the door for the plugins to be maintained and released independently of core Velero.

## Restic Integration Improvements

We’ve continued to work on improving Velero’s restic integration. With this release, we’ve made the following enhancements:

- Restic backup and restore progress is now captured during execution and visible to the user through the `velero backup/restore describe --details` command. The details are updated every 10 seconds. This provides a new level of visibility into restic operations for users.
- Restic backups of persistent volume claims (PVCs) now remain incremental across the rescheduling of a pod. Previously, if the pod using a PVC was rescheduled, the next restic backup would require a full rescan of the volume’s contents. This improvement potentially makes such backups significantly faster.
- Read-write-many volumes are no longer backed up once for every pod using the volume, but instead just once per Velero backup. This improvement speeds up backups and prevents potential restore issues due to multiple copies of the backup being processed simultaneously.


## Clone PVs When Cloning a Namespace

Before version 1.2, you could clone a Kubernetes namespace by backing it up and then restoring it to a different namespace in the same cluster by using the `--namespace-mappings` flag with the `velero restore create` command. However, in this scenario, Velero was unable to clone persistent volumes used by the namespace, leading to errors for users.

In version 1.2, Velero automatically detects when you are trying to clone an existing namespace, and clones the persistent volumes used by the namespace as well. This doesn’t require the user to specify any additional flags for the `velero restore create` command.  This change lets you fully achieve your goal of cloning namespaces using persistent storage within a cluster.

## Improved Server-Side Encryption Support

To help you secure your important backup data, we’ve added support for more forms of server-side encryption of backup data on both AWS and GCP. Specifically:

- On AWS, Velero now supports Amazon S3-managed encryption keys (SSE-S3), which uses AES256 encryption, by specifying `serverSideEncryption: AES256` in a backup storage location’s config.
- On GCP, Velero now supports using a specific Cloud KMS key for server-side encryption by specifying `kmsKeyName: <key name>` in a backup storage location’s config.

## CRD Structural Schema

In Kubernetes 1.16, custom resource definitions (CRDs) reached general availability. Structural schemas are required for CRDs created in the `apiextensions.k8s.io/v1` API group. Velero now defines a structural schema for each of its CRDs and automatically applies it the user runs the `velero install` command.  The structural schemas enable the user to get quicker feedback when their backup, restore, or schedule request is invalid, so they can immediately remediate their request.

## And More

There are too many new features and improvements to cover in this short blog post. For full details on all of the changes, see the [full changelog](https://github.com/vmware-tanzu/velero/blob/main/changelogs/CHANGELOG-1.2.md).

## Community Contributors

Velero’s user and contributor community continues to grow, and it is a huge part of this project’s success. This release includes many community contributions, including from (GitHub handles listed):

- [@betta1](https://github.com/betta1)
- [@lintongj](https://github.com/lintongj)
- [@spiffcs](https://github.com/spiffcs)
- [@s12chung](https://github.com/s12chung)
- [@boxcee](https://github.com/boxcee)
- [@andyzhangx](https://github.com/andyzhangx)
- [@sseago](https://github.com/sseago)
- [@Frank51](https://github.com/Frank51)
- [@alexander-demichev](https://github.com/alexander-demichev)

**Thank you for helping improve the Velero project!**

## Catch us at KubeCon

If you’re going to KubeCon + CloudNativeCon North America 2019 in San Diego, come hang out with us.! The Velero maintainers will all be attending and would love to chat with you. We’ll be having a Velero community lunch on Wednesday, November 20, at 12:30PM in the convention center.  Come to the VMware booth or look for the Velero signs in the lunch area.

Check out these talks related to Velero:

- [CSI Volume Snapshots: On the Way to Faster and Better Backups](https://sched.co/UaXR), by Adnan Abdulhussein and Nolan Brubaker, both from VMware (and core maintainers)
- [How to Backup and Restore Your Kubernetes Cluster](https://sched.co/UaZN), by Annette Clewett and Dylan Murray, both from Red Hat (Dylan is a Velero contributor)

## Join the Movement – Contribute!

Velero is better because of our contributors and maintainers. It is because of you that we can bring great software to the community. Please join us during our [online community meetings every Tuesday](https://velero.io/community/) and catch up with past meetings on YouTube on the [Velero Community Meetings playlist](https://www.youtube.com/watch?v=nc48ocI-6go&list=PL7bmigfV0EqQRysvqvqOtRNk4L5S7uqwM).

You can always find the latest project information at [velero.io](https://velero.io). Look for issues on GitHub marked [Good first issue](https://github.com/vmware-tanzu/velero/issues?q=is:open+is:issue+label:%22Good+first+issue%22) or [Help wanted](https://github.com/vmware-tanzu/velero/issues?utf8=✓&q=is:open+is:issue+label:%22Help+wanted%22+) if you want to roll up your sleeves and write some code with us.

You can chat with us on [Kubernetes Slack in the #velero channel](https://kubernetes.slack.com/messages/C6VCGP4MT) and follow us on Twitter at [@projectvelero](https://twitter.com/projectvelero).
