// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/ads/googleads/v4/common/segments.proto

package common

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v4/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Segment only fields.
type Segments struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Ad network type.
	AdNetworkType enums.AdNetworkTypeEnum_AdNetworkType `protobuf:"varint,3,opt,name=ad_network_type,json=adNetworkType,proto3,enum=google.ads.googleads.v4.enums.AdNetworkTypeEnum_AdNetworkType" json:"ad_network_type,omitempty"`
	// Click type.
	ClickType enums.ClickTypeEnum_ClickType `protobuf:"varint,26,opt,name=click_type,json=clickType,proto3,enum=google.ads.googleads.v4.enums.ClickTypeEnum_ClickType" json:"click_type,omitempty"`
	// Resource name of the conversion action.
	ConversionAction *wrappers.StringValue `protobuf:"bytes,52,opt,name=conversion_action,json=conversionAction,proto3" json:"conversion_action,omitempty"`
	// Conversion action category.
	ConversionActionCategory enums.ConversionActionCategoryEnum_ConversionActionCategory `protobuf:"varint,53,opt,name=conversion_action_category,json=conversionActionCategory,proto3,enum=google.ads.googleads.v4.enums.ConversionActionCategoryEnum_ConversionActionCategory" json:"conversion_action_category,omitempty"`
	// Conversion action name.
	ConversionActionName *wrappers.StringValue `protobuf:"bytes,54,opt,name=conversion_action_name,json=conversionActionName,proto3" json:"conversion_action_name,omitempty"`
	// This segments your conversion columns by the original conversion and
	// conversion value vs. the delta if conversions were adjusted. False row has
	// the data as originally stated; While true row has the delta between data
	// now and the data as originally stated. Summing the two together results
	// post-adjustment data.
	ConversionAdjustment *wrappers.BoolValue `protobuf:"bytes,27,opt,name=conversion_adjustment,json=conversionAdjustment,proto3" json:"conversion_adjustment,omitempty"`
	// Conversion attribution event type.
	ConversionAttributionEventType enums.ConversionAttributionEventTypeEnum_ConversionAttributionEventType `protobuf:"varint,2,opt,name=conversion_attribution_event_type,json=conversionAttributionEventType,proto3,enum=google.ads.googleads.v4.enums.ConversionAttributionEventTypeEnum_ConversionAttributionEventType" json:"conversion_attribution_event_type,omitempty"`
	// An enum value representing the number of days between the impression and
	// the conversion.
	ConversionLagBucket enums.ConversionLagBucketEnum_ConversionLagBucket `protobuf:"varint,50,opt,name=conversion_lag_bucket,json=conversionLagBucket,proto3,enum=google.ads.googleads.v4.enums.ConversionLagBucketEnum_ConversionLagBucket" json:"conversion_lag_bucket,omitempty"`
	// An enum value representing the number of days between the impression and
	// the conversion or between the impression and adjustments to the conversion.
	ConversionOrAdjustmentLagBucket enums.ConversionOrAdjustmentLagBucketEnum_ConversionOrAdjustmentLagBucket `protobuf:"varint,51,opt,name=conversion_or_adjustment_lag_bucket,json=conversionOrAdjustmentLagBucket,proto3,enum=google.ads.googleads.v4.enums.ConversionOrAdjustmentLagBucketEnum_ConversionOrAdjustmentLagBucket" json:"conversion_or_adjustment_lag_bucket,omitempty"`
	// Date to which metrics apply.
	// yyyy-MM-dd format, e.g., 2018-04-17.
	Date *wrappers.StringValue `protobuf:"bytes,4,opt,name=date,proto3" json:"date,omitempty"`
	// Day of the week, e.g., MONDAY.
	DayOfWeek enums.DayOfWeekEnum_DayOfWeek `protobuf:"varint,5,opt,name=day_of_week,json=dayOfWeek,proto3,enum=google.ads.googleads.v4.enums.DayOfWeekEnum_DayOfWeek" json:"day_of_week,omitempty"`
	// Device to which metrics apply.
	Device enums.DeviceEnum_Device `protobuf:"varint,1,opt,name=device,proto3,enum=google.ads.googleads.v4.enums.DeviceEnum_Device" json:"device,omitempty"`
	// External conversion source.
	ExternalConversionSource enums.ExternalConversionSourceEnum_ExternalConversionSource `protobuf:"varint,55,opt,name=external_conversion_source,json=externalConversionSource,proto3,enum=google.ads.googleads.v4.enums.ExternalConversionSourceEnum_ExternalConversionSource" json:"external_conversion_source,omitempty"`
	// Resource name of the geo target constant that represents an airport.
	GeoTargetAirport *wrappers.StringValue `protobuf:"bytes,65,opt,name=geo_target_airport,json=geoTargetAirport,proto3" json:"geo_target_airport,omitempty"`
	// Resource name of the geo target constant that represents a canton.
	GeoTargetCanton *wrappers.StringValue `protobuf:"bytes,76,opt,name=geo_target_canton,json=geoTargetCanton,proto3" json:"geo_target_canton,omitempty"`
	// Resource name of the geo target constant that represents a city.
	GeoTargetCity *wrappers.StringValue `protobuf:"bytes,62,opt,name=geo_target_city,json=geoTargetCity,proto3" json:"geo_target_city,omitempty"`
	// Resource name of the geo target constant that represents a country.
	GeoTargetCountry *wrappers.StringValue `protobuf:"bytes,77,opt,name=geo_target_country,json=geoTargetCountry,proto3" json:"geo_target_country,omitempty"`
	// Resource name of the geo target constant that represents a county.
	GeoTargetCounty *wrappers.StringValue `protobuf:"bytes,68,opt,name=geo_target_county,json=geoTargetCounty,proto3" json:"geo_target_county,omitempty"`
	// Resource name of the geo target constant that represents a district.
	GeoTargetDistrict *wrappers.StringValue `protobuf:"bytes,69,opt,name=geo_target_district,json=geoTargetDistrict,proto3" json:"geo_target_district,omitempty"`
	// Resource name of the geo target constant that represents a metro.
	GeoTargetMetro *wrappers.StringValue `protobuf:"bytes,63,opt,name=geo_target_metro,json=geoTargetMetro,proto3" json:"geo_target_metro,omitempty"`
	// Resource name of the geo target constant that represents the most
	// specific location.
	GeoTargetMostSpecificLocation *wrappers.StringValue `protobuf:"bytes,72,opt,name=geo_target_most_specific_location,json=geoTargetMostSpecificLocation,proto3" json:"geo_target_most_specific_location,omitempty"`
	// Resource name of the geo target constant that represents a postal code.
	GeoTargetPostalCode *wrappers.StringValue `protobuf:"bytes,71,opt,name=geo_target_postal_code,json=geoTargetPostalCode,proto3" json:"geo_target_postal_code,omitempty"`
	// Resource name of the geo target constant that represents a province.
	GeoTargetProvince *wrappers.StringValue `protobuf:"bytes,75,opt,name=geo_target_province,json=geoTargetProvince,proto3" json:"geo_target_province,omitempty"`
	// Resource name of the geo target constant that represents a region.
	GeoTargetRegion *wrappers.StringValue `protobuf:"bytes,64,opt,name=geo_target_region,json=geoTargetRegion,proto3" json:"geo_target_region,omitempty"`
	// Resource name of the geo target constant that represents a state.
	GeoTargetState *wrappers.StringValue `protobuf:"bytes,67,opt,name=geo_target_state,json=geoTargetState,proto3" json:"geo_target_state,omitempty"`
	// Hotel booking window in days.
	HotelBookingWindowDays *wrappers.Int64Value `protobuf:"bytes,6,opt,name=hotel_booking_window_days,json=hotelBookingWindowDays,proto3" json:"hotel_booking_window_days,omitempty"`
	// Hotel center ID.
	HotelCenterId *wrappers.Int64Value `protobuf:"bytes,7,opt,name=hotel_center_id,json=hotelCenterId,proto3" json:"hotel_center_id,omitempty"`
	// Hotel check-in date. Formatted as yyyy-MM-dd.
	HotelCheckInDate *wrappers.StringValue `protobuf:"bytes,8,opt,name=hotel_check_in_date,json=hotelCheckInDate,proto3" json:"hotel_check_in_date,omitempty"`
	// Hotel check-in day of week.
	HotelCheckInDayOfWeek enums.DayOfWeekEnum_DayOfWeek `protobuf:"varint,9,opt,name=hotel_check_in_day_of_week,json=hotelCheckInDayOfWeek,proto3,enum=google.ads.googleads.v4.enums.DayOfWeekEnum_DayOfWeek" json:"hotel_check_in_day_of_week,omitempty"`
	// Hotel city.
	HotelCity *wrappers.StringValue `protobuf:"bytes,10,opt,name=hotel_city,json=hotelCity,proto3" json:"hotel_city,omitempty"`
	// Hotel class.
	HotelClass *wrappers.Int32Value `protobuf:"bytes,11,opt,name=hotel_class,json=hotelClass,proto3" json:"hotel_class,omitempty"`
	// Hotel country.
	HotelCountry *wrappers.StringValue `protobuf:"bytes,12,opt,name=hotel_country,json=hotelCountry,proto3" json:"hotel_country,omitempty"`
	// Hotel date selection type.
	HotelDateSelectionType enums.HotelDateSelectionTypeEnum_HotelDateSelectionType `protobuf:"varint,13,opt,name=hotel_date_selection_type,json=hotelDateSelectionType,proto3,enum=google.ads.googleads.v4.enums.HotelDateSelectionTypeEnum_HotelDateSelectionType" json:"hotel_date_selection_type,omitempty"`
	// Hotel length of stay.
	HotelLengthOfStay *wrappers.Int32Value `protobuf:"bytes,14,opt,name=hotel_length_of_stay,json=hotelLengthOfStay,proto3" json:"hotel_length_of_stay,omitempty"`
	// Hotel rate rule ID.
	HotelRateRuleId *wrappers.StringValue `protobuf:"bytes,73,opt,name=hotel_rate_rule_id,json=hotelRateRuleId,proto3" json:"hotel_rate_rule_id,omitempty"`
	// Hotel rate type.
	HotelRateType enums.HotelRateTypeEnum_HotelRateType `protobuf:"varint,74,opt,name=hotel_rate_type,json=hotelRateType,proto3,enum=google.ads.googleads.v4.enums.HotelRateTypeEnum_HotelRateType" json:"hotel_rate_type,omitempty"`
	// Hotel price bucket.
	HotelPriceBucket enums.HotelPriceBucketEnum_HotelPriceBucket `protobuf:"varint,78,opt,name=hotel_price_bucket,json=hotelPriceBucket,proto3,enum=google.ads.googleads.v4.enums.HotelPriceBucketEnum_HotelPriceBucket" json:"hotel_price_bucket,omitempty"`
	// Hotel state.
	HotelState *wrappers.StringValue `protobuf:"bytes,15,opt,name=hotel_state,json=hotelState,proto3" json:"hotel_state,omitempty"`
	// Hour of day as a number between 0 and 23, inclusive.
	Hour *wrappers.Int32Value `protobuf:"bytes,16,opt,name=hour,proto3" json:"hour,omitempty"`
	// Only used with feed item metrics.
	// Indicates whether the interaction metrics occurred on the feed item itself
	// or a different extension or ad unit.
	InteractionOnThisExtension *wrappers.BoolValue `protobuf:"bytes,49,opt,name=interaction_on_this_extension,json=interactionOnThisExtension,proto3" json:"interaction_on_this_extension,omitempty"`
	// Keyword criterion.
	Keyword *Keyword `protobuf:"bytes,61,opt,name=keyword,proto3" json:"keyword,omitempty"`
	// Month as represented by the date of the first day of a month. Formatted as
	// yyyy-MM-dd.
	Month *wrappers.StringValue `protobuf:"bytes,17,opt,name=month,proto3" json:"month,omitempty"`
	// Month of the year, e.g., January.
	MonthOfYear enums.MonthOfYearEnum_MonthOfYear `protobuf:"varint,18,opt,name=month_of_year,json=monthOfYear,proto3,enum=google.ads.googleads.v4.enums.MonthOfYearEnum_MonthOfYear" json:"month_of_year,omitempty"`
	// Partner hotel ID.
	PartnerHotelId *wrappers.StringValue `protobuf:"bytes,19,opt,name=partner_hotel_id,json=partnerHotelId,proto3" json:"partner_hotel_id,omitempty"`
	// Placeholder type. This is only used with feed item metrics.
	PlaceholderType enums.PlaceholderTypeEnum_PlaceholderType `protobuf:"varint,20,opt,name=placeholder_type,json=placeholderType,proto3,enum=google.ads.googleads.v4.enums.PlaceholderTypeEnum_PlaceholderType" json:"placeholder_type,omitempty"`
	// Aggregator ID of the product.
	ProductAggregatorId *wrappers.UInt64Value `protobuf:"bytes,28,opt,name=product_aggregator_id,json=productAggregatorId,proto3" json:"product_aggregator_id,omitempty"`
	// Bidding category (level 1) of the product.
	ProductBiddingCategoryLevel1 *wrappers.StringValue `protobuf:"bytes,56,opt,name=product_bidding_category_level1,json=productBiddingCategoryLevel1,proto3" json:"product_bidding_category_level1,omitempty"`
	// Bidding category (level 2) of the product.
	ProductBiddingCategoryLevel2 *wrappers.StringValue `protobuf:"bytes,57,opt,name=product_bidding_category_level2,json=productBiddingCategoryLevel2,proto3" json:"product_bidding_category_level2,omitempty"`
	// Bidding category (level 3) of the product.
	ProductBiddingCategoryLevel3 *wrappers.StringValue `protobuf:"bytes,58,opt,name=product_bidding_category_level3,json=productBiddingCategoryLevel3,proto3" json:"product_bidding_category_level3,omitempty"`
	// Bidding category (level 4) of the product.
	ProductBiddingCategoryLevel4 *wrappers.StringValue `protobuf:"bytes,59,opt,name=product_bidding_category_level4,json=productBiddingCategoryLevel4,proto3" json:"product_bidding_category_level4,omitempty"`
	// Bidding category (level 5) of the product.
	ProductBiddingCategoryLevel5 *wrappers.StringValue `protobuf:"bytes,60,opt,name=product_bidding_category_level5,json=productBiddingCategoryLevel5,proto3" json:"product_bidding_category_level5,omitempty"`
	// Brand of the product.
	ProductBrand *wrappers.StringValue `protobuf:"bytes,29,opt,name=product_brand,json=productBrand,proto3" json:"product_brand,omitempty"`
	// Channel of the product.
	ProductChannel enums.ProductChannelEnum_ProductChannel `protobuf:"varint,30,opt,name=product_channel,json=productChannel,proto3,enum=google.ads.googleads.v4.enums.ProductChannelEnum_ProductChannel" json:"product_channel,omitempty"`
	// Channel exclusivity of the product.
	ProductChannelExclusivity enums.ProductChannelExclusivityEnum_ProductChannelExclusivity `protobuf:"varint,31,opt,name=product_channel_exclusivity,json=productChannelExclusivity,proto3,enum=google.ads.googleads.v4.enums.ProductChannelExclusivityEnum_ProductChannelExclusivity" json:"product_channel_exclusivity,omitempty"`
	// Condition of the product.
	ProductCondition enums.ProductConditionEnum_ProductCondition `protobuf:"varint,32,opt,name=product_condition,json=productCondition,proto3,enum=google.ads.googleads.v4.enums.ProductConditionEnum_ProductCondition" json:"product_condition,omitempty"`
	// Resource name of the geo target constant for the country of sale of the
	// product.
	ProductCountry *wrappers.StringValue `protobuf:"bytes,33,opt,name=product_country,json=productCountry,proto3" json:"product_country,omitempty"`
	// Custom attribute 0 of the product.
	ProductCustomAttribute0 *wrappers.StringValue `protobuf:"bytes,34,opt,name=product_custom_attribute0,json=productCustomAttribute0,proto3" json:"product_custom_attribute0,omitempty"`
	// Custom attribute 1 of the product.
	ProductCustomAttribute1 *wrappers.StringValue `protobuf:"bytes,35,opt,name=product_custom_attribute1,json=productCustomAttribute1,proto3" json:"product_custom_attribute1,omitempty"`
	// Custom attribute 2 of the product.
	ProductCustomAttribute2 *wrappers.StringValue `protobuf:"bytes,36,opt,name=product_custom_attribute2,json=productCustomAttribute2,proto3" json:"product_custom_attribute2,omitempty"`
	// Custom attribute 3 of the product.
	ProductCustomAttribute3 *wrappers.StringValue `protobuf:"bytes,37,opt,name=product_custom_attribute3,json=productCustomAttribute3,proto3" json:"product_custom_attribute3,omitempty"`
	// Custom attribute 4 of the product.
	ProductCustomAttribute4 *wrappers.StringValue `protobuf:"bytes,38,opt,name=product_custom_attribute4,json=productCustomAttribute4,proto3" json:"product_custom_attribute4,omitempty"`
	// Item ID of the product.
	ProductItemId *wrappers.StringValue `protobuf:"bytes,39,opt,name=product_item_id,json=productItemId,proto3" json:"product_item_id,omitempty"`
	// Resource name of the language constant for the language of the product.
	ProductLanguage *wrappers.StringValue `protobuf:"bytes,40,opt,name=product_language,json=productLanguage,proto3" json:"product_language,omitempty"`
	// Merchant ID of the product.
	ProductMerchantId *wrappers.UInt64Value `protobuf:"bytes,41,opt,name=product_merchant_id,json=productMerchantId,proto3" json:"product_merchant_id,omitempty"`
	// Store ID of the product.
	ProductStoreId *wrappers.StringValue `protobuf:"bytes,42,opt,name=product_store_id,json=productStoreId,proto3" json:"product_store_id,omitempty"`
	// Title of the product.
	ProductTitle *wrappers.StringValue `protobuf:"bytes,43,opt,name=product_title,json=productTitle,proto3" json:"product_title,omitempty"`
	// Type (level 1) of the product.
	ProductTypeL1 *wrappers.StringValue `protobuf:"bytes,44,opt,name=product_type_l1,json=productTypeL1,proto3" json:"product_type_l1,omitempty"`
	// Type (level 2) of the product.
	ProductTypeL2 *wrappers.StringValue `protobuf:"bytes,45,opt,name=product_type_l2,json=productTypeL2,proto3" json:"product_type_l2,omitempty"`
	// Type (level 3) of the product.
	ProductTypeL3 *wrappers.StringValue `protobuf:"bytes,46,opt,name=product_type_l3,json=productTypeL3,proto3" json:"product_type_l3,omitempty"`
	// Type (level 4) of the product.
	ProductTypeL4 *wrappers.StringValue `protobuf:"bytes,47,opt,name=product_type_l4,json=productTypeL4,proto3" json:"product_type_l4,omitempty"`
	// Type (level 5) of the product.
	ProductTypeL5 *wrappers.StringValue `protobuf:"bytes,48,opt,name=product_type_l5,json=productTypeL5,proto3" json:"product_type_l5,omitempty"`
	// Quarter as represented by the date of the first day of a quarter.
	// Uses the calendar year for quarters, e.g., the second quarter of 2018
	// starts on 2018-04-01. Formatted as yyyy-MM-dd.
	Quarter *wrappers.StringValue `protobuf:"bytes,21,opt,name=quarter,proto3" json:"quarter,omitempty"`
	// Type of the search engine results page.
	SearchEngineResultsPageType enums.SearchEngineResultsPageTypeEnum_SearchEngineResultsPageType `protobuf:"varint,70,opt,name=search_engine_results_page_type,json=searchEngineResultsPageType,proto3,enum=google.ads.googleads.v4.enums.SearchEngineResultsPageTypeEnum_SearchEngineResultsPageType" json:"search_engine_results_page_type,omitempty"`
	// Match type of the keyword that triggered the ad, including variants.
	SearchTermMatchType enums.SearchTermMatchTypeEnum_SearchTermMatchType `protobuf:"varint,22,opt,name=search_term_match_type,json=searchTermMatchType,proto3,enum=google.ads.googleads.v4.enums.SearchTermMatchTypeEnum_SearchTermMatchType" json:"search_term_match_type,omitempty"`
	// Position of the ad.
	Slot enums.SlotEnum_Slot `protobuf:"varint,23,opt,name=slot,proto3,enum=google.ads.googleads.v4.enums.SlotEnum_Slot" json:"slot,omitempty"`
	// Resource name of the ad group criterion that represents webpage criterion.
	Webpage *wrappers.StringValue `protobuf:"bytes,66,opt,name=webpage,proto3" json:"webpage,omitempty"`
	// Week as defined as Monday through Sunday, and represented by the date of
	// Monday. Formatted as yyyy-MM-dd.
	Week *wrappers.StringValue `protobuf:"bytes,24,opt,name=week,proto3" json:"week,omitempty"`
	// Year, formatted as yyyy.
	Year *wrappers.Int32Value `protobuf:"bytes,25,opt,name=year,proto3" json:"year,omitempty"`
}

func (x *Segments) Reset() {
	*x = Segments{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_common_segments_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Segments) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Segments) ProtoMessage() {}

func (x *Segments) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_common_segments_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Segments.ProtoReflect.Descriptor instead.
func (*Segments) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_common_segments_proto_rawDescGZIP(), []int{0}
}

func (x *Segments) GetAdNetworkType() enums.AdNetworkTypeEnum_AdNetworkType {
	if x != nil {
		return x.AdNetworkType
	}
	return enums.AdNetworkTypeEnum_UNSPECIFIED
}

func (x *Segments) GetClickType() enums.ClickTypeEnum_ClickType {
	if x != nil {
		return x.ClickType
	}
	return enums.ClickTypeEnum_UNSPECIFIED
}

func (x *Segments) GetConversionAction() *wrappers.StringValue {
	if x != nil {
		return x.ConversionAction
	}
	return nil
}

func (x *Segments) GetConversionActionCategory() enums.ConversionActionCategoryEnum_ConversionActionCategory {
	if x != nil {
		return x.ConversionActionCategory
	}
	return enums.ConversionActionCategoryEnum_UNSPECIFIED
}

func (x *Segments) GetConversionActionName() *wrappers.StringValue {
	if x != nil {
		return x.ConversionActionName
	}
	return nil
}

func (x *Segments) GetConversionAdjustment() *wrappers.BoolValue {
	if x != nil {
		return x.ConversionAdjustment
	}
	return nil
}

func (x *Segments) GetConversionAttributionEventType() enums.ConversionAttributionEventTypeEnum_ConversionAttributionEventType {
	if x != nil {
		return x.ConversionAttributionEventType
	}
	return enums.ConversionAttributionEventTypeEnum_UNSPECIFIED
}

func (x *Segments) GetConversionLagBucket() enums.ConversionLagBucketEnum_ConversionLagBucket {
	if x != nil {
		return x.ConversionLagBucket
	}
	return enums.ConversionLagBucketEnum_UNSPECIFIED
}

func (x *Segments) GetConversionOrAdjustmentLagBucket() enums.ConversionOrAdjustmentLagBucketEnum_ConversionOrAdjustmentLagBucket {
	if x != nil {
		return x.ConversionOrAdjustmentLagBucket
	}
	return enums.ConversionOrAdjustmentLagBucketEnum_UNSPECIFIED
}

func (x *Segments) GetDate() *wrappers.StringValue {
	if x != nil {
		return x.Date
	}
	return nil
}

func (x *Segments) GetDayOfWeek() enums.DayOfWeekEnum_DayOfWeek {
	if x != nil {
		return x.DayOfWeek
	}
	return enums.DayOfWeekEnum_UNSPECIFIED
}

func (x *Segments) GetDevice() enums.DeviceEnum_Device {
	if x != nil {
		return x.Device
	}
	return enums.DeviceEnum_UNSPECIFIED
}

func (x *Segments) GetExternalConversionSource() enums.ExternalConversionSourceEnum_ExternalConversionSource {
	if x != nil {
		return x.ExternalConversionSource
	}
	return enums.ExternalConversionSourceEnum_UNSPECIFIED
}

func (x *Segments) GetGeoTargetAirport() *wrappers.StringValue {
	if x != nil {
		return x.GeoTargetAirport
	}
	return nil
}

func (x *Segments) GetGeoTargetCanton() *wrappers.StringValue {
	if x != nil {
		return x.GeoTargetCanton
	}
	return nil
}

func (x *Segments) GetGeoTargetCity() *wrappers.StringValue {
	if x != nil {
		return x.GeoTargetCity
	}
	return nil
}

func (x *Segments) GetGeoTargetCountry() *wrappers.StringValue {
	if x != nil {
		return x.GeoTargetCountry
	}
	return nil
}

func (x *Segments) GetGeoTargetCounty() *wrappers.StringValue {
	if x != nil {
		return x.GeoTargetCounty
	}
	return nil
}

func (x *Segments) GetGeoTargetDistrict() *wrappers.StringValue {
	if x != nil {
		return x.GeoTargetDistrict
	}
	return nil
}

func (x *Segments) GetGeoTargetMetro() *wrappers.StringValue {
	if x != nil {
		return x.GeoTargetMetro
	}
	return nil
}

func (x *Segments) GetGeoTargetMostSpecificLocation() *wrappers.StringValue {
	if x != nil {
		return x.GeoTargetMostSpecificLocation
	}
	return nil
}

func (x *Segments) GetGeoTargetPostalCode() *wrappers.StringValue {
	if x != nil {
		return x.GeoTargetPostalCode
	}
	return nil
}

func (x *Segments) GetGeoTargetProvince() *wrappers.StringValue {
	if x != nil {
		return x.GeoTargetProvince
	}
	return nil
}

func (x *Segments) GetGeoTargetRegion() *wrappers.StringValue {
	if x != nil {
		return x.GeoTargetRegion
	}
	return nil
}

func (x *Segments) GetGeoTargetState() *wrappers.StringValue {
	if x != nil {
		return x.GeoTargetState
	}
	return nil
}

func (x *Segments) GetHotelBookingWindowDays() *wrappers.Int64Value {
	if x != nil {
		return x.HotelBookingWindowDays
	}
	return nil
}

func (x *Segments) GetHotelCenterId() *wrappers.Int64Value {
	if x != nil {
		return x.HotelCenterId
	}
	return nil
}

func (x *Segments) GetHotelCheckInDate() *wrappers.StringValue {
	if x != nil {
		return x.HotelCheckInDate
	}
	return nil
}

func (x *Segments) GetHotelCheckInDayOfWeek() enums.DayOfWeekEnum_DayOfWeek {
	if x != nil {
		return x.HotelCheckInDayOfWeek
	}
	return enums.DayOfWeekEnum_UNSPECIFIED
}

func (x *Segments) GetHotelCity() *wrappers.StringValue {
	if x != nil {
		return x.HotelCity
	}
	return nil
}

func (x *Segments) GetHotelClass() *wrappers.Int32Value {
	if x != nil {
		return x.HotelClass
	}
	return nil
}

func (x *Segments) GetHotelCountry() *wrappers.StringValue {
	if x != nil {
		return x.HotelCountry
	}
	return nil
}

func (x *Segments) GetHotelDateSelectionType() enums.HotelDateSelectionTypeEnum_HotelDateSelectionType {
	if x != nil {
		return x.HotelDateSelectionType
	}
	return enums.HotelDateSelectionTypeEnum_UNSPECIFIED
}

func (x *Segments) GetHotelLengthOfStay() *wrappers.Int32Value {
	if x != nil {
		return x.HotelLengthOfStay
	}
	return nil
}

func (x *Segments) GetHotelRateRuleId() *wrappers.StringValue {
	if x != nil {
		return x.HotelRateRuleId
	}
	return nil
}

func (x *Segments) GetHotelRateType() enums.HotelRateTypeEnum_HotelRateType {
	if x != nil {
		return x.HotelRateType
	}
	return enums.HotelRateTypeEnum_UNSPECIFIED
}

func (x *Segments) GetHotelPriceBucket() enums.HotelPriceBucketEnum_HotelPriceBucket {
	if x != nil {
		return x.HotelPriceBucket
	}
	return enums.HotelPriceBucketEnum_UNSPECIFIED
}

func (x *Segments) GetHotelState() *wrappers.StringValue {
	if x != nil {
		return x.HotelState
	}
	return nil
}

func (x *Segments) GetHour() *wrappers.Int32Value {
	if x != nil {
		return x.Hour
	}
	return nil
}

func (x *Segments) GetInteractionOnThisExtension() *wrappers.BoolValue {
	if x != nil {
		return x.InteractionOnThisExtension
	}
	return nil
}

func (x *Segments) GetKeyword() *Keyword {
	if x != nil {
		return x.Keyword
	}
	return nil
}

func (x *Segments) GetMonth() *wrappers.StringValue {
	if x != nil {
		return x.Month
	}
	return nil
}

func (x *Segments) GetMonthOfYear() enums.MonthOfYearEnum_MonthOfYear {
	if x != nil {
		return x.MonthOfYear
	}
	return enums.MonthOfYearEnum_UNSPECIFIED
}

func (x *Segments) GetPartnerHotelId() *wrappers.StringValue {
	if x != nil {
		return x.PartnerHotelId
	}
	return nil
}

func (x *Segments) GetPlaceholderType() enums.PlaceholderTypeEnum_PlaceholderType {
	if x != nil {
		return x.PlaceholderType
	}
	return enums.PlaceholderTypeEnum_UNSPECIFIED
}

func (x *Segments) GetProductAggregatorId() *wrappers.UInt64Value {
	if x != nil {
		return x.ProductAggregatorId
	}
	return nil
}

func (x *Segments) GetProductBiddingCategoryLevel1() *wrappers.StringValue {
	if x != nil {
		return x.ProductBiddingCategoryLevel1
	}
	return nil
}

func (x *Segments) GetProductBiddingCategoryLevel2() *wrappers.StringValue {
	if x != nil {
		return x.ProductBiddingCategoryLevel2
	}
	return nil
}

func (x *Segments) GetProductBiddingCategoryLevel3() *wrappers.StringValue {
	if x != nil {
		return x.ProductBiddingCategoryLevel3
	}
	return nil
}

func (x *Segments) GetProductBiddingCategoryLevel4() *wrappers.StringValue {
	if x != nil {
		return x.ProductBiddingCategoryLevel4
	}
	return nil
}

func (x *Segments) GetProductBiddingCategoryLevel5() *wrappers.StringValue {
	if x != nil {
		return x.ProductBiddingCategoryLevel5
	}
	return nil
}

func (x *Segments) GetProductBrand() *wrappers.StringValue {
	if x != nil {
		return x.ProductBrand
	}
	return nil
}

func (x *Segments) GetProductChannel() enums.ProductChannelEnum_ProductChannel {
	if x != nil {
		return x.ProductChannel
	}
	return enums.ProductChannelEnum_UNSPECIFIED
}

func (x *Segments) GetProductChannelExclusivity() enums.ProductChannelExclusivityEnum_ProductChannelExclusivity {
	if x != nil {
		return x.ProductChannelExclusivity
	}
	return enums.ProductChannelExclusivityEnum_UNSPECIFIED
}

func (x *Segments) GetProductCondition() enums.ProductConditionEnum_ProductCondition {
	if x != nil {
		return x.ProductCondition
	}
	return enums.ProductConditionEnum_UNSPECIFIED
}

func (x *Segments) GetProductCountry() *wrappers.StringValue {
	if x != nil {
		return x.ProductCountry
	}
	return nil
}

func (x *Segments) GetProductCustomAttribute0() *wrappers.StringValue {
	if x != nil {
		return x.ProductCustomAttribute0
	}
	return nil
}

func (x *Segments) GetProductCustomAttribute1() *wrappers.StringValue {
	if x != nil {
		return x.ProductCustomAttribute1
	}
	return nil
}

func (x *Segments) GetProductCustomAttribute2() *wrappers.StringValue {
	if x != nil {
		return x.ProductCustomAttribute2
	}
	return nil
}

func (x *Segments) GetProductCustomAttribute3() *wrappers.StringValue {
	if x != nil {
		return x.ProductCustomAttribute3
	}
	return nil
}

func (x *Segments) GetProductCustomAttribute4() *wrappers.StringValue {
	if x != nil {
		return x.ProductCustomAttribute4
	}
	return nil
}

func (x *Segments) GetProductItemId() *wrappers.StringValue {
	if x != nil {
		return x.ProductItemId
	}
	return nil
}

func (x *Segments) GetProductLanguage() *wrappers.StringValue {
	if x != nil {
		return x.ProductLanguage
	}
	return nil
}

func (x *Segments) GetProductMerchantId() *wrappers.UInt64Value {
	if x != nil {
		return x.ProductMerchantId
	}
	return nil
}

func (x *Segments) GetProductStoreId() *wrappers.StringValue {
	if x != nil {
		return x.ProductStoreId
	}
	return nil
}

func (x *Segments) GetProductTitle() *wrappers.StringValue {
	if x != nil {
		return x.ProductTitle
	}
	return nil
}

func (x *Segments) GetProductTypeL1() *wrappers.StringValue {
	if x != nil {
		return x.ProductTypeL1
	}
	return nil
}

func (x *Segments) GetProductTypeL2() *wrappers.StringValue {
	if x != nil {
		return x.ProductTypeL2
	}
	return nil
}

func (x *Segments) GetProductTypeL3() *wrappers.StringValue {
	if x != nil {
		return x.ProductTypeL3
	}
	return nil
}

func (x *Segments) GetProductTypeL4() *wrappers.StringValue {
	if x != nil {
		return x.ProductTypeL4
	}
	return nil
}

func (x *Segments) GetProductTypeL5() *wrappers.StringValue {
	if x != nil {
		return x.ProductTypeL5
	}
	return nil
}

func (x *Segments) GetQuarter() *wrappers.StringValue {
	if x != nil {
		return x.Quarter
	}
	return nil
}

func (x *Segments) GetSearchEngineResultsPageType() enums.SearchEngineResultsPageTypeEnum_SearchEngineResultsPageType {
	if x != nil {
		return x.SearchEngineResultsPageType
	}
	return enums.SearchEngineResultsPageTypeEnum_UNSPECIFIED
}

func (x *Segments) GetSearchTermMatchType() enums.SearchTermMatchTypeEnum_SearchTermMatchType {
	if x != nil {
		return x.SearchTermMatchType
	}
	return enums.SearchTermMatchTypeEnum_UNSPECIFIED
}

func (x *Segments) GetSlot() enums.SlotEnum_Slot {
	if x != nil {
		return x.Slot
	}
	return enums.SlotEnum_UNSPECIFIED
}

func (x *Segments) GetWebpage() *wrappers.StringValue {
	if x != nil {
		return x.Webpage
	}
	return nil
}

func (x *Segments) GetWeek() *wrappers.StringValue {
	if x != nil {
		return x.Week
	}
	return nil
}

func (x *Segments) GetYear() *wrappers.Int32Value {
	if x != nil {
		return x.Year
	}
	return nil
}

// A Keyword criterion segment.
type Keyword struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The AdGroupCriterion resource name.
	AdGroupCriterion *wrappers.StringValue `protobuf:"bytes,1,opt,name=ad_group_criterion,json=adGroupCriterion,proto3" json:"ad_group_criterion,omitempty"`
	// Keyword info.
	Info *KeywordInfo `protobuf:"bytes,2,opt,name=info,proto3" json:"info,omitempty"`
}

func (x *Keyword) Reset() {
	*x = Keyword{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v4_common_segments_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Keyword) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Keyword) ProtoMessage() {}

func (x *Keyword) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v4_common_segments_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Keyword.ProtoReflect.Descriptor instead.
func (*Keyword) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v4_common_segments_proto_rawDescGZIP(), []int{1}
}

func (x *Keyword) GetAdGroupCriterion() *wrappers.StringValue {
	if x != nil {
		return x.AdGroupCriterion
	}
	return nil
}

func (x *Keyword) GetInfo() *KeywordInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

var File_google_ads_googleads_v4_common_segments_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v4_common_segments_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x1a,
	0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f,
	0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x33,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x64,
	0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2f, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x39, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x67, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x6f, 0x72, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x61,
	0x67, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x64, 0x61,
	0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3d, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x68, 0x6f, 0x74, 0x65, 0x6c,
	0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f,
	0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34,
	0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x5f, 0x6f, 0x66, 0x5f,
	0x79, 0x65, 0x61, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x34, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64,
	0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x69, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x43, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x73, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x73, 0x6c,
	0x6f, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
	0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc3, 0x35, 0x0a, 0x08, 0x53, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x12, 0x66, 0x0a, 0x0f, 0x61, 0x64, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x64, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x41,
	0x64, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x61, 0x64,
	0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x55, 0x0a, 0x0a, 0x63,
	0x6c, 0x69, 0x63, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x1a, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x43, 0x6c, 0x69, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x6c,
	0x69, 0x63, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x49, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x34, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x92, 0x01,
	0x0a, 0x1a, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x35, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x45, 0x6e, 0x75, 0x6d, 0x2e,
	0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x52, 0x18, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x79, 0x12, 0x52, 0x0a, 0x16, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x36, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x14, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x64, 0x6a,
	0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0xab, 0x01, 0x0a, 0x21, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x1e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x7e, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x67, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x32,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4c,
	0x61, 0x67, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x67, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x52, 0x13, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x67, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0xb0, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x72, 0x5f, 0x61, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x6c, 0x61, 0x67, 0x5f, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x33, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x62, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x72,
	0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61, 0x67, 0x42, 0x75, 0x63,
	0x6b, 0x65, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x4f, 0x72, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x4c, 0x61,
	0x67, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x52, 0x1f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x41, 0x64, 0x6a, 0x75, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x4c,
	0x61, 0x67, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x30, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x64, 0x61, 0x74, 0x65, 0x12, 0x56, 0x0a, 0x0b, 0x64, 0x61,
	0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x44, 0x61,
	0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x52, 0x09, 0x64, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65,
	0x65, 0x6b, 0x12, 0x48, 0x0a, 0x06, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x44, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x52, 0x06, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x92, 0x01, 0x0a,
	0x1a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x37, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x45,
	0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x18, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x4a, 0x0a, 0x12, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x61, 0x69, 0x72, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x41, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x67, 0x65, 0x6f,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x41, 0x69, 0x72, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x48, 0x0a,
	0x11, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x61, 0x6e, 0x74,
	0x6f, 0x6e, 0x18, 0x4c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x43, 0x61, 0x6e, 0x74, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x0f, 0x67, 0x65, 0x6f, 0x5f, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x69, 0x74, 0x79, 0x18, 0x3e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d,
	0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x69, 0x74, 0x79, 0x12, 0x4a, 0x0a,
	0x12, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x72, 0x79, 0x18, 0x4d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x48, 0x0a, 0x11, 0x67, 0x65, 0x6f,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x79, 0x18, 0x44,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0f, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x79, 0x12, 0x4c, 0x0a, 0x13, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x18, 0x45, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11,
	0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x63,
	0x74, 0x12, 0x46, 0x0a, 0x10, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x6d, 0x65, 0x74, 0x72, 0x6f, 0x18, 0x3f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x67, 0x65, 0x6f, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x6f, 0x12, 0x66, 0x0a, 0x21, 0x67, 0x65, 0x6f,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6d, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x69, 0x66, 0x69, 0x63, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x48,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x1d, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4d, 0x6f, 0x73,
	0x74, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x51, 0x0a, 0x16, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x47, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x13, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x6f, 0x73, 0x74, 0x61, 0x6c,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x4c, 0x0a, 0x13, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x6e, 0x63, 0x65, 0x18, 0x4b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x11, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x6e,
	0x63, 0x65, 0x12, 0x48, 0x0a, 0x11, 0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x40, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x67, 0x65, 0x6f,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x10,
	0x67, 0x65, 0x6f, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x43, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x67, 0x65, 0x6f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x56, 0x0a, 0x19, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x62, 0x6f,
	0x6f, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x64, 0x61, 0x79,
	0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x16, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x42, 0x6f, 0x6f, 0x6b, 0x69,
	0x6e, 0x67, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x44, 0x61, 0x79, 0x73, 0x12, 0x43, 0x0a, 0x0f,
	0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0d, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49,
	0x64, 0x12, 0x4b, 0x0a, 0x13, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b,
	0x5f, 0x69, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x10, 0x68, 0x6f,
	0x74, 0x65, 0x6c, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x12, 0x71,
	0x0a, 0x1a, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x5f, 0x69, 0x6e,
	0x5f, 0x64, 0x61, 0x79, 0x5f, 0x6f, 0x66, 0x5f, 0x77, 0x65, 0x65, 0x6b, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x45, 0x6e, 0x75, 0x6d,
	0x2e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65, 0x6b, 0x52, 0x15, 0x68, 0x6f, 0x74, 0x65,
	0x6c, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x49, 0x6e, 0x44, 0x61, 0x79, 0x4f, 0x66, 0x57, 0x65, 0x65,
	0x6b, 0x12, 0x3b, 0x0a, 0x0a, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x69, 0x74, 0x79, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x52, 0x09, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x43, 0x69, 0x74, 0x79, 0x12, 0x3c,
	0x0a, 0x0b, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0a, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x12, 0x41, 0x0a, 0x0d,
	0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x0c, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x8b, 0x01, 0x0a, 0x19, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2e, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x44, 0x61, 0x74, 0x65, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x48,
	0x6f, 0x74, 0x65, 0x6c, 0x44, 0x61, 0x74, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x16, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x44, 0x61, 0x74, 0x65,
	0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4c, 0x0a,
	0x14, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x5f, 0x6f, 0x66,
	0x5f, 0x73, 0x74, 0x61, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e,
	0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x4c,
	0x65, 0x6e, 0x67, 0x74, 0x68, 0x4f, 0x66, 0x53, 0x74, 0x61, 0x79, 0x12, 0x49, 0x0a, 0x12, 0x68,
	0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x49, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x52, 0x61, 0x74, 0x65,
	0x52, 0x75, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x66, 0x0a, 0x0f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f,
	0x72, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x4a, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x48, 0x6f, 0x74, 0x65, 0x6c, 0x52, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75,
	0x6d, 0x2e, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x52, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0d, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x52, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x72,
	0x0a, 0x12, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x62, 0x75,
	0x63, 0x6b, 0x65, 0x74, 0x18, 0x4e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x48, 0x6f, 0x74, 0x65, 0x6c,
	0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e,
	0x48, 0x6f, 0x74, 0x65, 0x6c, 0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x52, 0x10, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x50, 0x72, 0x69, 0x63, 0x65, 0x42, 0x75, 0x63, 0x6b,
	0x65, 0x74, 0x12, 0x3d, 0x0a, 0x0b, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x2f, 0x0a, 0x04, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x68, 0x6f,
	0x75, 0x72, 0x12, 0x5d, 0x0a, 0x1d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6f, 0x6e, 0x5f, 0x74, 0x68, 0x69, 0x73, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x31, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x4f, 0x6e, 0x54, 0x68, 0x69, 0x73, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x41, 0x0a, 0x07, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x3d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x52, 0x07, 0x6b, 0x65, 0x79,
	0x77, 0x6f, 0x72, 0x64, 0x12, 0x32, 0x0a, 0x05, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x05, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x12, 0x5e, 0x0a, 0x0d, 0x6d, 0x6f, 0x6e, 0x74,
	0x68, 0x5f, 0x6f, 0x66, 0x5f, 0x79, 0x65, 0x61, 0x72, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e,
	0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x4f, 0x66, 0x59, 0x65, 0x61, 0x72, 0x45, 0x6e, 0x75, 0x6d, 0x2e,
	0x4d, 0x6f, 0x6e, 0x74, 0x68, 0x4f, 0x66, 0x59, 0x65, 0x61, 0x72, 0x52, 0x0b, 0x6d, 0x6f, 0x6e,
	0x74, 0x68, 0x4f, 0x66, 0x59, 0x65, 0x61, 0x72, 0x12, 0x46, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x74,
	0x6e, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x13, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0e, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x49, 0x64,
	0x12, 0x6d, 0x0a, 0x10, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64,
	0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50,
	0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f,
	0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x50, 0x0a, 0x15, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x61, 0x67, 0x67, 0x72, 0x65,
	0x67, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x55, 0x49, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x13, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x49,
	0x64, 0x12, 0x63, 0x0a, 0x1f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62, 0x69, 0x64,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x65,
	0x76, 0x65, 0x6c, 0x31, 0x18, 0x38, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79,
	0x4c, 0x65, 0x76, 0x65, 0x6c, 0x31, 0x12, 0x63, 0x0a, 0x1f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f,
	0x72, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x32, 0x18, 0x39, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1c, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x32, 0x12, 0x63, 0x0a, 0x1f, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x33, 0x18, 0x3a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x1c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x69, 0x64, 0x64, 0x69,
	0x6e, 0x67, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x33,
	0x12, 0x63, 0x0a, 0x1f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62, 0x69, 0x64, 0x64,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x5f, 0x6c, 0x65, 0x76,
	0x65, 0x6c, 0x34, 0x18, 0x3b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x4c,
	0x65, 0x76, 0x65, 0x6c, 0x34, 0x12, 0x63, 0x0a, 0x1f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x62, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x35, 0x18, 0x3c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x1c, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x69, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x35, 0x12, 0x41, 0x0a, 0x0d, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x18, 0x1d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52,
	0x0c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x12, 0x69, 0x0a,
	0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c,
	0x18, 0x1e, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34,
	0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x68,
	0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12, 0x96, 0x01, 0x0a, 0x1b, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x5f, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x76, 0x69, 0x74, 0x79, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x56,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x78, 0x63,
	0x6c, 0x75, 0x73, 0x69, 0x76, 0x69, 0x74, 0x79, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x78, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x76, 0x69, 0x74, 0x79, 0x52, 0x19, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43,
	0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x69, 0x74,
	0x79, 0x12, 0x71, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x20, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x75,
	0x6d, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x58, 0x0a, 0x19, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x30, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x30, 0x12, 0x58, 0x0a, 0x19, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x31, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x31, 0x12,
	0x58, 0x0a, 0x19, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x32, 0x18, 0x24, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x17, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41,
	0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x32, 0x12, 0x58, 0x0a, 0x19, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x33, 0x18, 0x25, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x70, 0x72, 0x6f, 0x64,
	0x75, 0x63, 0x74, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x33, 0x12, 0x58, 0x0a, 0x19, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x34,
	0x18, 0x26, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x17, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x43, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x34, 0x12, 0x44, 0x0a,
	0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64,
	0x18, 0x27, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x49, 0x74, 0x65,
	0x6d, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x28, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x4c, 0x0a, 0x13,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x6d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x29, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x55, 0x49, 0x6e, 0x74,
	0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x11, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x4d, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x46, 0x0a, 0x10, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x2a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x49, 0x64, 0x12, 0x41, 0x0a, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x18, 0x2b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x54, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x44, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x31, 0x18, 0x2c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x70, 0x72,
	0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x31, 0x12, 0x44, 0x0a, 0x0f, 0x70,
	0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x32, 0x18, 0x2d,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c,
	0x32, 0x12, 0x44, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x5f, 0x6c, 0x33, 0x18, 0x2e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x33, 0x12, 0x44, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x34, 0x18, 0x2f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d,
	0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70, 0x65, 0x4c, 0x34, 0x12, 0x44, 0x0a,
	0x0f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x35,
	0x18, 0x30, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x54, 0x79, 0x70,
	0x65, 0x4c, 0x35, 0x12, 0x36, 0x0a, 0x07, 0x71, 0x75, 0x61, 0x72, 0x74, 0x65, 0x72, 0x18, 0x15,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x07, 0x71, 0x75, 0x61, 0x72, 0x74, 0x65, 0x72, 0x12, 0xa0, 0x01, 0x0a, 0x1f,
	0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x46, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x50, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x50, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x1b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x50, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x7f,
	0x0a, 0x16, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x65, 0x72, 0x6d, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x72, 0x6d, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79,
	0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x65, 0x72,
	0x6d, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x13, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x54, 0x65, 0x72, 0x6d, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x40, 0x0a, 0x04, 0x73, 0x6c, 0x6f, 0x74, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x53, 0x6c,
	0x6f, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x53, 0x6c, 0x6f, 0x74, 0x52, 0x04, 0x73, 0x6c, 0x6f,
	0x74, 0x12, 0x36, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x70, 0x61, 0x67, 0x65, 0x18, 0x42, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x07, 0x77, 0x65, 0x62, 0x70, 0x61, 0x67, 0x65, 0x12, 0x30, 0x0a, 0x04, 0x77, 0x65, 0x65,
	0x6b, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x77, 0x65, 0x65, 0x6b, 0x12, 0x2f, 0x0a, 0x04, 0x79,
	0x65, 0x61, 0x72, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33,
	0x32, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x04, 0x79, 0x65, 0x61, 0x72, 0x22, 0x96, 0x01, 0x0a,
	0x07, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x4a, 0x0a, 0x12, 0x61, 0x64, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x10, 0x61, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x43, 0x72, 0x69, 0x74, 0x65,
	0x72, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x4b, 0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x04, 0x69, 0x6e, 0x66, 0x6f, 0x42, 0xe8, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x34, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x42, 0x0d, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x44, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67,
	0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2f, 0x76, 0x34, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x3b, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73,
	0x2e, 0x56, 0x34, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64,
	0x73, 0x5c, 0x56, 0x34, 0x5c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xea, 0x02, 0x22, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x34, 0x3a, 0x3a, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v4_common_segments_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v4_common_segments_proto_rawDescData = file_google_ads_googleads_v4_common_segments_proto_rawDesc
)

func file_google_ads_googleads_v4_common_segments_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v4_common_segments_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v4_common_segments_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v4_common_segments_proto_rawDescData)
	})
	return file_google_ads_googleads_v4_common_segments_proto_rawDescData
}

var file_google_ads_googleads_v4_common_segments_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_google_ads_googleads_v4_common_segments_proto_goTypes = []interface{}{
	(*Segments)(nil), // 0: google.ads.googleads.v4.common.Segments
	(*Keyword)(nil),  // 1: google.ads.googleads.v4.common.Keyword
	(enums.AdNetworkTypeEnum_AdNetworkType)(0),                                     // 2: google.ads.googleads.v4.enums.AdNetworkTypeEnum.AdNetworkType
	(enums.ClickTypeEnum_ClickType)(0),                                             // 3: google.ads.googleads.v4.enums.ClickTypeEnum.ClickType
	(*wrappers.StringValue)(nil),                                                   // 4: google.protobuf.StringValue
	(enums.ConversionActionCategoryEnum_ConversionActionCategory)(0),               // 5: google.ads.googleads.v4.enums.ConversionActionCategoryEnum.ConversionActionCategory
	(*wrappers.BoolValue)(nil),                                                     // 6: google.protobuf.BoolValue
	(enums.ConversionAttributionEventTypeEnum_ConversionAttributionEventType)(0),   // 7: google.ads.googleads.v4.enums.ConversionAttributionEventTypeEnum.ConversionAttributionEventType
	(enums.ConversionLagBucketEnum_ConversionLagBucket)(0),                         // 8: google.ads.googleads.v4.enums.ConversionLagBucketEnum.ConversionLagBucket
	(enums.ConversionOrAdjustmentLagBucketEnum_ConversionOrAdjustmentLagBucket)(0), // 9: google.ads.googleads.v4.enums.ConversionOrAdjustmentLagBucketEnum.ConversionOrAdjustmentLagBucket
	(enums.DayOfWeekEnum_DayOfWeek)(0),                                             // 10: google.ads.googleads.v4.enums.DayOfWeekEnum.DayOfWeek
	(enums.DeviceEnum_Device)(0),                                                   // 11: google.ads.googleads.v4.enums.DeviceEnum.Device
	(enums.ExternalConversionSourceEnum_ExternalConversionSource)(0),               // 12: google.ads.googleads.v4.enums.ExternalConversionSourceEnum.ExternalConversionSource
	(*wrappers.Int64Value)(nil),                                                    // 13: google.protobuf.Int64Value
	(*wrappers.Int32Value)(nil),                                                    // 14: google.protobuf.Int32Value
	(enums.HotelDateSelectionTypeEnum_HotelDateSelectionType)(0),                   // 15: google.ads.googleads.v4.enums.HotelDateSelectionTypeEnum.HotelDateSelectionType
	(enums.HotelRateTypeEnum_HotelRateType)(0),                                     // 16: google.ads.googleads.v4.enums.HotelRateTypeEnum.HotelRateType
	(enums.HotelPriceBucketEnum_HotelPriceBucket)(0),                               // 17: google.ads.googleads.v4.enums.HotelPriceBucketEnum.HotelPriceBucket
	(enums.MonthOfYearEnum_MonthOfYear)(0),                                         // 18: google.ads.googleads.v4.enums.MonthOfYearEnum.MonthOfYear
	(enums.PlaceholderTypeEnum_PlaceholderType)(0),                                 // 19: google.ads.googleads.v4.enums.PlaceholderTypeEnum.PlaceholderType
	(*wrappers.UInt64Value)(nil),                                                   // 20: google.protobuf.UInt64Value
	(enums.ProductChannelEnum_ProductChannel)(0),                                   // 21: google.ads.googleads.v4.enums.ProductChannelEnum.ProductChannel
	(enums.ProductChannelExclusivityEnum_ProductChannelExclusivity)(0),             // 22: google.ads.googleads.v4.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity
	(enums.ProductConditionEnum_ProductCondition)(0),                               // 23: google.ads.googleads.v4.enums.ProductConditionEnum.ProductCondition
	(enums.SearchEngineResultsPageTypeEnum_SearchEngineResultsPageType)(0),         // 24: google.ads.googleads.v4.enums.SearchEngineResultsPageTypeEnum.SearchEngineResultsPageType
	(enums.SearchTermMatchTypeEnum_SearchTermMatchType)(0),                         // 25: google.ads.googleads.v4.enums.SearchTermMatchTypeEnum.SearchTermMatchType
	(enums.SlotEnum_Slot)(0),                                                       // 26: google.ads.googleads.v4.enums.SlotEnum.Slot
	(*KeywordInfo)(nil),                                                            // 27: google.ads.googleads.v4.common.KeywordInfo
}
var file_google_ads_googleads_v4_common_segments_proto_depIdxs = []int32{
	2,  // 0: google.ads.googleads.v4.common.Segments.ad_network_type:type_name -> google.ads.googleads.v4.enums.AdNetworkTypeEnum.AdNetworkType
	3,  // 1: google.ads.googleads.v4.common.Segments.click_type:type_name -> google.ads.googleads.v4.enums.ClickTypeEnum.ClickType
	4,  // 2: google.ads.googleads.v4.common.Segments.conversion_action:type_name -> google.protobuf.StringValue
	5,  // 3: google.ads.googleads.v4.common.Segments.conversion_action_category:type_name -> google.ads.googleads.v4.enums.ConversionActionCategoryEnum.ConversionActionCategory
	4,  // 4: google.ads.googleads.v4.common.Segments.conversion_action_name:type_name -> google.protobuf.StringValue
	6,  // 5: google.ads.googleads.v4.common.Segments.conversion_adjustment:type_name -> google.protobuf.BoolValue
	7,  // 6: google.ads.googleads.v4.common.Segments.conversion_attribution_event_type:type_name -> google.ads.googleads.v4.enums.ConversionAttributionEventTypeEnum.ConversionAttributionEventType
	8,  // 7: google.ads.googleads.v4.common.Segments.conversion_lag_bucket:type_name -> google.ads.googleads.v4.enums.ConversionLagBucketEnum.ConversionLagBucket
	9,  // 8: google.ads.googleads.v4.common.Segments.conversion_or_adjustment_lag_bucket:type_name -> google.ads.googleads.v4.enums.ConversionOrAdjustmentLagBucketEnum.ConversionOrAdjustmentLagBucket
	4,  // 9: google.ads.googleads.v4.common.Segments.date:type_name -> google.protobuf.StringValue
	10, // 10: google.ads.googleads.v4.common.Segments.day_of_week:type_name -> google.ads.googleads.v4.enums.DayOfWeekEnum.DayOfWeek
	11, // 11: google.ads.googleads.v4.common.Segments.device:type_name -> google.ads.googleads.v4.enums.DeviceEnum.Device
	12, // 12: google.ads.googleads.v4.common.Segments.external_conversion_source:type_name -> google.ads.googleads.v4.enums.ExternalConversionSourceEnum.ExternalConversionSource
	4,  // 13: google.ads.googleads.v4.common.Segments.geo_target_airport:type_name -> google.protobuf.StringValue
	4,  // 14: google.ads.googleads.v4.common.Segments.geo_target_canton:type_name -> google.protobuf.StringValue
	4,  // 15: google.ads.googleads.v4.common.Segments.geo_target_city:type_name -> google.protobuf.StringValue
	4,  // 16: google.ads.googleads.v4.common.Segments.geo_target_country:type_name -> google.protobuf.StringValue
	4,  // 17: google.ads.googleads.v4.common.Segments.geo_target_county:type_name -> google.protobuf.StringValue
	4,  // 18: google.ads.googleads.v4.common.Segments.geo_target_district:type_name -> google.protobuf.StringValue
	4,  // 19: google.ads.googleads.v4.common.Segments.geo_target_metro:type_name -> google.protobuf.StringValue
	4,  // 20: google.ads.googleads.v4.common.Segments.geo_target_most_specific_location:type_name -> google.protobuf.StringValue
	4,  // 21: google.ads.googleads.v4.common.Segments.geo_target_postal_code:type_name -> google.protobuf.StringValue
	4,  // 22: google.ads.googleads.v4.common.Segments.geo_target_province:type_name -> google.protobuf.StringValue
	4,  // 23: google.ads.googleads.v4.common.Segments.geo_target_region:type_name -> google.protobuf.StringValue
	4,  // 24: google.ads.googleads.v4.common.Segments.geo_target_state:type_name -> google.protobuf.StringValue
	13, // 25: google.ads.googleads.v4.common.Segments.hotel_booking_window_days:type_name -> google.protobuf.Int64Value
	13, // 26: google.ads.googleads.v4.common.Segments.hotel_center_id:type_name -> google.protobuf.Int64Value
	4,  // 27: google.ads.googleads.v4.common.Segments.hotel_check_in_date:type_name -> google.protobuf.StringValue
	10, // 28: google.ads.googleads.v4.common.Segments.hotel_check_in_day_of_week:type_name -> google.ads.googleads.v4.enums.DayOfWeekEnum.DayOfWeek
	4,  // 29: google.ads.googleads.v4.common.Segments.hotel_city:type_name -> google.protobuf.StringValue
	14, // 30: google.ads.googleads.v4.common.Segments.hotel_class:type_name -> google.protobuf.Int32Value
	4,  // 31: google.ads.googleads.v4.common.Segments.hotel_country:type_name -> google.protobuf.StringValue
	15, // 32: google.ads.googleads.v4.common.Segments.hotel_date_selection_type:type_name -> google.ads.googleads.v4.enums.HotelDateSelectionTypeEnum.HotelDateSelectionType
	14, // 33: google.ads.googleads.v4.common.Segments.hotel_length_of_stay:type_name -> google.protobuf.Int32Value
	4,  // 34: google.ads.googleads.v4.common.Segments.hotel_rate_rule_id:type_name -> google.protobuf.StringValue
	16, // 35: google.ads.googleads.v4.common.Segments.hotel_rate_type:type_name -> google.ads.googleads.v4.enums.HotelRateTypeEnum.HotelRateType
	17, // 36: google.ads.googleads.v4.common.Segments.hotel_price_bucket:type_name -> google.ads.googleads.v4.enums.HotelPriceBucketEnum.HotelPriceBucket
	4,  // 37: google.ads.googleads.v4.common.Segments.hotel_state:type_name -> google.protobuf.StringValue
	14, // 38: google.ads.googleads.v4.common.Segments.hour:type_name -> google.protobuf.Int32Value
	6,  // 39: google.ads.googleads.v4.common.Segments.interaction_on_this_extension:type_name -> google.protobuf.BoolValue
	1,  // 40: google.ads.googleads.v4.common.Segments.keyword:type_name -> google.ads.googleads.v4.common.Keyword
	4,  // 41: google.ads.googleads.v4.common.Segments.month:type_name -> google.protobuf.StringValue
	18, // 42: google.ads.googleads.v4.common.Segments.month_of_year:type_name -> google.ads.googleads.v4.enums.MonthOfYearEnum.MonthOfYear
	4,  // 43: google.ads.googleads.v4.common.Segments.partner_hotel_id:type_name -> google.protobuf.StringValue
	19, // 44: google.ads.googleads.v4.common.Segments.placeholder_type:type_name -> google.ads.googleads.v4.enums.PlaceholderTypeEnum.PlaceholderType
	20, // 45: google.ads.googleads.v4.common.Segments.product_aggregator_id:type_name -> google.protobuf.UInt64Value
	4,  // 46: google.ads.googleads.v4.common.Segments.product_bidding_category_level1:type_name -> google.protobuf.StringValue
	4,  // 47: google.ads.googleads.v4.common.Segments.product_bidding_category_level2:type_name -> google.protobuf.StringValue
	4,  // 48: google.ads.googleads.v4.common.Segments.product_bidding_category_level3:type_name -> google.protobuf.StringValue
	4,  // 49: google.ads.googleads.v4.common.Segments.product_bidding_category_level4:type_name -> google.protobuf.StringValue
	4,  // 50: google.ads.googleads.v4.common.Segments.product_bidding_category_level5:type_name -> google.protobuf.StringValue
	4,  // 51: google.ads.googleads.v4.common.Segments.product_brand:type_name -> google.protobuf.StringValue
	21, // 52: google.ads.googleads.v4.common.Segments.product_channel:type_name -> google.ads.googleads.v4.enums.ProductChannelEnum.ProductChannel
	22, // 53: google.ads.googleads.v4.common.Segments.product_channel_exclusivity:type_name -> google.ads.googleads.v4.enums.ProductChannelExclusivityEnum.ProductChannelExclusivity
	23, // 54: google.ads.googleads.v4.common.Segments.product_condition:type_name -> google.ads.googleads.v4.enums.ProductConditionEnum.ProductCondition
	4,  // 55: google.ads.googleads.v4.common.Segments.product_country:type_name -> google.protobuf.StringValue
	4,  // 56: google.ads.googleads.v4.common.Segments.product_custom_attribute0:type_name -> google.protobuf.StringValue
	4,  // 57: google.ads.googleads.v4.common.Segments.product_custom_attribute1:type_name -> google.protobuf.StringValue
	4,  // 58: google.ads.googleads.v4.common.Segments.product_custom_attribute2:type_name -> google.protobuf.StringValue
	4,  // 59: google.ads.googleads.v4.common.Segments.product_custom_attribute3:type_name -> google.protobuf.StringValue
	4,  // 60: google.ads.googleads.v4.common.Segments.product_custom_attribute4:type_name -> google.protobuf.StringValue
	4,  // 61: google.ads.googleads.v4.common.Segments.product_item_id:type_name -> google.protobuf.StringValue
	4,  // 62: google.ads.googleads.v4.common.Segments.product_language:type_name -> google.protobuf.StringValue
	20, // 63: google.ads.googleads.v4.common.Segments.product_merchant_id:type_name -> google.protobuf.UInt64Value
	4,  // 64: google.ads.googleads.v4.common.Segments.product_store_id:type_name -> google.protobuf.StringValue
	4,  // 65: google.ads.googleads.v4.common.Segments.product_title:type_name -> google.protobuf.StringValue
	4,  // 66: google.ads.googleads.v4.common.Segments.product_type_l1:type_name -> google.protobuf.StringValue
	4,  // 67: google.ads.googleads.v4.common.Segments.product_type_l2:type_name -> google.protobuf.StringValue
	4,  // 68: google.ads.googleads.v4.common.Segments.product_type_l3:type_name -> google.protobuf.StringValue
	4,  // 69: google.ads.googleads.v4.common.Segments.product_type_l4:type_name -> google.protobuf.StringValue
	4,  // 70: google.ads.googleads.v4.common.Segments.product_type_l5:type_name -> google.protobuf.StringValue
	4,  // 71: google.ads.googleads.v4.common.Segments.quarter:type_name -> google.protobuf.StringValue
	24, // 72: google.ads.googleads.v4.common.Segments.search_engine_results_page_type:type_name -> google.ads.googleads.v4.enums.SearchEngineResultsPageTypeEnum.SearchEngineResultsPageType
	25, // 73: google.ads.googleads.v4.common.Segments.search_term_match_type:type_name -> google.ads.googleads.v4.enums.SearchTermMatchTypeEnum.SearchTermMatchType
	26, // 74: google.ads.googleads.v4.common.Segments.slot:type_name -> google.ads.googleads.v4.enums.SlotEnum.Slot
	4,  // 75: google.ads.googleads.v4.common.Segments.webpage:type_name -> google.protobuf.StringValue
	4,  // 76: google.ads.googleads.v4.common.Segments.week:type_name -> google.protobuf.StringValue
	14, // 77: google.ads.googleads.v4.common.Segments.year:type_name -> google.protobuf.Int32Value
	4,  // 78: google.ads.googleads.v4.common.Keyword.ad_group_criterion:type_name -> google.protobuf.StringValue
	27, // 79: google.ads.googleads.v4.common.Keyword.info:type_name -> google.ads.googleads.v4.common.KeywordInfo
	80, // [80:80] is the sub-list for method output_type
	80, // [80:80] is the sub-list for method input_type
	80, // [80:80] is the sub-list for extension type_name
	80, // [80:80] is the sub-list for extension extendee
	0,  // [0:80] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v4_common_segments_proto_init() }
func file_google_ads_googleads_v4_common_segments_proto_init() {
	if File_google_ads_googleads_v4_common_segments_proto != nil {
		return
	}
	file_google_ads_googleads_v4_common_criteria_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v4_common_segments_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Segments); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v4_common_segments_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Keyword); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v4_common_segments_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v4_common_segments_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v4_common_segments_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v4_common_segments_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v4_common_segments_proto = out.File
	file_google_ads_googleads_v4_common_segments_proto_rawDesc = nil
	file_google_ads_googleads_v4_common_segments_proto_goTypes = nil
	file_google_ads_googleads_v4_common_segments_proto_depIdxs = nil
}
