// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/firestore/admin/v1/firestore_admin.proto

package admin

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The request for [FirestoreAdmin.CreateIndex][google.firestore.admin.v1.FirestoreAdmin.CreateIndex].
type CreateIndexRequest struct {
	// A parent name of the form
	// `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The composite index to create.
	Index                *Index   `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateIndexRequest) Reset()         { *m = CreateIndexRequest{} }
func (m *CreateIndexRequest) String() string { return proto.CompactTextString(m) }
func (*CreateIndexRequest) ProtoMessage()    {}
func (*CreateIndexRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b39559c0814b3d0, []int{0}
}

func (m *CreateIndexRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateIndexRequest.Unmarshal(m, b)
}
func (m *CreateIndexRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateIndexRequest.Marshal(b, m, deterministic)
}
func (m *CreateIndexRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateIndexRequest.Merge(m, src)
}
func (m *CreateIndexRequest) XXX_Size() int {
	return xxx_messageInfo_CreateIndexRequest.Size(m)
}
func (m *CreateIndexRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateIndexRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateIndexRequest proto.InternalMessageInfo

func (m *CreateIndexRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateIndexRequest) GetIndex() *Index {
	if m != nil {
		return m.Index
	}
	return nil
}

// The request for [FirestoreAdmin.ListIndexes][google.firestore.admin.v1.FirestoreAdmin.ListIndexes].
type ListIndexesRequest struct {
	// A parent name of the form
	// `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter to apply to list results.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The number of results to return.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, returned from a previous call to
	// [FirestoreAdmin.ListIndexes][google.firestore.admin.v1.FirestoreAdmin.ListIndexes], that may be used to get the next
	// page of results.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIndexesRequest) Reset()         { *m = ListIndexesRequest{} }
func (m *ListIndexesRequest) String() string { return proto.CompactTextString(m) }
func (*ListIndexesRequest) ProtoMessage()    {}
func (*ListIndexesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b39559c0814b3d0, []int{1}
}

func (m *ListIndexesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIndexesRequest.Unmarshal(m, b)
}
func (m *ListIndexesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIndexesRequest.Marshal(b, m, deterministic)
}
func (m *ListIndexesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIndexesRequest.Merge(m, src)
}
func (m *ListIndexesRequest) XXX_Size() int {
	return xxx_messageInfo_ListIndexesRequest.Size(m)
}
func (m *ListIndexesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIndexesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListIndexesRequest proto.InternalMessageInfo

func (m *ListIndexesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListIndexesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListIndexesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListIndexesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for [FirestoreAdmin.ListIndexes][google.firestore.admin.v1.FirestoreAdmin.ListIndexes].
type ListIndexesResponse struct {
	// The requested indexes.
	Indexes []*Index `protobuf:"bytes,1,rep,name=indexes,proto3" json:"indexes,omitempty"`
	// A page token that may be used to request another page of results. If blank,
	// this is the last page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIndexesResponse) Reset()         { *m = ListIndexesResponse{} }
func (m *ListIndexesResponse) String() string { return proto.CompactTextString(m) }
func (*ListIndexesResponse) ProtoMessage()    {}
func (*ListIndexesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b39559c0814b3d0, []int{2}
}

func (m *ListIndexesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIndexesResponse.Unmarshal(m, b)
}
func (m *ListIndexesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIndexesResponse.Marshal(b, m, deterministic)
}
func (m *ListIndexesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIndexesResponse.Merge(m, src)
}
func (m *ListIndexesResponse) XXX_Size() int {
	return xxx_messageInfo_ListIndexesResponse.Size(m)
}
func (m *ListIndexesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIndexesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListIndexesResponse proto.InternalMessageInfo

func (m *ListIndexesResponse) GetIndexes() []*Index {
	if m != nil {
		return m.Indexes
	}
	return nil
}

func (m *ListIndexesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for [FirestoreAdmin.GetIndex][google.firestore.admin.v1.FirestoreAdmin.GetIndex].
type GetIndexRequest struct {
	// A name of the form
	// `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetIndexRequest) Reset()         { *m = GetIndexRequest{} }
func (m *GetIndexRequest) String() string { return proto.CompactTextString(m) }
func (*GetIndexRequest) ProtoMessage()    {}
func (*GetIndexRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b39559c0814b3d0, []int{3}
}

func (m *GetIndexRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetIndexRequest.Unmarshal(m, b)
}
func (m *GetIndexRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetIndexRequest.Marshal(b, m, deterministic)
}
func (m *GetIndexRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetIndexRequest.Merge(m, src)
}
func (m *GetIndexRequest) XXX_Size() int {
	return xxx_messageInfo_GetIndexRequest.Size(m)
}
func (m *GetIndexRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetIndexRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetIndexRequest proto.InternalMessageInfo

func (m *GetIndexRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [FirestoreAdmin.DeleteIndex][google.firestore.admin.v1.FirestoreAdmin.DeleteIndex].
type DeleteIndexRequest struct {
	// A name of the form
	// `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/indexes/{index_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteIndexRequest) Reset()         { *m = DeleteIndexRequest{} }
func (m *DeleteIndexRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteIndexRequest) ProtoMessage()    {}
func (*DeleteIndexRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b39559c0814b3d0, []int{4}
}

func (m *DeleteIndexRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteIndexRequest.Unmarshal(m, b)
}
func (m *DeleteIndexRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteIndexRequest.Marshal(b, m, deterministic)
}
func (m *DeleteIndexRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteIndexRequest.Merge(m, src)
}
func (m *DeleteIndexRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteIndexRequest.Size(m)
}
func (m *DeleteIndexRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteIndexRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteIndexRequest proto.InternalMessageInfo

func (m *DeleteIndexRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [FirestoreAdmin.UpdateField][google.firestore.admin.v1.FirestoreAdmin.UpdateField].
type UpdateFieldRequest struct {
	// The field to be updated.
	Field *Field `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	// A mask, relative to the field. If specified, only configuration specified
	// by this field_mask will be updated in the field.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateFieldRequest) Reset()         { *m = UpdateFieldRequest{} }
func (m *UpdateFieldRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFieldRequest) ProtoMessage()    {}
func (*UpdateFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b39559c0814b3d0, []int{5}
}

func (m *UpdateFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFieldRequest.Unmarshal(m, b)
}
func (m *UpdateFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFieldRequest.Marshal(b, m, deterministic)
}
func (m *UpdateFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFieldRequest.Merge(m, src)
}
func (m *UpdateFieldRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFieldRequest.Size(m)
}
func (m *UpdateFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFieldRequest proto.InternalMessageInfo

func (m *UpdateFieldRequest) GetField() *Field {
	if m != nil {
		return m.Field
	}
	return nil
}

func (m *UpdateFieldRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The request for [FirestoreAdmin.GetField][google.firestore.admin.v1.FirestoreAdmin.GetField].
type GetFieldRequest struct {
	// A name of the form
	// `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}/fields/{field_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetFieldRequest) Reset()         { *m = GetFieldRequest{} }
func (m *GetFieldRequest) String() string { return proto.CompactTextString(m) }
func (*GetFieldRequest) ProtoMessage()    {}
func (*GetFieldRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b39559c0814b3d0, []int{6}
}

func (m *GetFieldRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetFieldRequest.Unmarshal(m, b)
}
func (m *GetFieldRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetFieldRequest.Marshal(b, m, deterministic)
}
func (m *GetFieldRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetFieldRequest.Merge(m, src)
}
func (m *GetFieldRequest) XXX_Size() int {
	return xxx_messageInfo_GetFieldRequest.Size(m)
}
func (m *GetFieldRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetFieldRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetFieldRequest proto.InternalMessageInfo

func (m *GetFieldRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields].
type ListFieldsRequest struct {
	// A parent name of the form
	// `projects/{project_id}/databases/{database_id}/collectionGroups/{collection_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The filter to apply to list results. Currently,
	// [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields] only supports listing fields
	// that have been explicitly overridden. To issue this query, call
	// [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields] with the filter set to
	// `indexConfig.usesAncestorConfig:false`.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The number of results to return.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, returned from a previous call to
	// [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields], that may be used to get the next
	// page of results.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFieldsRequest) Reset()         { *m = ListFieldsRequest{} }
func (m *ListFieldsRequest) String() string { return proto.CompactTextString(m) }
func (*ListFieldsRequest) ProtoMessage()    {}
func (*ListFieldsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b39559c0814b3d0, []int{7}
}

func (m *ListFieldsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFieldsRequest.Unmarshal(m, b)
}
func (m *ListFieldsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFieldsRequest.Marshal(b, m, deterministic)
}
func (m *ListFieldsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFieldsRequest.Merge(m, src)
}
func (m *ListFieldsRequest) XXX_Size() int {
	return xxx_messageInfo_ListFieldsRequest.Size(m)
}
func (m *ListFieldsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFieldsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFieldsRequest proto.InternalMessageInfo

func (m *ListFieldsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListFieldsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListFieldsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListFieldsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields].
type ListFieldsResponse struct {
	// The requested fields.
	Fields []*Field `protobuf:"bytes,1,rep,name=fields,proto3" json:"fields,omitempty"`
	// A page token that may be used to request another page of results. If blank,
	// this is the last page.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFieldsResponse) Reset()         { *m = ListFieldsResponse{} }
func (m *ListFieldsResponse) String() string { return proto.CompactTextString(m) }
func (*ListFieldsResponse) ProtoMessage()    {}
func (*ListFieldsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b39559c0814b3d0, []int{8}
}

func (m *ListFieldsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFieldsResponse.Unmarshal(m, b)
}
func (m *ListFieldsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFieldsResponse.Marshal(b, m, deterministic)
}
func (m *ListFieldsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFieldsResponse.Merge(m, src)
}
func (m *ListFieldsResponse) XXX_Size() int {
	return xxx_messageInfo_ListFieldsResponse.Size(m)
}
func (m *ListFieldsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFieldsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFieldsResponse proto.InternalMessageInfo

func (m *ListFieldsResponse) GetFields() []*Field {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *ListFieldsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for [FirestoreAdmin.ExportDocuments][google.firestore.admin.v1.FirestoreAdmin.ExportDocuments].
type ExportDocumentsRequest struct {
	// Database to export. Should be of the form:
	// `projects/{project_id}/databases/{database_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Which collection ids to export. Unspecified means all collections.
	CollectionIds []string `protobuf:"bytes,2,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// The output URI. Currently only supports Google Cloud Storage URIs of the
	// form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
	// of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
	// Google Cloud Storage namespace path. When
	// choosing a name, be sure to consider Google Cloud Storage naming
	// guidelines: https://cloud.google.com/storage/docs/naming.
	// If the URI is a bucket (without a namespace path), a prefix will be
	// generated based on the start time.
	OutputUriPrefix      string   `protobuf:"bytes,3,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportDocumentsRequest) Reset()         { *m = ExportDocumentsRequest{} }
func (m *ExportDocumentsRequest) String() string { return proto.CompactTextString(m) }
func (*ExportDocumentsRequest) ProtoMessage()    {}
func (*ExportDocumentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b39559c0814b3d0, []int{9}
}

func (m *ExportDocumentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDocumentsRequest.Unmarshal(m, b)
}
func (m *ExportDocumentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDocumentsRequest.Marshal(b, m, deterministic)
}
func (m *ExportDocumentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDocumentsRequest.Merge(m, src)
}
func (m *ExportDocumentsRequest) XXX_Size() int {
	return xxx_messageInfo_ExportDocumentsRequest.Size(m)
}
func (m *ExportDocumentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDocumentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDocumentsRequest proto.InternalMessageInfo

func (m *ExportDocumentsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExportDocumentsRequest) GetCollectionIds() []string {
	if m != nil {
		return m.CollectionIds
	}
	return nil
}

func (m *ExportDocumentsRequest) GetOutputUriPrefix() string {
	if m != nil {
		return m.OutputUriPrefix
	}
	return ""
}

// The request for [FirestoreAdmin.ImportDocuments][google.firestore.admin.v1.FirestoreAdmin.ImportDocuments].
type ImportDocumentsRequest struct {
	// Database to import into. Should be of the form:
	// `projects/{project_id}/databases/{database_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Which collection ids to import. Unspecified means all collections included
	// in the import.
	CollectionIds []string `protobuf:"bytes,2,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// Location of the exported files.
	// This must match the output_uri_prefix of an ExportDocumentsResponse from
	// an export that has completed successfully.
	// See:
	// [google.firestore.admin.v1.ExportDocumentsResponse.output_uri_prefix][google.firestore.admin.v1.ExportDocumentsResponse.output_uri_prefix].
	InputUriPrefix       string   `protobuf:"bytes,3,opt,name=input_uri_prefix,json=inputUriPrefix,proto3" json:"input_uri_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportDocumentsRequest) Reset()         { *m = ImportDocumentsRequest{} }
func (m *ImportDocumentsRequest) String() string { return proto.CompactTextString(m) }
func (*ImportDocumentsRequest) ProtoMessage()    {}
func (*ImportDocumentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_1b39559c0814b3d0, []int{10}
}

func (m *ImportDocumentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportDocumentsRequest.Unmarshal(m, b)
}
func (m *ImportDocumentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportDocumentsRequest.Marshal(b, m, deterministic)
}
func (m *ImportDocumentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportDocumentsRequest.Merge(m, src)
}
func (m *ImportDocumentsRequest) XXX_Size() int {
	return xxx_messageInfo_ImportDocumentsRequest.Size(m)
}
func (m *ImportDocumentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportDocumentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportDocumentsRequest proto.InternalMessageInfo

func (m *ImportDocumentsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImportDocumentsRequest) GetCollectionIds() []string {
	if m != nil {
		return m.CollectionIds
	}
	return nil
}

func (m *ImportDocumentsRequest) GetInputUriPrefix() string {
	if m != nil {
		return m.InputUriPrefix
	}
	return ""
}

func init() {
	proto.RegisterType((*CreateIndexRequest)(nil), "google.firestore.admin.v1.CreateIndexRequest")
	proto.RegisterType((*ListIndexesRequest)(nil), "google.firestore.admin.v1.ListIndexesRequest")
	proto.RegisterType((*ListIndexesResponse)(nil), "google.firestore.admin.v1.ListIndexesResponse")
	proto.RegisterType((*GetIndexRequest)(nil), "google.firestore.admin.v1.GetIndexRequest")
	proto.RegisterType((*DeleteIndexRequest)(nil), "google.firestore.admin.v1.DeleteIndexRequest")
	proto.RegisterType((*UpdateFieldRequest)(nil), "google.firestore.admin.v1.UpdateFieldRequest")
	proto.RegisterType((*GetFieldRequest)(nil), "google.firestore.admin.v1.GetFieldRequest")
	proto.RegisterType((*ListFieldsRequest)(nil), "google.firestore.admin.v1.ListFieldsRequest")
	proto.RegisterType((*ListFieldsResponse)(nil), "google.firestore.admin.v1.ListFieldsResponse")
	proto.RegisterType((*ExportDocumentsRequest)(nil), "google.firestore.admin.v1.ExportDocumentsRequest")
	proto.RegisterType((*ImportDocumentsRequest)(nil), "google.firestore.admin.v1.ImportDocumentsRequest")
}

func init() {
	proto.RegisterFile("google/firestore/admin/v1/firestore_admin.proto", fileDescriptor_1b39559c0814b3d0)
}

var fileDescriptor_1b39559c0814b3d0 = []byte{
	// 1002 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x96, 0x4d, 0x6f, 0x1c, 0x35,
	0x18, 0xc7, 0x35, 0x9b, 0x17, 0x1a, 0x2f, 0x24, 0xd4, 0x95, 0x96, 0x65, 0x4a, 0xc4, 0x6a, 0x50,
	0xd0, 0x6a, 0xd5, 0x8c, 0xb5, 0x41, 0x8a, 0xd0, 0x96, 0x16, 0xd2, 0x34, 0x59, 0x45, 0x6a, 0x45,
	0xb4, 0xa5, 0x15, 0x42, 0x91, 0x56, 0xce, 0xae, 0x77, 0x6b, 0x32, 0x63, 0x0f, 0x63, 0x4f, 0x92,
	0x16, 0x45, 0x45, 0xdc, 0x38, 0x73, 0x45, 0xe2, 0xe5, 0xd8, 0x0b, 0x1c, 0xf8, 0x02, 0x5c, 0x7b,
	0x84, 0xaf, 0xc0, 0xd7, 0x40, 0x42, 0x7e, 0x99, 0x7d, 0xef, 0xcc, 0xd2, 0x56, 0xe2, 0xe6, 0x79,
	0xfc, 0xb7, 0x9f, 0x9f, 0x1f, 0xdb, 0x7f, 0x0f, 0x40, 0x7d, 0xce, 0xfb, 0x01, 0x41, 0x3d, 0x1a,
	0x13, 0x21, 0x79, 0x4c, 0x10, 0xee, 0x86, 0x94, 0xa1, 0xd3, 0xfa, 0x30, 0xd4, 0xd6, 0x21, 0x3f,
	0x8a, 0xb9, 0xe4, 0xf0, 0x6d, 0x33, 0xc0, 0x1f, 0xf4, 0xfa, 0xa6, 0xf7, 0xb4, 0xee, 0xbe, 0x63,
	0xe7, 0xc2, 0x11, 0x45, 0x98, 0x31, 0x2e, 0xb1, 0xa4, 0x9c, 0x09, 0x33, 0xd0, 0xdd, 0xc8, 0xca,
	0x44, 0x82, 0x6e, 0xbe, 0x8c, 0xb2, 0x2e, 0x39, 0xb7, 0xb2, 0xf7, 0xac, 0x2c, 0xe0, 0xac, 0x1f,
	0x27, 0x8c, 0x51, 0xd6, 0x47, 0x3c, 0x22, 0xf1, 0x58, 0xca, 0xab, 0x56, 0xa4, 0xbf, 0x8e, 0x93,
	0x1e, 0x22, 0x61, 0x24, 0x1f, 0xd9, 0xce, 0xca, 0x64, 0xa7, 0xa6, 0x68, 0x87, 0x58, 0x9c, 0x58,
	0xc5, 0x5b, 0x23, 0xeb, 0xe9, 0x04, 0x94, 0x30, 0x69, 0x3a, 0xbc, 0x2e, 0x80, 0xbb, 0x31, 0xc1,
	0x92, 0x1c, 0x28, 0xa2, 0x16, 0xf9, 0x2a, 0x21, 0x42, 0xc2, 0x12, 0x58, 0x8e, 0x70, 0x4c, 0x98,
	0x2c, 0x3b, 0x15, 0xa7, 0xba, 0xd2, 0xb2, 0x5f, 0x70, 0x1b, 0x2c, 0x69, 0xf2, 0x72, 0xa1, 0xe2,
	0x54, 0x8b, 0x5b, 0x15, 0xff, 0xb9, 0x15, 0xf4, 0xcd, 0x7c, 0x46, 0xee, 0x7d, 0xe3, 0x00, 0x78,
	0x87, 0x0a, 0xa9, 0x83, 0x44, 0xe4, 0xa5, 0x29, 0x81, 0xe5, 0x1e, 0x0d, 0x24, 0x89, 0x75, 0x9e,
	0x95, 0x96, 0xfd, 0x82, 0x57, 0xc1, 0x4a, 0x84, 0xfb, 0xa4, 0x2d, 0xe8, 0x63, 0x52, 0x5e, 0xa8,
	0x38, 0xd5, 0xa5, 0xd6, 0x25, 0x15, 0xb8, 0x47, 0x1f, 0x13, 0xb8, 0x0e, 0x80, 0xee, 0x94, 0xfc,
	0x84, 0xb0, 0xf2, 0xa2, 0x1e, 0xa8, 0xe5, 0x9f, 0xa9, 0x80, 0xf7, 0x08, 0x5c, 0x19, 0x23, 0x10,
	0x11, 0x67, 0x82, 0xc0, 0x06, 0x78, 0x8d, 0x9a, 0x50, 0xd9, 0xa9, 0x2c, 0xcc, 0xb5, 0xa6, 0x74,
	0x00, 0x7c, 0x1f, 0xac, 0x31, 0x72, 0x2e, 0xdb, 0x23, 0x69, 0x0d, 0xef, 0x1b, 0x2a, 0x7c, 0x38,
	0x48, 0xbd, 0x01, 0xd6, 0x9a, 0x44, 0x8e, 0x15, 0x18, 0x82, 0x45, 0x86, 0x43, 0x62, 0xd7, 0xad,
	0xdb, 0x5e, 0x15, 0xc0, 0xdb, 0x24, 0x20, 0x13, 0x5b, 0x31, 0x4b, 0xf9, 0x9d, 0x03, 0xe0, 0xfd,
	0xa8, 0x8b, 0x25, 0xd9, 0x57, 0x1b, 0x9d, 0x4a, 0xb7, 0xc1, 0x92, 0xde, 0x78, 0xad, 0xcd, 0x5e,
	0x89, 0x19, 0x67, 0xe4, 0xf0, 0x3a, 0x28, 0x26, 0x7a, 0x36, 0x7d, 0x62, 0xec, 0xde, 0xba, 0xe9,
	0xe8, 0xf4, 0x50, 0x99, 0x31, 0x77, 0xb1, 0x38, 0x69, 0x01, 0x23, 0x57, 0x6d, 0xbb, 0xb8, 0x31,
	0x8e, 0x59, 0xc8, 0x4f, 0xc0, 0x65, 0x55, 0x7e, 0xad, 0xfb, 0x5f, 0xf6, 0xff, 0xd4, 0x9c, 0xc0,
	0x14, 0xc0, 0x6e, 0xff, 0x87, 0x2a, 0x93, 0x8a, 0xcc, 0xb1, 0xfb, 0x66, 0x8d, 0x56, 0x3f, 0xf7,
	0xe6, 0x3f, 0x01, 0xa5, 0xbd, 0xf3, 0x88, 0xc7, 0xf2, 0x36, 0xef, 0x24, 0x21, 0x61, 0x52, 0x64,
	0x94, 0x09, 0x6e, 0x80, 0xd5, 0x0e, 0x0f, 0x02, 0xd2, 0x51, 0x77, 0xbf, 0x4d, 0xbb, 0xa2, 0x5c,
	0xa8, 0x2c, 0xa8, 0x49, 0x87, 0xd1, 0x83, 0xae, 0x80, 0x35, 0x70, 0x99, 0x27, 0x32, 0x4a, 0x64,
	0x3b, 0x89, 0x69, 0x3b, 0x8a, 0x49, 0x8f, 0x9e, 0xeb, 0x82, 0xac, 0xb4, 0xd6, 0x4c, 0xc7, 0xfd,
	0x98, 0x1e, 0xea, 0xb0, 0x77, 0x01, 0x4a, 0x07, 0xe1, 0xab, 0x06, 0xa8, 0x82, 0x37, 0x29, 0x9b,
	0x99, 0x7f, 0x55, 0xc7, 0x07, 0xe9, 0xb7, 0xfe, 0x79, 0x1d, 0xac, 0xee, 0xa7, 0xc5, 0xdc, 0x51,
	0xb5, 0x84, 0x4f, 0x1d, 0x50, 0x1c, 0x31, 0x1d, 0xb8, 0x99, 0x51, 0xf4, 0x69, 0x73, 0x72, 0xd7,
	0x53, 0xf9, 0x88, 0x61, 0xfa, 0x9f, 0xa6, 0x86, 0xe9, 0xdd, 0xfd, 0xf6, 0xaf, 0xbf, 0xbf, 0x2f,
	0x34, 0xbd, 0x9b, 0xca, 0x67, 0xbf, 0x36, 0x27, 0xea, 0x46, 0x14, 0xf3, 0x2f, 0x49, 0x47, 0x0a,
	0x54, 0x43, 0x5d, 0x2c, 0xf1, 0x31, 0x16, 0x44, 0xb5, 0x87, 0x8b, 0x6a, 0xc6, 0x3c, 0x89, 0x04,
	0xaa, 0x5d, 0x20, 0x7b, 0xbb, 0x1b, 0xc6, 0xba, 0xe0, 0xef, 0x0e, 0x28, 0x8e, 0x18, 0x47, 0x26,
	0xec, 0xb4, 0xc5, 0xb9, 0xfe, 0xbc, 0x72, 0x73, 0x20, 0xbd, 0x7d, 0x4d, 0xff, 0x09, 0x7c, 0x49,
	0x7a, 0xf8, 0x93, 0x03, 0x2e, 0xa5, 0xa6, 0x03, 0x6b, 0x19, 0x10, 0x13, 0xce, 0xe4, 0xe6, 0xfa,
	0xdf, 0x04, 0xa2, 0x3a, 0x35, 0xf3, 0x03, 0xa6, 0x7c, 0xa8, 0x76, 0x01, 0x7f, 0x70, 0x40, 0x71,
	0xc4, 0xf0, 0x32, 0x2b, 0x3b, 0x6d, 0x8c, 0x6e, 0x69, 0xca, 0xa0, 0xf6, 0xd4, 0x93, 0x98, 0xe2,
	0xd5, 0x5e, 0x16, 0xef, 0x47, 0x53, 0x41, 0x7d, 0xeb, 0xf3, 0x2a, 0x38, 0x6a, 0x7f, 0x6e, 0xae,
	0x87, 0x78, 0x7b, 0x1a, 0xf1, 0x63, 0x78, 0xe3, 0x45, 0x10, 0x8d, 0xff, 0x28, 0xc2, 0x5f, 0x1d,
	0x50, 0x1c, 0x79, 0x06, 0x32, 0x0b, 0x38, 0xfd, 0x5c, 0xe4, 0xdd, 0xa3, 0x96, 0x86, 0xbc, 0xb3,
	0xb5, 0xab, 0x21, 0xcd, 0x7f, 0xcd, 0x8b, 0xa2, 0x36, 0xec, 0x4b, 0xf3, 0x9b, 0x03, 0xc0, 0xd0,
	0x85, 0xe1, 0xb5, 0x9c, 0xcb, 0x31, 0xf6, 0x5a, 0xb8, 0x9b, 0x73, 0xaa, 0xed, 0x4d, 0x1a, 0x2f,
	0xf2, 0x7f, 0xbf, 0x49, 0xd6, 0xe7, 0x7f, 0x76, 0xc0, 0xda, 0x84, 0x81, 0xc3, 0x7a, 0x06, 0xc9,
	0x6c, 0xb3, 0xcf, 0x2b, 0xf6, 0x47, 0x1a, 0x76, 0xdb, 0xab, 0xe7, 0x9d, 0x88, 0x8b, 0x06, 0x19,
	0x4f, 0xd0, 0x70, 0x6a, 0x9a, 0x71, 0xc2, 0xe3, 0x33, 0x19, 0x67, 0xbf, 0x07, 0xaf, 0x90, 0x91,
	0x86, 0x93, 0x8c, 0xee, 0xe9, 0xb3, 0x9d, 0xf2, 0x10, 0xc5, 0x24, 0xc2, 0x11, 0x15, 0x7e, 0x87,
	0x87, 0x7f, 0xee, 0x7c, 0xfe, 0x50, 0xca, 0x48, 0x34, 0x10, 0x3a, 0x3b, 0x3b, 0x9b, 0xe8, 0x44,
	0x38, 0x91, 0x0f, 0x51, 0x27, 0xe0, 0x49, 0x77, 0x33, 0x0a, 0xb0, 0xec, 0xf1, 0x38, 0xbc, 0x96,
	0x27, 0x57, 0x34, 0x3a, 0xd3, 0xad, 0x3f, 0x1c, 0xb0, 0xde, 0xe1, 0xe1, 0xf3, 0xab, 0x71, 0xeb,
	0xca, 0xf8, 0xf3, 0x74, 0xa8, 0xec, 0xe4, 0xd0, 0xf9, 0xe2, 0xa6, 0x1d, 0xd1, 0xe7, 0x01, 0x66,
	0x7d, 0x9f, 0xc7, 0x7d, 0xd4, 0x27, 0x4c, 0x9b, 0x0d, 0x1a, 0xa6, 0x9c, 0xf1, 0x73, 0x7f, 0x5d,
	0x37, 0x7e, 0x29, 0x2c, 0x36, 0x77, 0xf7, 0xef, 0x3d, 0x2d, 0xbc, 0xdb, 0x34, 0xf3, 0xec, 0xaa,
	0x15, 0xf8, 0x83, 0x5c, 0xbe, 0x4e, 0xe6, 0x3f, 0xa8, 0x3f, 0x4b, 0x15, 0x47, 0x5a, 0x71, 0x34,
	0x50, 0x1c, 0x69, 0xc5, 0xd1, 0x83, 0xfa, 0xf1, 0xb2, 0xce, 0xfa, 0xc1, 0xbf, 0x01, 0x00, 0x00,
	0xff, 0xff, 0xc2, 0x64, 0x7f, 0xf0, 0xe2, 0x0c, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// FirestoreAdminClient is the client API for FirestoreAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FirestoreAdminClient interface {
	// Creates a composite index. This returns a [google.longrunning.Operation][google.longrunning.Operation]
	// which may be used to track the status of the creation. The metadata for
	// the operation will be the type [IndexOperationMetadata][google.firestore.admin.v1.IndexOperationMetadata].
	CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists composite indexes.
	ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error)
	// Gets a composite index.
	GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error)
	// Deletes a composite index.
	DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets the metadata and configuration for a Field.
	GetField(ctx context.Context, in *GetFieldRequest, opts ...grpc.CallOption) (*Field, error)
	// Updates a field configuration. Currently, field updates apply only to
	// single field index configuration. However, calls to
	// [FirestoreAdmin.UpdateField][google.firestore.admin.v1.FirestoreAdmin.UpdateField] should provide a field mask to avoid
	// changing any configuration that the caller isn't aware of. The field mask
	// should be specified as: `{ paths: "index_config" }`.
	//
	// This call returns a [google.longrunning.Operation][google.longrunning.Operation] which may be used to
	// track the status of the field update. The metadata for
	// the operation will be the type [FieldOperationMetadata][google.firestore.admin.v1.FieldOperationMetadata].
	//
	// To configure the default field settings for the database, use
	// the special `Field` with resource name:
	// `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/*`.
	UpdateField(ctx context.Context, in *UpdateFieldRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists the field configuration and metadata for this database.
	//
	// Currently, [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields] only supports listing fields
	// that have been explicitly overridden. To issue this query, call
	// [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields] with the filter set to
	// `indexConfig.usesAncestorConfig:false`.
	ListFields(ctx context.Context, in *ListFieldsRequest, opts ...grpc.CallOption) (*ListFieldsResponse, error)
	// Exports a copy of all or a subset of documents from Google Cloud Firestore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// documents may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportDocuments(ctx context.Context, in *ExportDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports documents into Google Cloud Firestore. Existing documents with the
	// same name are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportDocuments operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Firestore.
	ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type firestoreAdminClient struct {
	cc *grpc.ClientConn
}

func NewFirestoreAdminClient(cc *grpc.ClientConn) FirestoreAdminClient {
	return &firestoreAdminClient{cc}
}

func (c *firestoreAdminClient) CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1.FirestoreAdmin/CreateIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error) {
	out := new(ListIndexesResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1.FirestoreAdmin/ListIndexes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error) {
	out := new(Index)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1.FirestoreAdmin/GetIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1.FirestoreAdmin/DeleteIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) GetField(ctx context.Context, in *GetFieldRequest, opts ...grpc.CallOption) (*Field, error) {
	out := new(Field)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1.FirestoreAdmin/GetField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) UpdateField(ctx context.Context, in *UpdateFieldRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1.FirestoreAdmin/UpdateField", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ListFields(ctx context.Context, in *ListFieldsRequest, opts ...grpc.CallOption) (*ListFieldsResponse, error) {
	out := new(ListFieldsResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1.FirestoreAdmin/ListFields", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ExportDocuments(ctx context.Context, in *ExportDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1.FirestoreAdmin/ExportDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1.FirestoreAdmin/ImportDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FirestoreAdminServer is the server API for FirestoreAdmin service.
type FirestoreAdminServer interface {
	// Creates a composite index. This returns a [google.longrunning.Operation][google.longrunning.Operation]
	// which may be used to track the status of the creation. The metadata for
	// the operation will be the type [IndexOperationMetadata][google.firestore.admin.v1.IndexOperationMetadata].
	CreateIndex(context.Context, *CreateIndexRequest) (*longrunning.Operation, error)
	// Lists composite indexes.
	ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error)
	// Gets a composite index.
	GetIndex(context.Context, *GetIndexRequest) (*Index, error)
	// Deletes a composite index.
	DeleteIndex(context.Context, *DeleteIndexRequest) (*empty.Empty, error)
	// Gets the metadata and configuration for a Field.
	GetField(context.Context, *GetFieldRequest) (*Field, error)
	// Updates a field configuration. Currently, field updates apply only to
	// single field index configuration. However, calls to
	// [FirestoreAdmin.UpdateField][google.firestore.admin.v1.FirestoreAdmin.UpdateField] should provide a field mask to avoid
	// changing any configuration that the caller isn't aware of. The field mask
	// should be specified as: `{ paths: "index_config" }`.
	//
	// This call returns a [google.longrunning.Operation][google.longrunning.Operation] which may be used to
	// track the status of the field update. The metadata for
	// the operation will be the type [FieldOperationMetadata][google.firestore.admin.v1.FieldOperationMetadata].
	//
	// To configure the default field settings for the database, use
	// the special `Field` with resource name:
	// `projects/{project_id}/databases/{database_id}/collectionGroups/__default__/fields/*`.
	UpdateField(context.Context, *UpdateFieldRequest) (*longrunning.Operation, error)
	// Lists the field configuration and metadata for this database.
	//
	// Currently, [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields] only supports listing fields
	// that have been explicitly overridden. To issue this query, call
	// [FirestoreAdmin.ListFields][google.firestore.admin.v1.FirestoreAdmin.ListFields] with the filter set to
	// `indexConfig.usesAncestorConfig:false`.
	ListFields(context.Context, *ListFieldsRequest) (*ListFieldsResponse, error)
	// Exports a copy of all or a subset of documents from Google Cloud Firestore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// documents may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportDocuments(context.Context, *ExportDocumentsRequest) (*longrunning.Operation, error)
	// Imports documents into Google Cloud Firestore. Existing documents with the
	// same name are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportDocuments operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Firestore.
	ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunning.Operation, error)
}

func RegisterFirestoreAdminServer(s *grpc.Server, srv FirestoreAdminServer) {
	s.RegisterService(&_FirestoreAdmin_serviceDesc, srv)
}

func _FirestoreAdmin_CreateIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).CreateIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1.FirestoreAdmin/CreateIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).CreateIndex(ctx, req.(*CreateIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ListIndexes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIndexesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ListIndexes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1.FirestoreAdmin/ListIndexes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ListIndexes(ctx, req.(*ListIndexesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_GetIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).GetIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1.FirestoreAdmin/GetIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).GetIndex(ctx, req.(*GetIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_DeleteIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).DeleteIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1.FirestoreAdmin/DeleteIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).DeleteIndex(ctx, req.(*DeleteIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_GetField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).GetField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1.FirestoreAdmin/GetField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).GetField(ctx, req.(*GetFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_UpdateField_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFieldRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).UpdateField(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1.FirestoreAdmin/UpdateField",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).UpdateField(ctx, req.(*UpdateFieldRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ListFields_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFieldsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ListFields(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1.FirestoreAdmin/ListFields",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ListFields(ctx, req.(*ListFieldsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ExportDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ExportDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1.FirestoreAdmin/ExportDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ExportDocuments(ctx, req.(*ExportDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ImportDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ImportDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1.FirestoreAdmin/ImportDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ImportDocuments(ctx, req.(*ImportDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FirestoreAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.firestore.admin.v1.FirestoreAdmin",
	HandlerType: (*FirestoreAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateIndex",
			Handler:    _FirestoreAdmin_CreateIndex_Handler,
		},
		{
			MethodName: "ListIndexes",
			Handler:    _FirestoreAdmin_ListIndexes_Handler,
		},
		{
			MethodName: "GetIndex",
			Handler:    _FirestoreAdmin_GetIndex_Handler,
		},
		{
			MethodName: "DeleteIndex",
			Handler:    _FirestoreAdmin_DeleteIndex_Handler,
		},
		{
			MethodName: "GetField",
			Handler:    _FirestoreAdmin_GetField_Handler,
		},
		{
			MethodName: "UpdateField",
			Handler:    _FirestoreAdmin_UpdateField_Handler,
		},
		{
			MethodName: "ListFields",
			Handler:    _FirestoreAdmin_ListFields_Handler,
		},
		{
			MethodName: "ExportDocuments",
			Handler:    _FirestoreAdmin_ExportDocuments_Handler,
		},
		{
			MethodName: "ImportDocuments",
			Handler:    _FirestoreAdmin_ImportDocuments_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/firestore/admin/v1/firestore_admin.proto",
}
