// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/session.proto

package dialogflow

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_struct "github.com/golang/protobuf/ptypes/struct"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Represents the system's confidence that this knowledge answer is a good
// match for this conversational query.
type KnowledgeAnswers_Answer_MatchConfidenceLevel int32

const (
	// Not specified.
	KnowledgeAnswers_Answer_MATCH_CONFIDENCE_LEVEL_UNSPECIFIED KnowledgeAnswers_Answer_MatchConfidenceLevel = 0
	// Indicates that the confidence is low.
	KnowledgeAnswers_Answer_LOW KnowledgeAnswers_Answer_MatchConfidenceLevel = 1
	// Indicates our confidence is medium.
	KnowledgeAnswers_Answer_MEDIUM KnowledgeAnswers_Answer_MatchConfidenceLevel = 2
	// Indicates our confidence is high.
	KnowledgeAnswers_Answer_HIGH KnowledgeAnswers_Answer_MatchConfidenceLevel = 3
)

var KnowledgeAnswers_Answer_MatchConfidenceLevel_name = map[int32]string{
	0: "MATCH_CONFIDENCE_LEVEL_UNSPECIFIED",
	1: "LOW",
	2: "MEDIUM",
	3: "HIGH",
}

var KnowledgeAnswers_Answer_MatchConfidenceLevel_value = map[string]int32{
	"MATCH_CONFIDENCE_LEVEL_UNSPECIFIED": 0,
	"LOW":                                1,
	"MEDIUM":                             2,
	"HIGH":                               3,
}

func (x KnowledgeAnswers_Answer_MatchConfidenceLevel) String() string {
	return proto.EnumName(KnowledgeAnswers_Answer_MatchConfidenceLevel_name, int32(x))
}

func (KnowledgeAnswers_Answer_MatchConfidenceLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{5, 0, 0}
}

// Type of the response message.
type StreamingRecognitionResult_MessageType int32

const (
	// Not specified. Should never be used.
	StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED StreamingRecognitionResult_MessageType = 0
	// Message contains a (possibly partial) transcript.
	StreamingRecognitionResult_TRANSCRIPT StreamingRecognitionResult_MessageType = 1
	// Event indicates that the server has detected the end of the user's speech
	// utterance and expects no additional speech. Therefore, the server will
	// not process additional audio (although it may subsequently return
	// additional results). The client should stop sending additional audio
	// data, half-close the gRPC connection, and wait for any additional results
	// until the server closes the gRPC connection. This message is only sent if
	// `single_utterance` was set to `true`, and is not used otherwise.
	StreamingRecognitionResult_END_OF_SINGLE_UTTERANCE StreamingRecognitionResult_MessageType = 2
)

var StreamingRecognitionResult_MessageType_name = map[int32]string{
	0: "MESSAGE_TYPE_UNSPECIFIED",
	1: "TRANSCRIPT",
	2: "END_OF_SINGLE_UTTERANCE",
}

var StreamingRecognitionResult_MessageType_value = map[string]int32{
	"MESSAGE_TYPE_UNSPECIFIED": 0,
	"TRANSCRIPT":               1,
	"END_OF_SINGLE_UTTERANCE":  2,
}

func (x StreamingRecognitionResult_MessageType) String() string {
	return proto.EnumName(StreamingRecognitionResult_MessageType_name, int32(x))
}

func (StreamingRecognitionResult_MessageType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{8, 0}
}

// The request to detect user's intent.
type DetectIntentRequest struct {
	// Required. The name of the session this query is sent to. Format:
	// `projects/<Project ID>/agent/sessions/<Session ID>`, or
	// `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
	// ID>/sessions/<Session ID>`. If `Environment ID` is not specified, we assume
	// default 'draft' environment. If `User ID` is not specified, we are using
	// "-". It's up to the API caller to choose an appropriate `Session ID` and
	// `User Id`. They can be a random number or some type of user and session
	// identifiers (preferably hashed). The length of the `Session ID` and
	// `User ID` must not exceed 36 characters.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Optional. The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification. It can be set to:
	//
	// 1.  an audio config
	//     which instructs the speech recognizer how to process the speech audio,
	//
	// 2.  a conversational query in the form of text, or
	//
	// 3.  an event that specifies which intent to trigger.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// Optional. Instructs the speech synthesizer how to generate the output
	// audio. If this field is not set and agent-level speech synthesizer is not
	// configured, no output audio is generated.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,4,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	// Optional. The natural language speech audio to be processed. This field
	// should be populated iff `query_input` is set to an input audio config.
	// A single request can contain up to 1 minute of speech audio data.
	InputAudio           []byte   `protobuf:"bytes,5,opt,name=input_audio,json=inputAudio,proto3" json:"input_audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DetectIntentRequest) Reset()         { *m = DetectIntentRequest{} }
func (m *DetectIntentRequest) String() string { return proto.CompactTextString(m) }
func (*DetectIntentRequest) ProtoMessage()    {}
func (*DetectIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{0}
}

func (m *DetectIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectIntentRequest.Unmarshal(m, b)
}
func (m *DetectIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectIntentRequest.Marshal(b, m, deterministic)
}
func (m *DetectIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectIntentRequest.Merge(m, src)
}
func (m *DetectIntentRequest) XXX_Size() int {
	return xxx_messageInfo_DetectIntentRequest.Size(m)
}
func (m *DetectIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DetectIntentRequest proto.InternalMessageInfo

func (m *DetectIntentRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *DetectIntentRequest) GetQueryParams() *QueryParameters {
	if m != nil {
		return m.QueryParams
	}
	return nil
}

func (m *DetectIntentRequest) GetQueryInput() *QueryInput {
	if m != nil {
		return m.QueryInput
	}
	return nil
}

func (m *DetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

func (m *DetectIntentRequest) GetInputAudio() []byte {
	if m != nil {
		return m.InputAudio
	}
	return nil
}

// The message returned from the DetectIntent method.
type DetectIntentResponse struct {
	// The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The selected results of the conversational query or event processing.
	// See `alternative_query_results` for additional potential results.
	QueryResult *QueryResult `protobuf:"bytes,2,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// If Knowledge Connectors are enabled, there could be more than one result
	// returned for a given query or event, and this field will contain all
	// results except for the top one, which is captured in query_result. The
	// alternative results are ordered by decreasing
	// `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
	// disabled, this field will be empty until multiple responses for regular
	// intents are supported, at which point those additional results will be
	// surfaced here.
	AlternativeQueryResults []*QueryResult `protobuf:"bytes,5,rep,name=alternative_query_results,json=alternativeQueryResults,proto3" json:"alternative_query_results,omitempty"`
	// Specifies the status of the webhook request.
	WebhookStatus *status.Status `protobuf:"bytes,3,opt,name=webhook_status,json=webhookStatus,proto3" json:"webhook_status,omitempty"`
	// The audio data bytes encoded as specified in the request.
	// Note: The output audio is generated based on the values of default platform
	// text responses found in the `query_result.fulfillment_messages` field. If
	// multiple default text responses exist, they will be concatenated when
	// generating audio. If no default platform text responses exist, the
	// generated audio content will be empty.
	OutputAudio []byte `protobuf:"bytes,4,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// The config used by the speech synthesizer to generate the output audio.
	OutputAudioConfig    *OutputAudioConfig `protobuf:"bytes,6,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *DetectIntentResponse) Reset()         { *m = DetectIntentResponse{} }
func (m *DetectIntentResponse) String() string { return proto.CompactTextString(m) }
func (*DetectIntentResponse) ProtoMessage()    {}
func (*DetectIntentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{1}
}

func (m *DetectIntentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DetectIntentResponse.Unmarshal(m, b)
}
func (m *DetectIntentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DetectIntentResponse.Marshal(b, m, deterministic)
}
func (m *DetectIntentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DetectIntentResponse.Merge(m, src)
}
func (m *DetectIntentResponse) XXX_Size() int {
	return xxx_messageInfo_DetectIntentResponse.Size(m)
}
func (m *DetectIntentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_DetectIntentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_DetectIntentResponse proto.InternalMessageInfo

func (m *DetectIntentResponse) GetResponseId() string {
	if m != nil {
		return m.ResponseId
	}
	return ""
}

func (m *DetectIntentResponse) GetQueryResult() *QueryResult {
	if m != nil {
		return m.QueryResult
	}
	return nil
}

func (m *DetectIntentResponse) GetAlternativeQueryResults() []*QueryResult {
	if m != nil {
		return m.AlternativeQueryResults
	}
	return nil
}

func (m *DetectIntentResponse) GetWebhookStatus() *status.Status {
	if m != nil {
		return m.WebhookStatus
	}
	return nil
}

func (m *DetectIntentResponse) GetOutputAudio() []byte {
	if m != nil {
		return m.OutputAudio
	}
	return nil
}

func (m *DetectIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

// Represents the parameters of the conversational query.
type QueryParameters struct {
	// Optional. The time zone of this conversational query from the
	// [time zone database](https://www.iana.org/time-zones), e.g.,
	// America/New_York, Europe/Paris. If not provided, the time zone specified in
	// agent settings is used.
	TimeZone string `protobuf:"bytes,1,opt,name=time_zone,json=timeZone,proto3" json:"time_zone,omitempty"`
	// Optional. The geo location of this conversational query.
	GeoLocation *latlng.LatLng `protobuf:"bytes,2,opt,name=geo_location,json=geoLocation,proto3" json:"geo_location,omitempty"`
	// Optional. The collection of contexts to be activated before this query is
	// executed.
	Contexts []*Context `protobuf:"bytes,3,rep,name=contexts,proto3" json:"contexts,omitempty"`
	// Optional. Specifies whether to delete all contexts in the current session
	// before the new ones are activated.
	ResetContexts bool `protobuf:"varint,4,opt,name=reset_contexts,json=resetContexts,proto3" json:"reset_contexts,omitempty"`
	// Optional. Additional session entity types to replace or extend developer
	// entity types with. The entity synonyms apply to all languages and persist
	// for the session of this query.
	SessionEntityTypes []*SessionEntityType `protobuf:"bytes,5,rep,name=session_entity_types,json=sessionEntityTypes,proto3" json:"session_entity_types,omitempty"`
	// Optional. This field can be used to pass custom data into the webhook
	// associated with the agent. Arbitrary JSON objects are supported.
	Payload *_struct.Struct `protobuf:"bytes,6,opt,name=payload,proto3" json:"payload,omitempty"`
	// Optional. KnowledgeBases to get alternative results from. If not set, the
	// KnowledgeBases enabled in the agent (through UI) will be used.
	// Format:  `projects/<Project ID>/knowledgeBases/<Knowledge Base ID>`.
	KnowledgeBaseNames []string `protobuf:"bytes,12,rep,name=knowledge_base_names,json=knowledgeBaseNames,proto3" json:"knowledge_base_names,omitempty"`
	// Optional. Configures the type of sentiment analysis to perform. If not
	// provided, sentiment analysis is not performed.
	// Note: Sentiment Analysis is only currently available for Enterprise Edition
	// agents.
	SentimentAnalysisRequestConfig *SentimentAnalysisRequestConfig `protobuf:"bytes,10,opt,name=sentiment_analysis_request_config,json=sentimentAnalysisRequestConfig,proto3" json:"sentiment_analysis_request_config,omitempty"`
	XXX_NoUnkeyedLiteral           struct{}                        `json:"-"`
	XXX_unrecognized               []byte                          `json:"-"`
	XXX_sizecache                  int32                           `json:"-"`
}

func (m *QueryParameters) Reset()         { *m = QueryParameters{} }
func (m *QueryParameters) String() string { return proto.CompactTextString(m) }
func (*QueryParameters) ProtoMessage()    {}
func (*QueryParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{2}
}

func (m *QueryParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryParameters.Unmarshal(m, b)
}
func (m *QueryParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryParameters.Marshal(b, m, deterministic)
}
func (m *QueryParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryParameters.Merge(m, src)
}
func (m *QueryParameters) XXX_Size() int {
	return xxx_messageInfo_QueryParameters.Size(m)
}
func (m *QueryParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryParameters.DiscardUnknown(m)
}

var xxx_messageInfo_QueryParameters proto.InternalMessageInfo

func (m *QueryParameters) GetTimeZone() string {
	if m != nil {
		return m.TimeZone
	}
	return ""
}

func (m *QueryParameters) GetGeoLocation() *latlng.LatLng {
	if m != nil {
		return m.GeoLocation
	}
	return nil
}

func (m *QueryParameters) GetContexts() []*Context {
	if m != nil {
		return m.Contexts
	}
	return nil
}

func (m *QueryParameters) GetResetContexts() bool {
	if m != nil {
		return m.ResetContexts
	}
	return false
}

func (m *QueryParameters) GetSessionEntityTypes() []*SessionEntityType {
	if m != nil {
		return m.SessionEntityTypes
	}
	return nil
}

func (m *QueryParameters) GetPayload() *_struct.Struct {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *QueryParameters) GetKnowledgeBaseNames() []string {
	if m != nil {
		return m.KnowledgeBaseNames
	}
	return nil
}

func (m *QueryParameters) GetSentimentAnalysisRequestConfig() *SentimentAnalysisRequestConfig {
	if m != nil {
		return m.SentimentAnalysisRequestConfig
	}
	return nil
}

// Represents the query input. It can contain either:
//
// 1.  An audio config which
//     instructs the speech recognizer how to process the speech audio.
//
// 2.  A conversational query in the form of text.
//
// 3.  An event that specifies which intent to trigger.
type QueryInput struct {
	// Required. The input specification.
	//
	// Types that are valid to be assigned to Input:
	//	*QueryInput_AudioConfig
	//	*QueryInput_Text
	//	*QueryInput_Event
	Input                isQueryInput_Input `protobuf_oneof:"input"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *QueryInput) Reset()         { *m = QueryInput{} }
func (m *QueryInput) String() string { return proto.CompactTextString(m) }
func (*QueryInput) ProtoMessage()    {}
func (*QueryInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{3}
}

func (m *QueryInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryInput.Unmarshal(m, b)
}
func (m *QueryInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryInput.Marshal(b, m, deterministic)
}
func (m *QueryInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryInput.Merge(m, src)
}
func (m *QueryInput) XXX_Size() int {
	return xxx_messageInfo_QueryInput.Size(m)
}
func (m *QueryInput) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryInput.DiscardUnknown(m)
}

var xxx_messageInfo_QueryInput proto.InternalMessageInfo

type isQueryInput_Input interface {
	isQueryInput_Input()
}

type QueryInput_AudioConfig struct {
	AudioConfig *InputAudioConfig `protobuf:"bytes,1,opt,name=audio_config,json=audioConfig,proto3,oneof"`
}

type QueryInput_Text struct {
	Text *TextInput `protobuf:"bytes,2,opt,name=text,proto3,oneof"`
}

type QueryInput_Event struct {
	Event *EventInput `protobuf:"bytes,3,opt,name=event,proto3,oneof"`
}

func (*QueryInput_AudioConfig) isQueryInput_Input() {}

func (*QueryInput_Text) isQueryInput_Input() {}

func (*QueryInput_Event) isQueryInput_Input() {}

func (m *QueryInput) GetInput() isQueryInput_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (m *QueryInput) GetAudioConfig() *InputAudioConfig {
	if x, ok := m.GetInput().(*QueryInput_AudioConfig); ok {
		return x.AudioConfig
	}
	return nil
}

func (m *QueryInput) GetText() *TextInput {
	if x, ok := m.GetInput().(*QueryInput_Text); ok {
		return x.Text
	}
	return nil
}

func (m *QueryInput) GetEvent() *EventInput {
	if x, ok := m.GetInput().(*QueryInput_Event); ok {
		return x.Event
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*QueryInput) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*QueryInput_AudioConfig)(nil),
		(*QueryInput_Text)(nil),
		(*QueryInput_Event)(nil),
	}
}

// Represents the result of conversational query or event processing.
type QueryResult struct {
	// The original conversational query text:
	//
	// - If natural language text was provided as input, `query_text` contains
	//   a copy of the input.
	// - If natural language speech audio was provided as input, `query_text`
	//   contains the speech recognition result. If speech recognizer produced
	//   multiple alternatives, a particular one is picked.
	// - If automatic spell correction is enabled, `query_text` will contain the
	//   corrected user input.
	QueryText string `protobuf:"bytes,1,opt,name=query_text,json=queryText,proto3" json:"query_text,omitempty"`
	// The language that was triggered during intent detection.
	// See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,15,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The Speech recognition confidence between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. The default of 0.0 is a sentinel value indicating that confidence
	// was not set.
	//
	// This field is not guaranteed to be accurate or set. In particular this
	// field isn't set for StreamingDetectIntent since the streaming endpoint has
	// separate confidence estimates per portion of the audio in
	// StreamingRecognitionResult.
	SpeechRecognitionConfidence float32 `protobuf:"fixed32,2,opt,name=speech_recognition_confidence,json=speechRecognitionConfidence,proto3" json:"speech_recognition_confidence,omitempty"`
	// The action name from the matched intent.
	Action string `protobuf:"bytes,3,opt,name=action,proto3" json:"action,omitempty"`
	// The collection of extracted parameters.
	Parameters *_struct.Struct `protobuf:"bytes,4,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// This field is set to:
	//
	// - `false` if the matched intent has required parameters and not all of
	//    the required parameter values have been collected.
	// - `true` if all required parameter values have been collected, or if the
	//    matched intent doesn't contain any required parameters.
	AllRequiredParamsPresent bool `protobuf:"varint,5,opt,name=all_required_params_present,json=allRequiredParamsPresent,proto3" json:"all_required_params_present,omitempty"`
	// The text to be pronounced to the user or shown on the screen.
	// Note: This is a legacy field, `fulfillment_messages` should be preferred.
	FulfillmentText string `protobuf:"bytes,6,opt,name=fulfillment_text,json=fulfillmentText,proto3" json:"fulfillment_text,omitempty"`
	// The collection of rich messages to present to the user.
	FulfillmentMessages []*Intent_Message `protobuf:"bytes,7,rep,name=fulfillment_messages,json=fulfillmentMessages,proto3" json:"fulfillment_messages,omitempty"`
	// If the query was fulfilled by a webhook call, this field is set to the
	// value of the `source` field returned in the webhook response.
	WebhookSource string `protobuf:"bytes,8,opt,name=webhook_source,json=webhookSource,proto3" json:"webhook_source,omitempty"`
	// If the query was fulfilled by a webhook call, this field is set to the
	// value of the `payload` field returned in the webhook response.
	WebhookPayload *_struct.Struct `protobuf:"bytes,9,opt,name=webhook_payload,json=webhookPayload,proto3" json:"webhook_payload,omitempty"`
	// The collection of output contexts. If applicable,
	// `output_contexts.parameters` contains entries with name
	// `<parameter name>.original` containing the original parameter values
	// before the query.
	OutputContexts []*Context `protobuf:"bytes,10,rep,name=output_contexts,json=outputContexts,proto3" json:"output_contexts,omitempty"`
	// The intent that matched the conversational query. Some, not
	// all fields are filled in this message, including but not limited to:
	// `name`, `display_name`, `end_interaction` and `is_fallback`.
	Intent *Intent `protobuf:"bytes,11,opt,name=intent,proto3" json:"intent,omitempty"`
	// The intent detection confidence. Values range from 0.0
	// (completely uncertain) to 1.0 (completely certain).
	// This value is for informational purpose only and is only used to
	// help match the best intent within the classification threshold.
	// This value may change for the same end-user expression at any time due to a
	// model retraining or change in implementation.
	// If there are `multiple knowledge_answers` messages, this value is set to
	// the greatest `knowledgeAnswers.match_confidence` value in the list.
	IntentDetectionConfidence float32 `protobuf:"fixed32,12,opt,name=intent_detection_confidence,json=intentDetectionConfidence,proto3" json:"intent_detection_confidence,omitempty"`
	// The free-form diagnostic info. For example, this field could contain
	// webhook call latency. The string keys of the Struct's fields map can change
	// without notice.
	DiagnosticInfo *_struct.Struct `protobuf:"bytes,14,opt,name=diagnostic_info,json=diagnosticInfo,proto3" json:"diagnostic_info,omitempty"`
	// The sentiment analysis result, which depends on the
	// `sentiment_analysis_request_config` specified in the request.
	SentimentAnalysisResult *SentimentAnalysisResult `protobuf:"bytes,17,opt,name=sentiment_analysis_result,json=sentimentAnalysisResult,proto3" json:"sentiment_analysis_result,omitempty"`
	// The result from Knowledge Connector (if any), ordered by decreasing
	// `KnowledgeAnswers.match_confidence`.
	KnowledgeAnswers     *KnowledgeAnswers `protobuf:"bytes,18,opt,name=knowledge_answers,json=knowledgeAnswers,proto3" json:"knowledge_answers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *QueryResult) Reset()         { *m = QueryResult{} }
func (m *QueryResult) String() string { return proto.CompactTextString(m) }
func (*QueryResult) ProtoMessage()    {}
func (*QueryResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{4}
}

func (m *QueryResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryResult.Unmarshal(m, b)
}
func (m *QueryResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryResult.Marshal(b, m, deterministic)
}
func (m *QueryResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryResult.Merge(m, src)
}
func (m *QueryResult) XXX_Size() int {
	return xxx_messageInfo_QueryResult.Size(m)
}
func (m *QueryResult) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryResult.DiscardUnknown(m)
}

var xxx_messageInfo_QueryResult proto.InternalMessageInfo

func (m *QueryResult) GetQueryText() string {
	if m != nil {
		return m.QueryText
	}
	return ""
}

func (m *QueryResult) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *QueryResult) GetSpeechRecognitionConfidence() float32 {
	if m != nil {
		return m.SpeechRecognitionConfidence
	}
	return 0
}

func (m *QueryResult) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *QueryResult) GetParameters() *_struct.Struct {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *QueryResult) GetAllRequiredParamsPresent() bool {
	if m != nil {
		return m.AllRequiredParamsPresent
	}
	return false
}

func (m *QueryResult) GetFulfillmentText() string {
	if m != nil {
		return m.FulfillmentText
	}
	return ""
}

func (m *QueryResult) GetFulfillmentMessages() []*Intent_Message {
	if m != nil {
		return m.FulfillmentMessages
	}
	return nil
}

func (m *QueryResult) GetWebhookSource() string {
	if m != nil {
		return m.WebhookSource
	}
	return ""
}

func (m *QueryResult) GetWebhookPayload() *_struct.Struct {
	if m != nil {
		return m.WebhookPayload
	}
	return nil
}

func (m *QueryResult) GetOutputContexts() []*Context {
	if m != nil {
		return m.OutputContexts
	}
	return nil
}

func (m *QueryResult) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

func (m *QueryResult) GetIntentDetectionConfidence() float32 {
	if m != nil {
		return m.IntentDetectionConfidence
	}
	return 0
}

func (m *QueryResult) GetDiagnosticInfo() *_struct.Struct {
	if m != nil {
		return m.DiagnosticInfo
	}
	return nil
}

func (m *QueryResult) GetSentimentAnalysisResult() *SentimentAnalysisResult {
	if m != nil {
		return m.SentimentAnalysisResult
	}
	return nil
}

func (m *QueryResult) GetKnowledgeAnswers() *KnowledgeAnswers {
	if m != nil {
		return m.KnowledgeAnswers
	}
	return nil
}

// Represents the result of querying a Knowledge base.
type KnowledgeAnswers struct {
	// A list of answers from Knowledge Connector.
	Answers              []*KnowledgeAnswers_Answer `protobuf:"bytes,1,rep,name=answers,proto3" json:"answers,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *KnowledgeAnswers) Reset()         { *m = KnowledgeAnswers{} }
func (m *KnowledgeAnswers) String() string { return proto.CompactTextString(m) }
func (*KnowledgeAnswers) ProtoMessage()    {}
func (*KnowledgeAnswers) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{5}
}

func (m *KnowledgeAnswers) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KnowledgeAnswers.Unmarshal(m, b)
}
func (m *KnowledgeAnswers) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KnowledgeAnswers.Marshal(b, m, deterministic)
}
func (m *KnowledgeAnswers) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KnowledgeAnswers.Merge(m, src)
}
func (m *KnowledgeAnswers) XXX_Size() int {
	return xxx_messageInfo_KnowledgeAnswers.Size(m)
}
func (m *KnowledgeAnswers) XXX_DiscardUnknown() {
	xxx_messageInfo_KnowledgeAnswers.DiscardUnknown(m)
}

var xxx_messageInfo_KnowledgeAnswers proto.InternalMessageInfo

func (m *KnowledgeAnswers) GetAnswers() []*KnowledgeAnswers_Answer {
	if m != nil {
		return m.Answers
	}
	return nil
}

// An answer from Knowledge Connector.
type KnowledgeAnswers_Answer struct {
	// Indicates which Knowledge Document this answer was extracted from.
	// Format: `projects/<Project ID>/knowledgeBases/<Knowledge Base
	// ID>/documents/<Document ID>`.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The corresponding FAQ question if the answer was extracted from a FAQ
	// Document, empty otherwise.
	FaqQuestion string `protobuf:"bytes,2,opt,name=faq_question,json=faqQuestion,proto3" json:"faq_question,omitempty"`
	// The piece of text from the `source` knowledge base document that answers
	// this conversational query.
	Answer string `protobuf:"bytes,3,opt,name=answer,proto3" json:"answer,omitempty"`
	// The system's confidence level that this knowledge answer is a good match
	// for this conversational query.
	// NOTE: The confidence level for a given `<query, answer>` pair may change
	// without notice, as it depends on models that are constantly being
	// improved. However, it will change less frequently than the confidence
	// score below, and should be preferred for referencing the quality of an
	// answer.
	MatchConfidenceLevel KnowledgeAnswers_Answer_MatchConfidenceLevel `protobuf:"varint,4,opt,name=match_confidence_level,json=matchConfidenceLevel,proto3,enum=google.cloud.dialogflow.v2beta1.KnowledgeAnswers_Answer_MatchConfidenceLevel" json:"match_confidence_level,omitempty"`
	// The system's confidence score that this Knowledge answer is a good match
	// for this conversational query.
	// The range is from 0.0 (completely uncertain) to 1.0 (completely certain).
	// Note: The confidence score is likely to vary somewhat (possibly even for
	// identical requests), as the underlying model is under constant
	// improvement. It may be deprecated in the future. We recommend using
	// `match_confidence_level` which should be generally more stable.
	MatchConfidence      float32  `protobuf:"fixed32,5,opt,name=match_confidence,json=matchConfidence,proto3" json:"match_confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KnowledgeAnswers_Answer) Reset()         { *m = KnowledgeAnswers_Answer{} }
func (m *KnowledgeAnswers_Answer) String() string { return proto.CompactTextString(m) }
func (*KnowledgeAnswers_Answer) ProtoMessage()    {}
func (*KnowledgeAnswers_Answer) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{5, 0}
}

func (m *KnowledgeAnswers_Answer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KnowledgeAnswers_Answer.Unmarshal(m, b)
}
func (m *KnowledgeAnswers_Answer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KnowledgeAnswers_Answer.Marshal(b, m, deterministic)
}
func (m *KnowledgeAnswers_Answer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KnowledgeAnswers_Answer.Merge(m, src)
}
func (m *KnowledgeAnswers_Answer) XXX_Size() int {
	return xxx_messageInfo_KnowledgeAnswers_Answer.Size(m)
}
func (m *KnowledgeAnswers_Answer) XXX_DiscardUnknown() {
	xxx_messageInfo_KnowledgeAnswers_Answer.DiscardUnknown(m)
}

var xxx_messageInfo_KnowledgeAnswers_Answer proto.InternalMessageInfo

func (m *KnowledgeAnswers_Answer) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *KnowledgeAnswers_Answer) GetFaqQuestion() string {
	if m != nil {
		return m.FaqQuestion
	}
	return ""
}

func (m *KnowledgeAnswers_Answer) GetAnswer() string {
	if m != nil {
		return m.Answer
	}
	return ""
}

func (m *KnowledgeAnswers_Answer) GetMatchConfidenceLevel() KnowledgeAnswers_Answer_MatchConfidenceLevel {
	if m != nil {
		return m.MatchConfidenceLevel
	}
	return KnowledgeAnswers_Answer_MATCH_CONFIDENCE_LEVEL_UNSPECIFIED
}

func (m *KnowledgeAnswers_Answer) GetMatchConfidence() float32 {
	if m != nil {
		return m.MatchConfidence
	}
	return 0
}

// The top-level message sent by the client to the
// [StreamingDetectIntent][] method.
//
// Multiple request messages should be sent in order:
//
// 1.  The first message must contain [StreamingDetectIntentRequest.session][google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest.session],
//     [StreamingDetectIntentRequest.query_input] plus optionally
//     [StreamingDetectIntentRequest.query_params]. If the client wants to
//     receive an audio response, it should also contain
//     [StreamingDetectIntentRequest.output_audio_config][google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest.output_audio_config]. The message
//     must not contain [StreamingDetectIntentRequest.input_audio][google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest.input_audio].
// 2.  If [StreamingDetectIntentRequest.query_input][google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest.query_input] was set to
//     [StreamingDetectIntentRequest.query_input.audio_config][], all subsequent
//     messages must contain [StreamingDetectIntentRequest.input_audio] to
//     continue with Speech recognition.
//     If you decide to rather detect an intent from text input after you
//     already started Speech recognition, please send a message with
//     [StreamingDetectIntentRequest.query_input.text][].
//
//     However, note that:
//
//     * Dialogflow will bill you for the audio duration so far.
//     * Dialogflow discards all Speech recognition results in favor of the
//       input text.
//     * Dialogflow will use the language code from the first message.
//
// After you sent all input, you must half-close or abort the request stream.
type StreamingDetectIntentRequest struct {
	// Required. The name of the session the query is sent to.
	// Format of the session name:
	// `projects/<Project ID>/agent/sessions/<Session ID>`, or
	// `projects/<Project ID>/agent/environments/<Environment ID>/users/<User
	// ID>/sessions/<Session ID>`. If `Environment ID` is not specified, we assume
	// default 'draft' environment. If `User ID` is not specified, we are using
	// "-". It's up to the API caller to choose an appropriate `Session ID` and
	// `User Id`. They can be a random number or some type of user and session
	// identifiers (preferably hashed). The length of the `Session ID` and
	// `User ID` must not exceed 36 characters.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Optional. The parameters of this query.
	QueryParams *QueryParameters `protobuf:"bytes,2,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Required. The input specification. It can be set to:
	//
	// 1.  an audio config which instructs the speech recognizer how to process
	//     the speech audio,
	//
	// 2.  a conversational query in the form of text, or
	//
	// 3.  an event that specifies which intent to trigger.
	QueryInput *QueryInput `protobuf:"bytes,3,opt,name=query_input,json=queryInput,proto3" json:"query_input,omitempty"`
	// DEPRECATED. Please use [InputAudioConfig.single_utterance][google.cloud.dialogflow.v2beta1.InputAudioConfig.single_utterance] instead.
	// Optional. If `false` (default), recognition does not cease until the
	// client closes the stream.
	// If `true`, the recognizer will detect a single spoken utterance in input
	// audio. Recognition ceases when it detects the audio's voice has
	// stopped or paused. In this case, once a detected intent is received, the
	// client should close the stream and start a new request with a new stream as
	// needed.
	// This setting is ignored when `query_input` is a piece of text or an event.
	SingleUtterance bool `protobuf:"varint,4,opt,name=single_utterance,json=singleUtterance,proto3" json:"single_utterance,omitempty"`
	// Optional. Instructs the speech synthesizer how to generate the output
	// audio. If this field is not set and agent-level speech synthesizer is not
	// configured, no output audio is generated.
	OutputAudioConfig *OutputAudioConfig `protobuf:"bytes,5,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	// Optional. The input audio content to be recognized. Must be sent if
	// `query_input` was set to a streaming input audio config. The complete audio
	// over all streaming messages must not exceed 1 minute.
	InputAudio           []byte   `protobuf:"bytes,6,opt,name=input_audio,json=inputAudio,proto3" json:"input_audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingDetectIntentRequest) Reset()         { *m = StreamingDetectIntentRequest{} }
func (m *StreamingDetectIntentRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingDetectIntentRequest) ProtoMessage()    {}
func (*StreamingDetectIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{6}
}

func (m *StreamingDetectIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingDetectIntentRequest.Unmarshal(m, b)
}
func (m *StreamingDetectIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingDetectIntentRequest.Marshal(b, m, deterministic)
}
func (m *StreamingDetectIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingDetectIntentRequest.Merge(m, src)
}
func (m *StreamingDetectIntentRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingDetectIntentRequest.Size(m)
}
func (m *StreamingDetectIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingDetectIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingDetectIntentRequest proto.InternalMessageInfo

func (m *StreamingDetectIntentRequest) GetSession() string {
	if m != nil {
		return m.Session
	}
	return ""
}

func (m *StreamingDetectIntentRequest) GetQueryParams() *QueryParameters {
	if m != nil {
		return m.QueryParams
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetQueryInput() *QueryInput {
	if m != nil {
		return m.QueryInput
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetSingleUtterance() bool {
	if m != nil {
		return m.SingleUtterance
	}
	return false
}

func (m *StreamingDetectIntentRequest) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

func (m *StreamingDetectIntentRequest) GetInputAudio() []byte {
	if m != nil {
		return m.InputAudio
	}
	return nil
}

// The top-level message returned from the
// `StreamingDetectIntent` method.
//
// Multiple response messages can be returned in order:
//
// 1.  If the input was set to streaming audio, the first one or more messages
//     contain `recognition_result`. Each `recognition_result` represents a more
//     complete transcript of what the user said. The last `recognition_result`
//     has `is_final` set to `true`.
//
// 2.  The next message contains `response_id`, `query_result`,
//     `alternative_query_results` and optionally `webhook_status` if a WebHook
//     was called.
//
// 3.  If `output_audio_config` was specified in the request or agent-level
//     speech synthesizer is configured, all subsequent messages contain
//     `output_audio` and `output_audio_config`.
type StreamingDetectIntentResponse struct {
	// The unique identifier of the response. It can be used to
	// locate a response in the training example set or for reporting issues.
	ResponseId string `protobuf:"bytes,1,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// The result of speech recognition.
	RecognitionResult *StreamingRecognitionResult `protobuf:"bytes,2,opt,name=recognition_result,json=recognitionResult,proto3" json:"recognition_result,omitempty"`
	// The selected results of the conversational query or event processing.
	// See `alternative_query_results` for additional potential results.
	QueryResult *QueryResult `protobuf:"bytes,3,opt,name=query_result,json=queryResult,proto3" json:"query_result,omitempty"`
	// If Knowledge Connectors are enabled, there could be more than one result
	// returned for a given query or event, and this field will contain all
	// results except for the top one, which is captured in query_result. The
	// alternative results are ordered by decreasing
	// `QueryResult.intent_detection_confidence`. If Knowledge Connectors are
	// disabled, this field will be empty until multiple responses for regular
	// intents are supported, at which point those additional results will be
	// surfaced here.
	AlternativeQueryResults []*QueryResult `protobuf:"bytes,7,rep,name=alternative_query_results,json=alternativeQueryResults,proto3" json:"alternative_query_results,omitempty"`
	// Specifies the status of the webhook request.
	WebhookStatus *status.Status `protobuf:"bytes,4,opt,name=webhook_status,json=webhookStatus,proto3" json:"webhook_status,omitempty"`
	// The audio data bytes encoded as specified in the request.
	// Note: The output audio is generated based on the values of default platform
	// text responses found in the `query_result.fulfillment_messages` field. If
	// multiple default text responses exist, they will be concatenated when
	// generating audio. If no default platform text responses exist, the
	// generated audio content will be empty.
	OutputAudio []byte `protobuf:"bytes,5,opt,name=output_audio,json=outputAudio,proto3" json:"output_audio,omitempty"`
	// The config used by the speech synthesizer to generate the output audio.
	OutputAudioConfig    *OutputAudioConfig `protobuf:"bytes,6,opt,name=output_audio_config,json=outputAudioConfig,proto3" json:"output_audio_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamingDetectIntentResponse) Reset()         { *m = StreamingDetectIntentResponse{} }
func (m *StreamingDetectIntentResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingDetectIntentResponse) ProtoMessage()    {}
func (*StreamingDetectIntentResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{7}
}

func (m *StreamingDetectIntentResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingDetectIntentResponse.Unmarshal(m, b)
}
func (m *StreamingDetectIntentResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingDetectIntentResponse.Marshal(b, m, deterministic)
}
func (m *StreamingDetectIntentResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingDetectIntentResponse.Merge(m, src)
}
func (m *StreamingDetectIntentResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingDetectIntentResponse.Size(m)
}
func (m *StreamingDetectIntentResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingDetectIntentResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingDetectIntentResponse proto.InternalMessageInfo

func (m *StreamingDetectIntentResponse) GetResponseId() string {
	if m != nil {
		return m.ResponseId
	}
	return ""
}

func (m *StreamingDetectIntentResponse) GetRecognitionResult() *StreamingRecognitionResult {
	if m != nil {
		return m.RecognitionResult
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetQueryResult() *QueryResult {
	if m != nil {
		return m.QueryResult
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetAlternativeQueryResults() []*QueryResult {
	if m != nil {
		return m.AlternativeQueryResults
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetWebhookStatus() *status.Status {
	if m != nil {
		return m.WebhookStatus
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetOutputAudio() []byte {
	if m != nil {
		return m.OutputAudio
	}
	return nil
}

func (m *StreamingDetectIntentResponse) GetOutputAudioConfig() *OutputAudioConfig {
	if m != nil {
		return m.OutputAudioConfig
	}
	return nil
}

// Contains a speech recognition result corresponding to a portion of the audio
// that is currently being processed or an indication that this is the end
// of the single requested utterance.
//
// Example:
//
// 1.  transcript: "tube"
//
// 2.  transcript: "to be a"
//
// 3.  transcript: "to be"
//
// 4.  transcript: "to be or not to be"
//     is_final: true
//
// 5.  transcript: " that's"
//
// 6.  transcript: " that is"
//
// 7.  message_type: `END_OF_SINGLE_UTTERANCE`
//
// 8.  transcript: " that is the question"
//     is_final: true
//
// Only two of the responses contain final results (#4 and #8 indicated by
// `is_final: true`). Concatenating these generates the full transcript: "to be
// or not to be that is the question".
//
// In each response we populate:
//
// *  for `TRANSCRIPT`: `transcript` and possibly `is_final`.
//
// *  for `END_OF_SINGLE_UTTERANCE`: only `message_type`.
type StreamingRecognitionResult struct {
	// Type of the result message.
	MessageType StreamingRecognitionResult_MessageType `protobuf:"varint,1,opt,name=message_type,json=messageType,proto3,enum=google.cloud.dialogflow.v2beta1.StreamingRecognitionResult_MessageType" json:"message_type,omitempty"`
	// Transcript text representing the words that the user spoke.
	// Populated if and only if `message_type` = `TRANSCRIPT`.
	Transcript string `protobuf:"bytes,2,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// If `false`, the `StreamingRecognitionResult` represents an
	// interim result that may change. If `true`, the recognizer will not return
	// any further hypotheses about this piece of the audio. May only be populated
	// for `message_type` = `TRANSCRIPT`.
	IsFinal bool `protobuf:"varint,3,opt,name=is_final,json=isFinal,proto3" json:"is_final,omitempty"`
	// The Speech confidence between 0.0 and 1.0 for the current portion of audio.
	// A higher number indicates an estimated greater likelihood that the
	// recognized words are correct. The default of 0.0 is a sentinel value
	// indicating that confidence was not set.
	//
	// This field is typically only provided if `is_final` is true and you should
	// not rely on it being accurate or even set.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// An estimate of the likelihood that the speech recognizer will
	// not change its guess about this interim recognition result:
	// * If the value is unspecified or 0.0, Dialogflow didn't compute the
	//   stability. In particular, Dialogflow will only provide stability for
	//   `TRANSCRIPT` results with `is_final = false`.
	// * Otherwise, the value is in (0.0, 1.0] where 0.0 means completely
	//   unstable and 1.0 means completely stable.
	Stability float32 `protobuf:"fixed32,6,opt,name=stability,proto3" json:"stability,omitempty"`
	// Word-specific information for the words recognized by Speech in
	// [transcript][google.cloud.dialogflow.v2beta1.StreamingRecognitionResult.transcript]. Populated if and only if `message_type` = `TRANSCRIPT` and
	// [InputAudioConfig.enable_word_info] is set.
	SpeechWordInfo []*SpeechWordInfo `protobuf:"bytes,7,rep,name=speech_word_info,json=speechWordInfo,proto3" json:"speech_word_info,omitempty"`
	// Time offset of the end of this Speech recognition result relative to the
	// beginning of the audio. Only populated for `message_type` = `TRANSCRIPT`.
	SpeechEndOffset      *duration.Duration `protobuf:"bytes,8,opt,name=speech_end_offset,json=speechEndOffset,proto3" json:"speech_end_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *StreamingRecognitionResult) Reset()         { *m = StreamingRecognitionResult{} }
func (m *StreamingRecognitionResult) String() string { return proto.CompactTextString(m) }
func (*StreamingRecognitionResult) ProtoMessage()    {}
func (*StreamingRecognitionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{8}
}

func (m *StreamingRecognitionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingRecognitionResult.Unmarshal(m, b)
}
func (m *StreamingRecognitionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingRecognitionResult.Marshal(b, m, deterministic)
}
func (m *StreamingRecognitionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingRecognitionResult.Merge(m, src)
}
func (m *StreamingRecognitionResult) XXX_Size() int {
	return xxx_messageInfo_StreamingRecognitionResult.Size(m)
}
func (m *StreamingRecognitionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingRecognitionResult.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingRecognitionResult proto.InternalMessageInfo

func (m *StreamingRecognitionResult) GetMessageType() StreamingRecognitionResult_MessageType {
	if m != nil {
		return m.MessageType
	}
	return StreamingRecognitionResult_MESSAGE_TYPE_UNSPECIFIED
}

func (m *StreamingRecognitionResult) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *StreamingRecognitionResult) GetIsFinal() bool {
	if m != nil {
		return m.IsFinal
	}
	return false
}

func (m *StreamingRecognitionResult) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *StreamingRecognitionResult) GetStability() float32 {
	if m != nil {
		return m.Stability
	}
	return 0
}

func (m *StreamingRecognitionResult) GetSpeechWordInfo() []*SpeechWordInfo {
	if m != nil {
		return m.SpeechWordInfo
	}
	return nil
}

func (m *StreamingRecognitionResult) GetSpeechEndOffset() *duration.Duration {
	if m != nil {
		return m.SpeechEndOffset
	}
	return nil
}

// Represents the natural language text to be processed.
type TextInput struct {
	// Required. The UTF-8 encoded natural language text to be processed.
	// Text length must not exceed 256 characters.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Required. The language of this conversational query. See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes. Note that queries in
	// the same session do not necessarily need to specify the same language.
	LanguageCode         string   `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TextInput) Reset()         { *m = TextInput{} }
func (m *TextInput) String() string { return proto.CompactTextString(m) }
func (*TextInput) ProtoMessage()    {}
func (*TextInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{9}
}

func (m *TextInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextInput.Unmarshal(m, b)
}
func (m *TextInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextInput.Marshal(b, m, deterministic)
}
func (m *TextInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextInput.Merge(m, src)
}
func (m *TextInput) XXX_Size() int {
	return xxx_messageInfo_TextInput.Size(m)
}
func (m *TextInput) XXX_DiscardUnknown() {
	xxx_messageInfo_TextInput.DiscardUnknown(m)
}

var xxx_messageInfo_TextInput proto.InternalMessageInfo

func (m *TextInput) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *TextInput) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Events allow for matching intents by event name instead of the natural
// language input. For instance, input `<event: { name: "welcome_event",
// parameters: { name: "Sam" } }>` can trigger a personalized welcome response.
// The parameter `name` may be used by the agent in the response:
// `"Hello #welcome_event.name! What can I do for you today?"`.
type EventInput struct {
	// Required. The unique identifier of the event.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The collection of parameters associated with the event.
	Parameters *_struct.Struct `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Required. The language of this query. See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes. Note that queries in
	// the same session do not necessarily need to specify the same language.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EventInput) Reset()         { *m = EventInput{} }
func (m *EventInput) String() string { return proto.CompactTextString(m) }
func (*EventInput) ProtoMessage()    {}
func (*EventInput) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{10}
}

func (m *EventInput) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EventInput.Unmarshal(m, b)
}
func (m *EventInput) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EventInput.Marshal(b, m, deterministic)
}
func (m *EventInput) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EventInput.Merge(m, src)
}
func (m *EventInput) XXX_Size() int {
	return xxx_messageInfo_EventInput.Size(m)
}
func (m *EventInput) XXX_DiscardUnknown() {
	xxx_messageInfo_EventInput.DiscardUnknown(m)
}

var xxx_messageInfo_EventInput proto.InternalMessageInfo

func (m *EventInput) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *EventInput) GetParameters() *_struct.Struct {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *EventInput) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Configures the types of sentiment analysis to perform.
type SentimentAnalysisRequestConfig struct {
	// Optional. Instructs the service to perform sentiment analysis on
	// `query_text`. If not provided, sentiment analysis is not performed on
	// `query_text`.
	AnalyzeQueryTextSentiment bool     `protobuf:"varint,1,opt,name=analyze_query_text_sentiment,json=analyzeQueryTextSentiment,proto3" json:"analyze_query_text_sentiment,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *SentimentAnalysisRequestConfig) Reset()         { *m = SentimentAnalysisRequestConfig{} }
func (m *SentimentAnalysisRequestConfig) String() string { return proto.CompactTextString(m) }
func (*SentimentAnalysisRequestConfig) ProtoMessage()    {}
func (*SentimentAnalysisRequestConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{11}
}

func (m *SentimentAnalysisRequestConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SentimentAnalysisRequestConfig.Unmarshal(m, b)
}
func (m *SentimentAnalysisRequestConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SentimentAnalysisRequestConfig.Marshal(b, m, deterministic)
}
func (m *SentimentAnalysisRequestConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SentimentAnalysisRequestConfig.Merge(m, src)
}
func (m *SentimentAnalysisRequestConfig) XXX_Size() int {
	return xxx_messageInfo_SentimentAnalysisRequestConfig.Size(m)
}
func (m *SentimentAnalysisRequestConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SentimentAnalysisRequestConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SentimentAnalysisRequestConfig proto.InternalMessageInfo

func (m *SentimentAnalysisRequestConfig) GetAnalyzeQueryTextSentiment() bool {
	if m != nil {
		return m.AnalyzeQueryTextSentiment
	}
	return false
}

// The result of sentiment analysis as configured by
// `sentiment_analysis_request_config`.
type SentimentAnalysisResult struct {
	// The sentiment analysis result for `query_text`.
	QueryTextSentiment   *Sentiment `protobuf:"bytes,1,opt,name=query_text_sentiment,json=queryTextSentiment,proto3" json:"query_text_sentiment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *SentimentAnalysisResult) Reset()         { *m = SentimentAnalysisResult{} }
func (m *SentimentAnalysisResult) String() string { return proto.CompactTextString(m) }
func (*SentimentAnalysisResult) ProtoMessage()    {}
func (*SentimentAnalysisResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{12}
}

func (m *SentimentAnalysisResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SentimentAnalysisResult.Unmarshal(m, b)
}
func (m *SentimentAnalysisResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SentimentAnalysisResult.Marshal(b, m, deterministic)
}
func (m *SentimentAnalysisResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SentimentAnalysisResult.Merge(m, src)
}
func (m *SentimentAnalysisResult) XXX_Size() int {
	return xxx_messageInfo_SentimentAnalysisResult.Size(m)
}
func (m *SentimentAnalysisResult) XXX_DiscardUnknown() {
	xxx_messageInfo_SentimentAnalysisResult.DiscardUnknown(m)
}

var xxx_messageInfo_SentimentAnalysisResult proto.InternalMessageInfo

func (m *SentimentAnalysisResult) GetQueryTextSentiment() *Sentiment {
	if m != nil {
		return m.QueryTextSentiment
	}
	return nil
}

// The sentiment, such as positive/negative feeling or association, for a unit
// of analysis, such as the query text.
type Sentiment struct {
	// Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	// sentiment).
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// A non-negative number in the [0, +inf) range, which represents the absolute
	// magnitude of sentiment, regardless of score (positive or negative).
	Magnitude            float32  `protobuf:"fixed32,2,opt,name=magnitude,proto3" json:"magnitude,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Sentiment) Reset()         { *m = Sentiment{} }
func (m *Sentiment) String() string { return proto.CompactTextString(m) }
func (*Sentiment) ProtoMessage()    {}
func (*Sentiment) Descriptor() ([]byte, []int) {
	return fileDescriptor_40a53f854d709740, []int{13}
}

func (m *Sentiment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Sentiment.Unmarshal(m, b)
}
func (m *Sentiment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Sentiment.Marshal(b, m, deterministic)
}
func (m *Sentiment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Sentiment.Merge(m, src)
}
func (m *Sentiment) XXX_Size() int {
	return xxx_messageInfo_Sentiment.Size(m)
}
func (m *Sentiment) XXX_DiscardUnknown() {
	xxx_messageInfo_Sentiment.DiscardUnknown(m)
}

var xxx_messageInfo_Sentiment proto.InternalMessageInfo

func (m *Sentiment) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *Sentiment) GetMagnitude() float32 {
	if m != nil {
		return m.Magnitude
	}
	return 0
}

func init() {
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.KnowledgeAnswers_Answer_MatchConfidenceLevel", KnowledgeAnswers_Answer_MatchConfidenceLevel_name, KnowledgeAnswers_Answer_MatchConfidenceLevel_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.StreamingRecognitionResult_MessageType", StreamingRecognitionResult_MessageType_name, StreamingRecognitionResult_MessageType_value)
	proto.RegisterType((*DetectIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.DetectIntentRequest")
	proto.RegisterType((*DetectIntentResponse)(nil), "google.cloud.dialogflow.v2beta1.DetectIntentResponse")
	proto.RegisterType((*QueryParameters)(nil), "google.cloud.dialogflow.v2beta1.QueryParameters")
	proto.RegisterType((*QueryInput)(nil), "google.cloud.dialogflow.v2beta1.QueryInput")
	proto.RegisterType((*QueryResult)(nil), "google.cloud.dialogflow.v2beta1.QueryResult")
	proto.RegisterType((*KnowledgeAnswers)(nil), "google.cloud.dialogflow.v2beta1.KnowledgeAnswers")
	proto.RegisterType((*KnowledgeAnswers_Answer)(nil), "google.cloud.dialogflow.v2beta1.KnowledgeAnswers.Answer")
	proto.RegisterType((*StreamingDetectIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.StreamingDetectIntentRequest")
	proto.RegisterType((*StreamingDetectIntentResponse)(nil), "google.cloud.dialogflow.v2beta1.StreamingDetectIntentResponse")
	proto.RegisterType((*StreamingRecognitionResult)(nil), "google.cloud.dialogflow.v2beta1.StreamingRecognitionResult")
	proto.RegisterType((*TextInput)(nil), "google.cloud.dialogflow.v2beta1.TextInput")
	proto.RegisterType((*EventInput)(nil), "google.cloud.dialogflow.v2beta1.EventInput")
	proto.RegisterType((*SentimentAnalysisRequestConfig)(nil), "google.cloud.dialogflow.v2beta1.SentimentAnalysisRequestConfig")
	proto.RegisterType((*SentimentAnalysisResult)(nil), "google.cloud.dialogflow.v2beta1.SentimentAnalysisResult")
	proto.RegisterType((*Sentiment)(nil), "google.cloud.dialogflow.v2beta1.Sentiment")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2beta1/session.proto", fileDescriptor_40a53f854d709740)
}

var fileDescriptor_40a53f854d709740 = []byte{
	// 2040 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x58, 0xcd, 0x73, 0x1b, 0x49,
	0x15, 0x8f, 0x24, 0x7f, 0xc8, 0x4f, 0x5a, 0x5b, 0xe9, 0x98, 0xb5, 0xfc, 0x91, 0xc4, 0xab, 0x2d,
	0xc0, 0x9b, 0xcd, 0x4a, 0x89, 0xf9, 0xda, 0x4d, 0x2a, 0x9b, 0xd8, 0x92, 0x6c, 0xab, 0x90, 0x3f,
	0xd2, 0x72, 0x12, 0x92, 0x82, 0x9d, 0x6a, 0xcf, 0xb4, 0xc6, 0x93, 0x8c, 0xa6, 0xe5, 0xe9, 0x96,
	0x1d, 0x2f, 0x05, 0x07, 0x38, 0x01, 0x47, 0xae, 0x9c, 0xb8, 0xb1, 0x5c, 0xf9, 0x2b, 0x28, 0x2e,
	0xb0, 0x54, 0xf1, 0x0f, 0x70, 0xe3, 0x4a, 0x15, 0x5c, 0xa8, 0xa2, 0xfa, 0x63, 0xa4, 0xb1, 0xfc,
	0x21, 0x39, 0x90, 0xa2, 0x8a, 0x93, 0xd4, 0xaf, 0xdf, 0xfb, 0xf5, 0xeb, 0xd7, 0xaf, 0x7f, 0xfd,
	0xde, 0xc0, 0x47, 0x2e, 0x63, 0xae, 0x4f, 0x4b, 0xb6, 0xcf, 0x3a, 0x4e, 0xc9, 0xf1, 0x88, 0xcf,
	0xdc, 0xa6, 0xcf, 0x8e, 0x4a, 0x87, 0xcb, 0x7b, 0x54, 0x90, 0xbb, 0x25, 0x4e, 0x39, 0xf7, 0x58,
	0x50, 0x6c, 0x87, 0x4c, 0x30, 0x74, 0x53, 0xab, 0x17, 0x95, 0x7a, 0xb1, 0xa7, 0x5e, 0x34, 0xea,
	0x73, 0x0b, 0x06, 0x8f, 0xb4, 0xbd, 0x12, 0x09, 0x02, 0x26, 0x88, 0xf0, 0x58, 0xc0, 0xb5, 0xf9,
	0xdc, 0xcd, 0xd8, 0x6c, 0xd3, 0xa3, 0xbe, 0x63, 0xed, 0xd1, 0x7d, 0x72, 0xe8, 0xb1, 0xd0, 0x28,
	0x7c, 0x38, 0xc8, 0x1d, 0xe2, 0xd2, 0x40, 0x18, 0xe5, 0xe5, 0x81, 0xca, 0x1d, 0xc7, 0x63, 0x96,
	0xcd, 0x82, 0xa6, 0xe7, 0x1a, 0x9b, 0x81, 0xfb, 0xb5, 0x59, 0x20, 0xe8, 0xeb, 0x68, 0x89, 0xdb,
	0x83, 0xd4, 0xbd, 0x40, 0xf4, 0x1c, 0xfa, 0x64, 0xc8, 0x60, 0x5a, 0x34, 0x10, 0x9e, 0x38, 0xb6,
	0xc4, 0x71, 0x9b, 0x1a, 0xd3, 0x1b, 0xc6, 0x54, 0x8d, 0xf6, 0x3a, 0xcd, 0x92, 0xd3, 0x09, 0x55,
	0xe8, 0xcc, 0xfc, 0x42, 0xff, 0x3c, 0x17, 0x61, 0xc7, 0x8e, 0x16, 0x9e, 0x31, 0xb3, 0x61, 0xdb,
	0x2e, 0x71, 0x41, 0x44, 0x27, 0x0a, 0x78, 0xde, 0x4c, 0xc8, 0x95, 0x4a, 0x3e, 0x11, 0x7e, 0xe0,
	0xf6, 0x99, 0xc8, 0xa3, 0xb0, 0x7d, 0xaf, 0xbb, 0x89, 0xc2, 0x5f, 0x92, 0x70, 0xad, 0x42, 0x05,
	0xb5, 0x45, 0x4d, 0xed, 0x0d, 0xd3, 0x83, 0x0e, 0xe5, 0x02, 0xe5, 0x61, 0xdc, 0xb8, 0x9f, 0x4f,
	0x2c, 0x26, 0x96, 0x26, 0x70, 0x34, 0x44, 0x0d, 0xc8, 0x1e, 0x74, 0x68, 0x78, 0x6c, 0xb5, 0x49,
	0x48, 0x5a, 0x3c, 0x9f, 0x5c, 0x4c, 0x2c, 0x65, 0x96, 0xef, 0x14, 0x07, 0xe4, 0x4a, 0xf1, 0xb1,
	0x34, 0xda, 0x91, 0x36, 0x54, 0xd0, 0x90, 0xe3, 0xcc, 0x41, 0x57, 0xc0, 0x51, 0x1d, 0xf4, 0xd0,
	0xf2, 0x82, 0x76, 0x47, 0xe4, 0x53, 0x0a, 0xf3, 0xc3, 0xe1, 0x30, 0x6b, 0xd2, 0x04, 0xc3, 0x41,
	0xf7, 0x3f, 0xda, 0x83, 0x6b, 0xac, 0x23, 0xda, 0x1d, 0x61, 0xc5, 0x73, 0x22, 0x3f, 0xa2, 0x50,
	0x97, 0x07, 0xa2, 0x6e, 0x2b, 0xdb, 0x15, 0x69, 0x5a, 0x56, 0x96, 0xf8, 0x2a, 0xeb, 0x17, 0xa1,
	0x9b, 0x90, 0x51, 0xbe, 0xea, 0x25, 0xf2, 0xa3, 0x8b, 0x89, 0xa5, 0x2c, 0x06, 0x25, 0x52, 0x6a,
	0x85, 0xdf, 0xa5, 0x60, 0xfa, 0x64, 0x64, 0x79, 0x9b, 0x05, 0x9c, 0x4a, 0xcb, 0xd0, 0xfc, 0xb7,
	0x3c, 0xc7, 0x84, 0x17, 0x22, 0x51, 0xcd, 0x41, 0xdb, 0x51, 0x84, 0x43, 0xca, 0x3b, 0xbe, 0x30,
	0x11, 0xbe, 0x3d, 0x5c, 0x34, 0xb0, 0xb2, 0x31, 0xd1, 0xd5, 0x03, 0xb4, 0x0f, 0xb3, 0xc4, 0x17,
	0x34, 0x0c, 0x88, 0xf0, 0x0e, 0xa9, 0x15, 0x07, 0xe7, 0xf9, 0xd1, 0xc5, 0xd4, 0xa5, 0xd1, 0x67,
	0x62, 0x70, 0x31, 0x39, 0x47, 0x9f, 0xc0, 0xe4, 0x11, 0xdd, 0xdb, 0x67, 0xec, 0x95, 0xa5, 0x33,
	0xd3, 0x1c, 0x25, 0x8a, 0xe0, 0xc3, 0xb6, 0x5d, 0x6c, 0xa8, 0x19, 0xfc, 0x8e, 0xd1, 0xd4, 0x43,
	0xf4, 0x1e, 0x64, 0xe3, 0x87, 0xa6, 0x4e, 0x2b, 0x8b, 0x33, 0xb1, 0xc8, 0x9f, 0x77, 0xae, 0x63,
	0xff, 0xc5, 0x73, 0x2d, 0xfc, 0x76, 0x04, 0xa6, 0xfa, 0x52, 0x15, 0xcd, 0xc3, 0x84, 0xf0, 0x5a,
	0xd4, 0xfa, 0x9c, 0x05, 0xd4, 0x9c, 0x57, 0x5a, 0x0a, 0x5e, 0xb0, 0x80, 0xa2, 0x6f, 0x43, 0xd6,
	0xa5, 0xcc, 0xf2, 0x99, 0xad, 0x6e, 0xb0, 0x39, 0xad, 0x6b, 0x91, 0x37, 0xea, 0xd6, 0xd7, 0x89,
	0xa8, 0x07, 0x2e, 0xce, 0xb8, 0x94, 0xd5, 0x8d, 0x1e, 0xaa, 0x40, 0xda, 0xb0, 0x8f, 0x0c, 0x92,
	0x3c, 0x83, 0xa5, 0x81, 0x3b, 0x28, 0x6b, 0x03, 0xdc, 0xb5, 0x44, 0x5f, 0x85, 0xc9, 0x90, 0x72,
	0x2a, 0xac, 0x2e, 0x96, 0x8c, 0x5b, 0x1a, 0xbf, 0xa3, 0xa4, 0xe5, 0x48, 0xcd, 0x81, 0xe9, 0x33,
	0xd8, 0x28, 0x3a, 0xfc, 0xc1, 0xa1, 0x6b, 0x68, 0xe3, 0xaa, 0xb2, 0xdd, 0x3d, 0x6e, 0x53, 0x8c,
	0x78, 0xbf, 0x88, 0xa3, 0xbb, 0x30, 0xde, 0x26, 0xc7, 0x3e, 0x23, 0x8e, 0x39, 0x93, 0x99, 0x08,
	0x38, 0x22, 0xb2, 0x62, 0x43, 0x11, 0x19, 0x8e, 0xf4, 0xd0, 0x1d, 0x98, 0x7e, 0x15, 0xb0, 0x23,
	0x9f, 0x3a, 0x2e, 0xb5, 0xf6, 0x08, 0xa7, 0x56, 0x40, 0x5a, 0x94, 0xe7, 0xb3, 0x8b, 0xa9, 0xa5,
	0x09, 0x8c, 0xba, 0x73, 0xab, 0x84, 0xd3, 0x2d, 0x39, 0x83, 0x7e, 0x9e, 0x80, 0xf7, 0xb8, 0xdc,
	0x44, 0x8b, 0x06, 0xc2, 0x22, 0x01, 0xf1, 0x8f, 0xb9, 0xc7, 0xad, 0x50, 0x13, 0x57, 0x94, 0x13,
	0xa0, 0xd6, 0x7f, 0x38, 0xc4, 0xc6, 0x0c, 0xd2, 0x8a, 0x01, 0x32, 0x04, 0x68, 0x12, 0xe4, 0x06,
	0xbf, 0x70, 0xbe, 0xf0, 0xf7, 0x04, 0x40, 0x8f, 0x84, 0xd0, 0x53, 0xc8, 0x9e, 0xc8, 0xcc, 0x84,
	0xf2, 0xe2, 0xee, 0x40, 0x2f, 0x6a, 0xc1, 0xc9, 0x2c, 0xdc, 0xb8, 0x82, 0x33, 0x24, 0x46, 0x36,
	0x8f, 0x60, 0x44, 0x9e, 0xa3, 0xc9, 0xad, 0x5b, 0x03, 0xf1, 0x76, 0xe9, 0x6b, 0xa1, 0x30, 0x37,
	0xae, 0x60, 0x65, 0x89, 0xca, 0x30, 0x4a, 0x0f, 0x69, 0x30, 0x3c, 0xb5, 0x56, 0xa5, 0x76, 0x84,
	0xa1, 0x6d, 0x57, 0xc7, 0x61, 0x54, 0x11, 0x5c, 0xe1, 0x67, 0x69, 0xc8, 0xc4, 0xee, 0x3d, 0xba,
	0x0e, 0x9a, 0x7e, 0x2d, 0xe5, 0xa5, 0xbe, 0x21, 0x13, 0x4a, 0x22, 0x3d, 0x41, 0xef, 0xc3, 0x3b,
	0x3e, 0x09, 0xdc, 0x0e, 0x71, 0xa9, 0x65, 0x33, 0x87, 0xe6, 0xa7, 0x94, 0x46, 0x36, 0x12, 0x96,
	0x99, 0x43, 0xd1, 0x2a, 0x5c, 0xe7, 0x6d, 0x4a, 0xed, 0x7d, 0x2b, 0xa4, 0x36, 0x73, 0x03, 0x4f,
	0xde, 0x12, 0x1d, 0x48, 0x87, 0x06, 0x36, 0x55, 0x9b, 0x4f, 0xe2, 0x79, 0xad, 0x84, 0x7b, 0x3a,
	0xe5, 0xae, 0x0a, 0x7a, 0x17, 0xc6, 0x88, 0xad, 0x6e, 0x61, 0x4a, 0xad, 0x60, 0x46, 0xe8, 0x3b,
	0x00, 0xed, 0xee, 0x75, 0x36, 0xef, 0xc0, 0xb9, 0xb9, 0x19, 0x53, 0x45, 0x0f, 0x60, 0x9e, 0xf8,
	0xbe, 0x4a, 0x2e, 0x2f, 0xa4, 0x8e, 0x79, 0xf3, 0xac, 0xb6, 0xbc, 0x5d, 0x81, 0x50, 0xac, 0x9f,
	0xc6, 0x79, 0xe2, 0xfb, 0xd8, 0x68, 0xe8, 0xf7, 0x6c, 0x47, 0xcf, 0xa3, 0x0f, 0x20, 0xd7, 0xec,
	0xf8, 0x4d, 0xcf, 0xf7, 0x55, 0xb2, 0xaa, 0xe8, 0x8c, 0x29, 0xcf, 0xa6, 0x62, 0x72, 0x15, 0xa3,
	0x3d, 0x98, 0x8e, 0xab, 0xb6, 0x28, 0xe7, 0xc4, 0xa5, 0x3c, 0x3f, 0xae, 0x6e, 0x68, 0x69, 0x88,
	0x14, 0x52, 0xa5, 0xc9, 0xa6, 0xb6, 0xc3, 0xd7, 0x62, 0x60, 0x46, 0xa6, 0xc8, 0xa2, 0xcb, 0xce,
	0xac, 0x13, 0xda, 0x34, 0x9f, 0x56, 0xce, 0x74, 0x99, 0x58, 0x09, 0xd1, 0x23, 0x98, 0x8a, 0xd4,
	0xa2, 0xeb, 0x3c, 0x71, 0x71, 0xc8, 0x22, 0xd8, 0x1d, 0x73, 0xab, 0x1f, 0xc3, 0x94, 0x21, 0xea,
	0x2e, 0x2d, 0xc1, 0x25, 0x29, 0x6e, 0x52, 0x03, 0x74, 0x19, 0xec, 0x21, 0x8c, 0xe9, 0xea, 0x2b,
	0x9f, 0x51, 0xbe, 0x7c, 0x7d, 0xc8, 0x88, 0x60, 0x63, 0x86, 0x3e, 0x85, 0x79, 0xfd, 0xcf, 0x72,
	0xd4, 0xab, 0xdc, 0x97, 0x5d, 0x59, 0x95, 0x5d, 0xb3, 0x5a, 0xa5, 0x12, 0x69, 0xc4, 0x72, 0xeb,
	0x11, 0x4c, 0x39, 0x1e, 0x71, 0x03, 0xc6, 0x85, 0x67, 0x5b, 0x5e, 0xd0, 0x64, 0xf9, 0xc9, 0x01,
	0x51, 0xe9, 0xe9, 0xd7, 0x82, 0x26, 0x43, 0x02, 0x66, 0xcf, 0x24, 0x2e, 0xf5, 0xc8, 0x5f, 0x55,
	0x58, 0x1f, 0xbf, 0x09, 0x61, 0xe9, 0x27, 0x99, 0x9f, 0x3d, 0x81, 0x3e, 0x83, 0xab, 0x3d, 0x86,
	0x25, 0x01, 0x3f, 0x92, 0x57, 0x00, 0x0d, 0x49, 0x4c, 0xdf, 0x8d, 0x2c, 0x57, 0xb4, 0x21, 0xce,
	0xbd, 0xea, 0x93, 0x14, 0xfe, 0x9c, 0x82, 0x5c, 0xbf, 0x1a, 0xc2, 0x30, 0x1e, 0x2d, 0x95, 0x50,
	0x07, 0xff, 0xf1, 0xa5, 0x97, 0x2a, 0xea, 0x5f, 0x1c, 0x01, 0xcd, 0xfd, 0x2d, 0x09, 0x63, 0x5a,
	0x26, 0xef, 0xb9, 0x49, 0x60, 0xcd, 0x35, 0x66, 0x24, 0x6b, 0x88, 0x26, 0x39, 0xb0, 0x14, 0x43,
	0x47, 0x6f, 0xf1, 0x04, 0xce, 0x34, 0xc9, 0xc1, 0x63, 0x23, 0x52, 0x14, 0xa1, 0x40, 0xba, 0x14,
	0xa1, 0x21, 0x7f, 0x9a, 0x80, 0x77, 0x5b, 0x44, 0xd8, 0xfb, 0xb1, 0xa4, 0xb0, 0x7c, 0x7a, 0x48,
	0x7d, 0xc5, 0x17, 0x93, 0xcb, 0x9b, 0x6f, 0xba, 0x83, 0xe2, 0xa6, 0x84, 0xed, 0x65, 0x52, 0x5d,
	0x82, 0xe2, 0xe9, 0xd6, 0x19, 0x52, 0x49, 0x18, 0xfd, 0x4e, 0x28, 0x92, 0x49, 0xe2, 0xa9, 0x3e,
	0xfd, 0xc2, 0x0f, 0x60, 0xfa, 0x2c, 0x60, 0xf4, 0x35, 0x28, 0x6c, 0xae, 0xec, 0x96, 0x37, 0xac,
	0xf2, 0xf6, 0xd6, 0x5a, 0xad, 0x52, 0xdd, 0x2a, 0x57, 0xad, 0x7a, 0xf5, 0x69, 0xb5, 0x6e, 0x3d,
	0xd9, 0x6a, 0xec, 0x54, 0xcb, 0xb5, 0xb5, 0x5a, 0xb5, 0x92, 0xbb, 0x82, 0xc6, 0x21, 0x55, 0xdf,
	0x7e, 0x96, 0x4b, 0x20, 0x80, 0xb1, 0xcd, 0x6a, 0xa5, 0xf6, 0x64, 0x33, 0x97, 0x44, 0x69, 0x18,
	0xd9, 0xa8, 0xad, 0x6f, 0xe4, 0x52, 0x85, 0x5f, 0xa4, 0x60, 0xa1, 0x21, 0x42, 0x4a, 0x5a, 0x5e,
	0xe0, 0xfe, 0xdf, 0x75, 0x08, 0x1f, 0x40, 0x8e, 0x7b, 0x81, 0xeb, 0x53, 0xab, 0x23, 0x04, 0x0d,
	0x89, 0x8c, 0xb3, 0x2e, 0x9c, 0xa6, 0xb4, 0xfc, 0x49, 0x24, 0x3e, 0xaf, 0xe8, 0x1c, 0x7d, 0x8b,
	0xcd, 0xc4, 0xd8, 0xa9, 0x66, 0xe2, 0x37, 0x23, 0x70, 0xfd, 0x9c, 0xd3, 0x18, 0xb6, 0xab, 0x78,
	0x09, 0x28, 0xfe, 0xb0, 0x9e, 0xe8, 0x2d, 0xee, 0x0f, 0xa6, 0x9d, 0x68, 0xf1, 0xd8, 0xc3, 0x6b,
	0x98, 0xe7, 0x6a, 0xd8, 0x2f, 0x3a, 0xd5, 0xc1, 0xa4, 0xde, 0x6a, 0x07, 0x33, 0xfe, 0x76, 0x3b,
	0x98, 0x91, 0x37, 0xed, 0x60, 0x46, 0xff, 0x37, 0x1d, 0xcc, 0xbf, 0x52, 0x30, 0x77, 0xfe, 0x71,
	0xa1, 0x97, 0x90, 0x35, 0xc5, 0x85, 0xea, 0x01, 0x54, 0xa6, 0x4c, 0x2e, 0xaf, 0xff, 0x07, 0x19,
	0x10, 0x15, 0x1d, 0xaa, 0x2f, 0xc8, 0xb4, 0x7a, 0x03, 0x74, 0x03, 0x40, 0x84, 0x24, 0xe0, 0x76,
	0xe8, 0xb5, 0x85, 0x61, 0xe3, 0x98, 0x04, 0xcd, 0x42, 0xda, 0xe3, 0x56, 0xd3, 0x0b, 0x88, 0xaf,
	0x72, 0x24, 0x8d, 0xc7, 0x3d, 0xbe, 0x26, 0x87, 0xd2, 0x34, 0xc6, 0x81, 0x23, 0x8a, 0x03, 0x63,
	0x12, 0xb4, 0x00, 0x13, 0x5c, 0x90, 0x3d, 0xcf, 0xf7, 0xc4, 0xb1, 0x8a, 0x5f, 0x12, 0xf7, 0x04,
	0xe8, 0x39, 0xe4, 0x4c, 0x31, 0x79, 0xc4, 0x42, 0x47, 0xbf, 0xd6, 0xc3, 0x56, 0x52, 0x0d, 0x65,
	0xf8, 0x8c, 0x85, 0x8e, 0x7c, 0xb5, 0xf1, 0x24, 0x3f, 0x31, 0x46, 0x55, 0xb8, 0x6a, 0xa0, 0x69,
	0xe0, 0x58, 0xac, 0xd9, 0xe4, 0x54, 0xa8, 0x3a, 0x2a, 0xb3, 0x3c, 0x7b, 0xaa, 0x12, 0xa8, 0x98,
	0xef, 0x3a, 0x78, 0x4a, 0xdb, 0x54, 0x03, 0x67, 0x5b, 0x59, 0x14, 0xbe, 0x07, 0x99, 0x58, 0xd8,
	0xd0, 0x02, 0xe4, 0x37, 0xab, 0x8d, 0xc6, 0xca, 0x7a, 0xd5, 0xda, 0x7d, 0xbe, 0x53, 0xed, 0xe3,
	0xea, 0x49, 0x80, 0x5d, 0xbc, 0xb2, 0xd5, 0x28, 0xe3, 0xda, 0xce, 0x6e, 0x2e, 0x81, 0xe6, 0x61,
	0xa6, 0xba, 0x55, 0xb1, 0xb6, 0xd7, 0xac, 0x46, 0x6d, 0x6b, 0xbd, 0x5e, 0xb5, 0x9e, 0xec, 0xee,
	0x56, 0xf1, 0xca, 0x56, 0xb9, 0x9a, 0x4b, 0x16, 0x2a, 0x30, 0xd1, 0xad, 0xff, 0x11, 0x32, 0x9d,
	0x83, 0xe6, 0x03, 0xdd, 0x0b, 0x9c, 0x2a, 0xc7, 0x93, 0xa7, 0xcb, 0xf1, 0xc2, 0x8f, 0x01, 0x7a,
	0x2d, 0x80, 0x84, 0x91, 0x7d, 0x59, 0x04, 0x23, 0xff, 0xf7, 0x15, 0xd5, 0xc9, 0xe1, 0x8b, 0xea,
	0x53, 0xeb, 0xa7, 0xce, 0x58, 0x9f, 0xc0, 0x8d, 0x8b, 0x7b, 0x33, 0xf4, 0x10, 0x16, 0x54, 0x11,
	0xf5, 0x79, 0xc4, 0x07, 0x72, 0x73, 0x56, 0xb7, 0x0c, 0x52, 0xbe, 0xa6, 0xf1, 0xac, 0xd1, 0x79,
	0x1c, 0x75, 0x23, 0x5d, 0xd4, 0xc2, 0x11, 0xcc, 0x9c, 0x53, 0x4d, 0xa1, 0xef, 0xc3, 0xf4, 0xb9,
	0x98, 0xc3, 0x34, 0x60, 0x5d, 0x5c, 0x8c, 0x0e, 0x4e, 0x2f, 0xfc, 0x10, 0x26, 0xba, 0x03, 0x34,
	0x0d, 0xa3, 0xdc, 0x66, 0xa1, 0x8e, 0x6d, 0x12, 0xeb, 0x81, 0x4c, 0xef, 0x16, 0x91, 0xb7, 0xac,
	0xe3, 0x44, 0x9d, 0x4f, 0x4f, 0xb0, 0xfc, 0x8f, 0x51, 0x48, 0x9b, 0x96, 0x9c, 0xa3, 0x3f, 0xa6,
	0x20, 0x1b, 0x7f, 0x12, 0xd0, 0x37, 0x07, 0xba, 0x77, 0xc6, 0x7b, 0x3e, 0xf7, 0xad, 0x4b, 0x5a,
	0xe9, 0x87, 0xa5, 0xf0, 0x65, 0xf2, 0x27, 0x5f, 0xfe, 0xf5, 0x97, 0xc9, 0x3f, 0x24, 0x0b, 0xf7,
	0xbb, 0x1f, 0x3e, 0x7f, 0x68, 0x2a, 0x81, 0x07, 0xed, 0x90, 0xbd, 0xa4, 0xb6, 0xe0, 0xa5, 0x5b,
	0xfa, 0x53, 0x6e, 0xf4, 0x49, 0x94, 0x97, 0x6e, 0xfd, 0xe8, 0x9e, 0x13, 0x83, 0xbb, 0x97, 0xb8,
	0xf5, 0xe2, 0x59, 0x01, 0x0f, 0x81, 0x40, 0x83, 0x43, 0x2f, 0x64, 0x81, 0x0c, 0x9d, 0x14, 0x76,
	0x38, 0x0d, 0xe5, 0xef, 0x45, 0xc0, 0xf5, 0xc2, 0xfa, 0x85, 0xc0, 0xd1, 0xa7, 0x9b, 0xe1, 0xdc,
	0xb4, 0x0b, 0x9f, 0x5d, 0x12, 0xed, 0xf2, 0x2e, 0xa3, 0x5f, 0x25, 0xe0, 0x2b, 0x67, 0xbe, 0xf7,
	0xe8, 0xc1, 0xf0, 0x44, 0x7d, 0xd6, 0x29, 0x7f, 0xfa, 0xa6, 0xe6, 0xe6, 0xb8, 0xaf, 0x2c, 0x25,
	0xee, 0x24, 0xe6, 0x5e, 0xff, 0x7e, 0x65, 0x36, 0x66, 0xaa, 0x21, 0x49, 0xdb, 0xe3, 0x45, 0x9b,
	0xb5, 0xfe, 0xb4, 0xf2, 0x7c, 0x5f, 0x88, 0x36, 0xbf, 0x57, 0x2a, 0x1d, 0x1d, 0xf5, 0x4f, 0x96,
	0x48, 0x47, 0xec, 0xeb, 0x4f, 0xe6, 0x1f, 0xb5, 0x7d, 0x22, 0x9a, 0x2c, 0x6c, 0xdd, 0x1e, 0xa4,
	0xde, 0x5b, 0x6a, 0xf5, 0x8b, 0x04, 0xbc, 0x6f, 0xb3, 0xd6, 0xa0, 0x5d, 0xac, 0x66, 0xcd, 0xf5,
	0xd8, 0x91, 0x3c, 0xb4, 0x93, 0x78, 0x51, 0x33, 0x06, 0x2e, 0x93, 0x2c, 0x53, 0x64, 0xa1, 0x5b,
	0x72, 0x69, 0xa0, 0x58, 0xaa, 0xd4, 0x5b, 0xf2, 0xdc, 0x6f, 0xf9, 0xf7, 0x7b, 0xa2, 0x7f, 0x26,
	0x12, 0xbf, 0x4e, 0x26, 0x2b, 0x6b, 0x5f, 0x24, 0x6f, 0xae, 0x6b, 0xcc, 0xb2, 0x72, 0xa2, 0xd2,
	0x73, 0xe2, 0xa9, 0x36, 0xda, 0x1b, 0x53, 0xf8, 0xdf, 0xf8, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff,
	0xe1, 0x96, 0xf5, 0x48, 0x77, 0x19, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SessionsClient is the client API for Sessions service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SessionsClient interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error)
}

type sessionsClient struct {
	cc *grpc.ClientConn
}

func NewSessionsClient(cc *grpc.ClientConn) SessionsClient {
	return &sessionsClient{cc}
}

func (c *sessionsClient) DetectIntent(ctx context.Context, in *DetectIntentRequest, opts ...grpc.CallOption) (*DetectIntentResponse, error) {
	out := new(DetectIntentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Sessions/DetectIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sessionsClient) StreamingDetectIntent(ctx context.Context, opts ...grpc.CallOption) (Sessions_StreamingDetectIntentClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Sessions_serviceDesc.Streams[0], "/google.cloud.dialogflow.v2beta1.Sessions/StreamingDetectIntent", opts...)
	if err != nil {
		return nil, err
	}
	x := &sessionsStreamingDetectIntentClient{stream}
	return x, nil
}

type Sessions_StreamingDetectIntentClient interface {
	Send(*StreamingDetectIntentRequest) error
	Recv() (*StreamingDetectIntentResponse, error)
	grpc.ClientStream
}

type sessionsStreamingDetectIntentClient struct {
	grpc.ClientStream
}

func (x *sessionsStreamingDetectIntentClient) Send(m *StreamingDetectIntentRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentClient) Recv() (*StreamingDetectIntentResponse, error) {
	m := new(StreamingDetectIntentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SessionsServer is the server API for Sessions service.
type SessionsServer interface {
	// Processes a natural language query and returns structured, actionable data
	// as a result. This method is not idempotent, because it may cause contexts
	// and session entity types to be updated, which in turn might affect
	// results of future queries.
	DetectIntent(context.Context, *DetectIntentRequest) (*DetectIntentResponse, error)
	// Processes a natural language query in audio format in a streaming fashion
	// and returns structured, actionable data as a result. This method is only
	// available via the gRPC API (not REST).
	StreamingDetectIntent(Sessions_StreamingDetectIntentServer) error
}

func RegisterSessionsServer(s *grpc.Server, srv SessionsServer) {
	s.RegisterService(&_Sessions_serviceDesc, srv)
}

func _Sessions_DetectIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetectIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SessionsServer).DetectIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Sessions/DetectIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SessionsServer).DetectIntent(ctx, req.(*DetectIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Sessions_StreamingDetectIntent_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SessionsServer).StreamingDetectIntent(&sessionsStreamingDetectIntentServer{stream})
}

type Sessions_StreamingDetectIntentServer interface {
	Send(*StreamingDetectIntentResponse) error
	Recv() (*StreamingDetectIntentRequest, error)
	grpc.ServerStream
}

type sessionsStreamingDetectIntentServer struct {
	grpc.ServerStream
}

func (x *sessionsStreamingDetectIntentServer) Send(m *StreamingDetectIntentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *sessionsStreamingDetectIntentServer) Recv() (*StreamingDetectIntentRequest, error) {
	m := new(StreamingDetectIntentRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Sessions_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.Sessions",
	HandlerType: (*SessionsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "DetectIntent",
			Handler:    _Sessions_DetectIntent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingDetectIntent",
			Handler:       _Sessions_StreamingDetectIntent_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/dialogflow/v2beta1/session.proto",
}
