package sqlapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/sql/mgmt/2014-04-01/sql"
	"github.com/Azure/go-autorest/autorest"
)

// ServersClientAPI contains the set of methods on the ServersClient type.
type ServersClientAPI interface {
	CheckNameAvailability(ctx context.Context, parameters sql.CheckNameAvailabilityRequest) (result sql.CheckNameAvailabilityResponse, err error)
}

var _ ServersClientAPI = (*sql.ServersClient)(nil)

// DatabasesClientAPI contains the set of methods on the DatabasesClient type.
type DatabasesClientAPI interface {
	CreateImportOperation(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ImportExtensionRequest) (result sql.DatabasesCreateImportOperationFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.Database) (result sql.DatabasesCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result autorest.Response, err error)
	Export(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.ExportRequest) (result sql.DatabasesExportFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, expand string) (result sql.Database, err error)
	GetByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, databaseName string) (result sql.Database, err error)
	GetByRecommendedElasticPool(ctx context.Context, resourceGroupName string, serverName string, recommendedElasticPoolName string, databaseName string) (result sql.Database, err error)
	Import(ctx context.Context, resourceGroupName string, serverName string, parameters sql.ImportRequest) (result sql.DatabasesImportFuture, err error)
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.DatabaseListResult, err error)
	ListByRecommendedElasticPool(ctx context.Context, resourceGroupName string, serverName string, recommendedElasticPoolName string) (result sql.DatabaseListResult, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string, expand string, filter string) (result sql.DatabaseListResult, err error)
	Pause(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabasesPauseFuture, err error)
	Resume(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabasesResumeFuture, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseUpdate) (result sql.DatabasesUpdateFuture, err error)
}

var _ DatabasesClientAPI = (*sql.DatabasesClient)(nil)

// ElasticPoolsClientAPI contains the set of methods on the ElasticPoolsClient type.
type ElasticPoolsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, parameters sql.ElasticPool) (result sql.ElasticPoolsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPool, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.ElasticPoolListResult, err error)
	Update(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string, parameters sql.ElasticPoolUpdate) (result sql.ElasticPoolsUpdateFuture, err error)
}

var _ ElasticPoolsClientAPI = (*sql.ElasticPoolsClient)(nil)

// FirewallRulesClientAPI contains the set of methods on the FirewallRulesClient type.
type FirewallRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string, parameters sql.FirewallRule) (result sql.FirewallRule, err error)
	Delete(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, firewallRuleName string) (result sql.FirewallRule, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.FirewallRuleListResult, err error)
}

var _ FirewallRulesClientAPI = (*sql.FirewallRulesClient)(nil)

// RecommendedElasticPoolsClientAPI contains the set of methods on the RecommendedElasticPoolsClient type.
type RecommendedElasticPoolsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, recommendedElasticPoolName string) (result sql.RecommendedElasticPool, err error)
	ListByServer(ctx context.Context, resourceGroupName string, serverName string) (result sql.RecommendedElasticPoolListResult, err error)
	ListMetrics(ctx context.Context, resourceGroupName string, serverName string, recommendedElasticPoolName string) (result sql.RecommendedElasticPoolListMetricsResult, err error)
}

var _ RecommendedElasticPoolsClientAPI = (*sql.RecommendedElasticPoolsClient)(nil)

// ReplicationLinksClientAPI contains the set of methods on the ReplicationLinksClient type.
type ReplicationLinksClientAPI interface {
	Delete(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result autorest.Response, err error)
	Failover(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result sql.ReplicationLinksFailoverFuture, err error)
	FailoverAllowDataLoss(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result sql.ReplicationLinksFailoverAllowDataLossFuture, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, linkID string) (result sql.ReplicationLink, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ReplicationLinkListResult, err error)
}

var _ ReplicationLinksClientAPI = (*sql.ReplicationLinksClient)(nil)

// ElasticPoolActivitiesClientAPI contains the set of methods on the ElasticPoolActivitiesClient type.
type ElasticPoolActivitiesClientAPI interface {
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolActivityListResult, err error)
}

var _ ElasticPoolActivitiesClientAPI = (*sql.ElasticPoolActivitiesClient)(nil)

// ElasticPoolDatabaseActivitiesClientAPI contains the set of methods on the ElasticPoolDatabaseActivitiesClient type.
type ElasticPoolDatabaseActivitiesClientAPI interface {
	ListByElasticPool(ctx context.Context, resourceGroupName string, serverName string, elasticPoolName string) (result sql.ElasticPoolDatabaseActivityListResult, err error)
}

var _ ElasticPoolDatabaseActivitiesClientAPI = (*sql.ElasticPoolDatabaseActivitiesClient)(nil)

// ServiceTierAdvisorsClientAPI contains the set of methods on the ServiceTierAdvisorsClient type.
type ServiceTierAdvisorsClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string, serviceTierAdvisorName string) (result sql.ServiceTierAdvisor, err error)
	ListByDatabase(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.ServiceTierAdvisorListResult, err error)
}

var _ ServiceTierAdvisorsClientAPI = (*sql.ServiceTierAdvisorsClient)(nil)

// TransparentDataEncryptionsClientAPI contains the set of methods on the TransparentDataEncryptionsClient type.
type TransparentDataEncryptionsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.TransparentDataEncryption) (result sql.TransparentDataEncryption, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.TransparentDataEncryption, err error)
}

var _ TransparentDataEncryptionsClientAPI = (*sql.TransparentDataEncryptionsClient)(nil)

// TransparentDataEncryptionActivitiesClientAPI contains the set of methods on the TransparentDataEncryptionActivitiesClient type.
type TransparentDataEncryptionActivitiesClientAPI interface {
	ListByConfiguration(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.TransparentDataEncryptionActivityListResult, err error)
}

var _ TransparentDataEncryptionActivitiesClientAPI = (*sql.TransparentDataEncryptionActivitiesClient)(nil)

// DatabaseThreatDetectionPoliciesClientAPI contains the set of methods on the DatabaseThreatDetectionPoliciesClient type.
type DatabaseThreatDetectionPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, serverName string, databaseName string, parameters sql.DatabaseSecurityAlertPolicy) (result sql.DatabaseSecurityAlertPolicy, err error)
	Get(ctx context.Context, resourceGroupName string, serverName string, databaseName string) (result sql.DatabaseSecurityAlertPolicy, err error)
}

var _ DatabaseThreatDetectionPoliciesClientAPI = (*sql.DatabaseThreatDetectionPoliciesClient)(nil)
