// +build !ignore_autogenerated

/*
Copyright 2019 Red Hat Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
// Code generated by conversion-gen-linux. DO NOT EDIT.

package extv1beta1

import (
	unsafe "unsafe"

	v1 "k8s.io/api/apps/v1"
	corev1 "k8s.io/api/core/v1"
	v1beta1 "k8s.io/api/extensions/v1beta1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*v1.DaemonSet)(nil), (*v1beta1.DaemonSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSet_To_v1beta1_DaemonSet(a.(*v1.DaemonSet), b.(*v1beta1.DaemonSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DaemonSet)(nil), (*v1.DaemonSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DaemonSet_To_v1_DaemonSet(a.(*v1beta1.DaemonSet), b.(*v1.DaemonSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DaemonSetCondition)(nil), (*v1beta1.DaemonSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetCondition_To_v1beta1_DaemonSetCondition(a.(*v1.DaemonSetCondition), b.(*v1beta1.DaemonSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DaemonSetCondition)(nil), (*v1.DaemonSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DaemonSetCondition_To_v1_DaemonSetCondition(a.(*v1beta1.DaemonSetCondition), b.(*v1.DaemonSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DaemonSetList)(nil), (*v1beta1.DaemonSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetList_To_v1beta1_DaemonSetList(a.(*v1.DaemonSetList), b.(*v1beta1.DaemonSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DaemonSetList)(nil), (*v1.DaemonSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DaemonSetList_To_v1_DaemonSetList(a.(*v1beta1.DaemonSetList), b.(*v1.DaemonSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DaemonSetSpec)(nil), (*v1beta1.DaemonSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetSpec_To_v1beta1_DaemonSetSpec(a.(*v1.DaemonSetSpec), b.(*v1beta1.DaemonSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DaemonSetStatus)(nil), (*v1beta1.DaemonSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetStatus_To_v1beta1_DaemonSetStatus(a.(*v1.DaemonSetStatus), b.(*v1beta1.DaemonSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DaemonSetStatus)(nil), (*v1.DaemonSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DaemonSetStatus_To_v1_DaemonSetStatus(a.(*v1beta1.DaemonSetStatus), b.(*v1.DaemonSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DaemonSetUpdateStrategy)(nil), (*v1beta1.DaemonSetUpdateStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DaemonSetUpdateStrategy_To_v1beta1_DaemonSetUpdateStrategy(a.(*v1.DaemonSetUpdateStrategy), b.(*v1beta1.DaemonSetUpdateStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DaemonSetUpdateStrategy)(nil), (*v1.DaemonSetUpdateStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(a.(*v1beta1.DaemonSetUpdateStrategy), b.(*v1.DaemonSetUpdateStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.Deployment)(nil), (*v1beta1.Deployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_Deployment_To_v1beta1_Deployment(a.(*v1.Deployment), b.(*v1beta1.Deployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.Deployment)(nil), (*v1.Deployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_Deployment_To_v1_Deployment(a.(*v1beta1.Deployment), b.(*v1.Deployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeploymentCondition)(nil), (*v1beta1.DeploymentCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentCondition_To_v1beta1_DeploymentCondition(a.(*v1.DeploymentCondition), b.(*v1beta1.DeploymentCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DeploymentCondition)(nil), (*v1.DeploymentCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DeploymentCondition_To_v1_DeploymentCondition(a.(*v1beta1.DeploymentCondition), b.(*v1.DeploymentCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeploymentList)(nil), (*v1beta1.DeploymentList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentList_To_v1beta1_DeploymentList(a.(*v1.DeploymentList), b.(*v1beta1.DeploymentList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DeploymentList)(nil), (*v1.DeploymentList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DeploymentList_To_v1_DeploymentList(a.(*v1beta1.DeploymentList), b.(*v1.DeploymentList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeploymentSpec)(nil), (*v1beta1.DeploymentSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentSpec_To_v1beta1_DeploymentSpec(a.(*v1.DeploymentSpec), b.(*v1beta1.DeploymentSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeploymentStatus)(nil), (*v1beta1.DeploymentStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentStatus_To_v1beta1_DeploymentStatus(a.(*v1.DeploymentStatus), b.(*v1beta1.DeploymentStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DeploymentStatus)(nil), (*v1.DeploymentStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DeploymentStatus_To_v1_DeploymentStatus(a.(*v1beta1.DeploymentStatus), b.(*v1.DeploymentStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.DeploymentStrategy)(nil), (*v1beta1.DeploymentStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_DeploymentStrategy_To_v1beta1_DeploymentStrategy(a.(*v1.DeploymentStrategy), b.(*v1beta1.DeploymentStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.DeploymentStrategy)(nil), (*v1.DeploymentStrategy)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DeploymentStrategy_To_v1_DeploymentStrategy(a.(*v1beta1.DeploymentStrategy), b.(*v1.DeploymentStrategy), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ReplicaSet)(nil), (*v1beta1.ReplicaSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSet_To_v1beta1_ReplicaSet(a.(*v1.ReplicaSet), b.(*v1beta1.ReplicaSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ReplicaSet)(nil), (*v1.ReplicaSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ReplicaSet_To_v1_ReplicaSet(a.(*v1beta1.ReplicaSet), b.(*v1.ReplicaSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ReplicaSetCondition)(nil), (*v1beta1.ReplicaSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSetCondition_To_v1beta1_ReplicaSetCondition(a.(*v1.ReplicaSetCondition), b.(*v1beta1.ReplicaSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ReplicaSetCondition)(nil), (*v1.ReplicaSetCondition)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ReplicaSetCondition_To_v1_ReplicaSetCondition(a.(*v1beta1.ReplicaSetCondition), b.(*v1.ReplicaSetCondition), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ReplicaSetList)(nil), (*v1beta1.ReplicaSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSetList_To_v1beta1_ReplicaSetList(a.(*v1.ReplicaSetList), b.(*v1beta1.ReplicaSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ReplicaSetList)(nil), (*v1.ReplicaSetList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ReplicaSetList_To_v1_ReplicaSetList(a.(*v1beta1.ReplicaSetList), b.(*v1.ReplicaSetList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ReplicaSetSpec)(nil), (*v1beta1.ReplicaSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSetSpec_To_v1beta1_ReplicaSetSpec(a.(*v1.ReplicaSetSpec), b.(*v1beta1.ReplicaSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ReplicaSetSpec)(nil), (*v1.ReplicaSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ReplicaSetSpec_To_v1_ReplicaSetSpec(a.(*v1beta1.ReplicaSetSpec), b.(*v1.ReplicaSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.ReplicaSetStatus)(nil), (*v1beta1.ReplicaSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_ReplicaSetStatus_To_v1beta1_ReplicaSetStatus(a.(*v1.ReplicaSetStatus), b.(*v1beta1.ReplicaSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.ReplicaSetStatus)(nil), (*v1.ReplicaSetStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_ReplicaSetStatus_To_v1_ReplicaSetStatus(a.(*v1beta1.ReplicaSetStatus), b.(*v1.ReplicaSetStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.RollingUpdateDaemonSet)(nil), (*v1beta1.RollingUpdateDaemonSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_RollingUpdateDaemonSet_To_v1beta1_RollingUpdateDaemonSet(a.(*v1.RollingUpdateDaemonSet), b.(*v1beta1.RollingUpdateDaemonSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.RollingUpdateDaemonSet)(nil), (*v1.RollingUpdateDaemonSet)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet(a.(*v1beta1.RollingUpdateDaemonSet), b.(*v1.RollingUpdateDaemonSet), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1.RollingUpdateDeployment)(nil), (*v1beta1.RollingUpdateDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_RollingUpdateDeployment_To_v1beta1_RollingUpdateDeployment(a.(*v1.RollingUpdateDeployment), b.(*v1beta1.RollingUpdateDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*v1beta1.RollingUpdateDeployment)(nil), (*v1.RollingUpdateDeployment)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_RollingUpdateDeployment_To_v1_RollingUpdateDeployment(a.(*v1beta1.RollingUpdateDeployment), b.(*v1.RollingUpdateDeployment), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.DaemonSetSpec)(nil), (*v1.DaemonSetSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DaemonSetSpec_To_v1_DaemonSetSpec(a.(*v1beta1.DaemonSetSpec), b.(*v1.DaemonSetSpec), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*v1beta1.DeploymentSpec)(nil), (*v1.DeploymentSpec)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1beta1_DeploymentSpec_To_v1_DeploymentSpec(a.(*v1beta1.DeploymentSpec), b.(*v1.DeploymentSpec), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_DaemonSet_To_v1beta1_DaemonSet(in *v1.DaemonSet, out *v1beta1.DaemonSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_DaemonSetSpec_To_v1beta1_DaemonSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_DaemonSetStatus_To_v1beta1_DaemonSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_DaemonSet_To_v1beta1_DaemonSet is an autogenerated conversion function.
func Convert_v1_DaemonSet_To_v1beta1_DaemonSet(in *v1.DaemonSet, out *v1beta1.DaemonSet, s conversion.Scope) error {
	return autoConvert_v1_DaemonSet_To_v1beta1_DaemonSet(in, out, s)
}

func autoConvert_v1beta1_DaemonSet_To_v1_DaemonSet(in *v1beta1.DaemonSet, out *v1.DaemonSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_DaemonSetSpec_To_v1_DaemonSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_DaemonSetStatus_To_v1_DaemonSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_DaemonSet_To_v1_DaemonSet is an autogenerated conversion function.
func Convert_v1beta1_DaemonSet_To_v1_DaemonSet(in *v1beta1.DaemonSet, out *v1.DaemonSet, s conversion.Scope) error {
	return autoConvert_v1beta1_DaemonSet_To_v1_DaemonSet(in, out, s)
}

func autoConvert_v1_DaemonSetCondition_To_v1beta1_DaemonSetCondition(in *v1.DaemonSetCondition, out *v1beta1.DaemonSetCondition, s conversion.Scope) error {
	out.Type = v1beta1.DaemonSetConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_DaemonSetCondition_To_v1beta1_DaemonSetCondition is an autogenerated conversion function.
func Convert_v1_DaemonSetCondition_To_v1beta1_DaemonSetCondition(in *v1.DaemonSetCondition, out *v1beta1.DaemonSetCondition, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetCondition_To_v1beta1_DaemonSetCondition(in, out, s)
}

func autoConvert_v1beta1_DaemonSetCondition_To_v1_DaemonSetCondition(in *v1beta1.DaemonSetCondition, out *v1.DaemonSetCondition, s conversion.Scope) error {
	out.Type = v1.DaemonSetConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1beta1_DaemonSetCondition_To_v1_DaemonSetCondition is an autogenerated conversion function.
func Convert_v1beta1_DaemonSetCondition_To_v1_DaemonSetCondition(in *v1beta1.DaemonSetCondition, out *v1.DaemonSetCondition, s conversion.Scope) error {
	return autoConvert_v1beta1_DaemonSetCondition_To_v1_DaemonSetCondition(in, out, s)
}

func autoConvert_v1_DaemonSetList_To_v1beta1_DaemonSetList(in *v1.DaemonSetList, out *v1beta1.DaemonSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.DaemonSet, len(*in))
		for i := range *in {
			if err := Convert_v1_DaemonSet_To_v1beta1_DaemonSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_DaemonSetList_To_v1beta1_DaemonSetList is an autogenerated conversion function.
func Convert_v1_DaemonSetList_To_v1beta1_DaemonSetList(in *v1.DaemonSetList, out *v1beta1.DaemonSetList, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetList_To_v1beta1_DaemonSetList(in, out, s)
}

func autoConvert_v1beta1_DaemonSetList_To_v1_DaemonSetList(in *v1beta1.DaemonSetList, out *v1.DaemonSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.DaemonSet, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_DaemonSet_To_v1_DaemonSet(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_DaemonSetList_To_v1_DaemonSetList is an autogenerated conversion function.
func Convert_v1beta1_DaemonSetList_To_v1_DaemonSetList(in *v1beta1.DaemonSetList, out *v1.DaemonSetList, s conversion.Scope) error {
	return autoConvert_v1beta1_DaemonSetList_To_v1_DaemonSetList(in, out, s)
}

func autoConvert_v1_DaemonSetSpec_To_v1beta1_DaemonSetSpec(in *v1.DaemonSetSpec, out *v1beta1.DaemonSetSpec, s conversion.Scope) error {
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	if err := Convert_v1_DaemonSetUpdateStrategy_To_v1beta1_DaemonSetUpdateStrategy(&in.UpdateStrategy, &out.UpdateStrategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	return nil
}

// Convert_v1_DaemonSetSpec_To_v1beta1_DaemonSetSpec is an autogenerated conversion function.
func Convert_v1_DaemonSetSpec_To_v1beta1_DaemonSetSpec(in *v1.DaemonSetSpec, out *v1beta1.DaemonSetSpec, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetSpec_To_v1beta1_DaemonSetSpec(in, out, s)
}

func autoConvert_v1beta1_DaemonSetSpec_To_v1_DaemonSetSpec(in *v1beta1.DaemonSetSpec, out *v1.DaemonSetSpec, s conversion.Scope) error {
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	if err := Convert_v1beta1_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(&in.UpdateStrategy, &out.UpdateStrategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	// WARNING: in.TemplateGeneration requires manual conversion: does not exist in peer-type
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	return nil
}

func autoConvert_v1_DaemonSetStatus_To_v1beta1_DaemonSetStatus(in *v1.DaemonSetStatus, out *v1beta1.DaemonSetStatus, s conversion.Scope) error {
	out.CurrentNumberScheduled = in.CurrentNumberScheduled
	out.NumberMisscheduled = in.NumberMisscheduled
	out.DesiredNumberScheduled = in.DesiredNumberScheduled
	out.NumberReady = in.NumberReady
	out.ObservedGeneration = in.ObservedGeneration
	out.UpdatedNumberScheduled = in.UpdatedNumberScheduled
	out.NumberAvailable = in.NumberAvailable
	out.NumberUnavailable = in.NumberUnavailable
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	out.Conditions = *(*[]v1beta1.DaemonSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1_DaemonSetStatus_To_v1beta1_DaemonSetStatus is an autogenerated conversion function.
func Convert_v1_DaemonSetStatus_To_v1beta1_DaemonSetStatus(in *v1.DaemonSetStatus, out *v1beta1.DaemonSetStatus, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetStatus_To_v1beta1_DaemonSetStatus(in, out, s)
}

func autoConvert_v1beta1_DaemonSetStatus_To_v1_DaemonSetStatus(in *v1beta1.DaemonSetStatus, out *v1.DaemonSetStatus, s conversion.Scope) error {
	out.CurrentNumberScheduled = in.CurrentNumberScheduled
	out.NumberMisscheduled = in.NumberMisscheduled
	out.DesiredNumberScheduled = in.DesiredNumberScheduled
	out.NumberReady = in.NumberReady
	out.ObservedGeneration = in.ObservedGeneration
	out.UpdatedNumberScheduled = in.UpdatedNumberScheduled
	out.NumberAvailable = in.NumberAvailable
	out.NumberUnavailable = in.NumberUnavailable
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	out.Conditions = *(*[]v1.DaemonSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1beta1_DaemonSetStatus_To_v1_DaemonSetStatus is an autogenerated conversion function.
func Convert_v1beta1_DaemonSetStatus_To_v1_DaemonSetStatus(in *v1beta1.DaemonSetStatus, out *v1.DaemonSetStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_DaemonSetStatus_To_v1_DaemonSetStatus(in, out, s)
}

func autoConvert_v1_DaemonSetUpdateStrategy_To_v1beta1_DaemonSetUpdateStrategy(in *v1.DaemonSetUpdateStrategy, out *v1beta1.DaemonSetUpdateStrategy, s conversion.Scope) error {
	out.Type = v1beta1.DaemonSetUpdateStrategyType(in.Type)
	out.RollingUpdate = (*v1beta1.RollingUpdateDaemonSet)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1_DaemonSetUpdateStrategy_To_v1beta1_DaemonSetUpdateStrategy is an autogenerated conversion function.
func Convert_v1_DaemonSetUpdateStrategy_To_v1beta1_DaemonSetUpdateStrategy(in *v1.DaemonSetUpdateStrategy, out *v1beta1.DaemonSetUpdateStrategy, s conversion.Scope) error {
	return autoConvert_v1_DaemonSetUpdateStrategy_To_v1beta1_DaemonSetUpdateStrategy(in, out, s)
}

func autoConvert_v1beta1_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(in *v1beta1.DaemonSetUpdateStrategy, out *v1.DaemonSetUpdateStrategy, s conversion.Scope) error {
	out.Type = v1.DaemonSetUpdateStrategyType(in.Type)
	out.RollingUpdate = (*v1.RollingUpdateDaemonSet)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1beta1_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy is an autogenerated conversion function.
func Convert_v1beta1_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(in *v1beta1.DaemonSetUpdateStrategy, out *v1.DaemonSetUpdateStrategy, s conversion.Scope) error {
	return autoConvert_v1beta1_DaemonSetUpdateStrategy_To_v1_DaemonSetUpdateStrategy(in, out, s)
}

func autoConvert_v1_Deployment_To_v1beta1_Deployment(in *v1.Deployment, out *v1beta1.Deployment, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_DeploymentSpec_To_v1beta1_DeploymentSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_DeploymentStatus_To_v1beta1_DeploymentStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_Deployment_To_v1beta1_Deployment is an autogenerated conversion function.
func Convert_v1_Deployment_To_v1beta1_Deployment(in *v1.Deployment, out *v1beta1.Deployment, s conversion.Scope) error {
	return autoConvert_v1_Deployment_To_v1beta1_Deployment(in, out, s)
}

func autoConvert_v1beta1_Deployment_To_v1_Deployment(in *v1beta1.Deployment, out *v1.Deployment, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_DeploymentSpec_To_v1_DeploymentSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_DeploymentStatus_To_v1_DeploymentStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_Deployment_To_v1_Deployment is an autogenerated conversion function.
func Convert_v1beta1_Deployment_To_v1_Deployment(in *v1beta1.Deployment, out *v1.Deployment, s conversion.Scope) error {
	return autoConvert_v1beta1_Deployment_To_v1_Deployment(in, out, s)
}

func autoConvert_v1_DeploymentCondition_To_v1beta1_DeploymentCondition(in *v1.DeploymentCondition, out *v1beta1.DeploymentCondition, s conversion.Scope) error {
	out.Type = v1beta1.DeploymentConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_DeploymentCondition_To_v1beta1_DeploymentCondition is an autogenerated conversion function.
func Convert_v1_DeploymentCondition_To_v1beta1_DeploymentCondition(in *v1.DeploymentCondition, out *v1beta1.DeploymentCondition, s conversion.Scope) error {
	return autoConvert_v1_DeploymentCondition_To_v1beta1_DeploymentCondition(in, out, s)
}

func autoConvert_v1beta1_DeploymentCondition_To_v1_DeploymentCondition(in *v1beta1.DeploymentCondition, out *v1.DeploymentCondition, s conversion.Scope) error {
	out.Type = v1.DeploymentConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastUpdateTime = in.LastUpdateTime
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1beta1_DeploymentCondition_To_v1_DeploymentCondition is an autogenerated conversion function.
func Convert_v1beta1_DeploymentCondition_To_v1_DeploymentCondition(in *v1beta1.DeploymentCondition, out *v1.DeploymentCondition, s conversion.Scope) error {
	return autoConvert_v1beta1_DeploymentCondition_To_v1_DeploymentCondition(in, out, s)
}

func autoConvert_v1_DeploymentList_To_v1beta1_DeploymentList(in *v1.DeploymentList, out *v1beta1.DeploymentList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1beta1.Deployment, len(*in))
		for i := range *in {
			if err := Convert_v1_Deployment_To_v1beta1_Deployment(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1_DeploymentList_To_v1beta1_DeploymentList is an autogenerated conversion function.
func Convert_v1_DeploymentList_To_v1beta1_DeploymentList(in *v1.DeploymentList, out *v1beta1.DeploymentList, s conversion.Scope) error {
	return autoConvert_v1_DeploymentList_To_v1beta1_DeploymentList(in, out, s)
}

func autoConvert_v1beta1_DeploymentList_To_v1_DeploymentList(in *v1beta1.DeploymentList, out *v1.DeploymentList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]v1.Deployment, len(*in))
		for i := range *in {
			if err := Convert_v1beta1_Deployment_To_v1_Deployment(&(*in)[i], &(*out)[i], s); err != nil {
				return err
			}
		}
	} else {
		out.Items = nil
	}
	return nil
}

// Convert_v1beta1_DeploymentList_To_v1_DeploymentList is an autogenerated conversion function.
func Convert_v1beta1_DeploymentList_To_v1_DeploymentList(in *v1beta1.DeploymentList, out *v1.DeploymentList, s conversion.Scope) error {
	return autoConvert_v1beta1_DeploymentList_To_v1_DeploymentList(in, out, s)
}

func autoConvert_v1_DeploymentSpec_To_v1beta1_DeploymentSpec(in *v1.DeploymentSpec, out *v1beta1.DeploymentSpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	if err := Convert_v1_DeploymentStrategy_To_v1beta1_DeploymentStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.Paused = in.Paused
	out.ProgressDeadlineSeconds = (*int32)(unsafe.Pointer(in.ProgressDeadlineSeconds))
	return nil
}

// Convert_v1_DeploymentSpec_To_v1beta1_DeploymentSpec is an autogenerated conversion function.
func Convert_v1_DeploymentSpec_To_v1beta1_DeploymentSpec(in *v1.DeploymentSpec, out *v1beta1.DeploymentSpec, s conversion.Scope) error {
	return autoConvert_v1_DeploymentSpec_To_v1beta1_DeploymentSpec(in, out, s)
}

func autoConvert_v1beta1_DeploymentSpec_To_v1_DeploymentSpec(in *v1beta1.DeploymentSpec, out *v1.DeploymentSpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	if err := Convert_v1beta1_DeploymentStrategy_To_v1_DeploymentStrategy(&in.Strategy, &out.Strategy, s); err != nil {
		return err
	}
	out.MinReadySeconds = in.MinReadySeconds
	out.RevisionHistoryLimit = (*int32)(unsafe.Pointer(in.RevisionHistoryLimit))
	out.Paused = in.Paused
	// WARNING: in.RollbackTo requires manual conversion: does not exist in peer-type
	out.ProgressDeadlineSeconds = (*int32)(unsafe.Pointer(in.ProgressDeadlineSeconds))
	return nil
}

func autoConvert_v1_DeploymentStatus_To_v1beta1_DeploymentStatus(in *v1.DeploymentStatus, out *v1beta1.DeploymentStatus, s conversion.Scope) error {
	out.ObservedGeneration = in.ObservedGeneration
	out.Replicas = in.Replicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	out.Conditions = *(*[]v1beta1.DeploymentCondition)(unsafe.Pointer(&in.Conditions))
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	return nil
}

// Convert_v1_DeploymentStatus_To_v1beta1_DeploymentStatus is an autogenerated conversion function.
func Convert_v1_DeploymentStatus_To_v1beta1_DeploymentStatus(in *v1.DeploymentStatus, out *v1beta1.DeploymentStatus, s conversion.Scope) error {
	return autoConvert_v1_DeploymentStatus_To_v1beta1_DeploymentStatus(in, out, s)
}

func autoConvert_v1beta1_DeploymentStatus_To_v1_DeploymentStatus(in *v1beta1.DeploymentStatus, out *v1.DeploymentStatus, s conversion.Scope) error {
	out.ObservedGeneration = in.ObservedGeneration
	out.Replicas = in.Replicas
	out.UpdatedReplicas = in.UpdatedReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.UnavailableReplicas = in.UnavailableReplicas
	out.Conditions = *(*[]v1.DeploymentCondition)(unsafe.Pointer(&in.Conditions))
	out.CollisionCount = (*int32)(unsafe.Pointer(in.CollisionCount))
	return nil
}

// Convert_v1beta1_DeploymentStatus_To_v1_DeploymentStatus is an autogenerated conversion function.
func Convert_v1beta1_DeploymentStatus_To_v1_DeploymentStatus(in *v1beta1.DeploymentStatus, out *v1.DeploymentStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_DeploymentStatus_To_v1_DeploymentStatus(in, out, s)
}

func autoConvert_v1_DeploymentStrategy_To_v1beta1_DeploymentStrategy(in *v1.DeploymentStrategy, out *v1beta1.DeploymentStrategy, s conversion.Scope) error {
	out.Type = v1beta1.DeploymentStrategyType(in.Type)
	out.RollingUpdate = (*v1beta1.RollingUpdateDeployment)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1_DeploymentStrategy_To_v1beta1_DeploymentStrategy is an autogenerated conversion function.
func Convert_v1_DeploymentStrategy_To_v1beta1_DeploymentStrategy(in *v1.DeploymentStrategy, out *v1beta1.DeploymentStrategy, s conversion.Scope) error {
	return autoConvert_v1_DeploymentStrategy_To_v1beta1_DeploymentStrategy(in, out, s)
}

func autoConvert_v1beta1_DeploymentStrategy_To_v1_DeploymentStrategy(in *v1beta1.DeploymentStrategy, out *v1.DeploymentStrategy, s conversion.Scope) error {
	out.Type = v1.DeploymentStrategyType(in.Type)
	out.RollingUpdate = (*v1.RollingUpdateDeployment)(unsafe.Pointer(in.RollingUpdate))
	return nil
}

// Convert_v1beta1_DeploymentStrategy_To_v1_DeploymentStrategy is an autogenerated conversion function.
func Convert_v1beta1_DeploymentStrategy_To_v1_DeploymentStrategy(in *v1beta1.DeploymentStrategy, out *v1.DeploymentStrategy, s conversion.Scope) error {
	return autoConvert_v1beta1_DeploymentStrategy_To_v1_DeploymentStrategy(in, out, s)
}

func autoConvert_v1_ReplicaSet_To_v1beta1_ReplicaSet(in *v1.ReplicaSet, out *v1beta1.ReplicaSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_ReplicaSetSpec_To_v1beta1_ReplicaSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1_ReplicaSetStatus_To_v1beta1_ReplicaSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_ReplicaSet_To_v1beta1_ReplicaSet is an autogenerated conversion function.
func Convert_v1_ReplicaSet_To_v1beta1_ReplicaSet(in *v1.ReplicaSet, out *v1beta1.ReplicaSet, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSet_To_v1beta1_ReplicaSet(in, out, s)
}

func autoConvert_v1beta1_ReplicaSet_To_v1_ReplicaSet(in *v1beta1.ReplicaSet, out *v1.ReplicaSet, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1beta1_ReplicaSetSpec_To_v1_ReplicaSetSpec(&in.Spec, &out.Spec, s); err != nil {
		return err
	}
	if err := Convert_v1beta1_ReplicaSetStatus_To_v1_ReplicaSetStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1beta1_ReplicaSet_To_v1_ReplicaSet is an autogenerated conversion function.
func Convert_v1beta1_ReplicaSet_To_v1_ReplicaSet(in *v1beta1.ReplicaSet, out *v1.ReplicaSet, s conversion.Scope) error {
	return autoConvert_v1beta1_ReplicaSet_To_v1_ReplicaSet(in, out, s)
}

func autoConvert_v1_ReplicaSetCondition_To_v1beta1_ReplicaSetCondition(in *v1.ReplicaSetCondition, out *v1beta1.ReplicaSetCondition, s conversion.Scope) error {
	out.Type = v1beta1.ReplicaSetConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1_ReplicaSetCondition_To_v1beta1_ReplicaSetCondition is an autogenerated conversion function.
func Convert_v1_ReplicaSetCondition_To_v1beta1_ReplicaSetCondition(in *v1.ReplicaSetCondition, out *v1beta1.ReplicaSetCondition, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSetCondition_To_v1beta1_ReplicaSetCondition(in, out, s)
}

func autoConvert_v1beta1_ReplicaSetCondition_To_v1_ReplicaSetCondition(in *v1beta1.ReplicaSetCondition, out *v1.ReplicaSetCondition, s conversion.Scope) error {
	out.Type = v1.ReplicaSetConditionType(in.Type)
	out.Status = corev1.ConditionStatus(in.Status)
	out.LastTransitionTime = in.LastTransitionTime
	out.Reason = in.Reason
	out.Message = in.Message
	return nil
}

// Convert_v1beta1_ReplicaSetCondition_To_v1_ReplicaSetCondition is an autogenerated conversion function.
func Convert_v1beta1_ReplicaSetCondition_To_v1_ReplicaSetCondition(in *v1beta1.ReplicaSetCondition, out *v1.ReplicaSetCondition, s conversion.Scope) error {
	return autoConvert_v1beta1_ReplicaSetCondition_To_v1_ReplicaSetCondition(in, out, s)
}

func autoConvert_v1_ReplicaSetList_To_v1beta1_ReplicaSetList(in *v1.ReplicaSetList, out *v1beta1.ReplicaSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1beta1.ReplicaSet)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_ReplicaSetList_To_v1beta1_ReplicaSetList is an autogenerated conversion function.
func Convert_v1_ReplicaSetList_To_v1beta1_ReplicaSetList(in *v1.ReplicaSetList, out *v1beta1.ReplicaSetList, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSetList_To_v1beta1_ReplicaSetList(in, out, s)
}

func autoConvert_v1beta1_ReplicaSetList_To_v1_ReplicaSetList(in *v1beta1.ReplicaSetList, out *v1.ReplicaSetList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]v1.ReplicaSet)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1beta1_ReplicaSetList_To_v1_ReplicaSetList is an autogenerated conversion function.
func Convert_v1beta1_ReplicaSetList_To_v1_ReplicaSetList(in *v1beta1.ReplicaSetList, out *v1.ReplicaSetList, s conversion.Scope) error {
	return autoConvert_v1beta1_ReplicaSetList_To_v1_ReplicaSetList(in, out, s)
}

func autoConvert_v1_ReplicaSetSpec_To_v1beta1_ReplicaSetSpec(in *v1.ReplicaSetSpec, out *v1beta1.ReplicaSetSpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.MinReadySeconds = in.MinReadySeconds
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	return nil
}

// Convert_v1_ReplicaSetSpec_To_v1beta1_ReplicaSetSpec is an autogenerated conversion function.
func Convert_v1_ReplicaSetSpec_To_v1beta1_ReplicaSetSpec(in *v1.ReplicaSetSpec, out *v1beta1.ReplicaSetSpec, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSetSpec_To_v1beta1_ReplicaSetSpec(in, out, s)
}

func autoConvert_v1beta1_ReplicaSetSpec_To_v1_ReplicaSetSpec(in *v1beta1.ReplicaSetSpec, out *v1.ReplicaSetSpec, s conversion.Scope) error {
	out.Replicas = (*int32)(unsafe.Pointer(in.Replicas))
	out.MinReadySeconds = in.MinReadySeconds
	out.Selector = (*metav1.LabelSelector)(unsafe.Pointer(in.Selector))
	out.Template = in.Template
	return nil
}

// Convert_v1beta1_ReplicaSetSpec_To_v1_ReplicaSetSpec is an autogenerated conversion function.
func Convert_v1beta1_ReplicaSetSpec_To_v1_ReplicaSetSpec(in *v1beta1.ReplicaSetSpec, out *v1.ReplicaSetSpec, s conversion.Scope) error {
	return autoConvert_v1beta1_ReplicaSetSpec_To_v1_ReplicaSetSpec(in, out, s)
}

func autoConvert_v1_ReplicaSetStatus_To_v1beta1_ReplicaSetStatus(in *v1.ReplicaSetStatus, out *v1beta1.ReplicaSetStatus, s conversion.Scope) error {
	out.Replicas = in.Replicas
	out.FullyLabeledReplicas = in.FullyLabeledReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.ObservedGeneration = in.ObservedGeneration
	out.Conditions = *(*[]v1beta1.ReplicaSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1_ReplicaSetStatus_To_v1beta1_ReplicaSetStatus is an autogenerated conversion function.
func Convert_v1_ReplicaSetStatus_To_v1beta1_ReplicaSetStatus(in *v1.ReplicaSetStatus, out *v1beta1.ReplicaSetStatus, s conversion.Scope) error {
	return autoConvert_v1_ReplicaSetStatus_To_v1beta1_ReplicaSetStatus(in, out, s)
}

func autoConvert_v1beta1_ReplicaSetStatus_To_v1_ReplicaSetStatus(in *v1beta1.ReplicaSetStatus, out *v1.ReplicaSetStatus, s conversion.Scope) error {
	out.Replicas = in.Replicas
	out.FullyLabeledReplicas = in.FullyLabeledReplicas
	out.ReadyReplicas = in.ReadyReplicas
	out.AvailableReplicas = in.AvailableReplicas
	out.ObservedGeneration = in.ObservedGeneration
	out.Conditions = *(*[]v1.ReplicaSetCondition)(unsafe.Pointer(&in.Conditions))
	return nil
}

// Convert_v1beta1_ReplicaSetStatus_To_v1_ReplicaSetStatus is an autogenerated conversion function.
func Convert_v1beta1_ReplicaSetStatus_To_v1_ReplicaSetStatus(in *v1beta1.ReplicaSetStatus, out *v1.ReplicaSetStatus, s conversion.Scope) error {
	return autoConvert_v1beta1_ReplicaSetStatus_To_v1_ReplicaSetStatus(in, out, s)
}

func autoConvert_v1_RollingUpdateDaemonSet_To_v1beta1_RollingUpdateDaemonSet(in *v1.RollingUpdateDaemonSet, out *v1beta1.RollingUpdateDaemonSet, s conversion.Scope) error {
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	return nil
}

// Convert_v1_RollingUpdateDaemonSet_To_v1beta1_RollingUpdateDaemonSet is an autogenerated conversion function.
func Convert_v1_RollingUpdateDaemonSet_To_v1beta1_RollingUpdateDaemonSet(in *v1.RollingUpdateDaemonSet, out *v1beta1.RollingUpdateDaemonSet, s conversion.Scope) error {
	return autoConvert_v1_RollingUpdateDaemonSet_To_v1beta1_RollingUpdateDaemonSet(in, out, s)
}

func autoConvert_v1beta1_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet(in *v1beta1.RollingUpdateDaemonSet, out *v1.RollingUpdateDaemonSet, s conversion.Scope) error {
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	return nil
}

// Convert_v1beta1_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet is an autogenerated conversion function.
func Convert_v1beta1_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet(in *v1beta1.RollingUpdateDaemonSet, out *v1.RollingUpdateDaemonSet, s conversion.Scope) error {
	return autoConvert_v1beta1_RollingUpdateDaemonSet_To_v1_RollingUpdateDaemonSet(in, out, s)
}

func autoConvert_v1_RollingUpdateDeployment_To_v1beta1_RollingUpdateDeployment(in *v1.RollingUpdateDeployment, out *v1beta1.RollingUpdateDeployment, s conversion.Scope) error {
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	out.MaxSurge = (*intstr.IntOrString)(unsafe.Pointer(in.MaxSurge))
	return nil
}

// Convert_v1_RollingUpdateDeployment_To_v1beta1_RollingUpdateDeployment is an autogenerated conversion function.
func Convert_v1_RollingUpdateDeployment_To_v1beta1_RollingUpdateDeployment(in *v1.RollingUpdateDeployment, out *v1beta1.RollingUpdateDeployment, s conversion.Scope) error {
	return autoConvert_v1_RollingUpdateDeployment_To_v1beta1_RollingUpdateDeployment(in, out, s)
}

func autoConvert_v1beta1_RollingUpdateDeployment_To_v1_RollingUpdateDeployment(in *v1beta1.RollingUpdateDeployment, out *v1.RollingUpdateDeployment, s conversion.Scope) error {
	out.MaxUnavailable = (*intstr.IntOrString)(unsafe.Pointer(in.MaxUnavailable))
	out.MaxSurge = (*intstr.IntOrString)(unsafe.Pointer(in.MaxSurge))
	return nil
}

// Convert_v1beta1_RollingUpdateDeployment_To_v1_RollingUpdateDeployment is an autogenerated conversion function.
func Convert_v1beta1_RollingUpdateDeployment_To_v1_RollingUpdateDeployment(in *v1beta1.RollingUpdateDeployment, out *v1.RollingUpdateDeployment, s conversion.Scope) error {
	return autoConvert_v1beta1_RollingUpdateDeployment_To_v1_RollingUpdateDeployment(in, out, s)
}
