/*********************************************************************
 * Copyright (c) 2018-2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { AxiosInstance, AxiosPromise } from 'axios';
import { che } from '@eclipse-che/api';
export interface FactoryResolver {
    v: string;
    source: string;
    devfile: che.workspace.devfile.Devfile;
    scm_info: {
        clone_url: string;
        scm_provider: string;
        branch?: string;
    };
    links: che.core.rest.Link[];
}
export interface KubernetesNamespace {
    name: string;
    attributes: {
        default?: 'true' | 'false';
        displayName?: string;
        phase: string;
    };
}
export interface WorkspaceSettings {
    supportedRecipeTypes: string;
    [key: string]: string;
}
export interface IResourceCreateParams {
    attributes?: IResourceQueryParams;
    namespace?: string;
    infrastructureNamespace?: string;
}
export interface IResourceQueryParams {
    [propName: string]: string | boolean | undefined;
}
export interface Preferences {
    [key: string]: string;
}
export interface User {
    id: string;
    name: string;
    email: string;
}
export interface IResources {
    getAll<T>(): AxiosPromise<T[]>;
    getAllByNamespace<T>(namespace: string): AxiosPromise<T[]>;
    getById<T>(workspaceKey: string): AxiosPromise<T>;
    create<T>(devfile: che.workspace.devfile.Devfile, createParams: IResourceCreateParams | undefined): AxiosPromise<T>;
    update<T>(workspaceId: string, workspace: che.workspace.Workspace): AxiosPromise<T>;
    delete(workspaceId: string): AxiosPromise<void>;
    start<T>(workspaceId: string, params: IResourceQueryParams | undefined): AxiosPromise<T>;
    stop(workspaceId: string): AxiosPromise<void>;
    getSettings<T>(): AxiosPromise<T>;
    getFactoryResolver<T>(url: string, overrideParams?: {
        [params: string]: string;
    }): AxiosPromise<T>;
    generateSshKey<T>(service: string, name: string): AxiosPromise<T>;
    createSshKey(sshKeyPair: che.ssh.SshPair): AxiosPromise<void>;
    getSshKey<T>(service: string, name: string): AxiosPromise<T>;
    getAllSshKey<T>(service: string): AxiosPromise<T[]>;
    getOAuthProviders(): AxiosPromise<any[]>;
    deleteSshKey(service: string, name: string): AxiosPromise<void>;
    getCurrentUser(): AxiosPromise<User>;
    getCurrentUserProfile(): AxiosPromise<che.user.Profile>;
    getUserPreferences(filter: string | undefined): AxiosPromise<Preferences>;
    updateUserPreferences(update: Preferences): AxiosPromise<Preferences>;
    replaceUserPreferences(preferences: Preferences): AxiosPromise<Preferences>;
    deleteUserPreferences(list: string[] | undefined): AxiosPromise<void>;
    getOAuthToken(oAuthProvider: string): AxiosPromise<{
        token: string;
    }>;
    updateActivity(workspaceId: string): AxiosPromise<void>;
    getKubernetesNamespace<T>(): AxiosPromise<T>;
    provisionKubernetesNamespace(): AxiosPromise<KubernetesNamespace>;
    getDevfileSchema<T>(version?: string): AxiosPromise<T>;
    getApiInfo<T>(): AxiosPromise<T>;
}
export declare class Resources implements IResources {
    private readonly axios;
    private readonly baseUrl;
    private readonly workspaceUrl;
    private readonly factoryUrl;
    private readonly devfileUrl;
    constructor(axios: AxiosInstance, baseUrl: string);
    getAll<T>(): AxiosPromise<T[]>;
    getAllByNamespace<T>(namespace: string): AxiosPromise<T[]>;
    getById<T>(workspaceKey: string): AxiosPromise<T>;
    create<T>(devfile: che.workspace.devfile.Devfile, createParams?: IResourceCreateParams): AxiosPromise<T>;
    update<T>(workspaceId: string, workspace: che.workspace.Workspace): AxiosPromise<T>;
    delete(workspaceId: string): AxiosPromise<void>;
    start<T>(workspaceId: string, params: IResourceQueryParams | undefined): AxiosPromise<T>;
    stop(workspaceId: string): AxiosPromise<void>;
    getSettings<T>(): AxiosPromise<T>;
    getFactoryResolver<T>(url: string, overrideParams?: {
        [params: string]: string;
    }): AxiosPromise<T>;
    generateSshKey<T>(service: string, name: string): AxiosPromise<T>;
    createSshKey(sshKeyPair: any): AxiosPromise<void>;
    getSshKey<T>(service: string, name: string): AxiosPromise<T>;
    getAllSshKey<T>(service: string): AxiosPromise<T[]>;
    getCurrentUser(): AxiosPromise<User>;
    getCurrentUserProfile(): AxiosPromise<che.user.Profile>;
    deleteSshKey(service: string, name: string): AxiosPromise<void>;
    getUserPreferences(filter?: string | undefined): AxiosPromise<Preferences>;
    updateUserPreferences(update: Preferences): AxiosPromise<Preferences>;
    replaceUserPreferences(preferences: Preferences): AxiosPromise<Preferences>;
    deleteUserPreferences(list?: string[] | undefined): AxiosPromise<void>;
    getOAuthToken(oAuthProvider: string): AxiosPromise<{
        token: string;
    }>;
    getOAuthProviders(): AxiosPromise<any[]>;
    updateActivity(workspaceId: string): AxiosPromise<void>;
    getDevfileSchema<T>(version?: string): AxiosPromise<T>;
    getKubernetesNamespace<T>(): AxiosPromise<T>;
    provisionKubernetesNamespace(): AxiosPromise<KubernetesNamespace>;
    getApiInfo<T>(): AxiosPromise<T>;
}
