import { interfaces } from "../interfaces/interfaces";
declare class Container implements interfaces.Container {
    id: number;
    parent: interfaces.Container | null;
    readonly options: interfaces.ContainerOptions;
    private _middleware;
    private _bindingDictionary;
    private _activations;
    private _deactivations;
    private _snapshots;
    private _metadataReader;
    private _moduleActivationStore;
    static merge(container1: interfaces.Container, container2: interfaces.Container, ...containers: interfaces.Container[]): interfaces.Container;
    constructor(containerOptions?: interfaces.ContainerOptions);
    load(...modules: interfaces.ContainerModule[]): void;
    loadAsync(...modules: interfaces.AsyncContainerModule[]): Promise<void>;
    unload(...modules: interfaces.ContainerModuleBase[]): void;
    unloadAsync(...modules: interfaces.ContainerModuleBase[]): Promise<void>;
    bind<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>): interfaces.BindingToSyntax<T>;
    rebind<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>): interfaces.BindingToSyntax<T>;
    rebindAsync<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>): Promise<interfaces.BindingToSyntax<T>>;
    unbind(serviceIdentifier: interfaces.ServiceIdentifier): void;
    unbindAsync(serviceIdentifier: interfaces.ServiceIdentifier): Promise<void>;
    unbindAll(): void;
    unbindAllAsync(): Promise<void>;
    onActivation<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>, onActivation: interfaces.BindingActivation<T>): void;
    onDeactivation<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>, onDeactivation: interfaces.BindingDeactivation<T>): void;
    isBound(serviceIdentifier: interfaces.ServiceIdentifier<any>): boolean;
    isCurrentBound<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>): boolean;
    isBoundNamed(serviceIdentifier: interfaces.ServiceIdentifier, named: string | number | symbol): boolean;
    isBoundTagged(serviceIdentifier: interfaces.ServiceIdentifier, key: string | number | symbol, value: unknown): boolean;
    snapshot(): void;
    restore(): void;
    createChild(containerOptions?: interfaces.ContainerOptions): Container;
    applyMiddleware(...middlewares: interfaces.Middleware[]): void;
    applyCustomMetadataReader(metadataReader: interfaces.MetadataReader): void;
    get<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>): T;
    getAsync<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>): Promise<T>;
    getTagged<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>, key: string | number | symbol, value: unknown): T;
    getTaggedAsync<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>, key: string | number | symbol, value: unknown): Promise<T>;
    getNamed<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>, named: string | number | symbol): T;
    getNamedAsync<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>, named: string | number | symbol): Promise<T>;
    getAll<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>): T[];
    getAllAsync<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>): Promise<T[]>;
    getAllTagged<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>, key: string | number | symbol, value: unknown): T[];
    getAllTaggedAsync<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>, key: string | number | symbol, value: unknown): Promise<T[]>;
    getAllNamed<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>, named: string | number | symbol): T[];
    getAllNamedAsync<T>(serviceIdentifier: interfaces.ServiceIdentifier<T>, named: string | number | symbol): Promise<T[]>;
    resolve<T>(constructorFunction: interfaces.Newable<T>): T;
    private _preDestroy;
    private _removeModuleHandlers;
    private _removeModuleBindings;
    private _deactivate;
    private _handleDeactivationError;
    private _deactivateContainer;
    private _deactivateContainerAsync;
    private _getContainerModuleHelpersFactory;
    private _getAll;
    private _get;
    private _getButThrowIfAsync;
    private _getAllArgs;
    private _getNotAllArgs;
    private _planAndResolve;
    private _deactivateIfSingleton;
    private _deactivateSingletons;
    private _deactivateSingletonsAsync;
    private _propagateContainerDeactivationThenBindingAndPreDestroy;
    private _propagateContainerDeactivationThenBindingAndPreDestroyAsync;
    private _removeServiceFromDictionary;
    private _bindingDeactivationAndPreDestroy;
    private _bindingDeactivationAndPreDestroyAsync;
}
export { Container };
