/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
import { VSCodeExtensionEntry } from '../api/vscode-extension-entry';
/**
 * Resolve plug-ins by grabbing the definition from the plug-in registry.
 */
export declare class PluginRegistryResolver {
    private pluginRegistryUrl;
    private urlFetcher;
    resolve(vSCodeExtensionEntries: VSCodeExtensionEntry[]): Promise<void>;
    resolveDependencies(vSCodeExtensionEntries: VSCodeExtensionEntry[]): Promise<void>;
    loadDevfilePlugin(devfileId: string): Promise<any>;
    resolveEntry(vSCodeExtensionEntry: VSCodeExtensionEntry): Promise<void>;
}
//# sourceMappingURL=plugin-registry-resolver.d.ts.map