"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VscodeExtensionJsonAnalyzer = void 0;
const jsoncparser = require("jsonc-parser");
const inversify_1 = require("inversify");
/**
 * This class manages extraction of VS Code extensions id from the .vscode/extensions.json file content
 * All extensions are optional, meaning that if the plug-in registry does not contain them, it won't fail
 */
let VscodeExtensionJsonAnalyzer = class VscodeExtensionJsonAnalyzer {
    async extractPlugins(vscodeExtensionsJsonContent) {
        // use of JSONC parser as we have comments in the VS code json file
        const strippedContent = jsoncparser.stripComments(vscodeExtensionsJsonContent);
        const vscodeExtensionsJson = jsoncparser.parse(strippedContent);
        // no recommendations or invalid entry
        if (!(vscodeExtensionsJson === null || vscodeExtensionsJson === void 0 ? void 0 : vscodeExtensionsJson.recommendations)) {
            return [];
        }
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        return vscodeExtensionsJson.recommendations.map((recommendation) => ({
            id: `${recommendation.replace(/\./g, '/')}/latest`.toLocaleLowerCase(),
            resolved: false,
            optional: true,
            extensions: [],
        }));
    }
};
VscodeExtensionJsonAnalyzer = __decorate([
    inversify_1.injectable()
], VscodeExtensionJsonAnalyzer);
exports.VscodeExtensionJsonAnalyzer = VscodeExtensionJsonAnalyzer;
//# sourceMappingURL=vscode-extension-json-analyzer.js.map