"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheTheiaPluginsDevfileResolver = void 0;
const devfile_context_1 = require("../api/devfile-context");
const inversify_1 = require("inversify");
const che_theia_plugin_devcontainer_merger_1 = require("./che-theia-plugin-devcontainer-merger");
const che_theia_plugin_sidecar_merger_1 = require("./che-theia-plugin-sidecar-merger");
const che_theia_plugins_analyzer_1 = require("./che-theia-plugins-analyzer");
const devworkspace_updater_1 = require("./devworkspace-updater");
const plugin_registry_resolver_1 = require("../plugin-registry/plugin-registry-resolver");
const vscode_extension_json_analyzer_1 = require("./vscode-extension-json-analyzer");
/**
 * This class handle the che-theia-plugins attribute from within a devfile.
 * It will provide a set of set of DevWorkspace Templates and a map of attributes to add on some components.
 * New templates will be the optional 'sidecar' components, vsix downloader and extra map will contain for example the vscode extensions to add on che-theia IDE
 */
let CheTheiaPluginsDevfileResolver = class CheTheiaPluginsDevfileResolver {
    async handle(devfileContext) {
        var _a, _b, _c;
        let cheTheiaPluginsYamlContent = devfileContext.cheTheiaPluginsContent;
        let vscodeExtensionJsonContent = devfileContext.vscodeExtensionsJsonContent;
        if (!vscodeExtensionJsonContent) {
            vscodeExtensionJsonContent = (_a = devfileContext.devfile.attributes) === null || _a === void 0 ? void 0 : _a['.vscode/extensions.json'];
        }
        if (!cheTheiaPluginsYamlContent) {
            cheTheiaPluginsYamlContent = (_b = devfileContext.devfile.attributes) === null || _b === void 0 ? void 0 : _b['.che/che-theia-plugins.yaml'];
        }
        // no content, skip
        if (!cheTheiaPluginsYamlContent && !vscodeExtensionJsonContent) {
            return;
        }
        // we do have '.vscode/extensions.json' file, grab plug-ins from there.
        let vscodeExtensions = [];
        if (vscodeExtensionJsonContent) {
            vscodeExtensions = await this.vscodeExtensionJsonAnalyzer.extractPlugins(vscodeExtensionJsonContent);
        }
        let cheTheiaPlugins = [];
        if (cheTheiaPluginsYamlContent) {
            cheTheiaPlugins = await this.cheTheiaPluginsAnalyzer.extractPlugins(cheTheiaPluginsYamlContent);
        }
        // now, need to merge
        // if defined in both vscode/extensions.json and che-theia-plugins.yaml file, che-theia-plugins.yaml is winning
        // if not defined, add definition from where it is defined
        // filter out extensions already defined in che-theia-plugins.yaml files
        const allExtensions = cheTheiaPlugins.concat(vscodeExtensions.filter(extension => !cheTheiaPlugins.find(cheTheiaPlugin => cheTheiaPlugin.id === extension.id)));
        // unique extensions
        const uniqueExtensions = [...new Set(allExtensions)];
        // resolve the given set of extensions (if needed) by grabbing definition using plug-in registry
        await this.pluginRegistryResolver.resolve(uniqueExtensions);
        // now we do have definition of all extensions that we want to add into Theia and their optional sidecars for these plug-ins.
        // grab a list of VS Code extensions to install on main che-theia instance (no sidecar)
        const cheTheiaExtensions = uniqueExtensions
            // get only extensions without sidecars
            .filter(entry => !entry.sidecar);
        // grab a list of extensions with sidecars
        const allExtensionsWithSidecars = uniqueExtensions
            .filter(entry => entry.sidecar)
            .map(entry => entry);
        // do we need to change the sidecar and use a dev container instead ?
        // if need to use user container, we'll need to update an existing component with the following data
        let extensionsWithSidecars = [];
        // for dev container merge, we unify all extensions into a single sidecar and then we'll apply all settings except the image
        let extensionsForDevContainer;
        if (!devfileContext.sidecarPolicy) {
            const sidecarAttribute = (_c = devfileContext.devfile.attributes) === null || _c === void 0 ? void 0 : _c['che-theia.eclipse.org/sidecar-policy'];
            if (sidecarAttribute === devfile_context_1.SidecarPolicy.USE_DEV_CONTAINER) {
                devfileContext.sidecarPolicy = devfile_context_1.SidecarPolicy.USE_DEV_CONTAINER;
            }
            else if (sidecarAttribute === devfile_context_1.SidecarPolicy.MERGE_IMAGE) {
                devfileContext.sidecarPolicy = devfile_context_1.SidecarPolicy.MERGE_IMAGE;
            }
            else {
                // default is to use dev container
                devfileContext.sidecarPolicy = devfile_context_1.SidecarPolicy.USE_DEV_CONTAINER;
            }
        }
        switch (devfileContext.sidecarPolicy) {
            case 'mergeImage':
                extensionsWithSidecars = this.cheTheiaPluginSidecarMerger.merge(allExtensionsWithSidecars);
                break;
            case 'useDevContainer':
                extensionsForDevContainer = this.cheTheiaPluginDevContainerMerger.merge(allExtensionsWithSidecars);
                break;
        }
        // ok now we're ready to add the vsix on che-theia component, add component sidecars(if any) and vsix installer component, etc.
        await this.devWorkspaceUpdater.update(devfileContext, cheTheiaExtensions, extensionsWithSidecars, extensionsForDevContainer);
    }
};
__decorate([
    inversify_1.inject(vscode_extension_json_analyzer_1.VscodeExtensionJsonAnalyzer),
    __metadata("design:type", vscode_extension_json_analyzer_1.VscodeExtensionJsonAnalyzer)
], CheTheiaPluginsDevfileResolver.prototype, "vscodeExtensionJsonAnalyzer", void 0);
__decorate([
    inversify_1.inject(che_theia_plugins_analyzer_1.CheTheiaPluginsAnalyzer),
    __metadata("design:type", che_theia_plugins_analyzer_1.CheTheiaPluginsAnalyzer)
], CheTheiaPluginsDevfileResolver.prototype, "cheTheiaPluginsAnalyzer", void 0);
__decorate([
    inversify_1.inject(plugin_registry_resolver_1.PluginRegistryResolver),
    __metadata("design:type", plugin_registry_resolver_1.PluginRegistryResolver)
], CheTheiaPluginsDevfileResolver.prototype, "pluginRegistryResolver", void 0);
__decorate([
    inversify_1.inject(devworkspace_updater_1.DevWorkspaceUpdater),
    __metadata("design:type", devworkspace_updater_1.DevWorkspaceUpdater)
], CheTheiaPluginsDevfileResolver.prototype, "devWorkspaceUpdater", void 0);
__decorate([
    inversify_1.inject(che_theia_plugin_sidecar_merger_1.CheTheiaPluginSidecarMerger),
    __metadata("design:type", che_theia_plugin_sidecar_merger_1.CheTheiaPluginSidecarMerger)
], CheTheiaPluginsDevfileResolver.prototype, "cheTheiaPluginSidecarMerger", void 0);
__decorate([
    inversify_1.inject(che_theia_plugin_devcontainer_merger_1.CheTheiaPluginDevContainerMerger),
    __metadata("design:type", che_theia_plugin_devcontainer_merger_1.CheTheiaPluginDevContainerMerger)
], CheTheiaPluginsDevfileResolver.prototype, "cheTheiaPluginDevContainerMerger", void 0);
CheTheiaPluginsDevfileResolver = __decorate([
    inversify_1.injectable()
], CheTheiaPluginsDevfileResolver);
exports.CheTheiaPluginsDevfileResolver = CheTheiaPluginsDevfileResolver;
//# sourceMappingURL=che-theia-plugins-devfile-resolver.js.map