/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
import { DevfileContext } from '../api/devfile-context';
import { DevfileResolver } from '../api/devfile-che-theia-plugins-resolver';
/**
 * This class handle the che-theia-plugins attribute from within a devfile.
 * It will provide a set of set of DevWorkspace Templates and a map of attributes to add on some components.
 * New templates will be the optional 'sidecar' components, vsix downloader and extra map will contain for example the vscode extensions to add on che-theia IDE
 */
export declare class CheTheiaPluginsDevfileResolver implements DevfileResolver {
    private vscodeExtensionJsonAnalyzer;
    private cheTheiaPluginsAnalyzer;
    private pluginRegistryResolver;
    private devWorkspaceUpdater;
    private cheTheiaPluginSidecarMerger;
    private cheTheiaPluginDevContainerMerger;
    handle(devfileContext: DevfileContext): Promise<void>;
}
//# sourceMappingURL=che-theia-plugins-devfile-resolver.d.ts.map