/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
import { V1alpha2DevWorkspaceSpecTemplateComponentsItemsContainer } from '@devfile/api';
/**
 * Defines the entry of VS code extension with its extra information like if there is a need for a sidecar image, memory information, etc.
 */
export interface VSCodeExtensionEntry {
    id: string;
    resolved: boolean;
    optional?: boolean;
    preferences?: {
        [key: string]: any;
    };
    dependencies?: string[];
    sidecarName?: string;
    sidecar?: V1alpha2DevWorkspaceSpecTemplateComponentsItemsContainer;
    extensions: string[];
}
export interface VSCodeExtensionEntryWithSidecar extends VSCodeExtensionEntry {
    sidecar: V1alpha2DevWorkspaceSpecTemplateComponentsItemsContainer;
}
//# sourceMappingURL=vscode-extension-entry.d.ts.map