"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
exports.__esModule = true;
exports.K8SUnits = void 0;
var inversify_1 = require("inversify");
/**
 * Handle kubernetes units
 */
var K8SUnits = /** @class */ (function () {
    function K8SUnits() {
    }
    K8SUnits_1 = K8SUnits;
    K8SUnits.prototype.unitToNumber = function (unit) {
        // base two
        if (unit.endsWith('Ki') || unit.endsWith('ki')) {
            return parseFloat(unit.substring(0, unit.length - 2)) * K8SUnits_1.Ki;
        }
        else if (unit.endsWith('Mi') || unit.endsWith('mi')) {
            return parseFloat(unit.substring(0, unit.length - 2)) * K8SUnits_1.Mi;
        }
        else if (unit.endsWith('Gi') || unit.endsWith('gi')) {
            return parseFloat(unit.substring(0, unit.length - 2)) * K8SUnits_1.Gi;
        }
        else if (unit.endsWith('Ti') || unit.endsWith('ti')) {
            return parseFloat(unit.substring(0, unit.length - 2)) * K8SUnits_1.Ti;
        }
        else if (unit.endsWith('Pi') || unit.endsWith('pi')) {
            return parseFloat(unit.substring(0, unit.length - 2)) * K8SUnits_1.Pi;
        }
        else if (unit.endsWith('Ei') || unit.endsWith('ei')) {
            return parseFloat(unit.substring(0, unit.length - 2)) * K8SUnits_1.Ei;
        }
        else if (unit.endsWith('K') || unit.endsWith('k')) {
            return parseFloat(unit.substring(0, unit.length - 1)) * K8SUnits_1.K;
        }
        else if (unit.endsWith('M') || unit.endsWith('m')) {
            return parseFloat(unit.substring(0, unit.length - 1)) * K8SUnits_1.M;
        }
        else if (unit.endsWith('G') || unit.endsWith('g')) {
            return parseFloat(unit.substring(0, unit.length - 1)) * K8SUnits_1.G;
        }
        else if (unit.endsWith('T') || unit.endsWith('t')) {
            return parseFloat(unit.substring(0, unit.length - 1)) * K8SUnits_1.T;
        }
        else if (unit.endsWith('P') || unit.endsWith('p')) {
            return parseFloat(unit.substring(0, unit.length - 1)) * K8SUnits_1.P;
        }
        else if (unit.endsWith('E') || unit.endsWith('e')) {
            return parseFloat(unit.substring(0, unit.length - 1)) * K8SUnits_1.E;
        }
    };
    K8SUnits.prototype.sumUnits = function (unit1, unit2) {
        // convert unit to simple unit
        var sum = this.unitToNumber(unit1) + this.unitToNumber(unit2);
        return this.format(sum);
    };
    K8SUnits.prototype.format = function (value, decimals) {
        if (decimals === void 0) { decimals = 2; }
        if (value === 0) {
            return '0';
        }
        var k;
        var sizes;
        if (this.isBinaryUnit(value)) {
            sizes = ['', 'Ki', 'Mi', 'Gi', 'Ti', 'Pi', 'Ei'];
            k = 1024;
        }
        else {
            sizes = ['', 'K', 'M', 'G', 'T', 'P', 'E'];
            k = 1000;
        }
        var dm = decimals < 0 ? 0 : decimals;
        var i = Math.floor(Math.log(value) / Math.log(k));
        return "" + parseFloat((value / Math.pow(k, i)).toFixed(dm)) + sizes[i];
    };
    K8SUnits.prototype.isBinaryUnit = function (value) {
        var i = Math.floor(Math.log(value) / Math.log(1024));
        var val = value / Math.pow(1024, i);
        return Number.isInteger(val);
    };
    var K8SUnits_1;
    //  You can express storage as a plain integer or as a fixed-point number using one of these suffixes: E, P, T, G, M, K.
    // You can also use the power-of-two equivalents: Ei, Pi, Ti, Gi, Mi, Ki.
    K8SUnits.Ki = 1024;
    K8SUnits.Mi = 1024 * K8SUnits_1.Ki;
    K8SUnits.Gi = 1024 * K8SUnits_1.Mi;
    K8SUnits.Ti = 1024 * K8SUnits_1.Gi;
    K8SUnits.Pi = 1024 * K8SUnits_1.Ti;
    K8SUnits.Ei = 1024 * K8SUnits_1.Pi;
    K8SUnits.K = 1000;
    K8SUnits.M = 1000 * K8SUnits_1.K;
    K8SUnits.G = 1000 * K8SUnits_1.M;
    K8SUnits.T = 1000 * K8SUnits_1.G;
    K8SUnits.P = 1000 * K8SUnits_1.T;
    K8SUnits.E = 1000 * K8SUnits_1.P;
    K8SUnits = K8SUnits_1 = __decorate([
        (0, inversify_1.injectable)()
    ], K8SUnits);
    return K8SUnits;
}());
exports.K8SUnits = K8SUnits;
//# sourceMappingURL=k8s-units.js.map