"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
exports.DevContainerComponentUpdater = void 0;
var inversify_1 = require("inversify");
var k8s_units_1 = require("../k8s/k8s-units");
/**
 * Apply to the DevWorkspace component the information specified in a given DevContainer struct like preferences/extensions/endpoints, etc.
 */
var DevContainerComponentUpdater = /** @class */ (function () {
    function DevContainerComponentUpdater() {
    }
    DevContainerComponentUpdater_1 = DevContainerComponentUpdater;
    DevContainerComponentUpdater.prototype.update = function (devfileContext, cheCodeDescriptionComponent, devContainerComponent, devContainerExisted) {
        var _a;
        return __awaiter(this, void 0, void 0, function () {
            var devContainer, cheCodeDescriptionComponentContainer, devContainerAttributes, existingEntrypoint, devContainerVolumes, toInsertVolumeMounts, existingComponents, volumesInsideTemplates, volumeComponentsToAdd, devContainerEndpoints, cheCodeContainerEndpoints;
            var _b, _c;
            return __generator(this, function (_d) {
                devContainer = devContainerComponent.container;
                if (!devContainer) {
                    throw new Error('The dev container should be a component with type "container".');
                }
                cheCodeDescriptionComponentContainer = cheCodeDescriptionComponent.container;
                if (!cheCodeDescriptionComponentContainer) {
                    throw new Error('The che-code component should be a component with type "container".');
                }
                devContainerAttributes = devContainerComponent.attributes;
                if (!devContainerAttributes) {
                    devContainerAttributes = {};
                    devContainerComponent.attributes = devContainerAttributes;
                }
                existingEntrypoint = devContainer.command;
                if (existingEntrypoint) {
                    devContainerAttributes[DevContainerComponentUpdater_1.CONTRIBUTE_ENTRYPOINT] = true;
                    devContainerAttributes[DevContainerComponentUpdater_1.CONTRIBUTE_ORIGINAL_ENTRYPOINT] = existingEntrypoint;
                }
                else {
                    devContainer.command = cheCodeDescriptionComponentContainer.command;
                    devContainerAttributes[DevContainerComponentUpdater_1.CONTRIBUTE_ENTRYPOINT] = true;
                }
                devContainerVolumes = devContainer.volumeMounts || [];
                devContainer.volumeMounts = devContainerVolumes;
                toInsertVolumeMounts = (cheCodeDescriptionComponentContainer.volumeMounts || []).filter(function (volume) { return !devContainerVolumes.some(function (containerVolume) { return containerVolume.name === volume.name; }); });
                (_b = devContainer.volumeMounts).push.apply(_b, toInsertVolumeMounts);
                // add information that this volume has been added
                toInsertVolumeMounts.forEach(function (volumeMount) {
                    devContainerAttributes["" + DevContainerComponentUpdater_1.CONTRIBUTE_VOLUME_MOUNT + volumeMount.name] =
                        volumeMount.path;
                });
                existingComponents = devfileContext.devWorkspace.spec.template.components;
                volumesInsideTemplates = (_a = devfileContext.devWorkspaceTemplates) === null || _a === void 0 ? void 0 : _a.map(function (template) { return template.spec.components; }).map(function (components) {
                    return components.map(function (component) {
                        if (component.volume) {
                            return component.name;
                        }
                        else {
                            return undefined;
                        }
                    });
                }).filter(function (defined) { return defined; }).flat();
                volumeComponentsToAdd = toInsertVolumeMounts
                    .filter(function (volumeMount) { return !existingComponents.find(function (component) { return component.volume && component.name == volumeMount.name; }); })
                    .filter(
                // also filter out all volumes that are defined in the editor template
                function (volumeMount) { return !(volumesInsideTemplates || []).includes(volumeMount.name); });
                volumeComponentsToAdd.forEach(function (volume) {
                    // volume
                    devContainerAttributes["" + DevContainerComponentUpdater_1.CONTRIBUTE_VOLUME_COMPONENT + volume.name] = true;
                    existingComponents.push({ name: volume.name, volume: {} });
                });
                devContainerEndpoints = devContainer.endpoints || [];
                devContainer.endpoints = devContainerEndpoints;
                cheCodeContainerEndpoints = cheCodeDescriptionComponentContainer.endpoints || [];
                // add all endpoints
                (_c = devContainer.endpoints).push.apply(_c, cheCodeContainerEndpoints);
                cheCodeContainerEndpoints.forEach(function (endpoint) {
                    var endpointAttributes = endpoint.attributes || {};
                    endpoint.attributes = endpointAttributes;
                    endpointAttributes['contributed-by'] = 'che-code.eclipse.org';
                    devContainerAttributes["" + DevContainerComponentUpdater_1.CONTRIBUTE_ENDPOINT + endpoint.name] =
                        endpoint.targetPort;
                });
                // Either perform a sum or just insert fields
                if (devContainerExisted) {
                    // memory
                    this.addOrSum(cheCodeDescriptionComponentContainer, devContainer, devContainerAttributes, 'memoryLimit');
                    this.addOrSum(cheCodeDescriptionComponentContainer, devContainer, devContainerAttributes, 'memoryRequest');
                    // cpu
                    this.addOrSum(cheCodeDescriptionComponentContainer, devContainer, devContainerAttributes, 'cpuLimit');
                    this.addOrSum(cheCodeDescriptionComponentContainer, devContainer, devContainerAttributes, 'cpuRequest');
                }
                else {
                    // add attributes with original memory
                    this.addIfExists(cheCodeDescriptionComponentContainer, devContainer, devContainerAttributes, 'memoryLimit');
                    this.addIfExists(cheCodeDescriptionComponentContainer, devContainer, devContainerAttributes, 'memoryRequest');
                    this.addIfExists(cheCodeDescriptionComponentContainer, devContainer, devContainerAttributes, 'cpuLimit');
                    this.addIfExists(cheCodeDescriptionComponentContainer, devContainer, devContainerAttributes, 'cpuRequest');
                }
                // add component that was updated
                devContainerAttributes[DevContainerComponentUpdater_1.CONTRIBUTE_CONTAINER] = devContainerComponent.name;
                // need to add the kubernetes plug-in in the devWorkspace object
                if (this.insertDevWorkspaceTemplatesAsPlugin) {
                    devfileContext.devWorkspaceTemplates.map(function (template) {
                        var _a;
                        // eslint-disable-next-line @typescript-eslint/no-explicit-any
                        var name = (_a = template.metadata) === null || _a === void 0 ? void 0 : _a.name;
                        if (!name) {
                            throw new Error("No name found for the template " + JSON.stringify(template, undefined, 2) + ".");
                        }
                        devfileContext.devWorkspace.spec.template.components.push({
                            name: name,
                            plugin: {
                                kubernetes: {
                                    name: name
                                }
                            }
                        });
                    });
                }
                return [2 /*return*/];
            });
        });
    };
    /**
     * Add the attribute if it's defined in the from definition
     * Also add a contributed field in that case
     */
    DevContainerComponentUpdater.prototype.addIfExists = function (from, toContainer, toAttributes, attributeName) {
        if (from[attributeName]) {
            toAttributes["" + DevContainerComponentUpdater_1.CONTRIBUTE_PREFIX + attributeName] = true;
            toContainer[attributeName] = from[attributeName];
        }
    };
    /**
     * Add the attribute if it's defined in the from definition
     * But if it also existing in the to component definition, add it by adding both values (sum)
     */
    DevContainerComponentUpdater.prototype.addOrSum = function (from, toContainer, toAttributes, attributeName) {
        if (from[attributeName]) {
            toAttributes["" + DevContainerComponentUpdater_1.CONTRIBUTE_PREFIX + attributeName] = true;
            if (toContainer[attributeName]) {
                // store previous value
                toAttributes["" + DevContainerComponentUpdater_1.CONTRIBUTE_ORIGINAL_PREFIX + attributeName] =
                    toContainer[attributeName];
                // add sum
                toContainer[attributeName] = this.k8SUnits.sumUnits(from[attributeName], toContainer[attributeName]);
            }
            else {
                // use value
                toContainer[attributeName] = from[attributeName];
            }
        }
    };
    var DevContainerComponentUpdater_1;
    DevContainerComponentUpdater.CHECODE_ATTRIBUTE_PREFIX = 'che-code.eclipse.org/';
    DevContainerComponentUpdater.CONTRIBUTE_VOLUME_MOUNT = 'che-code.eclipse.org/contribute-volume-mount/';
    DevContainerComponentUpdater.CONTRIBUTE_VOLUME_COMPONENT = 'che-code.eclipse.org/contribute-volume-component/';
    DevContainerComponentUpdater.CONTRIBUTE_ENDPOINT = 'che-code.eclipse.org/contribute-endpoint/';
    DevContainerComponentUpdater.CONTRIBUTE_CONTAINER = 'che-code.eclipse.org/contributed-container';
    DevContainerComponentUpdater.CONTRIBUTE_ENTRYPOINT = 'che-code.eclipse.org/contribute-entry-point';
    DevContainerComponentUpdater.CONTRIBUTE_ORIGINAL_ENTRYPOINT = 'che-code.eclipse.org/original-entry-point';
    DevContainerComponentUpdater.CONTRIBUTE_PREFIX = 'che-code.eclipse.org/contribute-';
    DevContainerComponentUpdater.CONTRIBUTE_ORIGINAL_PREFIX = 'che-code.eclipse.org/original-';
    __decorate([
        (0, inversify_1.inject)('boolean'),
        (0, inversify_1.named)('INSERT_DEV_WORKSPACE_TEMPLATE_AS_PLUGIN')
    ], DevContainerComponentUpdater.prototype, "insertDevWorkspaceTemplatesAsPlugin");
    __decorate([
        (0, inversify_1.inject)(k8s_units_1.K8SUnits)
    ], DevContainerComponentUpdater.prototype, "k8SUnits");
    DevContainerComponentUpdater = DevContainerComponentUpdater_1 = __decorate([
        (0, inversify_1.injectable)()
    ], DevContainerComponentUpdater);
    return DevContainerComponentUpdater;
}());
exports.DevContainerComponentUpdater = DevContainerComponentUpdater;
//# sourceMappingURL=dev-container-component-updater.js.map