"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
exports.__esModule = true;
exports.CheCodeDevfileResolverImpl = void 0;
var inversify_1 = require("inversify");
var dev_container_component_finder_1 = require("./dev-container-component-finder");
var che_code_description_component_finder_1 = require("./che-code-description-component-finder");
var dev_container_component_updater_1 = require("./dev-container-component-updater");
var dev_container_component_inserter_1 = require("./dev-container-component-inserter");
var che_code_description_component_removal_1 = require("./che-code-description-component-removal");
/**
 * This class handle the enhancement of the devWorkspace/DevWorkspaceTemplate for che-code
 * it's responsible for overriding entrypoint, increasing memory/cpu, adding endpoint, volumes
 * and adding a user container if there is no component yet.
 */
var CheCodeDevfileResolverImpl = /** @class */ (function () {
    function CheCodeDevfileResolverImpl() {
    }
    CheCodeDevfileResolverImpl.prototype.update = function (devfileContext) {
        return __awaiter(this, void 0, void 0, function () {
            var cheCodeEditor, userContainer, userContainerExisted;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.cheCodeComponentFinder.find(devfileContext)];
                    case 1:
                        cheCodeEditor = _a.sent();
                        if (!cheCodeEditor) {
                            throw new Error('No che-code editor description found in DevWorkspaceTemplate');
                        }
                        return [4 /*yield*/, this.devContainerComponentFinder.find(devfileContext)];
                    case 2:
                        userContainer = _a.sent();
                        if (!!userContainer) return [3 /*break*/, 4];
                        return [4 /*yield*/, this.devContainerComponentInserter.insert(devfileContext, cheCodeEditor)];
                    case 3:
                        // not found probably that it's an empty devfile
                        // need to add one
                        userContainer = _a.sent();
                        userContainerExisted = false;
                        return [3 /*break*/, 5];
                    case 4:
                        userContainerExisted = true;
                        _a.label = 5;
                    case 5: 
                    // ok now need to apply settings on top of this container
                    // like endpoint, volume
                    // increase the memoryLimit/cpu, etc
                    return [4 /*yield*/, this.devContainerComponentUpdater.update(devfileContext, cheCodeEditor, userContainer, userContainerExisted)];
                    case 6:
                        // ok now need to apply settings on top of this container
                        // like endpoint, volume
                        // increase the memoryLimit/cpu, etc
                        _a.sent();
                        // Remove the definition of the che-code from the devWorkspaceTemplace
                        return [4 /*yield*/, this.cheCodeComponentRemoval.removeRuntimeComponent(devfileContext, cheCodeEditor)];
                    case 7:
                        // Remove the definition of the che-code from the devWorkspaceTemplace
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    __decorate([
        (0, inversify_1.inject)(dev_container_component_finder_1.DevContainerComponentFinder)
    ], CheCodeDevfileResolverImpl.prototype, "devContainerComponentFinder");
    __decorate([
        (0, inversify_1.inject)(che_code_description_component_finder_1.CheCodeDescriptionComponentFinder)
    ], CheCodeDevfileResolverImpl.prototype, "cheCodeComponentFinder");
    __decorate([
        (0, inversify_1.inject)(che_code_description_component_removal_1.CheCodeDescriptionComponentRemoval)
    ], CheCodeDevfileResolverImpl.prototype, "cheCodeComponentRemoval");
    __decorate([
        (0, inversify_1.inject)(dev_container_component_updater_1.DevContainerComponentUpdater)
    ], CheCodeDevfileResolverImpl.prototype, "devContainerComponentUpdater");
    __decorate([
        (0, inversify_1.inject)(dev_container_component_inserter_1.DevContainerComponentInserter)
    ], CheCodeDevfileResolverImpl.prototype, "devContainerComponentInserter");
    CheCodeDevfileResolverImpl = __decorate([
        (0, inversify_1.injectable)()
    ], CheCodeDevfileResolverImpl);
    return CheCodeDevfileResolverImpl;
}());
exports.CheCodeDevfileResolverImpl = CheCodeDevfileResolverImpl;
//# sourceMappingURL=che-code-devfile-resolver-impl.js.map