"use strict";
/**********************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var GithubResolver_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubResolver = void 0;
const github_url_1 = require("./github-url");
const inversify_1 = require("inversify");
/**
 * Providing a github URL it provides a github URL object allowing to interact
 */
let GithubResolver = GithubResolver_1 = class GithubResolver {
    resolve(link) {
        const match = GithubResolver_1.GITHUB_URL_PATTERN.exec(link);
        if (!match) {
            throw new Error(`Invalid github URL: ${link}`);
        }
        const repoUser = this.getGroup(match, 'repoUser');
        const repoName = this.getGroup(match, 'repoName');
        const branchName = this.getGroup(match, 'branchName', 'HEAD');
        const subFolder = this.getGroup(match, 'subFolder');
        return new github_url_1.GithubUrl(repoUser, repoName, branchName, subFolder);
    }
    getGroup(match, groupName, defaultValue) {
        if (match.groups && match.groups[groupName]) {
            return match.groups[groupName];
        }
        return defaultValue || '';
    }
};
// eslint-disable-next-line max-len
GithubResolver.GITHUB_URL_PATTERN = /^(?:http)(?:s)?(?:\:\/\/)github\.com\/(?<repoUser>[^\/]+)\/(?<repoName>[^\/]+)((\/)|(?:\/(blob|tree)\/(?<branchName>[^\/]+)(?:\/(?<subFolder>.*))?))?$/;
GithubResolver = GithubResolver_1 = __decorate([
    inversify_1.injectable()
], GithubResolver);
exports.GithubResolver = GithubResolver;
//# sourceMappingURL=github-resolver.js.map